/*
 * RS485.cpp
 *
 *  Created on: 2013-07-17
 *      Author: mitydsp
 */
#include <sys/ioctl.h>
#include "RS485.h"
using namespace MityDSP;

tcArmRS485::tcArmRS485()
{
	isOpen = false;
	isReady = false;

	termHandle = open("/dev/ttyS2", O_RDWR | O_NOCTTY | O_NDELAY);
	if (termHandle < 0)
		return;
	else
		isOpen = true;
	rs485conf.flags = SER_RS485_ENABLED;
	rs485conf.flags |= SER_RS485_USE_GPIO;
	rs485conf.delay_rts_before_send = 0;
	rs485conf.gpio_pin = GPIO0_9;

	rv = ioctl (termHandle, TIOCSRS485, &rs485conf);
	if (rv) {
		perror("unable to set IOCTL:");
		return;
	}
	tcgetattr(termHandle, &my_termios);
	// this is for raw mode, 19.2 kBaud
	/*	my_termios.c_iflag &= ~(IGNBRK | BRKINT | ICRNL | INLCR | PARMRK | IGNCR | ISTRIP | IXON);
		my_termios.c_oflag &= ~OPOST;
		my_termios.c_lflag &= ~(ECHO | ECHONL | ICANON | IEXTEN | ISIG);
		my_termios.c_cflag &= ~(CSIZE | PARENB);
		my_termios.c_cflag |= CS8 | CLOCAL;
		my_termios.c_cflag &= ~CBAUD;
		my_termios.c_cflag |= B19200;
	*/
	// this is for test mode
	my_termios.c_iflag &= ~(IGNBRK | BRKINT | ICRNL | INLCR | PARMRK | INPCK | ISTRIP | IXON);
	my_termios.c_oflag &= ~(OCRNL | ONLCR | ONLRET | ONOCR | OFILL | OLCUC | OPOST);
	my_termios.c_lflag &= ~(ECHO |  ECHONL | ICANON | IEXTEN | ISIG | ECHOK | ECHOCTL | ECHOPRT);
	my_termios.c_cflag &= ~(CSIZE | PARENB);
	my_termios.c_cflag &= ~CRTSCTS;
	my_termios.c_cflag |= CS8 | CLOCAL;
	my_termios.c_cflag &= ~CBAUD;
	my_termios.c_cflag |= B19200;
	my_termios.c_cc[VMIN] = 1;
	my_termios.c_cc[VTIME] = 0;
	rv = tcsetattr(termHandle, TCSANOW, &my_termios);

	tcgetattr(termHandle, &new_termios);

	isReady = true;

}

tcArmRS485::~tcArmRS485()
{
	if(isOpen)
		close(termHandle);
}





