----------------------------------------------------------------------------------
-- Company:
-- Engineer: Lukasz Dalek <L.Dalek@stud.elka.pw.edu.pl>
--
-- Create Date:
-- Design Name:
-- Module Name:
-- Project Name:
-- Target Devices:
-- Tool versions:
-- Description:
--
-- Dependencies:
--
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
--
----------------------------------------------------------------------------------
library work;
library ieee;
library unisim;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use unisim.vcomponents.all;

entity emifatest is
   port (
      i_ema_clk     : in std_logic; -- 100 MHz EMIF clock

      -- EMIFA BUS Interface
      i_ema_cs0_n   : in std_logic; -- RESERVED for SDRAM Controller
      i_ema_cs2_n   : in std_logic; -- ARM core CE space
      i_ema_cs3_n   : in std_logic; -- NAND FLASH space, not used
      i_ema_cs4_n   : in std_logic; -- DSP core CE space
      i_ema_cs5_n   : in std_logic; -- Reserved core space, not used
      i_ema_oe_n    : in std_logic;
      i_ema_we_n    : in std_logic;
      io_ema_wait_n : inout std_logic_vector(1 downto 0);
      io_ema_d      : inout std_logic_vector(15 downto 0);
      i_ema_a       : in std_logic_vector(13 downto 0);
      i_ema_ba      : in std_logic_vector(1 downto 0);
      i_ema_wen_dqm : in std_logic_vector(1 downto 0);
      i_ema_cas     : in std_logic; -- reserved for SDRAM controller, not used
      i_ema_ras     : in std_logic; -- reserved for SDRAM controller, not used
      i_ema_sdcke   : in std_logic; -- reserved for SDRAM controller, not used
      i_ema_rnw     : in std_logic; -- reserved for SDRAM controller, not used

      -- IRQ lines
      o_nmi_n       : out std_logic;
      o_int         : out std_logic_vector(1 downto 0)
  );
end emifatest;

architecture rtl of emifatest is
begin

o_nmi_n <= '1';
o_int <= (others => '0');
io_ema_d <= i_ema_a & i_ema_ba when i_ema_cs5_n = '0' else (others=>'Z');
io_ema_wait_n <= (others=>'Z');

end rtl;
-- vim: set ts=3 expandtab:
