#include <stdint.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <getopt.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <linux/types.h>
#include <linux/spi/spidev.h>
//#include <iostream>
#include <string.h>
//#include <chrono>

// ... test framework, etc.

const size_t SPI_BUFFER_SIZE = 4;
uint16_t spi_tx_buffer[SPI_BUFFER_SIZE];
uint16_t spi_rx_buffer[SPI_BUFFER_SIZE];

struct spi_ioc_transfer xfer[1];

int spi_init()
{
    int file;
    uint8_t mode, lsb, bits;
    uint32_t speed;

    if ((file = open("/dev/spidev32766.0", O_RDWR)) < 0)
    {
        printf("Failed to open the bus.\n");
        return -1;
    }

// ... mode reading and writing

    printf("file: spi mode %d, %d bits %sper word, %d Hz max\n", mode, bits, lsb ? "(lsb first) " : "", speed);

    memset(xfer, 0, sizeof(spi_ioc_transfer));

    xfer[0].tx_buf = (unsigned long)spi_tx_buffer;
    xfer[0].len = 20;       // Length of command to write
    xfer[0].cs_change = 1;  // Do NOT Keep CS activated
    xfer[0].delay_usecs = 0;
    xfer[0].speed_hz = 100000;
    xfer[0].bits_per_word = 16;
    return file;
}

uint16_t* spi_read(int file)
{
    int status;

    memset(spi_tx_buffer, 0, sizeof(spi_tx_buffer));
    memset(spi_rx_buffer, 0, sizeof(spi_rx_buffer));

    spi_tx_buffer[0] = 0x8330;

    xfer[0].tx_buf = (unsigned long)spi_tx_buffer;
    xfer[0].len = 2; // Length of command to write/read
    xfer[0].rx_buf = (unsigned long)spi_rx_buffer;

    status = ioctl(file, SPI_IOC_MESSAGE(1), xfer);
    if (status < 0)
    {
        perror("SPI_IOC_MESSAGE");
    }

    printf("rx: ");
    for (uint16_t i = 0; i < SPI_BUFFER_SIZE; i++)
    {
        printf("%04X ", spi_rx_buffer[i]);
    }
    printf("\n");

    return spi_rx_buffer;
}


int main()
{
    int spidev_fd = spi_init();
    if (spidev_fd < 0)
    {
        printf("Failed to open!\n");
        return -1;
    }

	spi_read(spidev_fd); //reading the address 0xE60E
	
    close(spidev_fd);
	return 0;
}
