#ifndef CONFIG_HDMI_H_
#define CONFIG_HDMI_H_


#define TX_ADDR_MAIN	0x72	    // I2C address of the HDMI Transmitter's Main Port Map

// Configuration data for HDMI Transmitter
unsigned char tx_conf_main[] =
{
		   0x00, 0x04, // Revision RO
		    0x01, 0x00, // High byte of N for audio clock
		    0x02, 0x18, // Middle bytes of N for audio clock
		    0x03, 0x00, // Lower bytes of N for audio clock
		    0x04, 0x00, // SPDIF 44.1kHz, High byte measured CTS RO
		    0x05, 0x21, // Middle bytes of measured CTS RO
		    0x06, 0xC0, // Lower bytes of measured CTS RO
		    0x07, 0x00, // High byte of CTS external
		    0x08, 0x00, // Middle bytes of CTS external
		    0x09, 0x00, // Lower bytes of CTS external
		    0x0A, 0x11,// Internal CTS, SDPIF, SPDIF MCLK inactive, I2S MCLK inactive, MCLK x256 fs
		    0x0B, 0x0E, // MCLK rising edge, normal audio
		    0x0C, 0x3C, // Enable all I2S pins, standard I2S format
		    0x0D, 0x18, // I2S bit width 24
		    0x0E, 0x01, // Sub packet 0 source
		    0x0F, 0x13, // Sub packet 1 source
		    0x10, 0x25, // Sub packet 2 source
		    0x11, 0x37, // Sub packet 3 source
		    0x12, 0x00, // Copy right, 2 audio channels w/o pre-emphasis, clock accuracy level II
		    0x13, 0x00, // Category code for audio InfoFrame (IEC 60958)
		    0x14, 0x00, // Source number 0, audio word length unspecified
		    0x15, 0x00, // I2S frequency 44.1kHz, Input video RGB 444, refresh rate > 30Hz
		    0x16, 0x00, // Output video format RGB 444, 422 is 12bits, Style 1, video input rising edge
		    0x17, 0x02, // ITU656 Error Correction disabled, VS high polarity, HS high polarity, CSC mode +- 1.0, 422 to 444 use zero order, aspect 16:9, disable DE gen
		    0x18, 6,    // CSC coefficients
		    0x19, 98,
		    0x1A, 4,
		    0x1B, 168,
		    0x1C, 0,
		    0x1D, 0,
		    0x1E, 28,
		    0x1F, 132,
		    0x20, 28,
		    0x21, 191,
		    0x22, 4,
		    0x23, 168,
		    0x24, 30,
		    0x25, 112,
		    0x26, 2,
		    0x27, 30,
		    0x28, 0,
		    0x29, 0,
		    0x2A, 4,
		    0x2B, 168,
		    0x2C, 8,
		    0x2D, 18,
		    0x2E, 27,
		    0x2F, 172,
		    0x30, 0,    // ITU 656 HS/VS/DE setup
		    0x31, 0,
		    0x32, 0,
		    0x33, 0,
		    0x34, 0,
		    0x35, 0,
		    0x36, 0,
		    0x37, 0,
		    0x38, 0,
		    0x39, 0,
		    0x3A, 0,
		    0x3B, 0x80, // external audio sampling freq, auto repetition mode, x1, CSC disable
		    0x3C, 0x00, // VID 0
		    0x3D, 0x04, // Actual pixel repition and VID RO
		    0x3E, 0x10, // VIDE detected by video FE RO
		    0x3F, 0x00, // Video input format RO
		    0x40, 0x00, // disable General Control packet, disbale Source Product Descriptor packet, disable MPEG packe, disable ACP packet, disable ISRC packet
		    0x41, 0x10, // Power up, sync generation disabled
		    0x42, 0xE0, // PD polarity, hot plug, monitor detect RO
		    0x43, 0x7E, // I2C address for EDID
		    0x44, 0xF8, // enable SPDIF receiver, enable N_CTS packet, enable audio sample packet, enable avi infoframe, enable audio infoframe, disable GMP packet
		    0x45, 0x00, // don't mute, output format RGB, Active format info invalid, no bar information
		    0x46, 0x00, // no scan info, no colorimetry data, no aspect ratio data, no known non-uniform scaling
		    0x47, 0x00, // Active format aspect ratio 0
		    0x48, 0,    // Bar locations
		    0x49, 0,
		    0x4A, 0,
		    0x4B, 0,
		    0x4C, 0,
		    0x4D, 0,
		    0x4E, 0,
		    0x4F, 0,
		    0x50, 0x00, // Channel count in stream header, no down mix inhibit info, 0dB attenuation
		    0x51, 0x00, // Speaker mapping
		    0x52, 0,    // Source Product Description
		    0x53, 0,
		    0x54, 0,
		    0x55, 0,
		    0x56, 0,
		    0x57, 0,
		    0x58, 0,
		    0x59, 0,
		    0x5A, 0,
		    0x5B, 0,
		    0x5C, 0,
		    0x5D, 0,
		    0x5E, 0,
		    0x5F, 0,
		    0x60, 0,
		    0x61, 0,
		    0x62, 0,
		    0x63, 0,
		    0x64, 0,
		    0x65, 0,
		    0x66, 0,
		    0x67, 0,
		    0x68, 0,
		    0x69, 0,
		    0x6A, 0,
		    0x6B, 0,    // MPEG
		    0x6C, 0,
		    0x6D, 0,
		    0x6E, 0,
		    0x6F, 0,
		    0x70, 0,
		    0x71, 0,    // ACP
		    0x72, 0,
		    0x73, 0,    // ISRC
		    0x74, 0,
		    0x75, 0,
		    0x76, 0,
		    0x77, 0,
		    0x78, 0,
		    0x79, 0,
		    0x7A, 0,
		    0x7B, 0,
		    0x7C, 0,
		    0x7D, 0,
		    0x7E, 0,
		    0x7F, 0,
		    0x80, 0,
		    0x81, 0,
		    0x82, 0,
		    0x83, 0,
		    0x84, 0,
		    0x85, 0,
		    0x86, 0,
		    0x87, 0,
		    0x88, 0,
		    0x89, 0,
		    0x8A, 0,
		    0x8B, 0,
		    0x8C, 0,
		    0x8D, 0,
		    0x8E, 0,
		    0x8F, 0,
		    0x90, 0,
		    0x91, 0,
		    0x92, 0,
		    0x93, 0,
		    0x94, 0xC0, // Interrupts disabled
		    0x95, 0x00, // Interrupts disabled
		    0x96, 0xE4, // Clear interrupts
		    0x97, 0x04,
		    0x98, 3,    // Reserved registers
		    0x99, 2,
		    0x9A, 0,
		    0x9B, 24,
		    0x9C, 56,
		    0x9D, 97,
		    0x9E, 0,
		    0x9F, 112,
		    0xA0, 0,
		    0xA1, 0x00, // Disable all power downs
		    0xA2, 0x87, // Differential data drive
		    0xA3, 0x86, // Differential clock drive
		    0xA4, 8,    // Reserved registers
		    0xA5, 4,
		    0xA6, 0,
		    0xA7, 0,
		    0xA8, 0,
		    0xA9, 0,
		    0xAA, 0,
		    0xAB, 64,
		    0xAC, 0,
		    0xAD, 0,
		    0xAE, 0,
		    0xAF, 0x06, // not encrypted, HDMI mode
		    0xB0, 253,  // Reserved registers
		    0xB1, 211,
		    0xB2, 164,
		    0xB3, 247,
		    0xB4, 217,
		    0xB5, 232,
		    0xB6, 132,
		    0xB7, 183,
		    0xB8, 0xA0, // Audio encryption/detected RO
		    0xB9, 0x00, // Reserved
		    0xBA, 0x00, // Edge select
		    0xBB, 255,  // Reserved registers
		    0xBC, 187,
		    0xBD, 165,
		    0xBE, 0x90, // HDCP info RO
		    0xBF, 131,  // HDCP registers RO
		    0xC0, 105,
		    0xC1, 220,
		    0xC2, 148,
		    0xC3, 122,
		    0xC4, 0x00, // E-DDC segment 0
		    0xC5, 16,   // Reserved
		    0xC6, 0x16, // HDMI info RO
		    0xC7, 0,    // HDCP Registers RO
		    0xC8, 0x04,
		    0xC9, 0x03, // 3 EDID tries
		    0xCD, 0x00, // xvYCC601 colorimetry, Default Quantization
		    0xCE, 0x00, // AVI_PB5
//		    0xCF, 0x56,  // Secondary address
		0x00, 0x00, 0x00, 0x00	// End of List Marker
};


#define RX_ADDR_IO 0x98
// Configuration for HDMI Receiver
unsigned char rx_conf_io[] =
{
	       0x0, 0x11,  // Chip revision, RO
	        0x1, 0x69,  // PLL Divider MSB
	        0x2, 0xD0,  // PLL Divider
	        0x3, 0x48,  // VCO Range 1, Charge Pump 001, Internal Clock
	        0x4, 0x80,  // ADC Phase Adjust
	        0x5, 0x80,  // R Gain
	        0x6, 0x80,  // G Gain
	        0x7, 0x80,  // B Gain
	        0x8, 0x00,  // Red Offset Adjust
	        0x9, 0x80,  // Red Offset
	        0xa, 0x00,  // Green Offset Adjust
	        0xb, 0x80,  // Green Offset
	        0xc, 0x00,  // Blue Offset Adjust
	        0xd, 0x80,  // Blue Offset
	        0xe, 0x20,  // Sync Separator Threshold
	        0xf, 0x80,  // SOG Comparator Threshold Enter
	        0x10, 0x80, // SOG Comparator Threshold Exit
	        0x11, 0x03, //0x00, // Auto HS, Auto VS, Auto Channel, Auto Interface
	        0x12, 0x00, // Auto HS Pol, Auto VS Pol, Auto Coast Pol, Raw VS Coast
	        0x13, 0x04, // HS before VS to Coast
	        0x14, 0x04, // HS after VS to Coast
	        0x15, 0x00, // HS, VS, SOG, Coast detect, RO
	        0x16, 0xCB, // HS, VS, Coast, Pseudo Sync Det, Sync Filt Lock, Bad Sync, RO
	        0x17, 0x02, // HS Per VS MSB, RO
	        0x18, 0x08, // HS Per VS, RO
	        0x19, 0x08, // Clamp Placement
	        0x1a, 0x14, // Clamp Duration
	        0x1b, 0x00, // R Clamp GND, G Clamp GND, B Clamp GND, Clamp Enable, Low Bandwidth, Normal Auto Offset
	        0x1c, 0x4F, // Manual Offset, Every 64 Clamps, 25% Diff, Auto Jump, Post Filer Enable, Toggle Filter Enable
	        0x1e, 0x20, // Sync Filter Lock Threshold
	        0x1f, 0x32, // Sync Filter Unlock Threshold
	        0x20, 0x14, // Sync Filter Window
	        0x21, 0xEC, // SP Sync Filer Enable, PLL Sync Filter Enable, VSync Filter Enable, Auto Offset Clamp Mode 1, Auto Offset Clamp Length 16
	        0x22, 0x08, // Vsync Duration
	        0x23, 0x32, // Hsync Duration
	        0x24, 0xF1, // HS Active High, VS Active High, DE Active High, Invert Output Clock
	        0x25, 0x62, // 1x CLK, Low Drive Strength, 4:4:4, Primary Output Enable
	        0x26, 0x08, // Power-Down Pin Active High
	        0x27, 0x00, // Auto Power-Down Disable
	        0x28, 0xA1, // VS Delay 48, HS Delay MSB 1
	        0x29, 0x8E, // HS Delay 398
	        0x2a, 0x05, // Line Width MSB
	        0x2b, 0x00, // Line Width 1280
	        0x2c, 0x04, // Screen Height MSB
	        0x2d, 0x00, // Screen Height 1024
	        0x2e, 0x18, // I2S Bit Width 24
	        0x2f, 0x6F, // RO
	        0x30, 0x80, // RO
	        0x31, 0x96, // MV Pulse Max 9, MV Pulse Min 6
	        0x32, 0x0D, // MV Line Count Start 13
	        0x33, 0x95, // MV Detect Progressive, MV Line Count End 21
	        0x34, 0x80, // MV Puls Limit Set 2, CSC Disable
	        0x35, 0x2C, // CSC Mode +-2 -8192 to 8190
	        0x36, 82,   // CSC Coeff
	        0x37, 8,    // CSC Coeff
	        0x38, 0,    // CSC Coeff
	        0x39, 0,    // CSC Coeff
	        0x3a, 0,    // CSC Coeff
	        0x3b, 25,   // CSC Coeff
	        0x3c, 215,  // CSC Coeff
	        0x3d, 28,   // CSC Coeff
	        0x3e, 84,   // CSC Coeff
	        0x3f, 8,    // CSC Coeff
	        0x40, 0,    // CSC Coeff
	        0x41, 30,   // CSC Coeff
	        0x42, 137,  // CSC Coeff
	        0x43, 2,    // CSC Coeff
	        0x44, 146,  // CSC Coeff
	        0x45, 0,    // CSC Coeff
	        0x46, 0,    // CSC Coeff
	        0x47, 8,    // CSC Coeff
	        0x48, 0,    // CSC Coeff
	        0x49, 14,   // CSC Coeff
	        0x4a, 135,  // CSC Coeff
	        0x4b, 24,   // CSC Coeff
	        0x4c, 189,  // CSC Coeff
	        0x4d, 54,   // CSC Coeff
	        0x4e, 54,   // CSC Coeff
	        0x4f, 51,   // CSC Coeff
	        0x50, 0x80, // Test
	        0x51, 64,   // Undoc
	        0x52, 1,    // Undoc
	        0x53, 63,   // Undoc
	        0x54, 0,    // Undoc
	        0x55, 0,    // Undoc
	        0x56, 15,   // Test
	        0x57, 0, // AV Mute
	        0x58, 0,
	        0x59, 0,
	        0x5a, 0,
	        0x5b, 3,
	        0x5c, 35,
	        0x5d, 156,
	        0x5e, 0,
	        0x5f, 0,
	        0x60, 0,
	        0x61, 0,
	        0x62, 0,
	        0x7b, 0,
	        0x7c, 0,
	        0x7d, 0,
	        0x7e, 0,
	        0x7f, 0,
        0x00, 0x00, 0x00, 0x00		// End of List Marker
};

unsigned char sample_edid_data[] = { //Analog Devices sample
	0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x0C, 0xA1, 0x00, 0x03, 0x01, 0x01, 0x01, 0x01,
	0x00 ,0x00, 0x01, 0x03, 0x80, 0x46, 0x28, 0x78, 0x2A, 0x0D, 0xC9, 0xA0, 0x57, 0x47, 0x98, 0x27,
	0x12, 0x48, 0x4C, 0xA1, 0x08, 0x00, 0x81, 0x80, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x3A, 0x80, 0x18, 0x71, 0x38, 0x2D, 0x40, 0x58, 0x2C,
	0x45, 0x00, 0xDF, 0xA4, 0x21, 0x00, 0x00, 0x1E, 0x01, 0x1D, 0x00, 0x72, 0x51, 0xD0, 0x1E, 0x20,
	0x6E, 0x28, 0x55, 0x00, 0xDF, 0xA4, 0x21, 0x00, 0x00, 0x1E, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x43,
	0x45, 0x41, 0x20, 0x44, 0x65, 0x65, 0x70, 0x43, 0x6F, 0x6C, 0x6F, 0x0A, 0x00, 0x00, 0x00, 0xFD,
	0x00, 0x3A, 0x3E, 0x0F, 0x46, 0x0F, 0x00, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x01, 0xDE,

	0x02, 0x03, 0x2A, 0x70, 0x49, 0x10, 0x05, 0x04, 0x03, 0x02, 0x07, 0x06, 0x01, 0x20, 0x23, 0x09,
	0x07, 0x07, 0x83, 0x01, 0x00, 0x00, 0xE3, 0x05, 0x03, 0x01, 0x6C, 0x03, 0x0C, 0x00, 0x10, 0x00,
	0xB0, 0x2D, 0xC0, 0x1D, 0x03, 0x22, 0x03, 0xE2, 0x00, 0x7B, 0x01, 0x1D, 0x80, 0x18, 0x71, 0x1C,
	0x16, 0x20, 0x58, 0x2C, 0x25, 0x00, 0xA0, 0x7A, 0x21, 0x00, 0x00, 0x9E, 0x8C, 0x0A, 0xD0, 0x8A,
	0x20, 0xE0, 0x2D, 0x10, 0x10, 0x3E, 0x96, 0x00, 0xDF, 0xA4, 0x21, 0x00, 0x00, 0x18, 0x8C, 0x0A,
	0xD0, 0x8A, 0x20, 0xE0, 0x2D, 0x10, 0x10, 0x3E, 0x96, 0x00, 0x30, 0xA4, 0x21, 0x00, 0x00, 0x18,
	0x8C, 0x0A, 0xA0, 0x14, 0x51, 0xF0, 0x16, 0x00, 0x26, 0x7C, 0x43, 0x00, 0x30, 0xA4, 0x21, 0x00,
	0x00, 0x98, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5F
	};

/*  unsigned char sample_edid_data[] = { //50Hz "ViClaro III E"
	0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x36, 0x98, 0x52, 0x62, 0x01, 0x00, 0x00, 0x00,
	0x01, 0x12, 0x01, 0x03, 0x8E, 0x34, 0x20, 0x78, 0x0A, 0x5A, 0xD5, 0xA7, 0x56, 0x4B, 0x9B, 0x24,
	0x13, 0x50, 0x54, 0x20, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x3A, 0x80, 0xD0, 0x72, 0x38, 0x2D, 0x40, 0x10, 0x2C,
	0x45, 0x80, 0x06, 0x44, 0x21, 0x00, 0x00, 0x1E, 0x01, 0x1D, 0x80, 0xD0, 0x72, 0x1C, 0x16, 0x20,
	0x10, 0x2C, 0x25, 0x80, 0x06, 0x44, 0x21, 0x00, 0x00, 0x9E, 0x01, 0x1D, 0x00, 0xBC, 0x52, 0xD0,
	0x1E, 0x20, 0xB8, 0x28, 0x55, 0x40, 0x06, 0x44, 0x21, 0x00, 0x00, 0x1E, 0x00, 0x00, 0x00, 0xFC,
	0x00, 0x56, 0x69, 0x43, 0x6C, 0x61, 0x72, 0x6F, 0x20, 0x49, 0x49, 0x49, 0x20, 0x45, 0x01, 0x5D,

	0x02, 0x03, 0x08, 0x09, 0x7F, 0x01, 0x83, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE0
	  };
*/
/*  unsigned char sample_edid_data[] = { //60Hz "ViClaro III"
	0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x36, 0x98, 0x52, 0x62, 0x01, 0x00, 0x00, 0x00,
	0x01, 0x12, 0x01, 0x03, 0x8E, 0x34, 0x20, 0x78, 0x0A, 0x5A, 0xD5, 0xA7, 0x56, 0x4B, 0x9B, 0x24,
	0x13, 0x50, 0x54, 0x20, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x3A, 0x80, 0x18, 0x71, 0x38, 0x2D, 0x40, 0x58, 0x2C,
	0x45, 0x00, 0x06, 0x44, 0x21, 0x00, 0x00, 0x1E, 0x01, 0x1D, 0x80, 0x18, 0x71, 0x1C, 0x16, 0x20,
	0x58, 0x2C, 0x25, 0x00, 0x06, 0x44, 0x21, 0x00, 0x00, 0x9E, 0x01, 0x1D, 0x00, 0x72, 0x51, 0xD0,
	0x1E, 0x20, 0x6E, 0x28, 0x55, 0x00, 0x06, 0x44, 0x21, 0x00, 0x00, 0x1E, 0x00, 0x00, 0x00, 0xFC,
	0x00, 0x56, 0x69, 0x43, 0x6C, 0x61, 0x72, 0x6F, 0x20, 0x49, 0x49, 0x49, 0x0A, 0x0A, 0x01, 0x65,

	0x02, 0x03, 0x08, 0x09, 0x7F, 0x01, 0x83, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE0
	  };
*/


#endif /*CONFIG_H_*/
