#include "mainwindow.h"
#include "ui_mainwindow.h"

#define GPIO_TO_PIN(bank, gpio) ((bank)*32 + (gpio))

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent)
    , ui(new Ui::MainWindow)
    , gpioRedLed(GPIO_TO_NUM(1,12)) // gpio1_12
{
    ui->setupUi(this);

    gpioRedLed.setDirection(1, 0); // Set gpio as output low
}

MainWindow::~MainWindow()
{
    delete ui;
}


void MainWindow::on_pbToggleLed_clicked()
{
    int ret;
    unsigned int value;

    ret = gpioRedLed.GetValue(value);
    if (ret < 0) {
        qDebug() << "Error: Failed to get gpio value";
        return;
    }
    ret = gpioRedLed.SetValue(!value);
    if (ret < 0) {
        qDebug() << "Error: Failed to set gpio value";
        return;
    }
}
