/**
 * \file  image.h
 *
 * \brief Raw data created from a BMP image
 */

/*
* Copyright (C) 2012 Texas Instruments Incorporated - http://www.ti.com/ 
*
*  Redistribution and use in source and binary forms, with or without 
*  modification, are permitted provided that the following conditions 
*  are met:
*
*    Redistributions of source code must retain the above copyright 
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the 
*    documentation and/or other materials provided with the   
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

const unsigned short image1[] =
{
    /* palette data */
    0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    /* image data   */
    0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,0x8410,0x7bef,
    0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,
    0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,
    0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,0x8410,0x7bef,
    0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,
    0x8410,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,
    0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,
    0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,
    0x8410,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,
    0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,
    0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,
    0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,
    0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,
    0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,
    0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,
    0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,
    0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,
    0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,
    0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,
    0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,
    0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,
    0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,0x8410,
    0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,
    0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,
    0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,0x8410,
    0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,
    0x8410,0x8410,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,
    0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,
    0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,
    0x8410,0x8410,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,0x8410,0x7bef,
    0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,
    0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,
    0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,0x8410,0x7bef,
    0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,
    0x8410,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,
    0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,
    0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,
    0x8410,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,
    0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,
    0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,
    0x8410,0xa514,0xb596,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xad55,0xa534,0xad55,0xad55,0xa534,
    0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xad55,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,
    0xa534,0xad55,0xa534,0xad55,0xbdd7,0x7bef,0x8430,0xe73c,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xd6ba,0x6b4d,0xad75,0xef5d,0xce79,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xef5d,
    0xa534,0x6b6d,0xdefb,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xe73c,0x73ae,0x94b2,0xef7d,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xbdf7,0x6b4d,0xce59,0xe71c,0xce59,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xef5d,0x8c51,0x8410,0xef5d,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xe71c,0xd69a,0x6b4d,0xb5b6,0xef5d,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce79,0xce79,0xce79,0xce59,0xce79,0xd69a,0xd6ba,0xdefb,0xe73c,0xe73c,0xef5d,0xf79e,0xf79e,0xe73c,0xd6ba,
    0xce59,0xbdd7,0xad75,0x9cf3,0x9492,0x8410,0x73ae,0x632c,0x632c,0x6b6d,0x6b6d,0x8410,0x7bef,0x73ae,0x94b2,0x9cd3,
    0x9cd3,0x9cf3,0xad55,0xb596,0xb5b6,0xb5b6,0xb5b6,0xb5b6,0xb5b6,0xbdd7,0xc638,0xc638,0xc638,0xc618,0xc618,0xc638,
    0xc638,0xc618,0xc618,0xc638,0xc638,0xc638,0xbdd7,0xb596,0xb5b6,0xb5b6,0xb5b6,0xb5b6,0xb596,0xad55,0xa514,0x9cf3,
    0x9cd3,0x94b2,0x73ae,0x7bef,0x8410,0x738e,0x738e,0x632c,0x632c,0x73ae,0x8410,0x9492,0x9cf3,0xad55,0xb5b6,0xc638,
    0xd69a,0xe71c,0xf79e,0xf79e,0xef7d,0xe73c,0xe73c,0xdefb,0xdedb,0xd69a,0xce79,0xce59,0xce79,0xce79,0xce79,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xef5d,0xb5b6,0x6b4d,0xd69a,0xe71c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xef5d,0x8410,0x8c51,0xef5d,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xce59,0xe71c,0xce59,0x6b4d,0xbdf7,0xe73c,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xef7d,0x94b2,0x73ae,0xe73c,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xdefb,0x6b6d,0xa534,
    0xef5d,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce79,0xef5d,0xad75,0x6b4d,0xd6ba,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xe73c,0x8430,0x7bef,0xbdd7,0xad55,0xa534,0xad55,0xa534,
    0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xad55,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,
    0xa534,0xad55,0xad55,0xa534,0xad55,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xad75,0xa534,0x8410,
    0x7bef,0xad55,0xbdf7,0xad75,0xb596,0xb596,0xad75,0xad75,0xb596,0xb596,0xad75,0xad75,0xad75,0xb596,0xb596,0xad75,
    0xad75,0xb596,0xb596,0xad75,0xad75,0xb596,0xb596,0xad75,0xad75,0xad75,0xb596,0xb596,0xad75,0xad75,0xb596,0xb596,
    0xad75,0xad75,0xad75,0xad75,0xc638,0x7bcf,0x8410,0xffff,0xe73c,0xdefb,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,
    0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,
    0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe73c,0xe71c,0xdefb,0xf79e,0xef5d,0x630c,0xb5b6,0xffff,0xdedb,0xe73c,
    0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,
    0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe73c,0xe71c,0xe71c,0xe71c,0xe73c,0xdefb,0xffff,
    0xad75,0x632c,0xf79e,0xf79e,0xdefb,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,
    0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe73c,0xe71c,0xe71c,0xe71c,
    0xe71c,0xe71c,0xe71c,0xdefb,0xef5d,0xffff,0x6b6d,0x9cd3,0xffff,0xdefb,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,
    0xe71c,0xe71c,0xe73c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe73c,
    0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe73c,0xdedb,0xffff,0xce59,0x5acb,0xdefb,0xffdf,0xdedb,
    0xe73c,0xe71c,0xe71c,0xe71c,0xe71c,0xe73c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,
    0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,
    0xffff,0x8430,0x7bef,0xffff,0xe73c,0xe71c,0xe71c,0xe71c,0xe73c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,
    0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,
    0xe71c,0xe71c,0xe71c,0xe73c,0xdedb,0xf7be,0xe73c,0x5aeb,0xc618,0xffff,0xdedb,0xe71c,0xdefb,0xdefb,0xdefb,0xe73c,
    0xef5d,0xef7d,0xf79e,0xffdf,0xffff,0xffff,0xef7d,0xdefb,0xd69a,0xc618,0xb5b6,0xad55,0xa514,0x94b2,0x94b2,0x9cd3,
    0x9cf3,0xa514,0xa514,0xa534,0xad55,0xad75,0xb596,0xb596,0xb5b6,0xb5b6,0xb5b6,0xd6ba,0x94b2,0x738e,0xd6ba,0xd69a,
    0xc638,0xce79,0xd69a,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xdedb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdedb,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd69a,0xce79,0xce59,
    0xd69a,0xd6ba,0x738e,0x94b2,0xd6ba,0xb5b6,0xbdd7,0xb5b6,0xb596,0xad75,0xad55,0xad55,0xa534,0xa534,0xa514,0x9cf3,
    0x9cd3,0x9cd3,0x94b2,0x9cf3,0xad55,0xb596,0xc618,0xd69a,0xdefb,0xef5d,0xffdf,0xffff,0xffdf,0xf79e,0xef7d,0xef5d,
    0xe73c,0xdefb,0xdefb,0xdefb,0xe71c,0xdedb,0xffff,0xc618,0x5aeb,0xe73c,0xf7be,0xdedb,0xe73c,0xe71c,0xe71c,0xe71c,
    0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,
    0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe73c,0xe71c,0xe71c,0xe71c,0xe73c,0xffff,0x7bef,0x8430,0xffff,
    0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,
    0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe73c,0xe71c,0xe71c,0xe71c,0xe71c,0xe73c,
    0xdedb,0xffdf,0xdefb,0x5acb,0xce59,0xffff,0xdedb,0xe73c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,
    0xe73c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe73c,0xe71c,0xe71c,
    0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xdefb,0xffff,0x9cd3,0x6b6d,0xffff,0xef5d,0xdefb,0xe71c,0xe71c,0xe71c,
    0xe71c,0xe71c,0xe71c,0xe73c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,
    0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xdefb,0xf79e,0xf79e,0x632c,0xad75,
    0xffff,0xdefb,0xe73c,0xe71c,0xe71c,0xe71c,0xe73c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,
    0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,
    0xe73c,0xdedb,0xffff,0xb5b6,0x630c,0xef5d,0xf79e,0xdefb,0xe71c,0xe73c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,
    0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,
    0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xe71c,0xdefb,0xe73c,0xffff,0x8410,0x7bcf,0xc638,0xad75,0xad75,0xad75,0xad75,
    0xb596,0xb596,0xad75,0xad75,0xb596,0xb596,0xad75,0xad75,0xad75,0xb596,0xb596,0xad75,0xad75,0xb596,0xb596,0xad75,
    0xad75,0xb596,0xb596,0xad75,0xad75,0xad75,0xb596,0xb596,0xad75,0xad75,0xb596,0xb596,0xad75,0xbdd7,0xad75,0x7bef,
    0x7bef,0xa514,0xad75,0xa514,0xa534,0xa534,0xa514,0xa514,0xa534,0xa534,0xa514,0xa514,0xa514,0xa534,0xa534,0xa514,
    0xa514,0xa534,0xa534,0xa514,0xa514,0xa534,0xa534,0xa514,0xa514,0xa514,0xa534,0xa534,0xa514,0xa514,0xa534,0xa534,
    0xa514,0xa514,0xa514,0xa514,0xbdd7,0x73ae,0x7bef,0xe73c,0xce79,0xc638,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xc638,0xdedb,0xd6ba,0x5aeb,0xad55,0xe73c,0xc638,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xc638,0xef5d,
    0xa514,0x630c,0xdefb,0xd6ba,0xc638,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xc638,0xd69a,0xe73c,0x6b4d,0x8c71,0xef7d,0xc638,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xc638,0xe71c,0xbdd7,0x5acb,0xce59,0xdefb,0xc618,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xef5d,0x8410,0x73ae,0xef5d,0xce79,0xc638,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xc618,0xdedb,0xce79,0x5acb,0xb596,0xe73c,0xce59,0xd6ba,0xd6ba,0xdedb,0xdedb,0xd69a,
    0xce59,0xc618,0xbdd7,0xb5b6,0xad75,0xa514,0x9cd3,0x9492,0x8c71,0x8430,0x7bef,0x7bcf,0x73ae,0x73ae,0x7bef,0x8c51,
    0x94b2,0xa514,0xad75,0xb5b6,0xc638,0xd69a,0xdefb,0xef5d,0xef5d,0xef5d,0xe71c,0xffff,0xa514,0x6b4d,0xf79e,0xe73c,
    0xd6ba,0xdedb,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xdedb,0xd6ba,
    0xe73c,0xf79e,0x6b4d,0xa514,0xffff,0xe71c,0xef5d,0xef5d,0xef5d,0xdefb,0xd69a,0xc638,0xbdd7,0xad75,0xa534,0x9cd3,
    0x8c71,0x8410,0x73ae,0x73ae,0x7bcf,0x7bef,0x8430,0x9492,0x94b2,0x9cd3,0xa534,0xad75,0xb5b6,0xbdd7,0xc618,0xce59,
    0xd69a,0xd6ba,0xdedb,0xd6ba,0xd6ba,0xce59,0xef5d,0xb596,0x5acb,0xce79,0xdedb,0xc618,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xc638,0xce79,0xef5d,0x73ae,0x8410,0xef5d,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xc618,0xdefb,0xce59,0x5acb,0xbdd7,0xe71c,0xc638,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xc638,0xef7d,0x8c71,0x6b4d,0xe73c,0xd69a,0xc638,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xc638,0xd6ba,0xdefb,0x630c,0xa514,
    0xef5d,0xc638,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xc638,0xe73c,0xad55,0x5aeb,0xd6ba,0xdedb,0xc638,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xc638,0xce79,0xe73c,0x7bef,0x73ae,0xbdd7,0xa514,0xa514,0xa514,0xa514,
    0xa534,0xa534,0xa514,0xa514,0xa534,0xa534,0xa514,0xa514,0xa514,0xa534,0xa534,0xa514,0xa514,0xa534,0xa534,0xa514,
    0xa514,0xa534,0xa534,0xa514,0xa514,0xa514,0xa534,0xa534,0xa514,0xa514,0xa534,0xa534,0xa514,0xad75,0xa514,0x7bef,
    0x8410,0xa534,0xb596,0xa534,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xbdf7,0x7bcf,0x8410,0xef7d,0xdedb,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,
    0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce79,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf79e,
    0xa534,0x632c,0xe73c,0xdefb,0xce79,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xd6ba,0xd69a,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xf7be,0xce79,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,
    0xd69a,0xd69a,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xce79,0xef7d,0xc618,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,
    0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf7be,0x8410,0x7bcf,0xf79e,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,
    0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,
    0xd69a,0xd69a,0xd6ba,0xd6ba,0xce59,0xe73c,0xdedb,0x5aeb,0xbdd7,0xf7be,0xce79,0xdedb,0xd6ba,0xd69a,0xce79,0xbdf7,
    0xad55,0x9cd3,0x8c71,0x7bcf,0x6b4d,0x632c,0x738e,0x8c51,0x9cf3,0xb596,0xc638,0xd6ba,0xe73c,0xf79e,0xf79e,0xef5d,
    0xef5d,0xe73c,0xdefb,0xdefb,0xdedb,0xd6ba,0xd69a,0xce79,0xce79,0xce79,0xce59,0xef7d,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x632c,0x9cd3,0xef7d,0xce59,0xce79,0xce79,0xce79,0xd69a,0xd6ba,0xd6ba,0xdedb,0xdefb,0xe73c,0xef5d,
    0xef5d,0xf79e,0xf79e,0xef5d,0xdedb,0xc638,0xb596,0xa514,0x8c71,0x73ae,0x632c,0x632c,0x73ae,0x8c51,0x94b2,0xa534,
    0xbdf7,0xce59,0xd69a,0xd6ba,0xd6ba,0xce79,0xf7be,0xbdd7,0x5aeb,0xdedb,0xe73c,0xce79,0xd6ba,0xd6ba,0xd69a,0xd69a,
    0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,
    0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xf79e,0x7bcf,0x8410,0xf7be,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,
    0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xc618,0xef7d,0xce79,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd69a,0xd69a,
    0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0x9492,0x6b6d,0xef7d,0xdedb,0xce79,0xd69a,0xd6ba,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xce79,0xdefb,0xe73c,0x632c,0xa534,
    0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce79,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,
    0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xdedb,0xef7d,0x8410,0x7bcf,0xbdf7,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xa534,0xb596,0xad55,0x8410,
    0x8410,0xa534,0xb596,0xa534,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xa534,0xbdf7,0x7bcf,0x8410,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf79e,
    0xa534,0x630c,0xe73c,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xf7be,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xd69a,0xd69a,
    0xce79,0xce79,0xce79,0xd6ba,0xce79,0xef7d,0xe71c,0x632c,0xc638,0xf79e,0xb596,0x9cf3,0x8430,0x6b4d,0x630c,0x73ae,
    0x8430,0x9cd3,0xad55,0xbdd7,0xd69a,0xdefb,0xdefb,0xdefb,0xdefb,0xdedb,0xd6ba,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf79e,0x9cd3,0x632c,0xef5d,0xdefb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdefb,0xef5d,0x632c,0x9cd3,0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd6ba,0xdedb,0xdedb,0xdedb,0xdefb,0xdefb,0xd69a,0xbdf7,0xad75,0x9cf3,0x8c51,
    0x7bcf,0x632c,0x632c,0x7bef,0x9cf3,0xad75,0xef5d,0xc618,0x632c,0xe71c,0xef7d,0xce79,0xd6ba,0xce79,0xce79,0xce79,
    0xd69a,0xd69a,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0x9492,0x6b6d,0xef7d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xe73c,0x630c,0xa534,
    0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x8410,0x7bcf,0xbdf7,0xa534,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xa534,0xb596,0xa534,0x8410,
    0x8410,0xa514,0xb596,0xa514,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,
    0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,
    0xa534,0xa534,0xa534,0xa534,0xbdd7,0x7bcf,0x7bef,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x630c,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b6d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xce79,0xce79,0xce79,0xd69a,
    0xdefb,0xe73c,0xf79e,0xe73c,0xce59,0xbdd7,0xa534,0x6b6d,0x738e,0x7bef,0x8410,0x94b2,0xa514,0xb596,0xbdf7,0xc638,
    0xce59,0xce79,0xd69a,0xd6ba,0xdedb,0xdefb,0xdefb,0xdedb,0xdedb,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x6b4d,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x6b4d,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd6ba,0xdedb,0xdefb,0xdefb,0xdedb,0xd6ba,0xd69a,0xce79,0xce59,
    0xc638,0xbdf7,0xb596,0xa534,0x9cd3,0x8430,0x7bef,0x738e,0x6b6d,0xa514,0xb5b6,0xc638,0xe71c,0xf79e,0xef5d,0xdefb,
    0xd6ba,0xce79,0xce79,0xce79,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b6d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x630c,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x7bef,0x7bcf,0xbdd7,0xa534,0xa534,0xa534,0xa534,
    0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,
    0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa514,0xad75,0xa534,0x8410,
    0x7bef,0xa514,0xb596,0xa514,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,
    0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,
    0xa534,0xa534,0xa534,0xa534,0xbdd7,0x7bcf,0x7bef,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b4d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xce79,0xce79,0xd69a,0xd6ba,0xdefb,0xef5d,0xe73c,0xd6ba,
    0xbdf7,0xad75,0x9cd3,0x8c71,0x8c51,0x94b2,0x94b2,0x6b6d,0x8c71,0xad55,0xad75,0xc618,0xce79,0xe71c,0xe73c,0xe73c,
    0xe71c,0xdefb,0xd6ba,0xd6ba,0xd69a,0xce59,0xce79,0xce59,0xce79,0xce79,0xce79,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce59,0xce79,0xd6ba,0xd6ba,0xdedb,0xe71c,
    0xe73c,0xe73c,0xe71c,0xd6ba,0xc638,0xb596,0xad75,0x9492,0x6b4d,0x94b2,0x94b2,0x8c51,0x8c71,0x94b2,0xad55,0xbdf7,
    0xd69a,0xe73c,0xe73c,0xdefb,0xd6ba,0xd69a,0xce79,0xce79,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b4d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x7bef,0x7bcf,0xbdd7,0xa534,0xa534,0xa534,0xa534,
    0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,
    0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa514,0xad75,0xa534,0x7bef,
    0x8410,0xa514,0xb596,0xa514,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,
    0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,
    0xa534,0xa534,0xa534,0xa534,0xbdd7,0x7bcf,0x7bef,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b4d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xd69a,0xd6ba,0xdedb,0xdefb,0xdedb,0xd69a,0xce59,0xc618,0xb5b6,0xa534,
    0x9492,0x8410,0x73ae,0x7bcf,0x8c51,0xbdd7,0xbdf7,0x630c,0xce79,0xffff,0xdefb,0xe71c,0xd6ba,0xce79,0xce59,0xce79,
    0xce79,0xce79,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xce79,0xce79,
    0xce79,0xce59,0xce79,0xd6ba,0xdefb,0xdefb,0xffff,0xce79,0x630c,0xc618,0xbdd7,0x8c71,0x7bef,0x738e,0x7bef,0x9492,
    0xa514,0xb596,0xbdf7,0xce59,0xce79,0xdedb,0xe71c,0xdedb,0xd6ba,0xd6ba,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b4d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x7bef,0x7bcf,0xbdd7,0xa534,0xa534,0xa534,0xa534,
    0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,
    0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa514,0xad75,0xa534,0x8410,
    0x8410,0xa534,0xb596,0xa534,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xa534,0xbdf7,0x7bcf,0x8410,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf79e,
    0xa534,0x630c,0xe73c,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xf7be,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xdedb,0xd6ba,0xdefb,0xdefb,0xce59,0xad55,0x8c71,0x738e,0x630c,0x7bcf,
    0x9cd3,0xbdd7,0xdefb,0xef5d,0xdefb,0xf79e,0xdefb,0x5aeb,0xb596,0xef5d,0xc638,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xef5d,0xdefb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdefb,0xef5d,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xc638,0xef5d,0xb596,0x5aeb,0xdefb,0xef7d,0xdefb,0xef5d,0xe71c,0xbdf7,0x9cf3,
    0x7bef,0x630c,0x6b6d,0x8c71,0xa534,0xc638,0xdedb,0xdedb,0xd6ba,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0x9492,0x6b6d,0xef7d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xe73c,0x630c,0xa534,
    0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x8410,0x7bcf,0xbdf7,0xa534,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xa534,0xb596,0xa534,0x8410,
    0x8410,0xa534,0xb596,0xa534,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xa534,0xbdf7,0x7bcf,0x8410,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf79e,
    0xa534,0x630c,0xe73c,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xf7be,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xce79,
    0xce79,0xce79,0xd69a,0xdefb,0xe73c,0xef7d,0xce79,0xad55,0x8430,0x6b4d,0x6b6d,0x8410,0xa514,0xbdd7,0xd69a,0xdedb,
    0xd6ba,0xd6ba,0xdedb,0xdedb,0xce79,0xe73c,0xdedb,0x5aeb,0xb5b6,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xef5d,0xdefb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdefb,0xef5d,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xdedb,0xe73c,0xce79,0xd6ba,0xd6ba,0xd6ba,0xd6ba,
    0xd6ba,0xd6ba,0xbdf7,0xa534,0x8c51,0x6b6d,0x632c,0x8410,0xa534,0xc638,0xef5d,0xef5d,0xdefb,0xd6ba,0xce79,0xce79,
    0xce79,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0x9492,0x6b6d,0xef7d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xe73c,0x630c,0xa534,
    0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x8410,0x7bcf,0xbdf7,0xa534,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xa534,0xb596,0xa534,0x8410,
    0x7bef,0xa514,0xb596,0xa514,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,
    0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,
    0xa534,0xa534,0xa534,0xa534,0xbdd7,0x7bcf,0x7bef,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b4d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xce79,0xce79,0xd69a,0xdedb,
    0xe73c,0xef7d,0xdedb,0xbdd7,0x9cd3,0x7bcf,0x7bef,0x8c71,0x9cf3,0xad55,0xbdd7,0xc618,0xce79,0xdedb,0xe71c,0xdefb,
    0xdedb,0xd6ba,0xd69a,0xd69a,0xc638,0xe71c,0xd6ba,0x5acb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xc638,0xd69a,0xd69a,0xd6ba,0xd6ba,
    0xdefb,0xe71c,0xdedb,0xce79,0xc618,0xbdd7,0xad55,0xa514,0x9492,0x8410,0x7bcf,0x94b2,0xb5b6,0xd6ba,0xef7d,0xef5d,
    0xdedb,0xd69a,0xce79,0xce79,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b4d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x7bef,0x7bcf,0xbdd7,0xa534,0xa534,0xa534,0xa534,
    0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,
    0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa514,0xad75,0xa534,0x7bef,
    0x7bef,0xa514,0xb596,0xa514,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,
    0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,
    0xa534,0xa534,0xa534,0xa534,0xbdd7,0x7bcf,0x7bef,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b4d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xd6ba,0xe71c,0xe73c,0xdefb,0xce59,
    0xb5b6,0xa514,0x9492,0x8c71,0x8430,0x8430,0x9cf3,0xb5b6,0xd69a,0xe73c,0xef5d,0xe71c,0xdedb,0xd6ba,0xce79,0xce59,
    0xce79,0xce79,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5acb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xce79,0xce79,
    0xce59,0xce79,0xd69a,0xdedb,0xdefb,0xef5d,0xe73c,0xd69a,0xbdd7,0xa514,0x8c51,0x8430,0x8c51,0x9492,0x9cf3,0xb596,
    0xc638,0xdedb,0xe73c,0xe71c,0xd6ba,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b4d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x7bef,0x7bcf,0xbdd7,0xa534,0xa534,0xa534,0xa534,
    0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,
    0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa514,0xad75,0xa534,0x7bef,
    0x8410,0xa534,0xb596,0xa534,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xa534,0xbdf7,0x7bcf,0x8410,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x630c,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b6d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd6ba,0xdedb,0xdedb,0xd69a,0xce79,0xc638,0xb596,0x9cd3,
    0x8410,0x6b6d,0x7bcf,0x9cf3,0xc638,0xef5d,0xef7d,0xe71c,0xd6ba,0xce79,0xce79,0xce79,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xce79,0xce79,0xce79,0xd6ba,0xdefb,0xef5d,0xef7d,0xce79,0xa514,0x8410,0x6b4d,0x7bef,
    0x94b2,0xad75,0xc638,0xce79,0xd69a,0xdedb,0xdedb,0xd6ba,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b6d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x630c,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x8410,0x7bcf,0xbdf7,0xa534,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xa534,0xb596,0xa534,0x8410,
    0x8410,0xa534,0xb596,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xad55,0xa534,0xad55,0xad55,0xa534,
    0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xad55,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,
    0xa534,0xad55,0xa534,0xa534,0xbdf7,0x7bcf,0x8410,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf79e,
    0xa534,0x630c,0xe73c,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xf7be,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd6ba,0xce79,0xd69a,0xd6ba,0xdefb,0xe73c,0xd69a,0xb596,0x8c51,0x632c,0x632c,0x8c71,
    0xb5b6,0xdedb,0xe73c,0xdefb,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xe73c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xef5d,0xdefb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdefb,0xef5d,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xdefb,0xe73c,0xdefb,0xbdf7,
    0x94b2,0x6b4d,0x630c,0x8410,0xad55,0xd69a,0xe71c,0xdedb,0xd6ba,0xd69a,0xce79,0xd6ba,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0x9492,0x6b6d,0xef7d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xe73c,0x630c,0xa534,
    0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x8410,0x7bcf,0xbdf7,0xa534,0xa534,0xad55,0xa534,
    0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xad55,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,
    0xa534,0xad55,0xad55,0xa534,0xad55,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xb596,0xa534,0x8410,
    0x8410,0xa534,0xb596,0xa534,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xa534,0xbdf7,0x7bcf,0x8410,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf79e,
    0xa534,0x630c,0xe73c,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xf7be,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x73ae,0xef7d,0xd6ba,0xdefb,0xef5d,0xdefb,0xb596,0x8410,0x6b4d,0x7bcf,0x9cf3,0xbdd7,0xce59,0xd69a,
    0xd6ba,0xdedb,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xe73c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xef5d,0xdefb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdefb,0xef5d,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xdedb,0xd6ba,
    0xd69a,0xce79,0xbdf7,0xa514,0x7bef,0x6b6d,0x7bcf,0xad55,0xdedb,0xef5d,0xdefb,0xdedb,0xef7d,0x73ae,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0x9492,0x6b6d,0xef7d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xe73c,0x630c,0xa534,
    0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x8410,0x7bcf,0xbdf7,0xa534,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xa534,0xb596,0xa534,0x8410,
    0x7bef,0xa514,0xb596,0xa514,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,
    0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,
    0xa534,0xa534,0xa534,0xa534,0xbdd7,0x7bcf,0x7bef,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b4d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xce79,
    0xef7d,0x7bef,0x8430,0xffff,0xdedb,0xb5b6,0x9492,0x7bef,0x8c51,0x9492,0xa514,0xbdd7,0xce59,0xdefb,0xe71c,0xdefb,
    0xd6ba,0xd69a,0xce79,0xce79,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5acb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xce79,0xce79,0xd69a,0xd6ba,
    0xdedb,0xe71c,0xe71c,0xce79,0xbdd7,0xa534,0x9492,0x8c51,0x7bef,0x8c71,0xad75,0xd69a,0xffff,0x8430,0x7bef,0xef7d,
    0xce79,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b4d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x7bef,0x7bcf,0xbdd7,0xa534,0xa534,0xa534,0xa534,
    0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,
    0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa514,0xad75,0xa534,0x7bef,
    0x7bef,0xa514,0xb596,0xa514,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,
    0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,
    0xa534,0xa534,0xa534,0xa534,0xbdd7,0x7bcf,0x7bef,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b4d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xce79,0xd69a,0xdefb,
    0xffff,0x8c71,0x738e,0xc638,0x9cf3,0x8c51,0x8410,0x8410,0xad55,0xce79,0xe73c,0xef5d,0xdefb,0xd69a,0xce59,0xce59,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5acb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xce59,0xce59,0xd69a,0xdedb,0xe73c,0xef5d,0xd6ba,0xb596,0x8430,0x7bef,0x8c51,0x9cd3,0xc618,0x73ae,0x8c71,0xffdf,
    0xdefb,0xd6ba,0xce79,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b4d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x7bef,0x7bcf,0xbdd7,0xa534,0xa534,0xa534,0xa534,
    0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,
    0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa514,0xad75,0xa534,0x7bef,
    0x8410,0xa534,0xb596,0xa534,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xa534,0xbdf7,0x7bcf,0x8410,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf79e,
    0xa534,0x630c,0xe73c,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xf7be,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd6ba,0xd69a,
    0xdedb,0x9492,0x630c,0x7bcf,0x7bef,0xa514,0xd6ba,0xef7d,0xe73c,0xdedb,0xce79,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xe73c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xef5d,0xdefb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdefb,0xef5d,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xce79,0xd6ba,0xe71c,0xef7d,0xdedb,0xad75,0x8410,0x7bcf,0x630c,0x9492,0xd6ba,
    0xd69a,0xd6ba,0xdedb,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0x9492,0x6b6d,0xef7d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xe73c,0x630c,0xa534,
    0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x8410,0x7bcf,0xbdf7,0xa534,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xa534,0xb596,0xa534,0x8410,
    0x8410,0xa534,0xb596,0xa534,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xa534,0xbdf7,0x7bcf,0x8410,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf79e,
    0xa534,0x630c,0xe73c,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xf7be,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xd6ba,0xe71c,0xe71c,0xc638,0x9492,
    0x73ae,0x5aeb,0x8c71,0xdefb,0xdefb,0xdefb,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xe73c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xef5d,0xdefb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdefb,0xef5d,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xdedb,0xe71c,0xe71c,0x8c71,0x5aeb,0x7bcf,
    0x8c51,0xbdf7,0xe71c,0xe71c,0xdedb,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0x9492,0x6b6d,0xef7d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xe73c,0x630c,0xa534,
    0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x8410,0x7bcf,0xbdf7,0xa534,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xa534,0xb596,0xa534,0x8410,
    0x8410,0xa514,0xb596,0xa514,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,
    0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,
    0xa534,0xa534,0xa534,0xa534,0xbdd7,0x7bcf,0x8410,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x630c,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b6d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xce79,0xd69a,0xe71c,0xef7d,0xd69a,0xa534,0x73ae,0x73ae,0x9cf3,
    0xd69a,0x8410,0x8410,0xf79e,0xdefb,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x6b4d,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x6b4d,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xdefb,0xf7be,0x8410,0x8410,0xdedb,
    0xa514,0x7bef,0x73ae,0x9cd3,0xce79,0xef5d,0xe73c,0xd69a,0xce79,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b6d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x630c,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x8410,0x7bcf,0xbdd7,0xa534,0xa534,0xa534,0xa534,
    0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,
    0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa514,0xad75,0xa534,0x8410,
    0x7bef,0xa514,0xb596,0xa514,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,
    0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,
    0xa534,0xa534,0xa534,0xa534,0xbdd7,0x7bcf,0x7bef,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b4d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xce79,0xd69a,0xdefb,0xef5d,0xdedb,0xbdd7,0x9cd3,0x8430,0x8c51,0x94b2,0xa534,0xce59,
    0xffff,0x8c71,0x73ae,0xef7d,0xd69a,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5acb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xce79,0xef7d,0x73ae,0x8c51,0xffff,
    0xce79,0xad75,0x94b2,0x8c51,0x8c71,0x94b2,0xb596,0xd6ba,0xef5d,0xe71c,0xd69a,0xce79,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b4d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x7bef,0x7bcf,0xbdd7,0xa534,0xa534,0xa534,0xa534,
    0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,
    0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa514,0xad75,0xa534,0x7bef,
    0x7bef,0xa514,0xb596,0xa514,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,
    0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,
    0xa534,0xa534,0xa534,0xa534,0xbdd7,0x7bcf,0x7bef,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b4d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce79,0xd69a,0xd6ba,0xdefb,0xdedb,0xce59,0xbdd7,0xa534,0x8c51,0x7bcf,0x8c51,0xb5b6,0xe71c,0xef5d,0xdedb,
    0xf79e,0x7bef,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5acb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x7bef,0xef7d,
    0xdedb,0xef5d,0xe73c,0xbdf7,0x94b2,0x7bcf,0x8430,0xa514,0xbdd7,0xce59,0xdedb,0xdefb,0xd6ba,0xd69a,0xce79,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b4d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x7bef,0x7bcf,0xbdd7,0xa534,0xa534,0xa534,0xa534,
    0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,
    0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa514,0xad75,0xa534,0x7bef,
    0x8410,0xa534,0xb596,0xa534,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xa534,0xbdf7,0x7bcf,0x8410,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf79e,
    0xa534,0x630c,0xe73c,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xf7be,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd6ba,0xd6ba,0xdedb,0xc638,0x94b2,0x6b4d,0x738e,0xa514,0xd69a,0xef5d,0xe71c,0xce79,0xce79,0xce79,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xe73c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xef5d,0xdefb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdefb,0xef5d,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf79e,0x7bcf,0x8410,0xf79e,
    0xce79,0xce79,0xce79,0xdedb,0xef5d,0xdedb,0xad75,0x73ae,0x632c,0x8c71,0xc618,0xdedb,0xd6ba,0xdedb,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0x9492,0x6b6d,0xef7d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xe73c,0x630c,0xa534,
    0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x8410,0x7bcf,0xbdf7,0xa534,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xa534,0xb596,0xa534,0x8410,
    0x8410,0xa534,0xb596,0xa534,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xa534,0xbdf7,0x7bcf,0x8410,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf79e,
    0xa534,0x630c,0xe73c,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xf7be,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xd69a,0xe73c,0xef5d,0xbdf7,0x7bcf,0x632c,0x8c51,0xbdf7,0xd6ba,0xdedb,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xe73c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xef5d,0xdefb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdefb,0xef5d,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xc618,0x94b2,0x632c,0x738e,0xb5b6,0xef5d,0xe73c,0xd69a,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0x9492,0x6b6d,0xef7d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xe73c,0x630c,0xa534,
    0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x8410,0x7bcf,0xbdf7,0xa534,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xa534,0xb596,0xa534,0x8410,
    0x7bef,0xa514,0xb596,0xa514,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,
    0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,
    0xa534,0xa534,0xa534,0xa534,0xbdd7,0x7bcf,0x7bef,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b4d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xce79,0xdedb,0xef7d,
    0xdefb,0xad55,0x8410,0x7bcf,0x9492,0xad75,0xce59,0xdedb,0xdefb,0xdedb,0xd69a,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5acb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xdefb,0xdefb,0xce59,0xb596,0x9cd3,0x7bef,0x7bef,0xa514,0xd6ba,
    0xef7d,0xdefb,0xd69a,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b4d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x7bef,0x7bcf,0xbdd7,0xa534,0xa534,0xa534,0xa534,
    0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,
    0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa514,0xad75,0xa534,0x7bef,
    0x7bef,0xa514,0xb596,0xa514,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,
    0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,
    0xa534,0xa534,0xa534,0xa534,0xbdd7,0x7bcf,0x7bef,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b4d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xdefb,0xe73c,0xce59,0xad55,
    0x9492,0x8430,0x8c51,0xa534,0xce79,0xe73c,0xe71c,0xd6ba,0xce79,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5acb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xce79,0xd69a,0xdefb,0xe73c,0xd69a,0xad55,0x8430,0x8430,0x9492,
    0xa534,0xc638,0xe73c,0xe71c,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b4d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x7bef,0x7bcf,0xbdd7,0xa534,0xa534,0xa534,0xa534,
    0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,
    0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa514,0xad75,0xa534,0x7bef,
    0x8410,0xa534,0xb596,0xa514,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,
    0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,
    0xa534,0xa534,0xa534,0xa534,0xbdd7,0x7bcf,0x8410,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x630c,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b6d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xdedb,0xd6ba,0xce79,0xc618,0x9cd3,0x738e,
    0x73ae,0xad55,0xdefb,0xef5d,0xdedb,0xce79,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xce79,0xd6ba,0xe73c,0xe71c,0xb5b6,0x7bcf,
    0x738e,0x94b2,0xbdd7,0xce59,0xd6ba,0xdefb,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b6d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x630c,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x8410,0x7bcf,0xbdd7,0xa534,0xa534,0xa534,0xa534,
    0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,
    0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa514,0xad75,0xad55,0x8410,
    0x8410,0xa534,0xb596,0xa534,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xa534,0xbdf7,0x7bcf,0x8410,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf79e,
    0xa534,0x630c,0xe73c,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xf7be,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xd69a,0xd69a,0xd69a,0xdedb,0xdefb,0xce59,0x9492,0x6b4d,0x8430,0xbdf7,
    0xe71c,0xdefb,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xe73c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xef5d,0xdefb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdefb,0xef5d,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xdefb,0xe71c,
    0xce59,0x8c71,0x632c,0x8430,0xc618,0xdefb,0xdedb,0xd69a,0xd69a,0xd69a,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0x9492,0x6b6d,0xef7d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xe73c,0x630c,0xa534,
    0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x8410,0x7bcf,0xbdf7,0xa534,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xa534,0xb596,0xa534,0x8410,
    0x8410,0xa534,0xb596,0xa534,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xa534,0xbdf7,0x7bcf,0x8410,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf79e,
    0xa534,0x630c,0xe73c,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xf7be,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xef5d,0xce59,0x8430,0x6b6d,0x94b2,0xc618,0xd69a,0xdedb,
    0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xe73c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xef5d,0xdefb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdefb,0xef5d,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xdedb,0xd6ba,0xc638,0x9cf3,0x738e,0x7bcf,0xbdf7,0xe73c,0xe71c,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0x9492,0x6b6d,0xef7d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xe73c,0x630c,0xa534,
    0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x8410,0x7bcf,0xbdf7,0xa534,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xa534,0xb596,0xa534,0x8410,
    0x7bef,0xa514,0xb596,0xa514,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,
    0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,
    0xa534,0xa534,0xa534,0xa534,0xbdd7,0x7bcf,0x7bef,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b4d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xdefb,0xef5d,0xc638,0x9492,0x7bef,0x9492,0xad55,0xce59,0xdefb,0xe71c,0xd6ba,
    0xce79,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5acb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xce79,
    0xd69a,0xdefb,0xe71c,0xce79,0xb596,0x9492,0x8410,0x8c51,0xbdf7,0xe73c,0xe71c,0xd69a,0xce59,0xce79,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b4d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x7bef,0x7bcf,0xbdd7,0xa534,0xa534,0xa534,0xa534,
    0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,
    0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa514,0xad75,0xa534,0x7bef,
    0x7bef,0xa514,0xb596,0xa514,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,
    0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,
    0xa534,0xa534,0xa534,0xa534,0xbdd7,0x7bcf,0x7bef,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b4d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xdefb,0xe71c,0xc638,0xa534,0x8c71,0x8410,0x94b2,0xce59,0xe73c,0xdefb,0xd69a,0xce79,0xce79,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5acb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce79,0xce79,0xce79,0xdedb,0xe73c,0xd6ba,0xa514,0x8410,0x8430,0xa514,0xc618,0xdefb,0xdefb,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b4d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x7bef,0x7bcf,0xbdd7,0xa534,0xa534,0xa534,0xa534,
    0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,
    0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa514,0xad75,0xa534,0x7bef,
    0x8410,0xa534,0xb596,0xa534,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xa534,0xbdf7,0x7bcf,0x8410,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf79e,
    0xa534,0x630c,0xe73c,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xf7be,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xdedb,0xd6ba,0xd6ba,0xbdf7,0x94b2,0x6b6d,0x8c71,0xd69a,0xef7d,0xdefb,0xce79,0xce79,0xd69a,0xd6ba,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xe73c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xef5d,0xdefb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdefb,0xef5d,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd6ba,0xd69a,0xce79,0xce79,0xdedb,0xef5d,0xd6ba,0x94b2,0x6b6d,0x8c71,0xbdd7,0xd69a,0xd6ba,0xdedb,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0x9492,0x6b6d,0xef7d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xe73c,0x630c,0xa534,
    0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x8410,0x7bcf,0xbdf7,0xa534,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xa534,0xb596,0xa534,0x8410,
    0x8410,0xa534,0xb596,0xa534,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xbdf7,0x7bcf,0x8410,0xef7d,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,
    0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf79e,
    0xa534,0x632c,0xe73c,0xdefb,0xce79,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xd6ba,0xd69a,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xf7be,0xce79,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,
    0xd69a,0xd69a,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xce79,0xef7d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xdefb,0xe73c,0xce59,0x8c51,0x6b4d,0x94b2,0xd69a,0xe71c,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,
    0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf7be,0x8410,0x7bcf,0xf79e,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,
    0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,
    0xd69a,0xd69a,0xd6ba,0xd6ba,0xce59,0xe73c,0xdedb,0x5aeb,0xb5b6,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,
    0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xce79,0xf79e,0x9cd3,0x6b4d,0xef5d,0xdefb,
    0xce79,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,
    0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xce79,
    0xdefb,0xef5d,0x6b4d,0x9cd3,0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,
    0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xdedb,0xe73c,0xce59,0xd6ba,0xd6ba,0xd69a,0xd69a,
    0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,
    0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xf79e,0x7bcf,0x8410,0xf7be,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,
    0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xe71c,0xd6ba,0x9cf3,0x6b4d,0x8410,0xc618,0xe71c,0xdefb,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef7d,0xce79,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd69a,0xd69a,
    0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0x9492,0x6b6d,0xef7d,0xdedb,0xce79,0xd69a,0xd6ba,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xce79,0xdefb,0xe73c,0x632c,0xa534,
    0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,
    0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xef7d,0x8410,0x7bcf,0xbdf7,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xa534,0xb596,0xa534,0x8410,
    0x8410,0xa514,0xad75,0x9cf3,0xa534,0xa534,0xa514,0xa514,0xa534,0xa534,0xa514,0xa514,0xa514,0xa534,0xa534,0xa514,
    0xa514,0xa534,0xa534,0xa514,0xa514,0xa534,0xa534,0xa514,0xa514,0xa514,0xa534,0xa534,0xa514,0xa514,0xa534,0xa534,
    0xa514,0xa514,0xa514,0xa514,0xb5b6,0x73ae,0x7bef,0xe73c,0xce79,0xc638,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xc638,0xdedb,0xd6ba,0x5aeb,0xad55,0xef5d,0xc618,0xce79,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xc638,0xef5d,
    0xa514,0x630c,0xdefb,0xd6ba,0xc638,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xc638,0xd69a,0xe73c,0x6b4d,0x8c71,0xef7d,0xc638,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xc618,0xe73c,0xbdd7,0x5acb,0xce59,0xef5d,0xdedb,
    0xce59,0x8410,0x6b6d,0x8c71,0xb5b6,0xce59,0xd69a,0xd69a,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xef5d,0x7bef,0x73ae,0xef5d,0xce79,0xc638,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce79,0xc618,0xdefb,0xd69a,0x5acb,0xb596,0xe73c,0xc618,0xce79,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xc638,0xef5d,0x94b2,0x632c,0xe71c,0xd69a,
    0xc638,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xc638,
    0xd69a,0xe71c,0x632c,0x94b2,0xef5d,0xc638,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce79,0xc618,0xe73c,0xb596,0x5acb,0xd69a,0xdefb,0xc618,0xce79,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xc638,0xce79,0xef5d,0x73ae,0x7bef,0xef5d,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xd69a,0xd6ba,0xce59,0xbdd7,0x94b2,0x738e,0x7bcf,0xbdf7,
    0xdedb,0xef7d,0xce59,0x5acb,0xbdd7,0xe73c,0xc618,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xc638,0xef7d,0x8c71,0x6b4d,0xe73c,0xd69a,0xc638,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xc638,0xd6ba,0xdefb,0x630c,0xa514,
    0xef5d,0xc638,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce79,0xc618,0xef5d,0xad55,0x5aeb,0xd6ba,0xdedb,0xc638,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xc638,0xce79,0xe73c,0x7bef,0x73ae,0xb5b6,0xa514,0xa514,0xa514,0xa514,
    0xa534,0xa534,0xa514,0xa514,0xa534,0xa534,0xa514,0xa514,0xa514,0xa534,0xa534,0xa514,0xa514,0xa534,0xa534,0xa514,
    0xa514,0xa534,0xa534,0xa514,0xa514,0xa514,0xa534,0xa534,0xa514,0xa514,0xa534,0xa534,0x9cf3,0xad55,0xa534,0x8410,
    0x7bef,0xad75,0xc638,0xb5b6,0xbdd7,0xbdd7,0xb5b6,0xb5b6,0xbdd7,0xbdd7,0xb5b6,0xbdd7,0xb5b6,0xbdd7,0xbdd7,0xb5b6,
    0xb5b6,0xbdd7,0xbdd7,0xb5b6,0xb5b6,0xbdd7,0xbdd7,0xb5b6,0xbdd7,0xb5b6,0xbdd7,0xbdd7,0xb5b6,0xb5b6,0xbdd7,0xbdd7,
    0xb5b6,0xbdd7,0xb5b6,0xb5b6,0xce79,0x7bef,0x8430,0xffff,0xf79e,0xef5d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,
    0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,
    0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xf79e,0xef7d,0xe73c,0xffff,0xf7be,0x630c,0xbdf7,0xffff,0xe73c,0xf79e,
    0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,
    0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xf79e,0xef7d,0xef7d,0xef7d,0xf79e,0xe73c,0xffff,
    0xb596,0x632c,0xffff,0xffdf,0xe73c,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,
    0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xf79e,0xef7d,0xef7d,0xef7d,
    0xef7d,0xef7d,0xef7d,0xe73c,0xf7be,0xffff,0x738e,0x9cf3,0xffff,0xef5d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,
    0xef7d,0xef7d,0xf79e,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xf79e,
    0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xf79e,0xe73c,0xffff,0xce79,0x5aeb,0xe73c,0xef7d,0xad55,
    0xa514,0xad55,0xc618,0xe73c,0xffff,0xffdf,0xef7d,0xef5d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,
    0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef5d,0xef7d,
    0xffff,0x8c51,0x8410,0xffff,0xf79e,0xef5d,0xef7d,0xef7d,0xf79e,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,
    0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,
    0xef7d,0xef7d,0xef7d,0xf79e,0xe73c,0xffff,0xef7d,0x5aeb,0xce59,0xffff,0xe73c,0xf79e,0xef7d,0xef7d,0xef7d,0xef7d,
    0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,
    0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xf79e,0xef5d,0xffff,0xa534,0x6b4d,0xffff,0xffdf,
    0xe73c,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,
    0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xe73c,
    0xffdf,0xffff,0x6b4d,0xa534,0xffff,0xef5d,0xf79e,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,
    0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,
    0xef7d,0xef7d,0xef7d,0xef7d,0xf79e,0xe73c,0xffff,0xce59,0x5aeb,0xef7d,0xffff,0xe73c,0xf79e,0xef7d,0xef7d,0xef7d,
    0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,
    0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xf79e,0xef7d,0xef7d,0xef5d,0xf79e,0xffff,0x8410,0x8c51,0xffff,
    0xef7d,0xef5d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,
    0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef5d,0xef7d,0xffdf,0xffff,0xef5d,0xc638,0xad75,0x9cf3,
    0xa534,0xef5d,0xe73c,0x5aeb,0xce79,0xffff,0xe73c,0xf79e,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,
    0xf79e,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xf79e,0xef7d,0xef7d,
    0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef5d,0xffff,0x9cf3,0x738e,0xffff,0xf7be,0xe73c,0xef7d,0xef7d,0xef7d,
    0xef7d,0xef7d,0xef7d,0xf79e,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,
    0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xe73c,0xffdf,0xffff,0x632c,0xb596,
    0xffff,0xe73c,0xf79e,0xef7d,0xef7d,0xef7d,0xf79e,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,
    0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,
    0xf79e,0xe73c,0xffff,0xbdf7,0x630c,0xf7be,0xffff,0xe73c,0xef7d,0xf79e,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,
    0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,
    0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xef5d,0xf79e,0xffff,0x8430,0x7bef,0xce79,0xb5b6,0xb5b6,0xbdd7,0xb5b6,
    0xbdd7,0xbdd7,0xb5b6,0xb5b6,0xbdd7,0xbdd7,0xb5b6,0xbdd7,0xb5b6,0xbdd7,0xbdd7,0xb5b6,0xb5b6,0xbdd7,0xbdd7,0xb5b6,
    0xb5b6,0xbdd7,0xbdd7,0xb5b6,0xbdd7,0xb5b6,0xbdd7,0xbdd7,0xb5b6,0xb5b6,0xbdd7,0xbdd7,0xb5b6,0xc618,0xb5b6,0x7bef,
    0x7bef,0x9492,0x94b2,0x8c71,0x9492,0x9492,0x9492,0x9492,0x9492,0x9492,0x9492,0x9492,0x9492,0x9492,0x9492,0x9492,
    0x9492,0x9492,0x9492,0x9492,0x9492,0x9492,0x9492,0x9492,0x9492,0x9492,0x9492,0x9492,0x9492,0x9492,0x9492,0x9492,
    0x9492,0x9492,0x9492,0x9492,0x9cf3,0x7bcf,0x7bef,0xc618,0xb5b6,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,
    0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,
    0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb5b6,0xad75,0xbdd7,0xbdd7,0x6b6d,0x9cf3,0xc638,0xb596,0xb596,
    0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,
    0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xad75,0xc638,
    0x94b2,0x6b6d,0xbdf7,0xbdd7,0xad75,0xb5b6,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,
    0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,
    0xb596,0xb596,0xb596,0xad75,0xbdd7,0xc618,0x73ae,0x8c51,0xce59,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,
    0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,
    0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xad75,0xc638,0xad75,0x6b4d,0xb5b6,0xa534,0x630c,
    0x6b4d,0xad75,0xce79,0xbdf7,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,
    0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,
    0xc638,0x8410,0x7bcf,0xc638,0xb5b6,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,
    0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,
    0xb596,0xb596,0xb596,0xb5b6,0xad75,0xbdf7,0xb5b6,0x6b4d,0xa514,0xc638,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,
    0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,
    0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xc638,0x9492,0x738e,0xbdf7,0xbdd7,
    0xad75,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,
    0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xad75,
    0xbdd7,0xbdf7,0x738e,0x9492,0xc638,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,
    0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,
    0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xc638,0xa514,0x6b4d,0xb5b6,0xbdf7,0xad75,0xb5b6,0xb596,0xb596,0xb596,
    0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,
    0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb5b6,0xc638,0x7bcf,0x8410,0xc638,
    0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,
    0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xad75,0xbdd7,0xce59,0xb5b6,0x738e,
    0x5aeb,0x9cf3,0xb5b6,0x6b4d,0xb596,0xce59,0xad75,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,
    0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,
    0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xce59,0x8c51,0x73ae,0xc618,0xbdd7,0xad75,0xb596,0xb596,0xb596,
    0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,
    0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb5b6,0xad75,0xbdd7,0xbdf7,0x6b6d,0x94b2,
    0xc638,0xad75,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,
    0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,
    0xb596,0xb596,0xc638,0x9cf3,0x6b6d,0xbdd7,0xbdd7,0xad75,0xb5b6,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,
    0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,
    0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb596,0xb5b6,0xc618,0x7bef,0x7bcf,0x9cf3,0x9492,0x9492,0x9492,0x9492,
    0x9492,0x9492,0x9492,0x9492,0x9492,0x9492,0x9492,0x9492,0x9492,0x9492,0x9492,0x9492,0x9492,0x9492,0x9492,0x9492,
    0x9492,0x9492,0x9492,0x9492,0x9492,0x9492,0x9492,0x9492,0x9492,0x9492,0x9492,0x9492,0x9492,0x94b2,0x9492,0x7bef,
    0x8410,0x738e,0x6b4d,0x6b4d,0x6b4d,0x6b4d,0x6b4d,0x6b4d,0x6b4d,0x6b4d,0x6b4d,0x6b4d,0x6b4d,0x6b4d,0x6b4d,0x6b4d,
    0x6b4d,0x6b4d,0x6b4d,0x6b4d,0x6b4d,0x6b4d,0x6b4d,0x6b4d,0x6b4d,0x6b4d,0x6b4d,0x6b4d,0x6b4d,0x6b4d,0x6b4d,0x6b4d,
    0x6b4d,0x6b4d,0x6b4d,0x6b4d,0x738e,0x738e,0x6b4d,0x632c,0x5aeb,0x5acb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,
    0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,
    0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5acb,0x5aeb,0x6b4d,0x6b6d,0x6b4d,0x630c,0x5aeb,0x5aeb,
    0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,
    0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x630c,
    0x6b4d,0x6b6d,0x6b4d,0x5aeb,0x5acb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,
    0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,
    0x5aeb,0x5aeb,0x5aeb,0x5acb,0x5aeb,0x632c,0x6b6d,0x6b4d,0x632c,0x5acb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,
    0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,
    0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x630c,0x630c,0x6b4d,0x738e,0x6b6d,0x6b4d,0x738e,
    0x738e,0x632c,0x5acb,0x5acb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,
    0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5acb,
    0x632c,0x6b4d,0x6b4d,0x632c,0x5aeb,0x5acb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,
    0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,
    0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5acb,0x5aeb,0x6b4d,0x6b6d,0x6b4d,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,
    0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,
    0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5acb,0x630c,0x6b4d,0x6b6d,0x6b4d,0x5aeb,
    0x5acb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,
    0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5acb,
    0x5aeb,0x6b4d,0x6b6d,0x6b4d,0x630c,0x5acb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,
    0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,
    0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x6b4d,0x6b6d,0x6b4d,0x5aeb,0x5acb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,
    0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,
    0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5acb,0x5aeb,0x632c,0x6b4d,0x6b4d,0x632c,
    0x5acb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,
    0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5acb,0x5acb,0x630c,0x738e,
    0x738e,0x6b4d,0x6b6d,0x738e,0x6b4d,0x630c,0x630c,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,
    0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,
    0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5acb,0x632c,0x6b4d,0x6b6d,0x632c,0x5aeb,0x5acb,0x5aeb,0x5aeb,0x5aeb,
    0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,
    0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5acb,0x5aeb,0x6b4d,0x6b6d,0x6b4d,
    0x630c,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,
    0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,
    0x5aeb,0x5aeb,0x630c,0x6b4d,0x6b6d,0x6b4d,0x5aeb,0x5acb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,
    0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,
    0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5acb,0x5aeb,0x632c,0x6b4d,0x738e,0x738e,0x6b4d,0x6b4d,0x6b4d,0x6b4d,
    0x6b4d,0x6b4d,0x6b4d,0x6b4d,0x6b4d,0x6b4d,0x6b4d,0x6b4d,0x6b4d,0x6b4d,0x6b4d,0x6b4d,0x6b4d,0x6b4d,0x6b4d,0x6b4d,
    0x6b4d,0x6b4d,0x6b4d,0x6b4d,0x6b4d,0x6b4d,0x6b4d,0x6b4d,0x6b4d,0x6b4d,0x6b4d,0x6b4d,0x6b4d,0x6b4d,0x73ae,0x8410,
    0x8410,0xce79,0xf79e,0xdedb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xffdf,0x9492,0x7bef,0xf79e,0xe71c,0xdedb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdedb,0xef5d,0xe71c,0x6b6d,0xb5b6,0xf7be,0xd6ba,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdedb,0xffdf,
    0xad75,0x738e,0xe73c,0xe73c,0xdedb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdedb,0xe71c,0xf79e,0x73ae,0x9cd3,0xffdf,0xdedb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdedb,0xdefb,0xe73c,0xef7d,0xce59,0x8c51,0x738e,0xbdd7,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xffdf,0x8c71,0x8410,0xf7be,0xe71c,0xdedb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xd6ba,0xef7d,0xdefb,0x6b4d,0xbdf7,0xf7be,0xd6ba,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdedb,0xffdf,0xa514,0x738e,0xef7d,0xe73c,
    0xdedb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdedb,
    0xe73c,0xef7d,0x738e,0xa514,0xffdf,0xdedb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xd6ba,0xf7be,0xbdf7,0x6b4d,0xdefb,0xef7d,0xd6ba,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdedb,0xe71c,0xf7be,0x8410,0x8c71,0xffdf,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xe71c,0xc618,0x73ae,0x7bcf,0xc618,0xef7d,0xef5d,0xdefb,0xdedb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdedb,0xffdf,0x9cd3,0x73ae,0xf79e,0xe71c,0xdedb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdedb,0xe73c,0xe73c,0x738e,0xad75,
    0xffdf,0xdedb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xd6ba,0xf7be,0xb5b6,0x6b6d,0xe71c,0xef5d,0xdedb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdedb,0xe71c,0xf79e,0x7bef,0x9492,0xffdf,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdedb,0xef7d,0xd6ba,0x8410,
    0x7bef,0xd69a,0xf7be,0xd6ba,0xe71c,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xffff,0x8c71,0x73ae,0xffff,0xe71c,0xdedb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xe71c,0xdefb,0xdedb,0xef7d,0xef5d,0x630c,0xb5b6,0xffff,0xd6ba,0xe71c,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xe71c,0xdefb,0xdefb,0xdefb,0xe71c,0xdedb,0xffff,
    0xad75,0x632c,0xf79e,0xef7d,0xdedb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xe71c,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdedb,0xe73c,0xffdf,0x6b6d,0x94b2,0xffff,0xdedb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xe71c,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xe71c,
    0xdefb,0xdefb,0xdefb,0xe71c,0xdefb,0xdedb,0xef5d,0xffdf,0xd6ba,0x8c71,0x94b2,0x94b2,0x6b4d,0xd6ba,0xef7d,0xd6ba,
    0xdefb,0xe71c,0xdefb,0xdefb,0xdefb,0xe71c,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xffff,0x8430,0x7bef,0xffff,0xe71c,0xdefb,0xdefb,0xdefb,0xe71c,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xe71c,0xd6ba,0xf79e,0xe71c,0x5aeb,0xbdf7,0xffff,0xd6ba,0xe71c,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xe71c,0xdedb,0xffff,0xa514,0x6b4d,0xf7be,0xef5d,
    0xdedb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdedb,
    0xef5d,0xf7be,0x6b4d,0xa514,0xffff,0xdedb,0xe71c,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xe71c,0xd6ba,0xffff,0xbdf7,0x5aeb,0xe71c,0xf79e,0xd6ba,0xe71c,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xe71c,0xdefb,0xdefb,0xdefb,0xe71c,0xffff,0x7bef,0x8430,0xffff,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xe71c,0xdefb,0xdefb,0xdefb,0xe71c,0xdefb,
    0xd6ba,0xf79e,0xd6ba,0x632c,0x9cd3,0x9cd3,0x8c51,0xce79,0xf7be,0xef7d,0xdedb,0xdefb,0xe71c,0xdefb,0xdefb,0xdefb,
    0xe71c,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xe71c,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdedb,0xffff,0x94b2,0x6b6d,0xffdf,0xe73c,0xdedb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xe71c,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdedb,0xef7d,0xf79e,0x632c,0xad75,
    0xffff,0xdedb,0xe71c,0xdefb,0xdefb,0xdefb,0xe71c,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xe71c,0xd6ba,0xffff,0xb5b6,0x630c,0xef5d,0xef7d,0xdedb,0xdefb,0xe71c,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdedb,0xe71c,0xffff,0x73ae,0x8c71,0xffff,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,
    0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xdefb,0xe71c,0xdedb,0xf79e,0xdedb,0x7bef,
    0x7bef,0xc618,0xe71c,0xc638,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,
    0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,
    0xce59,0xce59,0xce59,0xce59,0xef7d,0x8430,0x738e,0xef5d,0xd69a,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,
    0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,
    0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,0xce79,0xce79,0xc638,0xdedb,0xd6ba,0x5aeb,0xad55,0xef5d,0xc638,0xce79,
    0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,
    0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,0xce79,0xce59,0xce59,0xce59,0xce79,0xc638,0xef5d,
    0xa514,0x630c,0xdefb,0xdedb,0xc638,0xce79,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,
    0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,0xce79,0xce59,0xce59,0xce59,
    0xce79,0xce79,0xce79,0xc638,0xd69a,0xe73c,0x6b4d,0x8c71,0xef7d,0xce59,0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,
    0xce59,0xce59,0xce79,0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,0xce79,
    0xce59,0xce59,0xce59,0xce59,0xce79,0xdefb,0xce79,0x9cf3,0x7bef,0x738e,0xb5b6,0xb596,0x5aeb,0xd69a,0xe71c,0xc618,
    0xce79,0xce79,0xce59,0xce59,0xce59,0xce79,0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,
    0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,0xce59,
    0xef5d,0x8410,0x73ae,0xef5d,0xce79,0xce59,0xce79,0xce59,0xce79,0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,
    0xce79,0xce79,0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,
    0xce59,0xce59,0xce79,0xce79,0xc618,0xdefb,0xd69a,0x5acb,0xb596,0xe73c,0xc638,0xce79,0xce59,0xce59,0xce59,0xce79,
    0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,
    0xce79,0xce79,0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xc638,0xef5d,0x94b2,0x632c,0xe71c,0xd6ba,
    0xc638,0xce79,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,
    0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce79,0xc638,
    0xd6ba,0xe71c,0x632c,0x94b2,0xef5d,0xc638,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,0xce79,0xce79,
    0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,
    0xce79,0xce59,0xce59,0xce59,0xce79,0xc638,0xe73c,0xb596,0x5acb,0xd69a,0xdefb,0xc618,0xce79,0xce79,0xce59,0xce59,
    0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,0xce79,0xce79,
    0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,0xce79,0xce59,0xce79,0xce59,0xce79,0xef5d,0x73ae,0x8410,0xef5d,
    0xce59,0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,
    0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,0xce79,0xce59,0xce59,0xce59,0xce79,0xce79,
    0xc618,0xe71c,0xce79,0x5aeb,0xbdd7,0xbdf7,0x73ae,0x7bef,0x94b2,0xce59,0xdefb,0xd69a,0xce59,0xce59,0xce59,0xce59,
    0xce79,0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,0xce79,0xce59,0xce59,
    0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,0xce59,0xef7d,0x8c71,0x6b4d,0xe73c,0xd69a,0xc638,0xce79,0xce79,0xce79,
    0xce59,0xce59,0xce59,0xce79,0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,
    0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce79,0xc638,0xdedb,0xdefb,0x630c,0xa514,
    0xef5d,0xc638,0xce79,0xce59,0xce59,0xce59,0xce79,0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,
    0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,
    0xce79,0xc638,0xef5d,0xad55,0x5aeb,0xd6ba,0xdedb,0xc638,0xce79,0xce79,0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,
    0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,
    0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xd69a,0xef5d,0x738e,0x8430,0xef7d,0xce59,0xce59,0xce59,0xce59,
    0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,
    0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xc638,0xdefb,0xce59,0x7bef,
    0x8410,0xc638,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xdefb,0x630c,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x632c,0xe71c,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b6d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce79,0xd69a,0xdedb,0xdefb,0xce59,0x9cd3,0x738e,0x8c51,0xc618,0xffff,0xce59,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x6b4d,0xe73c,0xdedb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdedb,0xe73c,0x6b4d,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xc638,0xffff,0xce79,0x9492,0x738e,0x9492,0xc618,0xdedb,0xdefb,0xd69a,0xce79,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b6d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xe71c,0x632c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x630c,0xdefb,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x8410,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf79e,
    0xa534,0x630c,0xe73c,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xf7be,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xd69a,0xd69a,0xdedb,0xdefb,0xc638,0x7bcf,0x738e,0xbdd7,0xe73c,0xd6ba,0xef5d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xe73c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xef5d,0xdefb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdefb,0xef5d,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef5d,0xd6ba,0xe73c,0xc638,0x7bcf,0x738e,0xbdd7,0xdefb,0xdedb,0xd69a,0xd69a,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0x9492,0x6b6d,0xef7d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xe73c,0x630c,0xa534,
    0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf79e,
    0xa534,0x630c,0xe73c,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xf7be,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce79,0xe71c,0xdefb,0xa514,0x6b6d,0x9492,0xce59,0xdedb,0xdedb,0xce79,0xef5d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xe73c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xef5d,0xdefb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdefb,0xef5d,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef5d,0xce79,0xdedb,0xdedb,0xd69a,0x9cf3,0x6b6d,0x94b2,0xd6ba,0xe73c,0xce79,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0x9492,0x6b6d,0xef7d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xe73c,0x630c,0xa534,
    0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b4d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xce79,0xd6ba,
    0xef5d,0xc618,0x8430,0x7bef,0xa514,0xce79,0xdefb,0xd6ba,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5acb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd6ba,0xdefb,0xd69a,0xad55,0x8410,0x7bef,0xb5b6,0xef5d,
    0xdedb,0xce79,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b4d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b4d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xe71c,0xdedb,
    0xad75,0x8410,0x7bef,0xad75,0xe71c,0xe71c,0xce79,0xce79,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5acb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xce79,0xce79,0xdefb,0xe73c,0xbdd7,0x8410,0x7bef,0xa534,
    0xd69a,0xe71c,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b4d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf79e,
    0xa534,0x630c,0xe73c,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xf7be,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xdedb,0xd69a,0xad55,
    0x738e,0x8c51,0xce79,0xef5d,0xd6ba,0xce79,0xd69a,0xd6ba,0xd6ba,0xce59,0xef7d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xe73c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xef5d,0xdefb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdefb,0xef5d,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef7d,0xce59,0xd6ba,0xd6ba,0xd69a,0xce79,0xd69a,0xe73c,0xd6ba,0x9492,0x6b6d,
    0x9cf3,0xce59,0xdedb,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0x9492,0x6b6d,0xef7d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xe73c,0x630c,0xa534,
    0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf79e,
    0xa534,0x630c,0xe73c,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xf7be,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xe71c,0xce59,0x8c51,0x6b4d,
    0xad75,0xdefb,0xdedb,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef5d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xe73c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xef5d,0xdefb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdefb,0xef5d,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xe71c,0xbdd7,
    0x738e,0x7bef,0xbdf7,0xe71c,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0x9492,0x6b6d,0xef7d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xe73c,0x630c,0xa534,
    0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x8410,0xce59,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x630c,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b6d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xce79,0xdefb,0xe73c,0xad55,0x738e,0x8430,0xc618,
    0xdedb,0xdedb,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xdedb,0xdedb,
    0xc638,0x9492,0x738e,0x9cf3,0xe71c,0xe71c,0xce79,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b6d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x630c,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xd69a,0x8410,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b4d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xe73c,0xce79,0x9492,0x7bcf,0x94b2,0xc638,0xe73c,
    0xdedb,0xce79,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5acb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,
    0xe73c,0xce79,0x9cf3,0x7bcf,0x8c51,0xc638,0xe73c,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b4d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b4d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xdefb,0xdedb,0xbdd7,0x8c71,0x73ae,0xa514,0xdedb,0xe73c,0xd69a,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5acb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xce79,0xe71c,0xe71c,0xad75,0x73ae,0x8430,0xb596,0xd6ba,0xdefb,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b4d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf79e,
    0xa534,0x630c,0xe73c,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xf7be,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xdefb,0xdedb,0xb596,0x73ae,0x7bcf,0xce59,0xe73c,0xd6ba,0xce79,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xe73c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xef5d,0xdefb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdefb,0xef5d,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce79,0xd69a,0xe71c,0xd69a,0x8430,0x738e,0xa534,0xd6ba,0xdedb,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0x9492,0x6b6d,0xef7d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xe73c,0x630c,0xa534,
    0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf79e,
    0xa534,0x630c,0xe73c,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xf7be,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xe71c,0xdedb,0x8c71,0x6b6d,0x9cf3,0xdedb,0xdedb,0xd6ba,0xd69a,0xd69a,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xe73c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xef5d,0xdefb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdefb,0xef5d,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xd69a,0xd69a,0xd6ba,0xdefb,0xdefb,0xad55,0x738e,0x8430,0xd69a,0xe71c,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0x9492,0x6b6d,0xef7d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xe73c,0x630c,0xa534,
    0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x8410,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x630c,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b4d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xdedb,0xe71c,0xbdd7,0x7bcf,0x8410,0xb596,0xd6ba,0xdefb,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x6b4d,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x6b4d,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xdefb,0xdedb,0xb5b6,0x8c51,0x738e,0xad75,0xdefb,0xdefb,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b4d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x630c,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x8410,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b4d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce79,0xd69a,0xdefb,0xd6ba,0xa534,0x7bcf,0x8c71,0xbdf7,0xdefb,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5acb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xe71c,0xc638,0x9492,0x73ae,0x9cd3,0xd69a,0xe71c,0xd69a,0xce79,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b4d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x8410,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x630c,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b4d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xd6ba,0xdefb,0xd69a,0xa514,0x738e,0x9492,0xdedb,0xe71c,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x6b4d,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x6b4d,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xe71c,0xe71c,0x9cf3,0x738e,0x94b2,0xce79,0xdefb,0xd6ba,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b4d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x630c,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x8410,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf79e,
    0xa534,0x630c,0xe73c,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xf7be,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xe71c,0xd69a,0x9cd3,0x6b6d,0xad75,0xef5d,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xe73c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xef5d,0xdefb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdefb,0xef5d,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xef5d,0xbdd7,0x738e,0x8c51,0xce79,0xe71c,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0x9492,0x6b6d,0xef7d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xe73c,0x630c,0xa534,
    0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf79e,
    0xa534,0x630c,0xe73c,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xf7be,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xe73c,
    0xce59,0x8430,0x73ae,0xbdd7,0xdefb,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xe73c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xef5d,0xdefb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdefb,0xef5d,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xdefb,0xc618,0x8410,0x7bcf,0xc618,
    0xef5d,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0x9492,0x6b6d,0xef7d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xe73c,0x630c,0xa534,
    0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b4d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xce79,0xd69a,0xe73c,0xbdf7,
    0x8410,0x7bef,0xbdd7,0xdefb,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5acb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xdefb,0xc638,0x8c51,0x7bcf,
    0xb596,0xe73c,0xd6ba,0xce79,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b4d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b4d,0x9492,0xf79e,0xce79,0xd69a,0xce79,0xdedb,0xe71c,0xbdd7,0x7bef,
    0x8410,0xc618,0xe71c,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5acb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xe73c,0xce59,0x8c51,
    0x7bcf,0xad75,0xdefb,0xdedb,0xce79,0xd69a,0xce79,0xf79e,0x9492,0x6b4d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x8410,0xce59,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x630c,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b6d,0x9492,0xf79e,0xce79,0xd69a,0xdedb,0xdefb,0xbdd7,0x7bcf,0x8c51,
    0xce59,0xe73c,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xe71c,0xd6ba,
    0x9492,0x738e,0xb596,0xdedb,0xdedb,0xd69a,0xce79,0xf79e,0x9492,0x6b6d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x630c,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xd69a,0x8410,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf79e,
    0xa534,0x630c,0xe73c,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xf7be,0xce79,0xd69a,0xe73c,0xb596,0x6b6d,0x94b2,0xd69a,
    0xe71c,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef5d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xe73c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xef5d,0xdefb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdefb,0xef5d,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xdefb,
    0xd6ba,0xa514,0x6b4d,0xad55,0xe71c,0xd6ba,0xce79,0xf7be,0x9492,0x6b6d,0xef7d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xe73c,0x630c,0xa534,
    0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf79e,
    0xa534,0x630c,0xe73c,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xf79e,0xd6ba,0xe73c,0x9cf3,0x6b6d,0xa514,0xd69a,0xdefb,
    0xd6ba,0xd69a,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xe73c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xef5d,0xdefb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdefb,0xef5d,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xd69a,0xd69a,
    0xdefb,0xd6ba,0xad75,0x6b6d,0x9492,0xe71c,0xd6ba,0xf79e,0x9492,0x6b6d,0xef7d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xe73c,0x630c,0xa534,
    0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b4d,0x9492,0xffff,0xd6ba,0x94b2,0x73ae,0xa514,0xd6ba,0xdefb,0xd69a,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5acb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xd69a,0xdedb,0xdefb,0xad55,0x7bcf,0x8c71,0xce79,0xffff,0x94b2,0x6b4d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b4d,0x9cf3,0xef7d,0x94b2,0x738e,0xad55,0xe71c,0xdedb,0xd69a,0xce79,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5acb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce79,0xd69a,0xd6ba,0xe73c,0xb596,0x73ae,0x8c51,0xef5d,0x9cf3,0x6b4d,0xef5d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf79e,
    0xa534,0x630c,0xe73c,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef7d,0x73ae,0x8c71,0xb5b6,0x6b6d,0xbdd7,0xe71c,0xd6ba,0xce79,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xe73c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xef5d,0xdefb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdefb,0xef5d,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd6ba,0xce79,0xd69a,0xe71c,0xc638,0x6b6d,0xad55,0x8c51,0x7bcf,0xef7d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xe73c,0x630c,0xa534,
    0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf79e,
    0xa534,0x630c,0xe73c,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef7d,0x8c51,0x52aa,0x8c71,0xc638,0xdedb,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xe73c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xef5d,0xdefb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdefb,0xef5d,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xdedb,0xce79,0x9492,0x5acb,0x8430,0xef7d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xe73c,0x630c,0xa534,
    0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x8410,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x630c,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xce79,0xd6ba,0xe71c,0xce79,0x73ae,0x8430,0xce79,0xdefb,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x6b4d,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x6b4d,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xdefb,0xd6ba,0x8c71,0x6b6d,0xbdf7,0xe71c,0xdedb,0xce79,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x630c,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x8410,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce79,0xdedb,0xdefb,0xb5b6,0x8c51,0x5acb,0xad55,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5acb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0xad55,0x5acb,0x8c51,0xad55,0xdedb,0xdefb,0xce79,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xdedb,0xdedb,0xad75,0x8410,0x9cf3,0x632c,0x9cf3,0xef7d,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5acb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xef7d,0x9cd3,0x6b4d,0xad75,0x7bcf,0xa514,0xdedb,0xdedb,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x8410,0xce59,0xef5d,0xce79,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,
    0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,
    0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf79e,
    0xa534,0x632c,0xe73c,0xdefb,0xce79,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xdedb,0xe71c,0xad75,0x738e,0x9cd3,0xffdf,0x7bcf,0x8c71,0xf7be,0xce79,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,
    0xd69a,0xd69a,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xce79,0xef7d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,
    0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf7be,0x8410,0x7bcf,0xf79e,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,
    0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,
    0xd69a,0xd69a,0xd6ba,0xd6ba,0xce59,0xe73c,0xdedb,0x5aeb,0xb5b6,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,
    0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xce79,0xf79e,0x9cd3,0x6b4d,0xef5d,0xdefb,
    0xce79,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,
    0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xce79,
    0xdefb,0xef5d,0x6b4d,0x9cd3,0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,
    0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xdedb,0xe73c,0xce59,0xd6ba,0xd6ba,0xd69a,0xd69a,
    0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,
    0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xf79e,0x7bcf,0x8410,0xf7be,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,
    0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef7d,0xce79,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd69a,0xd69a,
    0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0x8c71,0x7bcf,0xffff,0xad55,0x738e,0xa534,0xe71c,0xdedb,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xce79,0xdefb,0xe73c,0x632c,0xa534,
    0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,
    0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,
    0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x8410,0xc638,0xe71c,0xc638,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,
    0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,
    0xce59,0xce59,0xce59,0xce59,0xef7d,0x8430,0x738e,0xef5d,0xd69a,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,
    0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,
    0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,0xce79,0xce59,0xc638,0xdedb,0xdedb,0x5aeb,0xad55,0xef5d,0xc638,0xce79,
    0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,
    0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,0xce79,0xce59,0xce59,0xce59,0xce79,0xc638,0xef5d,
    0xa514,0x630c,0xdefb,0xd6ba,0xc638,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,
    0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,0xce79,0xce59,0xce59,0xd6ba,
    0xdefb,0xad75,0x738e,0x8c71,0xdefb,0xef7d,0x6b6d,0x8c71,0xef7d,0xc638,0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,
    0xce59,0xce59,0xce79,0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,0xce79,
    0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xc638,0xe73c,0xbdd7,0x5acb,0xce79,0xdefb,0xc618,
    0xce79,0xce79,0xce59,0xce59,0xce59,0xce79,0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,
    0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,0xce59,
    0xef7d,0x7bef,0x7bcf,0xef5d,0xce79,0xce59,0xce59,0xce59,0xce79,0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,
    0xce79,0xce79,0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,
    0xce59,0xce59,0xce79,0xce79,0xc618,0xdefb,0xd69a,0x5acb,0xb596,0xef5d,0xc638,0xce79,0xce59,0xce59,0xce59,0xce79,
    0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,
    0xce79,0xce79,0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xc638,0xef7d,0x94b2,0x632c,0xe71c,0xd6ba,
    0xc638,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,
    0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xc638,
    0xd6ba,0xe71c,0x632c,0x94b2,0xef7d,0xc638,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,0xce79,0xce79,
    0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,
    0xce79,0xce59,0xce59,0xce59,0xce79,0xc638,0xef5d,0xb596,0x5acb,0xd69a,0xdefb,0xc618,0xce79,0xce79,0xce59,0xce59,
    0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,0xce79,0xce79,
    0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,0xce79,0xce59,0xce59,0xce59,0xce79,0xef5d,0x7bcf,0x7bef,0xef7d,
    0xce59,0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,
    0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,0xce79,0xce59,0xce59,0xce59,0xce79,0xce79,
    0xc618,0xdefb,0xce79,0x5acb,0xbdd7,0xe73c,0xc638,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,
    0xce79,0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,0xce79,0xce59,0xce59,
    0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,0xc638,0xef7d,0x8c71,0x6b4d,0xef7d,0xe71c,0x9cd3,0x738e,0x9cd3,0xdefb,
    0xdedb,0xce59,0xce59,0xce79,0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,
    0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xc638,0xd6ba,0xdefb,0x630c,0xa514,
    0xef5d,0xc638,0xce79,0xce59,0xce59,0xce59,0xce79,0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,
    0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,
    0xce79,0xc638,0xef5d,0xad55,0x5aeb,0xdedb,0xdedb,0xc638,0xce59,0xce79,0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,
    0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,
    0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xd69a,0xef5d,0x738e,0x8430,0xef7d,0xce59,0xce59,0xce59,0xce59,
    0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,
    0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xc638,0xdefb,0xce79,0x8410,
    0x7bef,0xdefb,0xffff,0xef7d,0xf7be,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xffff,0x94b2,0x7bef,0xffff,0xffdf,0xef7d,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xef7d,0xffff,0xffdf,0x632c,0xc618,0xffff,0xef5d,0xf7be,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf7be,0xef7d,0xffff,
    0xb5b6,0x6b4d,0xffff,0xffff,0xef7d,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xef7d,0xf79e,0xef5d,
    0xc618,0x8c51,0xbdd7,0xf7be,0xffff,0xffff,0x738e,0xa514,0xffff,0xef7d,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf7be,0xef5d,0xffff,0xd69a,0x5aeb,0xef5d,0xffff,0xef5d,
    0xf7be,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xffff,0x8c71,0x8410,0xffff,0xf7be,0xef7d,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf7be,0xef5d,0xffff,0xf79e,0x630c,0xce59,0xffff,0xef5d,0xf7be,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xef7d,0xffff,0xad55,0x6b6d,0xffff,0xffff,
    0xef7d,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xef7d,
    0xffff,0xffff,0x6b6d,0xad55,0xffff,0xef7d,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf7be,0xef5d,0xffff,0xce59,0x630c,0xf79e,0xffff,0xef5d,0xf7be,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xef7d,0xf7be,0xffff,0x8410,0x8c71,0xffff,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf7be,
    0xef5d,0xffff,0xef5d,0x5aeb,0xd69a,0xffff,0xef5d,0xf7be,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xef7d,0xffff,0xa514,0x738e,0xffff,0xffff,0xffdf,0xc638,0x8c71,0xbdd7,
    0xe73c,0xf79e,0xef7d,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xef7d,0xffff,0xffff,0x6b4d,0xb5b6,
    0xffff,0xef7d,0xf7be,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf7be,0xef5d,0xffff,0xc618,0x632c,0xffdf,0xffff,0xef7d,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xef7d,0xffdf,0xffff,0x7bef,0x94b2,0xffff,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf7be,0xef7d,0xffff,0xef5d,0x7bef,
    0x7bef,0x9cd3,0xa534,0x94b2,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,
    0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,
    0x9cd3,0x9cd3,0x9cd3,0x9cd3,0xad75,0x7bef,0x73ae,0xad55,0x9cf3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,
    0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,
    0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x94b2,0xa514,0xa514,0x6b6d,0x8c71,0xad55,0x94b2,0x9cd3,
    0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,
    0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x94b2,0xad55,
    0x8c51,0x6b6d,0xa534,0xa514,0x94b2,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,
    0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0xad75,0xa534,
    0x7bcf,0x630c,0x9cd3,0xad75,0x9cd3,0xad55,0x738e,0x8410,0xad55,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,
    0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,
    0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x94b2,0xa534,0x94b2,0x6b4d,0x9cf3,0xa514,0x94b2,
    0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,
    0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,
    0xad55,0x7bcf,0x73ae,0xad75,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,
    0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,
    0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x94b2,0xa514,0x9cf3,0x6b4d,0x9492,0xad55,0x94b2,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,
    0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,
    0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0xad55,0x8430,0x6b6d,0xa534,0xa514,
    0x94b2,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,
    0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x94b2,
    0xa514,0xa534,0x6b6d,0x8430,0xad55,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,
    0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,
    0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x94b2,0xad55,0x9492,0x6b4d,0x9cf3,0xa514,0x94b2,0x9cd3,0x9cd3,0x9cd3,0x9cd3,
    0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,
    0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0xad75,0x73ae,0x7bcf,0xad55,
    0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,
    0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,
    0x94b2,0xa514,0x9cf3,0x6b4d,0x94b2,0xa534,0x94b2,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,
    0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,
    0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0xad55,0x8410,0x738e,0xad55,0x94b2,0xad55,0x9cf3,0x6b6d,0x6b6d,
    0xa514,0xb596,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,
    0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x94b2,0xa514,0xa534,0x6b6d,0x8c51,
    0xad55,0x94b2,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,
    0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,
    0x9cd3,0x94b2,0xad55,0x8c71,0x6b6d,0xa514,0xa514,0x94b2,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,
    0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,
    0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cf3,0xad55,0x73ae,0x7bef,0xad75,0x9cd3,0x9cd3,0x9cd3,0x9cd3,
    0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,
    0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x9cd3,0x94b2,0xa514,0x9cf3,0x7bef,
    0x8410,0x738e,0x6b4d,0x632c,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,
    0x632c,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,
    0x632c,0x632c,0x6b4d,0x632c,0x738e,0x6b6d,0x6b6d,0x738e,0x632c,0x632c,0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,0x6b4d,
    0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,
    0x632c,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,0x6b4d,0x738e,0x6b6d,0x6b6d,0x6b6d,0x632c,0x6b4d,
    0x6b4d,0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,0x6b4d,
    0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x632c,0x6b6d,
    0x738e,0x6b6d,0x73ae,0x6b4d,0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,
    0x6b4d,0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x738e,0x5aeb,0x5acb,
    0x7bef,0x7bef,0x6b6d,0x630c,0x6b4d,0x738e,0x6b6d,0x6b6d,0x738e,0x632c,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x632c,
    0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,0x6b4d,0x6b4d,
    0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x632c,0x6b4d,0x738e,0x6b6d,0x738e,0x6b4d,0x632c,
    0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x6b4d,
    0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,0x6b4d,0x632c,
    0x738e,0x6b6d,0x6b6d,0x738e,0x632c,0x632c,0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x632c,0x632c,
    0x6b4d,0x6b4d,0x6b4d,0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x6b4d,
    0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,0x6b4d,0x73ae,0x6b6d,0x738e,0x6b6d,0x632c,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,
    0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x632c,0x632c,
    0x6b4d,0x6b4d,0x6b4d,0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x632c,0x6b6d,0x6b6d,0x6b6d,0x738e,0x6b4d,
    0x632c,0x632c,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,
    0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x632c,0x632c,
    0x6b4d,0x738e,0x6b6d,0x6b6d,0x6b6d,0x632c,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,0x6b4d,0x6b4d,0x6b4d,
    0x632c,0x632c,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,
    0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x632c,0x6b6d,0x738e,0x6b6d,0x73ae,0x6b4d,0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,
    0x6b4d,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,0x6b4d,0x6b4d,0x6b4d,
    0x632c,0x632c,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,0x632c,0x632c,0x738e,0x6b6d,0x6b6d,0x738e,
    0x632c,0x6b4d,0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,
    0x6b4d,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,
    0x632c,0x6b4d,0x738e,0x6b6d,0x738e,0x6b4d,0x632c,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,
    0x6b4d,0x6b4d,0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,
    0x632c,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x632c,0x738e,0x6b6d,0x6b6d,0x738e,0x6b4d,0x630c,0x6b6d,0x7bef,0x8410,
    0x5aeb,0x5acb,0x738e,0x6b6d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,0x6b4d,
    0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,0x6b4d,0x73ae,0x6b6d,0x738e,
    0x6b6d,0x632c,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,
    0x6b4d,0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,0x6b4d,
    0x6b4d,0x632c,0x6b6d,0x6b6d,0x6b6d,0x738e,0x6b4d,0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x632c,
    0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,
    0x6b4d,0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,0x632c,0x632c,0x738e,0x6b6d,0x6b6d,0x738e,0x632c,0x6b4d,0x632c,0x632c,
    0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x632c,
    0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,0x6b4d,0x6b4d,0x6b4d,0x632c,0x632c,0x6b4d,0x6b4d,0x632c,0x6b4d,0x738e,0x8410,
    0x8410,0xd6ba,0xffff,0xe73c,0xef7d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,
    0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,
    0xef5d,0xef5d,0xef5d,0xef5d,0xffff,0x94b2,0x7bef,0xffff,0xf79e,0xe73c,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,
    0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,
    0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xe73c,0xffdf,0xef7d,0x6b4d,0xbdf7,0xffff,0xe73c,0xef7d,
    0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,
    0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef7d,0xe73c,0xffff,
    0xb596,0x6b6d,0xf7be,0xf7be,0xe73c,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,
    0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef7d,0xf7be,0xe71c,0x9492,0x8c51,
    0xe73c,0xef5d,0xef5d,0xe73c,0xf79e,0xffff,0x73ae,0x9cf3,0xffff,0xe73c,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,
    0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,
    0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef7d,0xe73c,0xffff,0xce79,0x632c,0xe71c,0xffff,0xe71c,
    0xef7d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,
    0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,
    0xffff,0x8c71,0x8430,0xffff,0xef7d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,
    0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,
    0xef5d,0xef5d,0xef5d,0xef7d,0xe71c,0xffff,0xef5d,0x632c,0xc638,0xffff,0xe73c,0xef7d,0xef5d,0xef5d,0xef5d,0xef5d,
    0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,
    0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef7d,0xe73c,0xffff,0xad55,0x738e,0xffdf,0xf7be,
    0xe73c,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,
    0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xe73c,
    0xf7be,0xffdf,0x738e,0xad55,0xffff,0xe73c,0xef7d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,
    0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,
    0xef5d,0xef5d,0xef5d,0xef5d,0xef7d,0xe73c,0xffff,0xc638,0x632c,0xef5d,0xffff,0xe71c,0xef7d,0xef5d,0xef5d,0xef5d,
    0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,
    0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef7d,0xffff,0x8430,0x8c71,0xffff,
    0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,
    0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef7d,
    0xe71c,0xffff,0xe71c,0x632c,0xce79,0xffff,0xe73c,0xef7d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,
    0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,
    0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xe73c,0xffff,0x9cf3,0x73ae,0xffff,0xf79e,0xe73c,0xef5d,0xef7d,0xef5d,
    0x94b2,0x8c71,0xd6ba,0xf7be,0xef7d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,
    0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xe73c,0xf7be,0xf7be,0x6b6d,0xb596,
    0xffff,0xe73c,0xef7d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,
    0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,
    0xef7d,0xe73c,0xffff,0xbdf7,0x6b4d,0xef7d,0xffdf,0xe73c,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,
    0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,
    0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xe73c,0xf79e,0xffff,0x7bef,0x94b2,0xffff,0xef5d,0xef5d,0xef5d,0xef5d,
    0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,
    0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef5d,0xef7d,0xe73c,0xffff,0xe71c,0x8410,
    0x8410,0xce79,0xef7d,0xd69a,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,
    0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,
    0xdedb,0xdedb,0xdedb,0xd6ba,0xffdf,0x8c51,0x738e,0xf7be,0xdefb,0xd6ba,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,
    0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,
    0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xd69a,0xe73c,0xe71c,0x5aeb,0xb596,0xf7be,0xce79,0xdedb,
    0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,
    0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xd69a,0xffdf,
    0xad55,0x630c,0xef5d,0xe73c,0xd69a,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,
    0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xd6ba,0xe71c,0xdedb,0x7bef,0x8c71,0xd69a,
    0xdefb,0xdedb,0xd6ba,0xd69a,0xe71c,0xf79e,0x6b6d,0x94b2,0xffdf,0xd6ba,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,
    0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,
    0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xd69a,0xf79e,0xc618,0x5acb,0xd6ba,0xef7d,0xce79,
    0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,
    0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,
    0xffdf,0x8430,0x7bcf,0xffdf,0xdedb,0xd6ba,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,
    0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,
    0xdedb,0xdedb,0xdedb,0xdedb,0xce79,0xef5d,0xdefb,0x5aeb,0xbdd7,0xf7be,0xce79,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,
    0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,
    0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xd6ba,0xffdf,0x9cf3,0x632c,0xef7d,0xe71c,
    0xd69a,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,
    0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xd69a,
    0xe71c,0xef7d,0x632c,0x9cf3,0xffdf,0xd6ba,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,
    0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,
    0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xce79,0xf7be,0xbdd7,0x5aeb,0xdefb,0xef5d,0xce79,0xdedb,0xdedb,0xdedb,0xdedb,
    0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,
    0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xd6ba,0xdedb,0xffdf,0x7bcf,0x8430,0xffdf,
    0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,
    0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,
    0xce79,0xef7d,0xd6ba,0x5acb,0xc618,0xf79e,0xd69a,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,
    0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,
    0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xd6ba,0xffdf,0x94b2,0x6b6d,0xf79e,0xe71c,0xd69a,0xd6ba,0xdedb,0xdefb,
    0xd6ba,0x9492,0x7bcf,0xce79,0xe71c,0xdedb,0xd6ba,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,
    0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xd69a,0xe73c,0xef5d,0x630c,0xad55,
    0xffdf,0xd69a,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,
    0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,
    0xdedb,0xce79,0xf7be,0xb596,0x5aeb,0xe71c,0xe73c,0xd69a,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,
    0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,
    0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xd6ba,0xdefb,0xf7be,0x738e,0x8c51,0xffdf,0xd6ba,0xdedb,0xdedb,0xdedb,
    0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,
    0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xdedb,0xd69a,0xef7d,0xd6ba,0x8410,
    0x7bef,0xc638,0xe71c,0xc638,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce59,0xef7d,0x8430,0x738e,0xef5d,0xd69a,0xce59,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce59,0xdedb,0xdedb,0x5aeb,0xad55,0xef5d,0xc638,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce59,0xef5d,
    0xa514,0x630c,0xe71c,0xdedb,0xce59,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce59,0xce79,0xce79,0xce59,0xe71c,0xce59,0x7bef,0x8410,0xbdf7,0xe71c,
    0xd69a,0xce79,0xce79,0xce59,0xd69a,0xe73c,0x6b4d,0x9492,0xef7d,0xce59,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xc638,0xe73c,0xbdd7,0x5acb,0xce79,0xe71c,0xc638,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xef7d,0x8410,0x73ae,0xef5d,0xce79,0xce59,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xc638,0xdefb,0xd6ba,0x5acb,0xb596,0xef5d,0xc638,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce59,0xef7d,0x9cd3,0x632c,0xe71c,0xd6ba,
    0xce59,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce59,
    0xd6ba,0xe71c,0x632c,0x9cd3,0xef7d,0xce59,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xc638,0xef5d,0xb596,0x5acb,0xd6ba,0xdefb,0xc638,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce59,0xce79,0xef5d,0x73ae,0x8410,0xef7d,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xc638,0xe71c,0xce79,0x5acb,0xbdd7,0xe73c,0xc638,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce59,0xef7d,0x9492,0x6b4d,0xe73c,0xd69a,0xce59,0xce79,0xce79,0xce79,
    0xe71c,0xce59,0x8c51,0x738e,0xc618,0xe71c,0xce59,0xce79,0xce79,0xce59,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce59,0xdedb,0xe71c,0x630c,0xa514,
    0xef5d,0xce59,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xc638,0xef5d,0xad55,0x5aeb,0xdedb,0xdedb,0xce59,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce59,0xd69a,0xef5d,0x738e,0x8430,0xef7d,0xce59,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce59,0xdefb,0xce79,0x7bef,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xe71c,0xce79,0x8c71,0x7bcf,0xc638,0xe71c,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b4d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5acb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b4d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xce79,0xe71c,0xce79,0x7bef,0x8430,0xc638,0xe73c,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf79e,
    0xa534,0x630c,0xe73c,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xdedb,0xdedb,0x8c71,0x6b6d,0xce59,0xdedb,0xd69a,0xce79,
    0xd6ba,0xd69a,0xd69a,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xf7be,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xe73c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xef5d,0xdefb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdefb,0xef5d,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0x9492,0x6b6d,0xef7d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xdefb,0xd6ba,0x73ae,0x8430,0xd6ba,0xdefb,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xe73c,0x630c,0xa534,
    0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf79e,
    0xa534,0x630c,0xe73c,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xdedb,0xdefb,0x8c71,0x7bcf,0xbdd7,0xdefb,0xd6ba,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xf7be,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xe73c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xef5d,0xdefb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdefb,0xef5d,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0x9492,0x6b6d,0xef7d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd6ba,0xdefb,0xce59,0x7bef,0x8410,0xdefb,0xdedb,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xe73c,0x630c,0xa534,
    0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x8410,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x630c,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xdefb,0x94b2,0x7bcf,0xad75,0xe71c,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b6d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b6d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xe71c,0xbdd7,0x8410,0x8c51,0xdedb,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x630c,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x8410,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xd6ba,0xa514,0x73ae,0xad55,0xdefb,0xdedb,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b4d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5acb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b4d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xdefb,0xb5b6,0x73ae,0x94b2,0xd69a,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xdedb,0xdefb,0xa534,0x73ae,0xa534,0xdedb,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b4d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5acb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b4d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xdefb,0xb5b6,0x738e,0x9cd3,0xd6ba,0xdefb,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf79e,
    0xa534,0x630c,0xe73c,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xdedb,0xe73c,0xa534,0x73ae,0x9cf3,0xe71c,0xdefb,0xce79,0xd69a,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xf7be,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xe73c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xef5d,0xdefb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdefb,0xef5d,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0x9492,0x6b6d,0xef7d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xd69a,0xce79,0xdedb,0xe71c,0xad75,0x738e,0x94b2,0xe73c,0xdedb,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xe73c,0x630c,0xa534,
    0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf79e,
    0xa534,0x630c,0xe73c,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xdedb,0xdefb,0xb596,0x73ae,0x94b2,0xe71c,0xdedb,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xf7be,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xe73c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xef5d,0xdefb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdefb,0xef5d,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0x9492,0x6b6d,0xef7d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xdedb,0xe71c,0xa514,0x7bcf,0xa514,0xe71c,0xdefb,0xce79,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xe73c,0x630c,0xa534,
    0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce79,0xd6ba,0xdedb,0xbdf7,0x738e,0x94b2,0xd6ba,0xdefb,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b4d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5acb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b4d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xdedb,0xdefb,0x9cf3,0x6b6d,0xad75,0xdedb,0xdedb,0xce79,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce79,0xe71c,0xbdf7,0x73ae,0x9492,0xce79,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b4d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5acb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b4d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xd6ba,0x9cd3,0x738e,0xb5b6,0xdefb,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x8410,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x630c,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xdefb,0xce59,0x8c51,0x7bcf,0xdedb,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b6d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x6b4d,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x6b4d,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b6d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xdefb,0x8c51,0x8410,0xbdd7,0xe71c,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x630c,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x8410,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf79e,
    0xa534,0x630c,0xe73c,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xe71c,0x9492,0x73ae,0xce79,0xdedb,0xd69a,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xf7be,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xe73c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xef5d,0xdefb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdefb,0xef5d,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0x9492,0x6b6d,0xef7d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xdedb,0xdedb,0x7bcf,0x8430,0xdedb,
    0xdedb,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xe73c,0x630c,0xa534,
    0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf79e,
    0xa534,0x630c,0xe73c,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xe73c,
    0x9cf3,0x7bcf,0xad55,0xe71c,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xf7be,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xe73c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xef5d,0xdefb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdefb,0xef5d,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0x9492,0x6b6d,0xef7d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xe71c,0xbdf7,0x7bef,0x8c71,
    0xe73c,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xe73c,0x630c,0xa534,
    0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xdedb,0xc618,
    0x738e,0x9cd3,0xe71c,0xd6ba,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b4d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5acb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b4d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xe73c,0xa514,0x738e,
    0xb596,0xdedb,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xce59,0x7bcf,
    0x9492,0xce79,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b4d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5acb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b4d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xd69a,0x9cf3,
    0x738e,0xc618,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf79e,
    0xa534,0x630c,0xe73c,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xd69a,0x9cd3,0x738e,
    0xc638,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xf7be,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xe73c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xef5d,0xdefb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdefb,0xef5d,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0x9492,0x6b6d,0xef7d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xce79,
    0x8410,0x8c51,0xc638,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xe73c,0x630c,0xa534,
    0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf79e,
    0xa534,0x630c,0xe73c,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xe73c,0xa514,0x6b6d,0xc618,
    0xdedb,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xf7be,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef5d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xe73c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xef5d,0xdefb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdefb,0xef5d,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0x9492,0x6b6d,0xef7d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xdefb,
    0xce79,0x6b6d,0x94b2,0xe71c,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xe73c,0x630c,0xa534,
    0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x8410,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x630c,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xe73c,0xad75,0x7bcf,0x9cf3,0xdefb,
    0xdedb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b6d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b6d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdedb,
    0xdefb,0xad75,0x7bcf,0x9cf3,0xef5d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x630c,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x8410,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xdedb,0xce79,0x7bcf,0x8c51,0xdedb,0xdedb,
    0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b4d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5acb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b4d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,
    0xd6ba,0xe71c,0x9492,0x73ae,0xc618,0xdefb,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xd6ba,0x8430,0x8430,0xc618,0xe73c,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b4d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5acb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b4d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xdefb,0xce79,0x8c71,0x7bcf,0xce79,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf79e,
    0xa534,0x630c,0xe73c,0xdefb,0xce79,0xd69a,0xd6ba,0xce79,0xdedb,0xd6ba,0xad55,0x6b6d,0xb5b6,0xe73c,0xce79,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xf7be,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xe73c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xef5d,0xdefb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdefb,0xef5d,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0x9492,0x6b6d,0xef7d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce79,0xe73c,0xc618,0x7bcf,0x9cd3,0xce79,0xdefb,0xce79,0xd6ba,0xd69a,0xce79,0xdefb,0xe73c,0x630c,0xa534,
    0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf79e,
    0xa534,0x630c,0xe73c,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xe73c,0xad75,0x6b6d,0xb596,0xdedb,0xdedb,0xd69a,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xf7be,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xe73c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xef5d,0xdefb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdefb,0xef5d,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0x9492,0x6b6d,0xef7d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xd69a,0xd6ba,0xdefb,0xbdf7,0x6b4d,0xa534,0xe71c,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xe73c,0x630c,0xa534,
    0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x8410,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x630c,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xe73c,0xbdd7,0x8410,0x8c71,0xdedb,0xdefb,0xce79,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b4d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b4d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xce79,0xdedb,0xdefb,0xa514,0x7bcf,0xad75,0xef5d,0xd69a,0xce79,0xce79,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x630c,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x8410,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xdedb,0xd6ba,0x8410,0x7bef,0xd69a,0xdedb,0xd69a,0xce79,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b4d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5acb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b4d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xce79,0xd69a,0xdedb,0xdefb,0x8430,0x7bef,0xce59,0xdefb,0xd6ba,0xc638,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x8410,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x630c,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xdedb,0xdefb,0x9492,0x8410,0xb5b6,0xe73c,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b6d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x6b4d,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x6b4d,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b6d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xe71c,0xc638,0x8430,0x8430,0xdedb,0xdefb,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x630c,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x8410,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf79e,
    0xa534,0x630c,0xe73c,0xdefb,0xd69a,0xdedb,0xb5b6,0x6b6d,0xad55,0xe73c,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xf7be,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xe73c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xef5d,0xdefb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdefb,0xef5d,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0x9492,0x6b6d,0xef7d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xef5d,0xb596,0x73ae,0xa534,0xd6ba,0xd6ba,0xdefb,0xe73c,0x630c,0xa534,
    0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf79e,
    0xa534,0x630c,0xe71c,0xdedb,0xdefb,0xc618,0x6b6d,0xa514,0xd6ba,0xdedb,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xf7be,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xe73c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xef5d,0xdefb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdefb,0xef5d,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0x9492,0x6b6d,0xef7d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xdefb,0xad75,0x6b4d,0xb5b6,0xdefb,0xdedb,0xe71c,0x630c,0xa534,
    0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xef7d,0xc618,0x8c71,0x8410,0xce79,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b4d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5acb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b4d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xd6ba,0x8c71,0x8410,0xb5b6,0xf79e,0xdefb,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xef7d,0x9492,0x738e,0xce59,0xdedb,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b4d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5acb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b4d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xdedb,0xd6ba,0x73ae,0x8430,0xe73c,0xe73c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x8410,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x630c,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa514,0x632c,0xf79e,0xbdd7,0x7bcf,0x9cd3,0xe73c,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b6d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x6b4d,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x6b4d,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b6d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xe71c,0xad75,0x7bcf,0xad55,0xf79e,0x632c,0xa514,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x630c,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x8410,
    0x8410,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xce79,0xd69a,0xd69a,0xce79,
    0xce79,0xd69a,0xd69a,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xd69a,0xd69a,
    0xce79,0xce79,0xce79,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xce79,
    0xd69a,0xd69a,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xce79,0xd69a,0xd69a,0xce79,
    0xce79,0xd69a,0xd69a,0xce79,0xce79,0xce79,0xd69a,0xce79,0xce59,0xdefb,0xdedb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xce79,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xce79,
    0xd69a,0xd69a,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xce79,0xd69a,0xce79,0xce79,0xce79,0xd69a,0xce59,0xef7d,
    0xa514,0x6b4d,0xef5d,0x7bef,0x8410,0xdefb,0xd6ba,0xd69a,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xd69a,0xd69a,
    0xce79,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xce79,0xd69a,0xce79,0xce79,0xce79,
    0xd69a,0xd69a,0xce79,0xce59,0xd6ba,0xef5d,0x6b4d,0x9492,0xf79e,0xce59,0xce79,0xce79,0xce79,0xd69a,0xd69a,0xce79,
    0xce79,0xce79,0xd69a,0xce79,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xce79,0xd69a,
    0xce79,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe71c,0xc638,
    0xd69a,0xd69a,0xce79,0xce79,0xce79,0xd69a,0xce79,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xd69a,0xd69a,0xce79,
    0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xce79,0xce79,
    0xf79e,0x8410,0x7bcf,0xef7d,0xd69a,0xce79,0xce79,0xce79,0xd69a,0xce79,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,
    0xd69a,0xd69a,0xce79,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xd69a,0xd69a,0xce79,
    0xce79,0xce79,0xd69a,0xd69a,0xc638,0xe71c,0xd6ba,0x5acb,0xb5b6,0xef7d,0xce59,0xd69a,0xce79,0xce79,0xce79,0xd69a,
    0xd69a,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,
    0xd69a,0xd69a,0xce79,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xd69a,0xce59,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce59,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xd69a,
    0xd69a,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce59,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce59,0xd69a,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xce79,0xd69a,0xd69a,
    0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xd69a,
    0xd69a,0xce79,0xce79,0xce79,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xc638,0xd69a,0xd69a,0xce79,0xce79,
    0xce79,0xd69a,0xd69a,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xce79,0xd69a,0xd69a,
    0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xce79,0xd69a,0xce79,0xce79,0xce79,0xd69a,0xef7d,0x7bcf,0x8410,0xf79e,
    0xce79,0xce79,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,
    0xce79,0xd69a,0xd69a,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xce79,0xd69a,0xce79,0xce79,0xce79,0xd69a,0xd69a,
    0xc638,0xe71c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xce79,
    0xd69a,0xce79,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xce79,0xd69a,0xce79,0xce79,
    0xce79,0xd69a,0xd69a,0xce79,0xce79,0xce79,0xce59,0xf79e,0x9492,0x6b4d,0xef5d,0xd6ba,0xce59,0xce79,0xd69a,0xd69a,
    0xce79,0xce79,0xce79,0xd69a,0xce79,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xce79,
    0xd69a,0xd69a,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xd69a,0xd69a,0xe73c,0x8c51,0x7bef,0xe73c,0x6b4d,0xa534,
    0xef7d,0xce59,0xd69a,0xce79,0xce79,0xce79,0xd69a,0xce79,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xd69a,0xd69a,
    0xce79,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xce79,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdedb,0xdefb,0xce59,0xce79,0xd69a,0xce79,0xce79,0xce79,0xd69a,0xd69a,0xce79,
    0xce79,0xd69a,0xd69a,0xce79,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xd69a,0xd69a,
    0xce79,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xce79,0xce79,0xce79,
    0xd69a,0xd69a,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xd69a,0xd69a,0xce79,
    0xce79,0xd69a,0xd69a,0xce79,0xce79,0xce79,0xd69a,0xd69a,0xce79,0xce79,0xd69a,0xd69a,0xce59,0xe71c,0xce79,0x8410,
    0x8410,0xdefb,0xffff,0xef7d,0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf7be,0xf79e,0xf7be,0xf7be,0xf79e,
    0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf7be,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,
    0xf79e,0xf7be,0xf79e,0xf79e,0xffff,0x94b2,0x7bef,0xffff,0xffdf,0xef7d,0xf7be,0xf7be,0xf7be,0xf79e,0xf7be,0xf79e,
    0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf7be,0xf79e,0xf7be,0xf7be,0xf79e,
    0xf79e,0xf7be,0xf7be,0xf79e,0xf7be,0xf79e,0xf7be,0xf79e,0xef7d,0xffff,0xffdf,0x632c,0xc618,0xffff,0xef5d,0xf7be,
    0xf79e,0xf7be,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf7be,0xf79e,
    0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf7be,0xf79e,0xf7be,0xf79e,0xf7be,0xf79e,0xf7be,0xef7d,0xffff,
    0xc618,0x632c,0xb5b6,0xa534,0xd69a,0xffff,0xf79e,0xf79e,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,
    0xf79e,0xf7be,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf7be,0xf79e,0xf7be,0xf79e,0xf7be,0xf79e,
    0xf7be,0xf7be,0xf7be,0xef7d,0xffdf,0xffff,0x73ae,0xa514,0xffff,0xef7d,0xf79e,0xf7be,0xf79e,0xf7be,0xf7be,0xf79e,
    0xf7be,0xf79e,0xf7be,0xf79e,0xf7be,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf7be,0xf79e,0xf7be,
    0xf79e,0xf7be,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,0xef5d,0xffff,0xd6ba,0x630c,0xef5d,0xffff,0xef5d,
    0xf7be,0xf7be,0xf79e,0xf7be,0xf79e,0xf7be,0xf79e,0xf7be,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,
    0xf7be,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf7be,0xf79e,0xf7be,
    0xffff,0x8c71,0x8430,0xffff,0xf7be,0xef7d,0xf7be,0xf79e,0xf7be,0xf79e,0xf7be,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,
    0xf7be,0xf7be,0xf79e,0xf7be,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,
    0xf7be,0xf79e,0xf7be,0xf7be,0xef5d,0xffff,0xf79e,0x632c,0xce59,0xffff,0xef5d,0xf7be,0xf79e,0xf7be,0xf79e,0xf7be,
    0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf7be,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,
    0xf7be,0xf7be,0xf79e,0xf7be,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xef7d,0xffff,0xad55,0x738e,0xffff,0xffff,
    0xef7d,0xf7be,0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf7be,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,
    0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf7be,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,0xf7be,0xef7d,
    0xffff,0xffff,0x738e,0xad55,0xffff,0xef7d,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf7be,0xf79e,0xf7be,0xf7be,
    0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf7be,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,
    0xf7be,0xf79e,0xf7be,0xf79e,0xf7be,0xef5d,0xffff,0xce59,0x632c,0xf79e,0xffff,0xef5d,0xf7be,0xf7be,0xf79e,0xf7be,
    0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf7be,0xf79e,0xf7be,0xf7be,
    0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf7be,0xf79e,0xf7be,0xf79e,0xf7be,0xef7d,0xf7be,0xffff,0x8430,0x8c71,0xffff,
    0xf7be,0xf79e,0xf7be,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf7be,
    0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf7be,0xf79e,0xf7be,0xf79e,0xf7be,0xf79e,0xf7be,0xf7be,
    0xef5d,0xffff,0xef5d,0x630c,0xd6ba,0xffff,0xef5d,0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf7be,0xf79e,
    0xf7be,0xf79e,0xf7be,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf7be,0xf79e,0xf7be,0xf79e,0xf7be,
    0xf79e,0xf7be,0xf7be,0xf79e,0xf7be,0xf79e,0xef7d,0xffff,0xa514,0x73ae,0xffff,0xffdf,0xef7d,0xf7be,0xf7be,0xf7be,
    0xf79e,0xf7be,0xf79e,0xf7be,0xf79e,0xf7be,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf7be,0xf79e,
    0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf79e,0xf79e,0xffff,0xdefb,0xad75,0xa534,0x630c,0xc618,
    0xffff,0xef7d,0xf7be,0xf79e,0xf7be,0xf79e,0xf7be,0xf79e,0xf7be,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,
    0xf79e,0xf7be,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf7be,0xf79e,
    0xf7be,0xef5d,0xffff,0xc618,0x632c,0xffdf,0xffff,0xef7d,0xf79e,0xf7be,0xf79e,0xf7be,0xf79e,0xf7be,0xf7be,0xf79e,
    0xf79e,0xf7be,0xf7be,0xf79e,0xf7be,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,
    0xf79e,0xf7be,0xf79e,0xf7be,0xf7be,0xf7be,0xef7d,0xffdf,0xffff,0x7bef,0x94b2,0xffff,0xf79e,0xf79e,0xf7be,0xf79e,
    0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf7be,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,
    0xf79e,0xf7be,0xf7be,0xf79e,0xf7be,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,0xef7d,0xffff,0xef5d,0x8410,
    0x7bef,0x8430,0x8c51,0x8410,0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,0x8430,0x8410,0x8430,0x8430,0x8430,0x8410,
    0x8410,0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,0x8430,0x8410,0x8430,0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,
    0x8410,0x8410,0x8430,0x8410,0x9492,0x73ae,0x738e,0x9492,0x8430,0x8410,0x8410,0x8430,0x8430,0x8430,0x8410,0x8430,
    0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,0x8430,0x8410,0x8430,0x8430,0x8430,0x8410,
    0x8410,0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,0x8430,0x8410,0x8c51,0x8c71,0x6b6d,0x8410,0x8c71,0x8410,0x8430,
    0x8430,0x8410,0x8430,0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,0x8430,0x8410,0x8430,
    0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,0x8430,0x8410,0x8410,0x8430,0x8410,0x8c71,
    0x8410,0x6b6d,0x738e,0x73ae,0x8410,0x8c51,0x8410,0x8430,0x8410,0x8410,0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,
    0x8430,0x8410,0x8430,0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,0x8430,0x8410,0x8410,
    0x8430,0x8430,0x8410,0x8410,0x8430,0x9492,0x6b6d,0x7bcf,0x9492,0x8410,0x8430,0x8410,0x8410,0x8430,0x8430,0x8410,
    0x8410,0x8430,0x8430,0x8430,0x8410,0x8430,0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,0x8430,0x8410,0x8430,0x8430,
    0x8430,0x8410,0x8410,0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,0x8410,0x8c51,0x8430,0x6b4d,0x8c51,0x8c51,0x7bef,
    0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,0x8430,
    0x8410,0x8430,0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,0x8430,0x8410,0x8430,0x8430,
    0x9492,0x73ae,0x738e,0x9492,0x8430,0x8410,0x8410,0x8430,0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,0x8410,0x8410,
    0x8430,0x8430,0x8430,0x8410,0x8430,0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,0x8430,
    0x8410,0x8430,0x8430,0x8430,0x7bef,0x8c51,0x8c51,0x6b6d,0x8410,0x8c71,0x8410,0x8430,0x8430,0x8410,0x8410,0x8430,
    0x8430,0x8410,0x8410,0x8430,0x8430,0x8430,0x8410,0x8430,0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,0x8410,0x8410,
    0x8430,0x8430,0x8430,0x8410,0x8430,0x8430,0x8430,0x8410,0x8410,0x8430,0x8410,0x8c71,0x7bcf,0x6b6d,0x8c71,0x8430,
    0x8410,0x8410,0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,0x8430,0x8410,0x8430,0x8430,0x8430,0x8410,0x8410,0x8430,
    0x8430,0x8410,0x8410,0x8430,0x8430,0x8430,0x8410,0x8430,0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,0x8410,0x8410,
    0x8430,0x8c71,0x6b6d,0x7bcf,0x8c71,0x8410,0x8430,0x8410,0x8410,0x8430,0x8430,0x8430,0x8410,0x8430,0x8430,0x8430,
    0x8410,0x8410,0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,0x8430,0x8410,0x8430,0x8430,0x8430,0x8410,0x8410,0x8430,
    0x8430,0x8410,0x8410,0x8430,0x8430,0x8410,0x8c71,0x8410,0x6b6d,0x8c51,0x8c51,0x7bef,0x8430,0x8430,0x8430,0x8410,
    0x8430,0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,0x8430,0x8410,0x8430,0x8430,0x8430,
    0x8410,0x8410,0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,0x8430,0x8410,0x8410,0x8430,0x9492,0x738e,0x73ae,0x9492,
    0x8430,0x8430,0x8410,0x8430,0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,0x8430,0x8410,
    0x8430,0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,
    0x7bef,0x8c51,0x8c51,0x6b4d,0x8430,0x8c51,0x8410,0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,0x8410,0x8410,0x8430,
    0x8430,0x8430,0x8410,0x8430,0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,0x8430,0x8410,0x8430,0x8430,0x8430,0x8410,
    0x8410,0x8430,0x8430,0x8410,0x8410,0x8430,0x8410,0x9492,0x7bcf,0x6b6d,0x9492,0x8430,0x8410,0x8410,0x8430,0x8430,
    0x8410,0x8410,0x8430,0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,0x8430,0x8410,0x8430,
    0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,0x8410,0x8410,0x8430,0x8410,0x8430,0x8430,0x7bcf,0x6b4d,0x6b6d,0x8410,
    0x8c51,0x8410,0x8430,0x8410,0x8410,0x8430,0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,
    0x8430,0x8410,0x8430,0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,0x8430,0x8410,0x8430,
    0x8430,0x8410,0x8c71,0x8410,0x6b6d,0x8c71,0x8c51,0x8410,0x8430,0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,0x8410,
    0x8410,0x8430,0x8430,0x8430,0x8410,0x8430,0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,
    0x8430,0x8410,0x8430,0x8430,0x8430,0x8410,0x8410,0x8430,0x9492,0x738e,0x73ae,0x9492,0x8410,0x8430,0x8410,0x8410,
    0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,0x8430,0x8410,0x8430,0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,0x8410,
    0x8410,0x8430,0x8430,0x8430,0x8410,0x8430,0x8430,0x8430,0x8410,0x8410,0x8430,0x8430,0x8410,0x8c51,0x8c51,0x7bef,
    0x7bef,0x8410,0x7bef,0x73ae,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,
    0x73ae,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,
    0x73ae,0x73ae,0x7bcf,0x73ae,0x8430,0x738e,0x738e,0x8430,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x7bcf,
    0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,
    0x73ae,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x7bcf,0x8410,0x6b6d,0x7bcf,0x8410,0x73ae,0x7bcf,
    0x7bcf,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x7bcf,
    0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x73ae,0x8430,
    0x7bef,0x738e,0x8c71,0x8c51,0x7bef,0x73ae,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,
    0x7bcf,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x73ae,
    0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x8430,0x738e,0x73ae,0x8430,0x73ae,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x73ae,
    0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x7bcf,0x7bcf,
    0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x73ae,0x7bef,0x7bef,0x6b4d,0x8410,0x7bef,0x73ae,
    0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x7bcf,
    0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x7bcf,0x7bcf,
    0x8430,0x738e,0x6b6d,0x8430,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x73ae,0x73ae,
    0x7bcf,0x7bcf,0x7bcf,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x7bcf,
    0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x7bef,0x8410,0x6b6d,0x7bef,0x8410,0x73ae,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,
    0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x73ae,0x73ae,
    0x7bcf,0x7bcf,0x7bcf,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x73ae,0x8410,0x73ae,0x6b6d,0x8430,0x7bef,
    0x73ae,0x73ae,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,
    0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x73ae,0x73ae,
    0x7bef,0x8430,0x6b6d,0x73ae,0x8410,0x73ae,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x7bcf,0x7bcf,0x7bcf,
    0x73ae,0x73ae,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,
    0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x73ae,0x8410,0x7bef,0x6b6d,0x8410,0x7bef,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,
    0x7bcf,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x7bcf,0x7bcf,0x7bcf,
    0x73ae,0x73ae,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x8430,0x6b6d,0x738e,0x8430,
    0x7bcf,0x7bcf,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,
    0x7bcf,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,
    0x73ae,0x7bef,0x8410,0x6b4d,0x7bef,0x7bef,0x73ae,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,
    0x7bcf,0x7bcf,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,
    0x73ae,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x73ae,0x8430,0x73ae,0x738e,0x8430,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,
    0x73ae,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x7bcf,
    0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x7bcf,0x8c51,0x9492,0x738e,0x7bcf,
    0x8430,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,
    0x7bcf,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x7bcf,
    0x7bcf,0x73ae,0x8410,0x7bcf,0x6b6d,0x8410,0x7bcf,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x73ae,
    0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,
    0x7bcf,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x8430,0x738e,0x738e,0x8430,0x73ae,0x7bcf,0x73ae,0x73ae,
    0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x73ae,
    0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x7bcf,0x7bcf,0x7bcf,0x73ae,0x73ae,0x7bcf,0x7bcf,0x73ae,0x7bef,0x8410,0x7bef,
    0x8410,0xdefb,0xffff,0xef7d,0xf7be,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xffff,0x94b2,0x7bef,0xffff,0xf7be,0xef7d,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xef7d,0xffff,0xf7be,0x6b4d,0xbdf7,0xffff,0xef5d,0xf7be,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xffff,
    0xb5b6,0x6b6d,0xdedb,0xf79e,0xef7d,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xef7d,0xffdf,0xffff,0x73ae,0xa514,0xffff,0xef7d,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xef5d,0xffff,0xd69a,0x630c,0xe73c,0xffff,0xef5d,
    0xf7be,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xffff,0x8c71,0x8430,0xffff,0xf7be,0xef7d,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf7be,0xef5d,0xffff,0xf79e,0x632c,0xce59,0xffff,0xef5d,0xf7be,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xef7d,0xffff,0xad55,0x738e,0xffff,0xffff,
    0xef7d,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xef7d,
    0xffff,0xffff,0x738e,0xad55,0xffff,0xef7d,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf7be,0xef5d,0xffff,0xce59,0x632c,0xf79e,0xffff,0xef5d,0xf7be,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xef7d,0xf7be,0xffff,0x8430,0x8c71,0xffff,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf7be,
    0xef5d,0xffff,0xe73c,0x630c,0xd69a,0xffff,0xef5d,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xef7d,0xffff,0xa514,0x73ae,0xffff,0xffdf,0xef7d,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xef7d,0xf7be,0xe73c,0x6b6d,0xad75,
    0xffff,0xf7be,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf7be,0xef5d,0xffff,0xbdf7,0x6b4d,0xf7be,0xffff,0xef7d,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xef7d,0xf7be,0xffff,0x7bef,0x94b2,0xffff,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf7be,0xef7d,0xffff,0xe73c,0x8410,
    0x8410,0xce59,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xdefb,0x5aeb,0xad75,0xf79e,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xdefb,0xc618,
    0x7bcf,0x73ae,0xe73c,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xf7be,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xdedb,0x5acb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xef5d,0xdedb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdedb,0xef5d,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xdedb,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0x9492,0x6b6d,0xef7d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xe71c,0x73ae,0x6b6d,
    0xb5b6,0xe71c,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xf79e,0xad75,0x5aeb,0xdefb,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf7be,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xd69a,0x8410,
    0x8410,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef5d,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x630c,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xce79,0xd6ba,0xdedb,0x9cd3,
    0x5acb,0x7bcf,0xe71c,0xdedb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce59,0xd6ba,0xef5d,0x6b4d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe71c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,
    0xf79e,0x8410,0x7bcf,0xef7d,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5aeb,0xb5b6,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xef7d,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x632c,0x9cd3,0xef7d,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xb5b6,0x5aeb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xef7d,0x7bcf,0x8410,0xf79e,
    0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe71c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b4d,0xef5d,0xd6ba,0xce59,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdedb,0xe71c,0x7bcf,0x5aeb,
    0x9cd3,0xce79,0xd6ba,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x630c,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xef5d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xce79,0x8410,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xdefb,0x9cf3,0xa514,
    0x7bef,0x738e,0xdefb,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b6d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5acb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b6d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xe71c,0x6b6d,0x8c71,
    0xad55,0x8c51,0xdedb,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x8410,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xd69a,0x632c,0xc618,
    0xb5b6,0x632c,0xe71c,0xdedb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b4d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b4d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdedb,0xe71c,0x5aeb,0xbdf7,
    0xce79,0x632c,0xce59,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x8410,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xd69a,0xdefb,0xce79,0xa514,0x8410,0xe71c,
    0xbdd7,0x5aeb,0xe73c,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xf7be,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xe73c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xef5d,0xdefb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdefb,0xef5d,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0x9492,0x6b6d,0xef7d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xe73c,0x5aeb,0xb596,
    0xef5d,0x8c71,0x94b2,0xce59,0xdefb,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xef5d,0xbdd7,0x6b6d,0xb5b6,0xffff,
    0xa534,0x630c,0xe73c,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xf7be,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xe73c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xef5d,0xdefb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdefb,0xef5d,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0x9492,0x6b6d,0xef7d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xe73c,0x630c,0xa534,
    0xffff,0xc618,0x6b4d,0xb596,0xe73c,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xd69a,0x9cd3,0x7bef,0xce79,0xffff,
    0xa514,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b4d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5acb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b4d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0x9cf3,
    0xffdf,0xd69a,0x8c71,0x9492,0xc638,0xdefb,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xef5d,0x9cf3,0x7bef,0xc618,0xd69a,0xf7be,
    0xa514,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b4d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5acb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b4d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa514,
    0xf79e,0xd69a,0xd69a,0x7bcf,0x94b2,0xe73c,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x8410,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x630c,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xdedb,0xd69a,0x8410,0x8430,0xef5d,0xd69a,0xf79e,
    0xa534,0x632c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b6d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b6d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xef7d,0xce79,0xef5d,0x9492,0x8410,0xc638,0xdefb,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x630c,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x8410,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xdedb,0xe71c,0x94b2,0x8c71,0xc618,0xdefb,0xce79,0xf79e,
    0xa534,0x630c,0xe73c,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xf7be,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xe73c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xef5d,0xdefb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdefb,0xef5d,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0x9492,0x6b6d,0xef7d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xe73c,0x630c,0xa534,
    0xf79e,0xce79,0xdedb,0xd69a,0x9492,0x8410,0xe71c,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xdedb,0xce79,0x738e,0xa514,0xef5d,0xd69a,0xce79,0xf79e,
    0xa534,0x630c,0xe73c,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xf7be,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xe73c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xef5d,0xdefb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdefb,0xef5d,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0x9492,0x6b6d,0xef7d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xe73c,0x630c,0xa534,
    0xf79e,0xce79,0xd69a,0xef5d,0xad55,0x73ae,0xc618,0xd6ba,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xce79,0x8c71,0x8c71,0xc618,0xe71c,0xce79,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b4d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5acb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b4d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xdedb,0xce79,0x9cf3,0x7bef,0xce59,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xbdd7,0x6b4d,0xbdf7,0xdefb,0xce79,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b4d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5acb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b4d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xce79,0xe71c,0xc638,0x6b6d,0xb596,0xdedb,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xc638,0x94b2,0x9492,0xd69a,0xe71c,0xce79,0xd6ba,0xce79,0xf79e,
    0xa534,0x630c,0xe73c,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xf7be,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xe73c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xef5d,0xdefb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdefb,0xef5d,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0x9492,0x6b6d,0xef7d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xe73c,0x630c,0xa534,
    0xf79e,0xce79,0xd6ba,0xce79,0xdedb,0xd6ba,0xa514,0x8c51,0xbdd7,0xe73c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xef7d,0xa534,0x73ae,0xce59,0xdedb,0xd69a,0xd69a,0xd6ba,0xce79,0xf79e,
    0xa534,0x630c,0xe73c,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xf7be,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xe73c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xef5d,0xdefb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdefb,0xef5d,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0x9492,0x6b6d,0xef7d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xe73c,0x630c,0xa534,
    0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xdefb,0xdedb,0x738e,0x9cf3,0xef7d,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x8410,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x630c,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0x9492,0x8430,0xe71c,0xdedb,0xce79,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b6d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x6b4d,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x6b4d,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b6d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xce79,0xdedb,0xe71c,0x94b2,0x8c71,0xc618,0xdedb,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x630c,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x8410,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xe73c,0x94b2,0x8410,0xbdf7,0xdedb,0xd6ba,0xce79,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b4d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5acb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b4d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xce79,0xd69a,0xd6ba,0xd69a,0x8430,0x8430,0xe73c,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xdefb,0x73ae,0x8c71,0xe73c,0xd69a,0xd69a,0xce79,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b4d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5acb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b4d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xef5d,0x94b2,0x73ae,0xd69a,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xce79,0xdedb,0xdedb,0xad55,0x8c51,0xb5b6,0xe73c,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf79e,
    0xa534,0x630c,0xe73c,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xf7be,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xe73c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xef5d,0xdefb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdefb,0xef5d,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0x9492,0x6b6d,0xef7d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xe73c,0x630c,0xa534,
    0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xdefb,0xc618,0x9492,0x94b2,0xd6ba,0xdefb,0xce79,0xd6ba,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xce79,0xe71c,0xd69a,0x6b6d,0xa514,0xdedb,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf79e,
    0xa534,0x630c,0xe73c,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xf7be,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xe73c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xef5d,0xdefb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdefb,0xef5d,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0x9492,0x6b6d,0xef7d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xe73c,0x630c,0xa534,
    0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xe71c,0xad75,0x632c,0xce79,0xe71c,0xce79,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd6ba,0xd69a,0xad75,0x738e,0xbdf7,0xe73c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b4d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5acb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b4d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe73c,0xc638,0x7bef,0xa514,0xce79,0xdedb,0xce79,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce79,0xe73c,0xbdd7,0x7bcf,0xa534,0xd69a,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b4d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5acb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b4d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xd6ba,0xb5b6,0x6b6d,0xb596,0xef5d,0xce79,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x8410,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x630c,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xe71c,0xa514,0x6b4d,0xd69a,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b6d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x6b4d,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x6b4d,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b6d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xdedb,0x6b6d,0x9cd3,0xdedb,0xd6ba,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x630c,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x8410,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xdefb,0xbdd7,0x8c51,0x94b2,0xdefb,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf79e,
    0xa534,0x630c,0xe73c,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xf7be,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xe73c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xef5d,0xdefb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdefb,0xef5d,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0x9492,0x6b6d,0xef7d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xe73c,0x630c,0xa534,
    0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xdedb,0xad55,0x8430,0xad75,0xe71c,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xef5d,0x9492,0x7bcf,0xd69a,0xdedb,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf79e,
    0xa534,0x630c,0xe73c,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xf7be,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xe73c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xef5d,0xdefb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdefb,0xef5d,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0x9492,0x6b6d,0xef7d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xe73c,0x630c,0xa534,
    0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xdedb,0xe71c,0x7bef,0x8410,0xe73c,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xd6ba,0x8410,0x8c51,0xef5d,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b4d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5acb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b4d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xef5d,0x94b2,0x8410,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdedb,
    0xdedb,0xa514,0x8c51,0xb596,0xdefb,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b4d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5acb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b4d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xdedb,0xc638,0x9492,0x8c71,0xdefb,
    0xdedb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,
    0xdedb,0x73ae,0x9cd3,0xdedb,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf79e,
    0xa534,0x630c,0xe73c,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xf7be,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xe73c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xef5d,0xdefb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdefb,0xef5d,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0x9492,0x6b6d,0xef7d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xe73c,0x630c,0xa534,
    0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xe73c,0xa514,0x6b6d,0xd6ba,
    0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,
    0xbdf7,0x73ae,0xb596,0xef5d,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf79e,
    0xa534,0x630c,0xe73c,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xf7be,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xbdf7,0x5acb,0xd69a,0xe73c,0xce59,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xe73c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xef5d,0xdefb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdefb,0xef5d,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xce59,0xe73c,0xd69a,0x5acb,0xbdf7,0xef7d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf7be,0x9492,0x6b6d,0xef7d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xe73c,0x630c,0xa534,
    0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xbdd7,0x8410,0xad75,
    0xd69a,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x8410,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x630c,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xce59,
    0x9492,0x9cd3,0xce59,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b6d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5aeb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b6d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xd69a,0xad75,0x7bcf,
    0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x630c,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x8410,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe73c,0xbdd7,
    0x6b4d,0xc618,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf79e,
    0xa534,0x630c,0xe71c,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x6b4d,0x9492,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef5d,0xbdf7,0x5acb,0xce79,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xf79e,0x8410,0x7bcf,0xf79e,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd6ba,0x5acb,0xb5b6,0xef7d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,
    0xdedb,0xe73c,0x632c,0x9cd3,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf79e,0x7bcf,0x8410,0xf79e,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe73c,0xce79,0x5acb,0xbdf7,0xef5d,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x9492,0x6b4d,0xef5d,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xe71c,0x630c,0xa534,
    0xf79e,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xce59,0x6b4d,
    0xb596,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x7bef,0xc638,0xe73c,0xc638,0xd69a,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xf79e,0x8430,0x738e,0xef5d,0xd69a,0xce59,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xd69a,0xce79,0xce59,0xdefb,0xdedb,0x5aeb,0xad75,0xef7d,0xc638,0xd69a,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xd6ba,0xd69a,0xa514,
    0x73ae,0xd69a,0xdefb,0xce59,0xd69a,0xce79,0xce79,0xce79,0xce79,0xd69a,0xce79,0xce79,0xce79,0xd69a,0xce59,0xef7d,
    0xa514,0x630c,0xe71c,0xdedb,0xce59,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xd69a,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce59,0xd6ba,0xef5d,0x6b4d,0x9492,0xf79e,0xce59,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xd69a,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xd69a,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xd69a,0xc638,0xef5d,0xbdd7,0x5acb,0xce79,0xe71c,0xc638,
    0xd69a,0xce79,0xce79,0xce79,0xce79,0xd69a,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xef7e,0x8410,0x7bcf,0xef7d,0xd69a,0xce79,0xce79,0xce79,0xd69a,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xd69a,0xc638,0xe71c,0xd6ba,0x5acb,0xb5b6,0xef5d,0xc638,0xd69a,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xd69a,0xce59,0xef7d,0x9cd3,0x632c,0xe73c,0xdedb,
    0xce59,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce59,
    0xdedb,0xe73c,0x632c,0x9cd3,0xef7d,0xce59,0xd69a,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xd69a,0xc638,0xef5d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xc638,0xd69a,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xd69a,0xce79,0xce79,0xce79,0xd69a,0xef7d,0x7bcf,0x8410,0xef9e,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xd69a,0xce79,0xce79,0xce79,0xce79,0xd69a,
    0xc638,0xe71c,0xce79,0x5acb,0xbdf7,0xef5d,0xc638,0xd69a,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xd69a,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xd69a,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce59,0xf79e,0x9492,0x6b4d,0xef5d,0xd6ba,0xce59,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xd69a,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce59,0xdedb,0xe71c,0x630c,0xa514,
    0xef7d,0xce59,0xd69a,0xce79,0xce79,0xce79,0xd69a,0xce79,0xce79,0xce79,0xce79,0xd69a,0xce59,0xdedb,0xd69a,0x8c71,
    0x9492,0xc638,0xdedb,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xd69a,0xc638,0xef7d,0xad75,0x5aeb,0xdedb,0xdefb,0xce59,0xce79,0xd69a,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce59,0xd69a,0xef5d,0x738e,0x8430,0xf79e,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xd69a,0xce59,0xe71c,0xce79,0x7bef,
    0x8410,0xce59,0xef7d,0xce79,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,
    0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,
    0xd6ba,0xd6ba,0xd6ba,0xd69a,0xffdf,0x8c51,0x738e,0xf79e,0xdedb,0xd69a,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,
    0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,
    0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xce79,0xe73c,0xe71c,0x5aeb,0xad75,0xf7be,0xce79,0xd6ba,
    0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd69a,0xd6ba,0xe73c,0xb596,0x8c51,
    0xbdd7,0xdedb,0xdedb,0xd69a,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xce79,0xf7be,
    0xa534,0x630c,0xe73c,0xe71c,0xce79,0xd6ba,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,
    0xd69a,0xd6ba,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd6ba,0xd69a,0xd6ba,0xd69a,0xd6ba,0xd69a,
    0xd6ba,0xd6ba,0xd6ba,0xce79,0xdedb,0xef7d,0x6b6d,0x9492,0xffde,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd6ba,0xd6ba,0xd69a,
    0xd6ba,0xd69a,0xd6ba,0xd69a,0xd6ba,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd6ba,0xd69a,0xd6ba,
    0xd69a,0xd6ba,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xce79,0xef7d,0xc618,0x5acb,0xd69a,0xef5d,0xce79,
    0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,
    0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd69a,0xd6ba,
    0xf7be,0x8410,0x7bcf,0xf7be,0xd6ba,0xd69a,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,
    0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,
    0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xce79,0xe73c,0xdedb,0x5acb,0xbdd7,0xf79e,0xce79,0xd6ba,0xd69a,0xd6ba,0xd69a,0xd6ba,
    0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd6ba,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,
    0xd6ba,0xd6ba,0xd69a,0xd6ba,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd679,0xf7be,0x9cf3,0x632c,0xef5d,0xdefb,
    0xd67a,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,
    0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd67a,
    0xdefb,0xef5d,0x632c,0x9cf3,0xf7be,0xce99,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,
    0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,
    0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xce79,0xf79e,0xb5d6,0x5aeb,0xdedb,0xe73c,0xce79,0xd6ba,0xd6ba,0xd6ba,0xd6ba,
    0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,
    0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd69a,0xd6ba,0xf7be,0x7bcf,0x8410,0xf7be,
    0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,
    0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,
    0xce79,0xef5d,0xd69a,0x5acb,0xc618,0xef7d,0xce79,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,
    0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,
    0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd69a,0xf7bf,0x94b2,0x6b6d,0xf79e,0xdefb,0xd69a,0xd6ba,0xd6ba,0xd6ba,
    0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,
    0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xce79,0xe71c,0xe73c,0x630c,0xa534,
    0xf7be,0xce79,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd69a,0xd6ba,0xdedb,0xce59,
    0x8410,0xa514,0xef5d,0xd6ba,0xd69a,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,
    0xd6ba,0xce79,0xf7be,0xad75,0x5aeb,0xe71c,0xe73c,0xce79,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,
    0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,
    0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd69a,0xdedb,0xf79e,0x738e,0x8c51,0xffdf,0xd69a,0xd6ba,0xd6ba,0xd6ba,
    0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,
    0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xd6ba,0xce79,0xef5d,0xd69a,0x8410,
    0x8410,0xdedb,0xffff,0xef5d,0xf79e,0xf79e,0xef7d,0xef7d,0xf79e,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xf79e,0xef7d,
    0xef7d,0xf79e,0xf79e,0xef7d,0xef7d,0xf79e,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xf79e,0xef7d,0xef7d,0xf79e,0xf79e,
    0xef7d,0xef7d,0xef7d,0xef7d,0xffff,0x94b2,0x8410,0xffff,0xf7be,0xef7d,0xef7d,0xf79e,0xef7d,0xef7d,0xef7d,0xef7d,
    0xef7d,0xf79e,0xef7d,0xef7d,0xf79e,0xf79e,0xef7d,0xef7d,0xf79e,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xf79e,0xef7d,
    0xef7d,0xf79e,0xf79e,0xef7d,0xef7d,0xef7d,0xf79e,0xef7d,0xef5d,0xffff,0xf7be,0x6b4d,0xbdf7,0xffff,0xef5d,0xf79e,
    0xef7d,0xef7d,0xef7d,0xef7d,0xf79e,0xef7d,0xef7d,0xf79e,0xf79e,0xef7d,0xef7d,0xf79e,0xef7d,0xffdf,0x9cf3,0x8c51,
    0xffff,0xf7be,0xef7d,0xef7d,0xf79e,0xf79e,0xef7d,0xef7d,0xef7d,0xf79e,0xef7d,0xef7d,0xef7d,0xf79e,0xef5d,0xffff,
    0xb5b6,0x6b6d,0xffff,0xffff,0xef7d,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xef7d,0xffdf,0xffff,0x7bcf,0xa513,0xffff,0xef7b,0xf79c,0xf79c,0xf79c,0xf79c,0xf79c,0xf79c,
    0xf79c,0xf79c,0xf79c,0xf79c,0xf79c,0xf79c,0xf79c,0xf79c,0xf79c,0xf79c,0xf79c,0xf79c,0xf79c,0xf79c,0xf79c,0xf79c,
    0xf79c,0xf79c,0xf79c,0xf79c,0xf79c,0xf79c,0xf79c,0xf79c,0xf79c,0xef5b,0xffff,0xd699,0x632c,0xe71b,0xfffe,0xef3b,
    0xf77c,0xf77c,0xf77c,0xf77c,0xf75c,0xf77c,0xf75c,0xf77c,0xf77c,0xf77c,0xf77c,0xf77c,0xf77c,0xf77c,0xf77c,0xf75c,
    0xf77c,0xf75c,0xf77c,0xf77c,0xf77c,0xf77c,0xf77c,0xf77c,0xf77c,0xf77c,0xf77c,0xf77c,0xf75c,0xf77c,0xf75c,0xf77c,
    0xffff,0x9471,0x8410,0xffff,0xf75d,0xef1c,0xef3c,0xef3c,0xef3c,0xef3c,0xef3c,0xef3c,0xef3c,0xef3c,0xef3c,0xef3c,
    0xef3c,0xef3c,0xef3c,0xef3c,0xef3c,0xef3c,0xef3c,0xef3c,0xef3c,0xef3c,0xef3c,0xef3c,0xef3c,0xef3c,0xef3c,0xef3c,
    0xef3c,0xef3c,0xef3c,0xef3c,0xe6fb,0xffbe,0xef3c,0x632c,0xc659,0xffff,0xdf5d,0xe79e,0xe79e,0xe79e,0xe79e,0xe79e,
    0xe79e,0xe79e,0xe79e,0xe79e,0xe79e,0xe79e,0xe79e,0xe79e,0xe79e,0xe79e,0xe79e,0xe79e,0xe79e,0xe79e,0xe79e,0xe79e,
    0xe79e,0xe79e,0xe79e,0xe79e,0xe79e,0xe79e,0xe79e,0xe79e,0xe79e,0xe79e,0xdf7d,0xffff,0xa575,0x6b8d,0xf7de,0xefbd,
    0xdf3b,0xe75c,0xe75c,0xe75c,0xe75c,0xe75c,0xe75c,0xe75c,0xe75c,0xe75c,0xe75c,0xe75c,0xe75c,0xe75c,0xe75c,0xe75c,
    0xe75c,0xe75c,0xe75c,0xe75c,0xe75c,0xe75c,0xe75c,0xe75c,0xe75c,0xe75c,0xe75c,0xe75c,0xe75c,0xe75c,0xe75c,0xdf3b,
    0xefbd,0xf7fe,0x6b6d,0xad35,0xffff,0xeefd,0xf73e,0xf71e,0xf71e,0xf73e,0xf71e,0xf71e,0xf71e,0xf71e,0xf71e,0xf73e,
    0xf71e,0xf71e,0xf73e,0xf73e,0xf71e,0xf71e,0xf73e,0xf71e,0xf71e,0xf71e,0xf71e,0xf71e,0xf73e,0xf71e,0xf71e,0xf73e,
    0xf73e,0xf71e,0xf71e,0xf71e,0xf73e,0xeefd,0xffff,0xce19,0x630c,0xef3d,0xffbf,0xe6dc,0xef3d,0xef1d,0xef1d,0xef1d,
    0xef1d,0xef1d,0xef3d,0xef1d,0xef1d,0xef3d,0xef3d,0xef1d,0xef1d,0xef3d,0xef1d,0xef1d,0xef1d,0xef1d,0xef1d,0xef3d,
    0xef1d,0xef1d,0xef3d,0xef3d,0xef1d,0xef1d,0xef1d,0xef3d,0xef1d,0xef1d,0xe71c,0xef3d,0xffff,0x8410,0x9451,0xffff,
    0xf71c,0xf71c,0xf71c,0xf71c,0xf71c,0xf73c,0xf71c,0xf71c,0xf73c,0xf73c,0xf71c,0xf71c,0xf73c,0xf71c,0xf71c,0xf71c,
    0xf71c,0xf71c,0xf73c,0xf71c,0xf71c,0xf73c,0xf73c,0xf71c,0xf71c,0xf71c,0xf73c,0xf71c,0xf71c,0xf71c,0xf73c,0xf73c,
    0xeedb,0xffbe,0xe6fb,0x630c,0xce5a,0xffdf,0xdefd,0xe73e,0xe73e,0xe71e,0xe71e,0xe73e,0xe73e,0xe71e,0xe71e,0xe71e,
    0xe73e,0xe71e,0xe71e,0xe71e,0xe71e,0xe73e,0xe71e,0xe71e,0xe73e,0xe71e,0xe71e,0xe71e,0xe71e,0xe73e,0xe71e,0xe71e,
    0xe71e,0xe73e,0xe73e,0xe71e,0xe71e,0xe71e,0xdefd,0xffff,0x9cd4,0x738e,0xffdf,0xef5d,0xdefb,0xe71c,0xe73c,0xe73c,
    0xe71c,0xe71c,0xe71c,0xe73c,0xe71c,0xe71c,0xe71c,0xe73c,0xe73c,0xe71c,0xe71c,0xe73c,0xe71c,0xe71c,0xe71c,0xe71c,
    0xe71c,0xe73c,0xe71c,0xe71c,0xe73c,0xe73c,0xe71c,0xe71c,0xe73c,0xe71c,0xe71c,0xdefb,0xef7d,0xf79e,0x6b4d,0xb5b6,
    0xffff,0xef5d,0xf79e,0xef7d,0xef7d,0xef7d,0xf79e,0xef7d,0xef7d,0xef7d,0xf79e,0xf79e,0xef7d,0xef7d,0xf7be,0xffff,
    0x94b2,0x9cd3,0xf79e,0xef7d,0xf79e,0xef7d,0xef7d,0xf79e,0xf79e,0xef7d,0xef7d,0xf79e,0xef7d,0xef7d,0xef7d,0xef7d,
    0xf79e,0xef5d,0xffff,0xbdf7,0x6b4d,0xf7be,0xffff,0xef5d,0xef7d,0xf79e,0xef7d,0xef7d,0xef7d,0xf79e,0xf79e,0xef7d,
    0xef7d,0xf79e,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xf79e,0xef7d,0xef7d,0xf79e,0xf79e,0xef7d,0xef7d,0xf79e,0xef7d,
    0xef7d,0xef7d,0xef7d,0xef7d,0xf79e,0xef7d,0xef7d,0xf7be,0xffff,0x8410,0x94b2,0xffff,0xef7d,0xef7d,0xef7d,0xef7d,
    0xf79e,0xf79e,0xef7d,0xef7d,0xf79e,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xf79e,0xef7d,0xef7d,0xf79e,0xf79e,0xef7d,
    0xef7d,0xf79e,0xef7d,0xef7d,0xef7d,0xef7d,0xef7d,0xf79e,0xef7d,0xef7d,0xf79e,0xf79e,0xef5d,0xffff,0xe71c,0x8410,
    0x7bef,0x7bcf,0x73ae,0x6b6d,0x738e,0x738e,0x6b6d,0x6b6d,0x738e,0x738e,0x738e,0x6b6d,0x738e,0x738e,0x738e,0x6b6d,
    0x6b6d,0x738e,0x738e,0x6b6d,0x6b6d,0x738e,0x738e,0x738e,0x6b6d,0x738e,0x738e,0x738e,0x6b6d,0x6b6d,0x738e,0x738e,
    0x6b6d,0x6b6d,0x738e,0x6b6d,0x7bcf,0x738e,0x6b6d,0x7bcf,0x738e,0x6b6d,0x6b6d,0x738e,0x738e,0x738e,0x6b6d,0x738e,
    0x738e,0x738e,0x6b6d,0x6b6d,0x738e,0x738e,0x6b6d,0x6b6d,0x738e,0x738e,0x738e,0x6b6d,0x738e,0x738e,0x738e,0x6b6d,
    0x6b6d,0x738e,0x738e,0x6b6d,0x6b6d,0x738e,0x738e,0x738e,0x6b6d,0x738e,0x7bcf,0x6b6d,0x73ae,0x73ae,0x6b6d,0x738e,
    0x738e,0x6b6d,0x738e,0x738e,0x738e,0x6b6d,0x6b6d,0x738e,0x738e,0x6b6d,0x738e,0x738e,0x6b6d,0x8c51,0x6b6d,0x630c,
    0x7bcf,0x738e,0x6b6d,0x6b6d,0x738e,0x738e,0x6b6d,0x6b6d,0x738e,0x738e,0x738e,0x6b6d,0x6b6d,0x738e,0x6b6d,0x73ae,
    0x73ae,0x6b4d,0x6b6d,0x632c,0x5aeb,0x630c,0x630c,0x630c,0x5aeb,0x5aeb,0x630c,0x630c,0x5aeb,0x5aeb,0x630c,0x630c,
    0x630c,0x630c,0x630c,0x630c,0x630c,0x5aeb,0x5aeb,0x630c,0x630c,0x5aeb,0x630c,0x630c,0x630c,0x630c,0x630c,0x5aeb,
    0x630c,0x630c,0x630c,0x5aeb,0x630c,0x6b6d,0x6b4d,0x6b72,0x6b77,0x6316,0x6316,0x6316,0x5af6,0x6316,0x6316,0x5af6,
    0x6316,0x6316,0x6316,0x6316,0x6316,0x6316,0x6316,0x6316,0x5af6,0x5af6,0x6316,0x6316,0x6316,0x6316,0x6316,0x6316,
    0x6316,0x6316,0x5af6,0x6316,0x6316,0x5af6,0x5af6,0x6316,0x6316,0x6316,0x6b57,0x6b74,0x6b6e,0x7435,0x6417,0x5bf6,
    0x63f6,0x63f6,0x5bf6,0x63f6,0x63f6,0x63f6,0x63f6,0x63f6,0x5bf6,0x63f6,0x63f6,0x5bf6,0x5bf6,0x63f6,0x63f6,0x63f6,
    0x63f6,0x63f6,0x63f6,0x63f6,0x5bf6,0x5bf6,0x63f6,0x63f6,0x5bf6,0x5bf6,0x63f6,0x63f6,0x63f6,0x63f6,0x63f6,0x63f6,
    0x7457,0x6b91,0x7410,0x8d96,0x7d55,0x7d34,0x7d34,0x7d34,0x7d34,0x7d34,0x7d34,0x7d34,0x7d34,0x7d34,0x7d34,0x7d34,
    0x7d34,0x7d34,0x7d34,0x7d34,0x7d34,0x7d34,0x7d34,0x7d34,0x7d34,0x7d34,0x7d34,0x7d34,0x7d34,0x7d34,0x7d34,0x7d34,
    0x7d34,0x7d34,0x7d34,0x7d34,0x7d14,0x8575,0x8555,0x738e,0xa34d,0xbb4d,0xb30c,0xb30c,0xb30c,0xb30c,0xb2eb,0xb30c,
    0xb30c,0xb2eb,0xb2eb,0xb30c,0xb30c,0xb30c,0xb30c,0xb30c,0xb30c,0xb30c,0xb2eb,0xb2eb,0xb30c,0xb30c,0xb2eb,0xb2eb,
    0xb30c,0xb30c,0xb30c,0xb30c,0xb30c,0xb30c,0xb30c,0xb2eb,0xb2eb,0xb30c,0xb30c,0xbb4d,0x934c,0x7baf,0xbcb7,0xb476,
    0xb456,0xb456,0xb476,0xb476,0xb456,0xb456,0xb476,0xb476,0xb456,0xb456,0xb456,0xb476,0xb476,0xb456,0xb456,0xb476,
    0xb476,0xb456,0xb456,0xb476,0xb476,0xb456,0xb456,0xb456,0xb476,0xb476,0xb456,0xb456,0xb476,0xb476,0xb456,0xb456,
    0xb476,0xbcb7,0x7b8f,0x64ac,0x6dcd,0x658c,0x65ac,0x5dab,0x5dab,0x65ac,0x65ac,0x65ac,0x65ac,0x65ac,0x65ac,0x65ac,
    0x5dab,0x5dab,0x65ac,0x65ac,0x5dab,0x5dab,0x65ac,0x65ac,0x65ac,0x65ac,0x65ac,0x65ac,0x65ac,0x5dab,0x5dab,0x65ac,
    0x65ac,0x5dab,0x65ac,0x65ac,0x65ac,0x658c,0x6dcd,0x6d0d,0x6bcd,0x9592,0x8db1,0x8d91,0x8db1,0x8db1,0x8db1,0x8db1,
    0x8db1,0x8db1,0x8db1,0x8db1,0x8db1,0x8db1,0x8db1,0x8db1,0x8db1,0x8db1,0x8db1,0x8db1,0x8db1,0x8db1,0x8db1,0x8db1,
    0x8db1,0x8db1,0x8db1,0x8db1,0x8db1,0x8db1,0x8db1,0x8db1,0x8db1,0x8db1,0x8d91,0x8db1,0x95f2,0x7c2e,0x6c31,0x75f7,
    0x65b6,0x6596,0x65b6,0x65b6,0x65b6,0x65b6,0x5db6,0x5db6,0x65b6,0x65b6,0x5db6,0x5db6,0x65b6,0x65b6,0x65b6,0x65b6,
    0x65b6,0x65b6,0x65b6,0x5db6,0x5db6,0x65b6,0x65b6,0x5db6,0x65b6,0x65b6,0x65b6,0x65b6,0x65b6,0x5db6,0x65b6,0x65b6,
    0x5d96,0x65d7,0x6d76,0x6bae,0xad2d,0xbdcd,0xb58c,0xb5ac,0xb5ac,0xb5ab,0xb5ab,0xb5ac,0xb5ac,0xb5ab,0xb5ac,0xb5ac,
    0xb5ac,0xb5ac,0xb5ac,0xb5ac,0xb5ac,0xb5ac,0xb5ab,0xb5ab,0xb5ac,0xb5ac,0xb5ac,0xb5ac,0xb5ac,0xb5ac,0xb5ac,0xb5ac,
    0xb5ab,0xb5ac,0xb5ac,0xb5ab,0xb5ac,0xb5ac,0xb58c,0xbded,0x8c6c,0x8410,0xbdd7,0xb5b6,0xb596,0xb5b6,0xb5b6,0xb5b6,
    0xb5b6,0xb5b6,0xb5b6,0xb5b6,0xb5b6,0xb5b6,0xb5b6,0xb5b6,0xb5b6,0xb5b6,0xb5b6,0xb5b6,0xb5b6,0xb5b6,0xb5b6,0xb5b6,
    0xb5b6,0xb5b6,0xb5b6,0xb5b6,0xb5b6,0xb5b6,0xb5b6,0xb5b6,0xb5b6,0xb5b6,0xb5b6,0xb596,0xb5b6,0xbdd7,0x7bef,0x738e,
    0x7bcf,0x6b6d,0x738e,0x6b6d,0x6b6d,0x738e,0x738e,0x738e,0x6b6d,0x6b6d,0x738e,0x738e,0x6b6d,0x6b6d,0x738e,0x7bcf,
    0x630c,0x6b6d,0x8430,0x738e,0x6b6d,0x738e,0x6b6d,0x738e,0x738e,0x6b6d,0x6b6d,0x738e,0x738e,0x738e,0x6b6d,0x738e,
    0x738e,0x6b6d,0x73ae,0x73ae,0x6b6d,0x7bcf,0x738e,0x6b6d,0x738e,0x738e,0x738e,0x6b6d,0x6b6d,0x738e,0x738e,0x6b6d,
    0x6b6d,0x738e,0x738e,0x738e,0x6b6d,0x738e,0x738e,0x738e,0x6b6d,0x6b6d,0x738e,0x738e,0x6b6d,0x6b6d,0x738e,0x738e,
    0x738e,0x6b6d,0x738e,0x738e,0x738e,0x6b6d,0x6b6d,0x738e,0x7bcf,0x6b6d,0x738e,0x7bcf,0x6b6d,0x738e,0x6b6d,0x6b6d,
    0x738e,0x738e,0x6b6d,0x6b6d,0x738e,0x738e,0x738e,0x6b6d,0x738e,0x738e,0x738e,0x6b6d,0x6b6d,0x738e,0x738e,0x6b6d,
    0x6b6d,0x738e,0x738e,0x738e,0x6b6d,0x738e,0x738e,0x738e,0x6b6d,0x6b6d,0x738e,0x738e,0x6b6d,0x738e,0x7bcf,0x7bef,
    0x7bef,0x9492,0x94b2,0x8c51,0x9492,0x9492,0x8c71,0x8c71,0x9492,0x9492,0x8c71,0x8c71,0x8c71,0x9492,0x9492,0x8c71,
    0x8c71,0x9492,0x9492,0x8c71,0x8c71,0x9492,0x9492,0x8c71,0x8c71,0x8c71,0x9492,0x9492,0x8c71,0x8c71,0x9492,0x9492,
    0x8c71,0x8c71,0x8c71,0x8c71,0x9cf3,0x7bcf,0x738e,0x9cf3,0x9492,0x8c71,0x8c71,0x9492,0x9492,0x8c71,0x8c71,0x8c71,
    0x9492,0x9492,0x8c71,0x8c71,0x9492,0x9492,0x8c71,0x8c71,0x9492,0x9492,0x8c71,0x8c71,0x8c71,0x9492,0x9492,0x8c71,
    0x8c71,0x9492,0x9492,0x8c71,0x8c71,0x8c71,0x9492,0x8c71,0x8c71,0x94b2,0x94b2,0x6b4d,0x8430,0x9cd3,0x8c71,0x9492,
    0x8c71,0x8c71,0x8c71,0x9492,0x9492,0x8c71,0x8c71,0x9492,0x9492,0x8c71,0x8c51,0x9492,0x9cf3,0x6b4d,0x7bcf,0xa514,
    0x9492,0x8c71,0x8c71,0x8c71,0x9492,0x9492,0x8c71,0x8c71,0x8c71,0x9492,0x8c71,0x8c71,0x8c71,0x9492,0x8c71,0x9cf3,
    0x7bef,0x6b6d,0xb5b6,0xad55,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,
    0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xad55,0xa534,0xad55,0xa534,0xad55,0xa534,
    0xad55,0xad55,0xad55,0xa534,0xa534,0xb5b6,0x6b72,0x8428,0xb584,0xa525,0xa525,0xad45,0xa525,0xad45,0xad45,0xa525,
    0xad45,0xa525,0xad45,0xa525,0xa525,0xa525,0xad45,0xad45,0xa525,0xa525,0xad45,0xad45,0xa525,0xa525,0xa525,0xad45,
    0xa525,0xad45,0xa525,0xad45,0xad45,0xa525,0xa525,0xad45,0xad45,0xa525,0xad44,0xa527,0x6353,0xabc6,0xabe4,0xa3a5,
    0xabc5,0xabc5,0xa3c5,0xabc5,0xa3c5,0xabc5,0xa3c5,0xabc5,0xa3c5,0xabc5,0xabc5,0xa3c5,0xa3c5,0xabc5,0xabc5,0xa3c5,
    0xa3c5,0xa3c5,0xabc5,0xa3c5,0xa3c5,0xa3c5,0xabc5,0xabc5,0xa3c5,0xa3c5,0xa3c5,0xabc5,0xa3c5,0xa3c5,0xa3c5,0xabc5,
    0xb3c3,0x844d,0x6b30,0x81a5,0x79e8,0x7a08,0x79e7,0x7a08,0x7a08,0x7a08,0x79e7,0x79e7,0x7a08,0x7a08,0x79e7,0x79e7,
    0x7a08,0x7a08,0x7a08,0x79e7,0x7a08,0x7a08,0x7a08,0x79e7,0x79e7,0x7a08,0x7a08,0x79e7,0x79e7,0x7a08,0x7a08,0x7a08,
    0x79e7,0x7a08,0x7a08,0x7a08,0x7208,0x79a6,0x81e7,0x8b8e,0x3d55,0x2555,0x2d34,0x2d55,0x2d34,0x2d55,0x2d34,0x2d55,
    0x2d55,0x2d34,0x2d34,0x2d55,0x2d55,0x2d34,0x2d34,0x2d34,0x2d55,0x2d34,0x2d34,0x2d34,0x2d55,0x2d55,0x2d34,0x2d34,
    0x2d34,0x2d55,0x2d34,0x2d34,0x2d34,0x2d55,0x2d55,0x2d34,0x2d34,0x2d34,0x2d34,0x1d75,0x5cd4,0x8b2c,0x1b63,0x2b25,
    0x2b25,0x2b25,0x2b45,0x2b45,0x2b25,0x2b25,0x2b45,0x2b45,0x2b45,0x2b25,0x2b45,0x2b45,0x2b45,0x2b25,0x2b25,0x2b45,
    0x2b45,0x2b25,0x2b25,0x2b45,0x2b45,0x2b45,0x2b25,0x2b45,0x2b45,0x2b45,0x2b25,0x2b25,0x2b45,0x2b45,0x2b25,0x2b25,
    0x2b25,0x1b43,0x646c,0xa274,0xa915,0xa154,0xa154,0xa154,0xa154,0xa955,0xa955,0xa154,0xa154,0xa154,0xa955,0xa154,
    0xa154,0xa154,0xa955,0xa955,0xa154,0xa154,0xa154,0xa955,0xa154,0xa154,0xa154,0xa955,0xa955,0xa154,0xa154,0xa955,
    0xa955,0xa154,0xa955,0xa154,0xa955,0xa174,0xa915,0xa234,0x6cad,0x694d,0x692d,0x616c,0x694d,0x694d,0x694d,0x614c,
    0x694d,0x694d,0x694d,0x614c,0x614c,0x694d,0x694d,0x614c,0x614c,0x694d,0x694d,0x694d,0x614c,0x694d,0x694d,0x694d,
    0x614c,0x614c,0x694d,0x694d,0x614c,0x614c,0x694d,0x694d,0x694d,0x614c,0x614c,0x694d,0x68cc,0x63d1,0x8b8c,0xb0e3,
    0xa945,0xa145,0xa145,0xa145,0xa945,0xa145,0xa145,0xa145,0xa945,0xa945,0xa145,0xa145,0xa145,0xa945,0xa145,0xa145,
    0xa145,0xa945,0xa945,0xa145,0xa145,0xa945,0xa945,0xa145,0xa945,0xa145,0xa945,0xa145,0xa945,0xa145,0xa945,0xa945,
    0xa165,0xa124,0xb185,0x84cf,0x31f6,0x2115,0x2974,0x2955,0x2955,0x2954,0x2954,0x2955,0x2955,0x2954,0x2955,0x2954,
    0x2955,0x2954,0x2954,0x2954,0x2955,0x2955,0x2954,0x2954,0x2955,0x2955,0x2954,0x2954,0x2954,0x2955,0x2954,0x2955,
    0x2954,0x2955,0x2955,0x2954,0x2955,0x2954,0x2954,0x18f5,0x6314,0x842b,0x18c3,0x2945,0x2945,0x2945,0x2945,0x2945,
    0x2945,0x2945,0x2945,0x2945,0x2945,0x2945,0x2945,0x2945,0x2945,0x2945,0x2945,0x2945,0x2945,0x2945,0x2945,0x2945,
    0x2945,0x2945,0x2945,0x2945,0x2945,0x2945,0x2945,0x2945,0x2945,0x2945,0x2945,0x2965,0x2945,0x2104,0x738e,0x9cd3,
    0x9492,0x8c71,0x9492,0x8c71,0x8c71,0x8c71,0x9492,0x8c71,0x8c71,0x8c71,0x9492,0x9492,0x8c71,0x8c71,0x8c71,0x8c71,
    0xad55,0x7bef,0x630c,0x9cf3,0x94b2,0x8c71,0x8c71,0x9492,0x9492,0x8c71,0x8c71,0x9492,0x9492,0x8c71,0x8c71,0x8c71,
    0x9492,0x8c71,0x9cd3,0x8430,0x6b4d,0x94b2,0x94b2,0x8c71,0x8c71,0x9492,0x8c71,0x8c71,0x8c71,0x9492,0x9492,0x8c71,
    0x8c71,0x9492,0x9492,0x8c71,0x8c71,0x8c71,0x9492,0x9492,0x8c71,0x8c71,0x9492,0x9492,0x8c71,0x8c71,0x9492,0x9492,
    0x8c71,0x8c71,0x8c71,0x9492,0x9492,0x8c71,0x8c71,0x9492,0x9cf3,0x738e,0x7bcf,0x9cf3,0x8c71,0x8c71,0x8c71,0x8c71,
    0x9492,0x9492,0x8c71,0x8c71,0x9492,0x9492,0x8c71,0x8c71,0x8c71,0x9492,0x9492,0x8c71,0x8c71,0x9492,0x9492,0x8c71,
    0x8c71,0x9492,0x9492,0x8c71,0x8c71,0x8c71,0x9492,0x9492,0x8c71,0x8c71,0x9492,0x9492,0x8c51,0x94b2,0x94b2,0x7bef,
    0x8410,0xdefb,0xffff,0xef7d,0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,
    0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,
    0xf79e,0xf79e,0xf79e,0xf79e,0xffff,0x94b2,0x7bef,0xffff,0xffdf,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf79e,
    0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,
    0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf79e,0xf7be,0xf7be,0xef7d,0xffff,0xffdf,0x632c,0xc618,0xffff,0xef5d,0xf7be,
    0xf79e,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xffdf,0xffff,0x8c51,0xa514,0xffdf,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf79e,0xf7be,0xf79e,0xf79e,0xf79e,0xf7be,0xef7d,0xffff,
    0xad75,0x6b6d,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x73b8,0xbdc1,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0x52f6,0xfd40,0xfe20,0xfd80,
    0xfda0,0xfda0,0xfda0,0xfda0,0xfda0,0xfda0,0xfda0,0xfda0,0xfda0,0xfda0,0xfda0,0xfda0,0xfda0,0xfda0,0xfda0,0xfda0,
    0xfda0,0xfda0,0xfda0,0xfda0,0xfda0,0xfda0,0xfda0,0xfda0,0xfda0,0xfda0,0xfda0,0xfda0,0xfda0,0xfda0,0xfda0,0xfda0,
    0xfde0,0xb56b,0x62b1,0xc800,0xb882,0xb0a2,0xb082,0xb0a2,0xb0a2,0xb0a2,0xb0a2,0xb0a2,0xb0a2,0xb0a2,0xb0a2,0xb0a2,
    0xb0a2,0xb0a2,0xb0a2,0xb0a2,0xb0a2,0xb0a2,0xb0a2,0xb0a2,0xb0a2,0xb0a2,0xb0a2,0xb0a2,0xb0a2,0xb0a2,0xb0a2,0xb0a2,
    0xb0a2,0xb0a2,0xb0a2,0xb082,0xb0c3,0xb841,0xb841,0xa32c,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x3f3f,0x9aa8,0x0440,0x0420,
    0x0420,0x0420,0x0420,0x0420,0x0420,0x0420,0x0420,0x0420,0x0420,0x0420,0x0420,0x0420,0x0420,0x0420,0x0420,0x0420,
    0x0420,0x0420,0x0420,0x0420,0x0420,0x0420,0x0420,0x0420,0x0420,0x0420,0x0420,0x0420,0x0420,0x0420,0x0420,0x0420,
    0x0420,0x0400,0x4548,0xf8ff,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf87f,0x5d6b,0x780f,0x8811,0x8010,0x8010,0x8010,0x8010,0x8010,
    0x8010,0x8010,0x8010,0x8010,0x8010,0x8010,0x8010,0x8010,0x8010,0x8010,0x8010,0x8010,0x8010,0x8010,0x8010,0x8010,
    0x8010,0x8010,0x8010,0x8010,0x8010,0x8010,0x8010,0x8010,0x8010,0x8010,0x8010,0x8010,0x900f,0x5bb5,0xbb48,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf800,0xf800,0xf800,0x8d8e,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x4a5f,0x8c67,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x630c,0xe73c,
    0xffff,0xef7d,0xf7be,0xf79e,0xf79e,0xf79e,0xf7be,0xf79e,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf79e,
    0xffff,0xa534,0x8410,0xffdf,0xffff,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf79e,
    0xf7be,0xef5d,0xffff,0xc618,0x632c,0xffdf,0xffff,0xef7d,0xf7be,0xf7be,0xf79e,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,
    0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,
    0xf79e,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xffdf,0xffff,0x7bef,0x94b2,0xffff,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,
    0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,0xef7d,0xffff,0xef5d,0x8410,
    0x8410,0xc638,0xe73c,0xc638,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce59,0xf79e,0x8c51,0x738e,0xef5d,0xd69a,0xce59,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xc638,0xdefb,0xdedb,0x5aeb,0xad55,0xef7d,0xc638,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce59,0xce79,0xd69a,0xbdd7,0x7bcf,0xad55,0xe73c,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xc638,0xf79e,
    0x9cd3,0x630c,0xffff,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xf7be,0xffff,0xffff,0x6336,0x9ce3,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xf7a1,0xffe0,0xe763,0x42b7,0xfce0,0xfd60,0xf4e1,
    0xfd00,0xfd00,0xfd00,0xfd00,0xfd00,0xfd00,0xfd00,0xfd00,0xfd00,0xfd00,0xfd00,0xfd00,0xfd00,0xfd00,0xfd00,0xfd00,
    0xfd00,0xfd00,0xfd00,0xfd00,0xfd00,0xfd00,0xfd00,0xfd00,0xfd00,0xfd00,0xfd00,0xfd00,0xfd00,0xfd00,0xfd00,0xfd00,
    0xfd40,0x9d2d,0x62f2,0xb0a1,0xa145,0xa165,0xa165,0xa165,0xa165,0xa165,0xa165,0xa165,0xa165,0xa165,0xa165,0xa165,
    0xa165,0xa165,0xa165,0xa165,0xa165,0xa165,0xa165,0xa165,0xa165,0xa165,0xa165,0xa165,0xa165,0xa165,0xa165,0xa165,
    0xa165,0xa165,0xa165,0xa165,0x9986,0xa104,0xa904,0x9b4d,0x0fbe,0x07ff,0x0fbe,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07df,0x07ff,0x4e5c,0xa2aa,0x0400,0x03e0,
    0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,
    0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,
    0x03e0,0x03e0,0x554a,0xe19c,0xf81f,0xf83f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf05e,0xf81f,0xe93d,0x5dcb,0x780f,0x8010,0x784f,0x780f,0x780f,0x780f,0x780f,
    0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,
    0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x782f,0x7810,0x880e,0x5c34,0xabaa,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf041,0xf800,0xf800,0x8dce,0x00df,0x001f,0x085e,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x5afb,0x9cc9,0x0000,0x0000,0x0020,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0000,0x6b4d,0xce79,
    0xdefb,0xce59,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce59,
    0xe71c,0xb5b6,0x8430,0xad55,0xd69a,0xd69a,0xce59,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xc638,0xef7d,0xad55,0x5aeb,0xdedb,0xdefb,0xc638,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce59,0xd69a,0xef5d,0x738e,0x8c51,0xf79e,0xce59,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,
    0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xce79,0xc638,0xe71c,0xce79,0x8410,
    0x8410,0xce59,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xdefb,0x630c,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xd69a,0x94b2,0x94b2,0xc638,0xdefb,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf7be,
    0x9cd3,0x630c,0xffff,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xf7be,0xffff,0xffff,0x6336,0xa503,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xf7a0,0xffe0,0xe762,0x42d7,0xfce0,0xfd80,0xf500,
    0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,
    0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,
    0xfd40,0xa52d,0x62f2,0xb880,0xa125,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa165,0xa0e3,0xa8e3,0x9b4d,0x0fbe,0x07ff,0x07be,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07df,0x07ff,0x4e7d,0xa2aa,0x0420,0x0400,
    0x03e0,0x03e0,0x0400,0x0400,0x03e0,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x03e0,0x0400,
    0x0400,0x03e0,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x03e0,0x0400,0x0400,0x03e0,0x03e0,
    0x03e0,0x03e0,0x554a,0xe99d,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf03e,0xf81f,0xe91d,0x5dab,0x780f,0x8010,0x782f,0x8010,0x8010,0x8010,0x780f,
    0x8010,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x8010,0x780f,0x8010,0x8010,0x8010,
    0x780f,0x780f,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x8010,0x780f,0x780f,0x7810,0x880e,0x5c34,0xabaa,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf020,0xf800,0xf800,0x8dcf,0x00bf,0x001f,0x003e,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x5adb,0x9cc9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0000,0x6b4d,0xd69a,
    0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xdedb,0xce79,0xa514,0x7bef,0xce79,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x630c,0xdefb,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xd69a,0x8410,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xc638,0x6b4d,0xb596,0xdefb,0xce79,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf7be,
    0x9cd3,0x630c,0xffff,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xf7be,0xffff,0xffff,0x6316,0xa503,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xf7a0,0xffe0,0xe763,0x42b7,0xfce0,0xfd60,0xf4e0,
    0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd00,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,
    0xfd00,0xfd20,0xfd00,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd00,0xfd00,0xfd00,
    0xfd40,0xa50d,0x62f2,0xb080,0xa145,0xa165,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa165,0xa0e3,0xa8e3,0x9b2c,0x0fbe,0x07ff,0x07be,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07df,0x07ff,0x4e5d,0xa2aa,0x0400,0x03e0,
    0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,
    0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,
    0x03e0,0x03c0,0x552a,0xe99d,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf03e,0xf81f,0xe93d,0x5dab,0x780f,0x8010,0x782f,0x780f,0x780f,0x780f,0x780f,
    0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,
    0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x880e,0x5434,0xabaa,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf020,0xf800,0xf800,0x85ce,0x00df,0x001f,0x003e,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x5adb,0x9cc9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0000,0x6b4d,0xce79,
    0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce79,0xe71c,0xbdf7,0x632c,0xc618,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xdedb,0xb596,0x6b4d,0xc638,0xe73c,0xce59,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf7be,
    0x9cd3,0x630c,0xffff,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xf7be,0xffff,0xffff,0x6316,0xa503,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xf7a0,0xffe0,0xe763,0x42b7,0xfce0,0xfd60,0xf4e0,
    0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd00,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,
    0xfd00,0xfd20,0xfd00,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd00,0xfd00,0xfd00,
    0xfd40,0xa50d,0x62f2,0xb080,0xa145,0xa165,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa165,0xa0e3,0xa8e3,0x9b2c,0x0fbe,0x07ff,0x07be,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07df,0x07ff,0x4e5d,0xa2aa,0x0400,0x03e0,
    0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,
    0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,
    0x03e0,0x03c0,0x552a,0xe99d,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf03e,0xf81f,0xe93d,0x5dab,0x780f,0x8010,0x782f,0x780f,0x780f,0x780f,0x780f,
    0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,
    0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x880e,0x5414,0xabaa,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf020,0xf800,0xf800,0x85ce,0x00df,0x001f,0x003e,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x5adb,0x9cc9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0000,0x6b4d,0xce79,
    0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce59,0xe71c,0xce59,0x7bcf,0xa534,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf79e,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xef7d,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe71c,0xc618,0x9492,0x9cd3,0xd69a,0xdedb,0xce79,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf7be,
    0x9cd3,0x630c,0xffff,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xf7be,0xffff,0xffff,0x6336,0xa503,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xf7a0,0xffe0,0xe763,0x42d7,0xfce0,0xfd80,0xf500,
    0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,
    0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,
    0xfd40,0xa52d,0x62f2,0xb880,0xa145,0xa165,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa165,0xa0e3,0xa8e3,0x9b4d,0x0fbe,0x07ff,0x07be,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07df,0x07ff,0x4e7d,0xa2aa,0x0420,0x0400,
    0x03e0,0x03e0,0x0400,0x0400,0x03e0,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x03e0,0x0400,
    0x0400,0x03e0,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x03e0,0x0400,0x0400,0x03e0,0x03e0,
    0x03e0,0x03e0,0x554a,0xe99d,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf03e,0xf81f,0xe91d,0x5dab,0x780f,0x8010,0x782f,0x8010,0x8010,0x8010,0x780f,
    0x8010,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x8010,0x780f,0x8010,0x8010,0x8010,
    0x780f,0x780f,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x8010,0x780f,0x780f,0x7810,0x880e,0x5c34,0xabaa,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf020,0xf800,0xf800,0x8dcf,0x00df,0x001f,0x003e,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x5adc,0x9cc9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0000,0x6b4d,0xd69a,
    0xe71c,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xce79,0xd6ba,0xd69a,0xad75,0x8430,0xbdd7,0xe73c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xef7d,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf79e,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xef7d,0xad55,0x6b6d,0xc638,0xdedb,0xd6ba,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf7be,
    0x9cd3,0x630c,0xffff,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffdf,0xffff,0xffff,0x6336,0xa503,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xf7a0,0xffe0,0xe783,0x42d7,0xfce0,0xfd80,0xf500,
    0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,
    0xfd00,0xfd20,0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd20,0xfd00,0xfd20,
    0xfd40,0xa52d,0x62f2,0xb880,0xa145,0xa165,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa165,0xa0e3,0xa8e3,0x9b4d,0x0fbe,0x07ff,0x07df,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x4e7d,0xa2aa,0x0400,0x0400,
    0x03e0,0x03e0,0x0400,0x0400,0x03e0,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x03e0,0x0400,
    0x0400,0x03e0,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x03e0,0x0400,0x0400,0x03e0,0x03e0,
    0x03e0,0x03e0,0x554a,0xe99d,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf83f,0xf81f,0xe91d,0x5dab,0x780f,0x8010,0x782f,0x8010,0x8010,0x8010,0x780f,
    0x8010,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x8010,0x780f,0x8010,0x8010,0x8010,
    0x780f,0x780f,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x8010,0x780f,0x780f,0x7810,0x880e,0x5c34,0xabaa,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf020,0xf800,0xf800,0x8dcf,0x00df,0x001f,0x003e,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x5adc,0x9cc9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0000,0x6b4d,0xd69a,
    0xe71c,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xdefb,0xd6ba,0x6b4d,0x9cf3,0xef7d,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x8410,0xce59,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x630c,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xdedb,0x9492,0x73ae,0xe71c,0xdedb,0xce79,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf7be,
    0x9cd3,0x630c,0xffff,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xf7be,0xffff,0xffff,0x6336,0xa503,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xf7a0,0xffe0,0xe763,0x42d7,0xfce0,0xfd80,0xf500,
    0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,
    0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,
    0xfd40,0xa52d,0x62f2,0xb880,0xa145,0xa165,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa165,0xa0e3,0xa8e3,0x9b4d,0x0fbe,0x07ff,0x07be,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07df,0x07ff,0x4e7d,0xa2aa,0x0420,0x0400,
    0x03e0,0x03e0,0x0400,0x0400,0x03e0,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x03e0,0x0400,
    0x0400,0x03e0,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x03e0,0x0400,0x0400,0x03e0,0x03e0,
    0x03e0,0x03e0,0x554a,0xe99d,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf03e,0xf81f,0xe91d,0x5dab,0x780f,0x8010,0x782f,0x8010,0x8010,0x8010,0x780f,
    0x8010,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x8010,0x780f,0x8010,0x8010,0x8010,
    0x780f,0x780f,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x8010,0x780f,0x780f,0x7810,0x880e,0x5c34,0xabaa,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf020,0xf800,0xf800,0x8dcf,0x00df,0x001f,0x003e,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x5adb,0x9cc9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0000,0x6b4d,0xd69a,
    0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce79,0xdedb,0xe71c,0x8410,0x8c71,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x630c,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xd69a,0x8410,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xdedb,0xbdd7,0x8c51,0x94b2,0xe71c,0xd6ba,0xce79,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf7be,
    0x9cd3,0x630c,0xffff,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xf7be,0xffff,0xffff,0x6316,0xa503,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xf7a0,0xffe0,0xe763,0x42b7,0xfce0,0xfd60,0xf4e0,
    0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd00,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,
    0xfd00,0xfd20,0xfd00,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd00,0xfd00,0xfd00,
    0xfd40,0xa50d,0x62f2,0xb080,0xa145,0xa165,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa165,0xa0e3,0xa8e3,0x9b2c,0x0fbe,0x07ff,0x07be,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07df,0x07ff,0x4e5d,0xa2aa,0x0400,0x03e0,
    0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,
    0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,
    0x03e0,0x03c0,0x552a,0xe99d,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf03e,0xf81f,0xe93d,0x5dab,0x780f,0x8010,0x782f,0x780f,0x780f,0x780f,0x780f,
    0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,
    0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x880e,0x5414,0xabaa,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf020,0xf800,0xf800,0x85ce,0x00df,0x001f,0x003e,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x5adb,0x9cc9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0000,0x6b4d,0xce79,
    0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce79,0xd6ba,0xdedb,0xad75,0x8c51,0xad55,0xe71c,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef5d,0x9492,0x8430,0xc638,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf7be,
    0x9cd3,0x630c,0xffff,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xf7be,0xffff,0xffff,0x6316,0xa503,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xf7a0,0xffe0,0xe763,0x42b7,0xfce0,0xfd60,0xf4e0,
    0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd00,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,
    0xfd00,0xfd20,0xfd00,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd00,0xfd00,0xfd00,
    0xfd40,0x9d0d,0x62f2,0xb080,0xa145,0xa165,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa165,0xa0e3,0xa8e3,0x9b2c,0x0fbe,0x07ff,0x07be,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07df,0x07ff,0x4e5d,0xa2aa,0x0400,0x03e0,
    0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,
    0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,
    0x03e0,0x03c0,0x552a,0xe99d,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf03e,0xf81f,0xe93d,0x5dab,0x780f,0x8010,0x782f,0x780f,0x780f,0x780f,0x780f,
    0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,
    0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x880e,0x5434,0xabaa,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf020,0xf800,0xf800,0x85ce,0x00df,0x001f,0x003e,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x5adb,0x9cc9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0000,0x6b4d,0xce79,
    0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce79,0xd69a,0xd6ba,0xd6ba,0x8410,0x8430,0xef5d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xef5d,0x7bcf,0x8410,0xe73c,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf7be,
    0x9cd3,0x630c,0xffff,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffdf,0xffff,0xffff,0x6336,0xa503,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xf7a0,0xffe0,0xe783,0x42d7,0xfce0,0xfd80,0xf500,
    0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,
    0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,
    0xfd40,0xa52d,0x62f2,0xb880,0xa145,0xa165,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa165,0xa0e3,0xa8e3,0x9b4d,0x0fbe,0x07ff,0x07df,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x4e7d,0xa2aa,0x0420,0x0400,
    0x03e0,0x03e0,0x0400,0x0400,0x03e0,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x03e0,0x0400,
    0x0400,0x03e0,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x03e0,0x0400,0x0400,0x03e0,0x03e0,
    0x03e0,0x03e0,0x554a,0xe99d,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf83f,0xf81f,0xe91d,0x5dab,0x780f,0x8010,0x782f,0x8010,0x8010,0x8010,0x780f,
    0x8010,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x8010,0x780f,0x8010,0x8010,0x8010,
    0x780f,0x780f,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x8010,0x780f,0x780f,0x7810,0x880e,0x5c34,0xabaa,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf020,0xf800,0xf800,0x8dcf,0x00df,0x001f,0x003e,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x5adc,0x9cc9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0000,0x6b4d,0xd69a,
    0xe71c,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xef7d,0x8c51,0x738e,0xdefb,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xd6ba,0xc638,0x7bef,0x9cf3,0xef7d,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf7be,
    0x9cd3,0x630c,0xffff,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffdf,0xffff,0xffff,0x6336,0xa503,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xf7a0,0xffe0,0xe783,0x42d7,0xfce0,0xfd80,0xf500,
    0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,
    0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,
    0xfd40,0xa52d,0x62f2,0xb880,0xa145,0xa165,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa165,0xa0e3,0xa8e3,0x9b4d,0x0fbe,0x07ff,0x07df,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x4e7d,0xa2aa,0x0400,0x0400,
    0x03e0,0x03e0,0x0400,0x0400,0x03e0,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x03e0,0x0400,
    0x0400,0x03e0,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x03e0,0x0400,0x0400,0x03e0,0x03e0,
    0x03e0,0x03e0,0x554a,0xe99d,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf83f,0xf81f,0xe91d,0x5dab,0x780f,0x8010,0x782f,0x8010,0x8010,0x8010,0x780f,
    0x8010,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x8010,0x780f,0x8010,0x8010,0x8010,
    0x780f,0x780f,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x8010,0x780f,0x780f,0x7810,0x880e,0x5c34,0xabaa,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf020,0xf800,0xf800,0x8dce,0x00df,0x001f,0x003e,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x5adc,0x9cc9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0000,0x6b4d,0xd69a,
    0xe71c,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xe73c,0xad55,0x8430,0xb5b6,0xd6ba,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x8410,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x630c,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xd6ba,0xa514,0x8c71,0xb5b6,0xe71c,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf7be,
    0x9cd3,0x630c,0xffff,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xf7be,0xffff,0xffff,0x6316,0xa503,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xf7a0,0xffe0,0xe763,0x42d7,0xfce0,0xfd60,0xf4e0,
    0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd00,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,
    0xfd00,0xfd20,0xfd00,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd00,0xfd00,0xfd00,
    0xfd40,0x9d0d,0x62f2,0xb080,0xa145,0xa165,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa165,0xa0e3,0xa8e3,0x9b4d,0x0fbe,0x07ff,0x07be,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07df,0x07ff,0x4e5d,0xa2aa,0x0420,0x0400,
    0x03e0,0x03e0,0x0400,0x0400,0x03e0,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x03e0,0x0400,
    0x0400,0x03e0,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x03e0,0x0400,0x0400,0x03e0,0x03e0,
    0x03e0,0x03e0,0x552a,0xe99d,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf03e,0xf81f,0xe91d,0x5dab,0x780f,0x8010,0x782f,0x8010,0x8010,0x8010,0x780f,
    0x8010,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x8010,0x780f,0x8010,0x8010,0x8010,
    0x780f,0x780f,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x8010,0x780f,0x780f,0x7810,0x880e,0x5c34,0xabaa,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf020,0xf800,0xf800,0x8dcf,0x00df,0x001f,0x003e,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x5adb,0x9cc9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0000,0x6b4d,0xce79,
    0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xdedb,0xc638,0x9cd3,0x8c71,0xd6ba,0xdedb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x630c,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x8410,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdedb,0x73ae,0xa514,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf7be,
    0x9cd3,0x630c,0xffff,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xf7be,0xffff,0xffff,0x6336,0xa503,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xf7a0,0xffe0,0xe763,0x42b7,0xfce0,0xfd60,0xf4e0,
    0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,
    0xfd00,0xfd20,0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd00,0xfd00,0xfd20,
    0xfd40,0xa52d,0x62f2,0xb080,0xa145,0xa165,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa165,0xa0e3,0xa8e3,0x9b2c,0x0fbe,0x07ff,0x07be,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07df,0x07ff,0x4e5d,0xa2aa,0x0400,0x03e0,
    0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,
    0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,
    0x03e0,0x03c0,0x552a,0xe99d,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf03e,0xf81f,0xe91d,0x5dab,0x780f,0x8010,0x782f,0x780f,0x780f,0x780f,0x780f,
    0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,
    0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x800e,0x5414,0xabaa,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf020,0xf800,0xf800,0x85ce,0x00df,0x001f,0x003e,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x5adb,0x9cc9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0000,0x6b4d,0xce79,
    0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xe71c,0xad55,0x6b4d,0xd6ba,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x8410,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x630c,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xce79,0x630c,0xad75,0xef5d,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf7be,
    0x9cd3,0x630c,0xffff,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xf7be,0xffff,0xffff,0x6316,0xa503,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xf7a0,0xffe0,0xe763,0x42d7,0xfce0,0xfd60,0xf4e0,
    0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd00,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,
    0xfd00,0xfd20,0xfd00,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd00,0xfd00,0xfd00,
    0xfd40,0x9d0d,0x62f2,0xb080,0xa145,0xa165,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa165,0xa0e3,0xa8e3,0x9b4d,0x0fbe,0x07ff,0x07be,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07df,0x07ff,0x4e5d,0xa2aa,0x0420,0x0400,
    0x03e0,0x03e0,0x0400,0x0400,0x03e0,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x03e0,0x0400,
    0x0400,0x03e0,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x03e0,0x0400,0x0400,0x03e0,0x03e0,
    0x03e0,0x03e0,0x552a,0xe99d,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf03e,0xf81f,0xe91d,0x5dab,0x780f,0x8010,0x782f,0x8010,0x8010,0x8010,0x780f,
    0x8010,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x8010,0x780f,0x8010,0x8010,0x8010,
    0x780f,0x780f,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x8010,0x780f,0x780f,0x7810,0x880e,0x5c34,0xabaa,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf020,0xf800,0xf800,0x85cf,0x00df,0x001f,0x003e,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x5adb,0x9cc9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0000,0x6b4d,0xce79,
    0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xef5d,0xb5b6,0x6b4d,0xc618,0xdedb,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x630c,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x8410,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xd69a,0xd6ba,0xd69a,0xad75,0x7bef,0xc618,0xe73c,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf7be,
    0x9cd3,0x630c,0xffff,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffdf,0xffff,0xffff,0x6336,0xa503,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xf7a0,0xffe0,0xe783,0x42d7,0xfce0,0xfd80,0xf500,
    0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,
    0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,
    0xfd40,0xa52d,0x62f2,0xb880,0xa145,0xa165,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa165,0xa0e3,0xa8e3,0x9b4d,0x0fbe,0x07ff,0x07df,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x4e7d,0xa2aa,0x0400,0x0400,
    0x03e0,0x03e0,0x0400,0x0400,0x03e0,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x03e0,0x0400,
    0x0400,0x03e0,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x03e0,0x0400,0x0400,0x03e0,0x03e0,
    0x03e0,0x03e0,0x554a,0xe99d,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf83f,0xf81f,0xe91d,0x5dab,0x780f,0x8010,0x782f,0x8010,0x8010,0x8010,0x780f,
    0x8010,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x8010,0x780f,0x8010,0x8010,0x8010,
    0x780f,0x780f,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x8010,0x780f,0x780f,0x7810,0x880e,0x5c34,0xabaa,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf020,0xf800,0xf800,0x8dce,0x00df,0x001f,0x003e,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x5adc,0x9cc9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0000,0x6b4d,0xd69a,
    0xe71c,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xdefb,0xc638,0x8c71,0xa514,0xce79,0xdefb,0xd69a,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe71c,0xc638,0x9492,0x9cf3,0xce79,0xdefb,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf7be,
    0x9cd3,0x630c,0xffff,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffdf,0xffff,0xffff,0x6336,0xa503,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xf7a0,0xffe0,0xe783,0x42d7,0xfce0,0xfd80,0xf500,
    0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,
    0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,
    0xfd40,0xa52d,0x62f2,0xb880,0xa145,0xa165,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa165,0xa0e3,0xa8e3,0x9b4d,0x0fbe,0x07ff,0x07df,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x4e7d,0xa2aa,0x0420,0x0400,
    0x03e0,0x03e0,0x0400,0x0400,0x03e0,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x03e0,0x0400,
    0x0400,0x03e0,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x03e0,0x0400,0x0400,0x03e0,0x03e0,
    0x03e0,0x03e0,0x554a,0xe99d,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf83f,0xf81f,0xe91d,0x5dab,0x780f,0x8010,0x782f,0x8010,0x8010,0x8010,0x780f,
    0x8010,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x8010,0x780f,0x8010,0x8010,0x8010,
    0x780f,0x780f,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x8010,0x780f,0x780f,0x7810,0x880e,0x5c34,0xabaa,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf020,0xf800,0xf800,0x8dcf,0x00df,0x001f,0x003e,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x5adc,0x9cc9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0000,0x6b4d,0xd69a,
    0xe71c,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xd69a,0xd6ba,0xd69a,0xad75,0x7bef,0xbdf7,0xe73c,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xef5d,0xb5b6,0x6b4d,0xc618,0xdedb,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf7be,
    0x9cd3,0x630c,0xffff,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xf7be,0xffff,0xffff,0x6316,0xa503,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xf7a0,0xffe0,0xe763,0x42b7,0xfce0,0xfd60,0xf4e0,
    0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd00,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,
    0xfd00,0xfd20,0xfd00,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd00,0xfd00,0xfd00,
    0xfd40,0x9d0d,0x62f2,0xb080,0xa145,0xa165,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa165,0xa0e3,0xa8e3,0x9b2c,0x0fbe,0x07ff,0x07be,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07df,0x07ff,0x4e5d,0xa2aa,0x0400,0x03e0,
    0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,
    0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,
    0x03e0,0x03c0,0x552a,0xe99d,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf03e,0xf81f,0xe93d,0x5dab,0x780f,0x8010,0x782f,0x780f,0x780f,0x780f,0x780f,
    0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,
    0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x880e,0x5434,0xabaa,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf020,0xf800,0xf800,0x85ce,0x00df,0x001f,0x003e,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x5adb,0x9cc9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0000,0x6b4d,0xce79,
    0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xce79,0x632c,0xad75,0xef5d,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xe71c,0xa534,0x6b6d,0xd6ba,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf7be,
    0x9cd3,0x630c,0xffff,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xf7be,0xffff,0xffff,0x6316,0xa503,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xf7a0,0xffe0,0xe763,0x42b7,0xfce0,0xfd60,0xf4e0,
    0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd00,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,
    0xfd00,0xfd20,0xfd00,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd00,0xfd00,0xfd00,
    0xfd40,0xa50d,0x62f2,0xb080,0xa145,0xa165,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa165,0xa0e3,0xa8e3,0x9b2c,0x0fbe,0x07ff,0x07be,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07df,0x07ff,0x4e5d,0xa2aa,0x0400,0x03e0,
    0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,
    0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,
    0x03e0,0x03c0,0x552a,0xe99d,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf03e,0xf81f,0xe93d,0x5dab,0x780f,0x8010,0x782f,0x780f,0x780f,0x780f,0x780f,
    0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,
    0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x880e,0x5414,0xabaa,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf020,0xf800,0xf800,0x85ce,0x00df,0x001f,0x003e,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x5adb,0x9cc9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0000,0x6b4d,0xce79,
    0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdedb,0x73ae,0x9cf3,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x8410,0xce59,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x630c,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xdedb,0xc638,0x9cd3,0x9492,0xd6ba,0xdedb,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf7be,
    0x9cd3,0x630c,0xffff,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xf7be,0xffff,0xffff,0x6336,0xa503,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xf7a0,0xffe0,0xe763,0x42d7,0xfce0,0xfd80,0xf500,
    0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,
    0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,
    0xfd40,0xa52d,0x62f2,0xb880,0xa145,0xa165,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa165,0xa0e3,0xa8e3,0x9b4d,0x0fbe,0x07ff,0x07be,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07df,0x07ff,0x4e5d,0xa2aa,0x0420,0x0400,
    0x03e0,0x03e0,0x0400,0x0400,0x03e0,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x03e0,0x0400,
    0x0400,0x03e0,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x03e0,0x0400,0x0400,0x03e0,0x03e0,
    0x03e0,0x03e0,0x554a,0xe99d,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf03e,0xf81f,0xe91d,0x5dab,0x780f,0x8010,0x782f,0x8010,0x8010,0x8010,0x780f,
    0x8010,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x8010,0x780f,0x8010,0x8010,0x8010,
    0x780f,0x780f,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x8010,0x780f,0x780f,0x7810,0x880e,0x5c34,0xabaa,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf020,0xf800,0xf800,0x8dcf,0x00df,0x001f,0x003e,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x5adb,0x9cc9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0000,0x6b4d,0xd69a,
    0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xdedb,0xdedb,0xa534,0x9492,0xbdd7,0xdefb,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x630c,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x8410,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xe73c,0xad75,0x8c71,0xb5b6,0xdedb,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf7be,
    0x9cd3,0x630c,0xffff,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffdf,0xffff,0xffff,0x6336,0xa503,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xf7a0,0xffe0,0xe783,0x42d7,0xfce0,0xfd80,0xf500,
    0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,
    0xfd00,0xfd20,0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd20,0xfd00,0xfd20,
    0xfd40,0xa52d,0x62f2,0xb880,0xa145,0xa165,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa165,0xa0e3,0xa8e3,0x9b4d,0x0fbe,0x07ff,0x07df,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x4e7d,0xa2aa,0x0400,0x0400,
    0x03e0,0x03e0,0x0400,0x0400,0x03e0,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x03e0,0x0400,
    0x0400,0x03e0,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x03e0,0x0400,0x0400,0x03e0,0x03e0,
    0x03e0,0x03e0,0x554a,0xe99d,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf83f,0xf81f,0xe91d,0x5dab,0x780f,0x8010,0x782f,0x8010,0x8010,0x8010,0x780f,
    0x8010,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x8010,0x780f,0x8010,0x8010,0x8010,
    0x780f,0x780f,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x8010,0x780f,0x780f,0x7810,0x880e,0x5c34,0xabaa,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf020,0xf800,0xf800,0x8dcf,0x00df,0x001f,0x003e,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x5adc,0x9cc9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0000,0x6b4d,0xd69a,
    0xe71c,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xd6ba,0xce59,0x8430,0xa514,0xef5d,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xef7d,0x9492,0x7bef,0xdedb,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf7be,
    0x9cd3,0x630c,0xffff,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xf7be,0xffff,0xffff,0x6336,0xa503,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xf7a0,0xffe0,0xe783,0x42d7,0xfce0,0xfd80,0xf500,
    0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,
    0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,
    0xfd40,0xa52d,0x62f2,0xb880,0xa145,0xa165,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa165,0xa0e3,0xa8e3,0x9b4d,0x0fbe,0x07ff,0x07be,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07df,0x07ff,0x4e7d,0xa2aa,0x0420,0x0400,
    0x03e0,0x03e0,0x0400,0x0400,0x03e0,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x03e0,0x0400,
    0x0400,0x03e0,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x03e0,0x0400,0x0400,0x03e0,0x03e0,
    0x03e0,0x03e0,0x554a,0xe99d,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf03e,0xf81f,0xe91d,0x5dab,0x780f,0x8010,0x782f,0x8010,0x8010,0x8010,0x780f,
    0x8010,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x8010,0x780f,0x8010,0x8010,0x8010,
    0x780f,0x780f,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x8010,0x780f,0x780f,0x7810,0x880e,0x5c34,0xabaa,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf020,0xf800,0xf800,0x8dcf,0x00df,0x001f,0x003e,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x5adc,0x9cc9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0000,0x6b4d,0xd69a,
    0xe71c,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xe73c,0x7bcf,0x8430,0xf79e,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xce79,0xd69a,0xd69a,0xe73c,0x8430,0x8410,0xef5d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf7be,
    0x9cd3,0x630c,0xffff,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xf7be,0xffff,0xffff,0x6316,0xa503,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xf7a0,0xffe0,0xe763,0x42b7,0xfce0,0xfd60,0xf4e0,
    0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd00,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,
    0xfd00,0xfd20,0xfd00,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd00,0xfd00,0xfd00,
    0xfd40,0xa50d,0x62f2,0xb080,0xa145,0xa165,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa165,0xa0e3,0xa8e3,0x9b2c,0x0fbe,0x07ff,0x07be,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07df,0x07ff,0x4e5d,0xa2aa,0x0400,0x03e0,
    0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,
    0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,
    0x03e0,0x03c0,0x552a,0xe99d,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf03e,0xf81f,0xe93d,0x5dab,0x780f,0x8010,0x782f,0x780f,0x780f,0x780f,0x780f,
    0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,
    0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x880e,0x5414,0xabaa,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf020,0xf800,0xf800,0x85ce,0x00df,0x001f,0x003e,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x5adb,0x9cc9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0000,0x6b4d,0xce79,
    0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xef5d,0x8c51,0x8430,0xd6ba,0xd6ba,0xd69a,0xce79,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xce79,0xd6ba,0xd6ba,0xce59,0x8430,0x94b2,0xe73c,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf7be,
    0x9cd3,0x630c,0xffff,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xf7be,0xffff,0xffff,0x6316,0xa503,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xf7a0,0xffe0,0xe763,0x42b7,0xfce0,0xfd60,0xf4e0,
    0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd00,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,
    0xfd00,0xfd20,0xfd00,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd00,0xfd00,0xfd00,
    0xfd40,0x9d0d,0x62f2,0xb080,0xa145,0xa165,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa165,0xa0e3,0xa8e3,0x9b2c,0x0fbe,0x07ff,0x07be,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07df,0x07ff,0x4e5d,0xa2aa,0x0400,0x03e0,
    0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,
    0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,
    0x03e0,0x03c0,0x552a,0xe99d,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf03e,0xf81f,0xe93d,0x5dab,0x780f,0x8010,0x782f,0x780f,0x780f,0x780f,0x780f,
    0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,
    0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x880e,0x5434,0xabaa,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf020,0xf800,0xf800,0x85ce,0x00df,0x001f,0x003e,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x5adb,0x9cc9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0000,0x6b4d,0xce79,
    0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xe71c,0xad55,0x8c71,0xb596,0xd6ba,0xd6ba,0xce79,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xce79,0xd6ba,0xdefb,0xad55,0x8c71,0xb596,0xdefb,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf7be,
    0x9cd3,0x630c,0xffff,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffdf,0xffff,0xffff,0x6336,0xa503,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xf7a0,0xffe0,0xe783,0x42d7,0xfce0,0xfd80,0xf500,
    0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,
    0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,
    0xfd40,0xa52d,0x62f2,0xb880,0xa145,0xa165,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa165,0xa0e3,0xa8e3,0x9b4d,0x0fbe,0x07ff,0x07df,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x4e7d,0xa2aa,0x0420,0x0400,
    0x03e0,0x03e0,0x0400,0x0400,0x03e0,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x03e0,0x0400,
    0x0400,0x03e0,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x03e0,0x0400,0x0400,0x03e0,0x03e0,
    0x03e0,0x03e0,0x554a,0xe99d,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf83f,0xf81f,0xe91d,0x5dab,0x780f,0x8010,0x782f,0x8010,0x8010,0x8010,0x780f,
    0x8010,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x8010,0x780f,0x8010,0x8010,0x8010,
    0x780f,0x780f,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x8010,0x780f,0x780f,0x7810,0x880e,0x5c34,0xabaa,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf020,0xf800,0xf800,0x8dcf,0x00df,0x001f,0x003e,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x5adc,0x9cc9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0000,0x6b4d,0xd69a,
    0xe71c,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xdedb,0xc618,0x9492,0x9cd3,0xdefb,0xdedb,0xce79,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xd69a,0xce79,0xdedb,0xdefb,0x8c51,0x94b2,0xce79,0xdedb,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf7be,
    0x9cd3,0x630c,0xffff,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffdf,0xffff,0xffff,0x6336,0xa503,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xf7a0,0xffe0,0xe783,0x42d7,0xfce0,0xfd80,0xf500,
    0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,
    0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,
    0xfd40,0xa52d,0x62f2,0xb880,0xa145,0xa165,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa165,0xa0e3,0xa8e3,0x9b4d,0x0fbe,0x07ff,0x07df,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x4e7d,0xa2aa,0x0400,0x0400,
    0x03e0,0x03e0,0x0400,0x0400,0x03e0,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x03e0,0x0400,
    0x0400,0x03e0,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x03e0,0x0400,0x0400,0x03e0,0x03e0,
    0x03e0,0x03e0,0x554a,0xe99d,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf83f,0xf81f,0xe91d,0x5dab,0x780f,0x8010,0x782f,0x8010,0x8010,0x8010,0x780f,
    0x8010,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x8010,0x780f,0x8010,0x8010,0x8010,
    0x780f,0x780f,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x8010,0x780f,0x780f,0x7810,0x880e,0x5c34,0xabaa,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf020,0xf800,0xf800,0x8dce,0x00df,0x001f,0x003e,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x5adc,0x9cc9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0000,0x6b4d,0xd69a,
    0xe71c,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xe71c,0x9cd3,0x73ae,0xe71c,0xdefb,0xce79,0xd69a,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x8410,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x630c,0xad75,0xef7d,0xce59,0xd69a,
    0xd69a,0xce79,0xdefb,0xdefb,0x6b4d,0x9cf3,0xef5d,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf7be,
    0x9cd3,0x630c,0xffff,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xf7be,0xffff,0xffff,0x6336,0xa503,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xf7a0,0xffe0,0xe763,0x42d7,0xfce0,0xfd60,0xf4e0,
    0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd00,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,
    0xfd00,0xfd20,0xfd00,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd00,0xfd00,0xfd00,
    0xfd40,0x9d0d,0x62f2,0xb080,0xa145,0xa165,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa165,0xa0e3,0xa8e3,0x9b4d,0x0fbe,0x07ff,0x07be,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07df,0x07ff,0x4e5d,0xa2aa,0x0420,0x0400,
    0x03e0,0x03e0,0x0400,0x0400,0x03e0,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x03e0,0x0400,
    0x0400,0x03e0,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x03e0,0x0400,0x0400,0x03e0,0x03e0,
    0x03e0,0x03e0,0x554a,0xe99d,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf03e,0xf81f,0xe91d,0x5dab,0x780f,0x8010,0x782f,0x8010,0x8010,0x8010,0x780f,
    0x8010,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x8010,0x780f,0x8010,0x8010,0x8010,
    0x780f,0x780f,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x8010,0x780f,0x780f,0x7810,0x880e,0x5c34,0xabaa,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf020,0xf800,0xf800,0x8dcf,0x00df,0x001f,0x003e,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x5adb,0x9cc9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0000,0x6b4d,0xce79,
    0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xef7d,0xa534,0x6b4d,0xd6ba,0xdedb,0xce79,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x630c,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x8410,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xce79,0xd69a,0xdedb,0xce59,0x738e,0xad75,0xef5d,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf7be,
    0x9cd3,0x630c,0xffff,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xf7be,0xffff,0xffff,0x6336,0xa503,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xf7a0,0xffe0,0xe763,0x42b7,0xfce0,0xfd60,0xf4e0,
    0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,
    0xfd00,0xfd20,0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd00,0xfd00,0xfd20,
    0xfd40,0xa52d,0x62f2,0xb080,0xa145,0xa165,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa165,0xa0e3,0xa8e3,0x9b2c,0x0fbe,0x07ff,0x07be,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07df,0x07ff,0x4e5d,0xa2aa,0x0400,0x03e0,
    0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,
    0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,
    0x03e0,0x03c0,0x552a,0xe99d,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf03e,0xf81f,0xe93d,0x5dab,0x780f,0x8010,0x782f,0x780f,0x780f,0x780f,0x780f,
    0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,
    0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x800e,0x5414,0xabaa,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf020,0xf800,0xf800,0x85ce,0x00df,0x001f,0x003e,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x5adb,0x9cc9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0000,0x6b4d,0xce79,
    0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe73c,0xb5b6,0x7bef,0xbdd7,0xd69a,0xd6ba,0xce79,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xce79,0xd6ba,0xce79,0xa534,0x8c51,0xbdf7,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf7be,
    0x9cd3,0x630c,0xffff,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xf7be,0xffff,0xffff,0x6316,0xa503,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xf7a0,0xffe0,0xe763,0x42b7,0xfce0,0xfd60,0xf4e0,
    0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd00,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,
    0xfd00,0xfd20,0xfd00,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd00,0xfd00,0xfd00,
    0xfd40,0x9d0d,0x62f2,0xb080,0xa145,0xa165,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa165,0xa0e3,0xa8e3,0x9b4d,0x0fbe,0x07ff,0x07be,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07df,0x07ff,0x4e5d,0xa2aa,0x0400,0x03e0,
    0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,
    0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,
    0x03e0,0x03c0,0x552a,0xe99d,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf03e,0xf81f,0xe93d,0x5dab,0x780f,0x8010,0x782f,0x780f,0x780f,0x780f,0x780f,
    0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,
    0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x800e,0x5c34,0xabaa,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf020,0xf800,0xf800,0x85cf,0x00df,0x001f,0x003e,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x5adb,0x9cc9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0000,0x6b4d,0xce79,
    0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xc638,0x94b2,0x9cd3,0xce79,0xdefb,0xce79,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xce79,0xe71c,0xce59,0x8c71,0x9cf3,0xce59,0xdedb,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf7be,
    0x9cd3,0x630c,0xffff,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffdf,0xffff,0xffff,0x6336,0xa503,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xf7a0,0xffe0,0xe783,0x42d7,0xfce0,0xfd80,0xf500,
    0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,
    0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,
    0xfd40,0xa52d,0x62f2,0xb880,0xa145,0xa165,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa165,0xa0e3,0xa8e3,0x9b4d,0x0fbe,0x07ff,0x07df,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x4e7d,0xa2aa,0x0420,0x0400,
    0x03e0,0x03e0,0x0400,0x0400,0x03e0,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x03e0,0x0400,
    0x0400,0x03e0,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x03e0,0x0400,0x0400,0x03e0,0x03e0,
    0x03e0,0x03e0,0x554a,0xe99d,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf83f,0xf81f,0xe91d,0x5dab,0x780f,0x8010,0x782f,0x8010,0x8010,0x8010,0x780f,
    0x8010,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x8010,0x780f,0x8010,0x8010,0x8010,
    0x780f,0x780f,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x8010,0x780f,0x780f,0x7810,0x880e,0x5c34,0xabaa,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf020,0xf800,0xf800,0x8dce,0x00df,0x001f,0x003e,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x5adc,0x9cc9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0000,0x6b4d,0xd69a,
    0xe71c,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xd69a,0xad75,0x7bcf,0xce59,0xe71c,0xce79,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce59,0xd6ba,
    0xce79,0xef5d,0xc638,0x6b6d,0xbdd7,0xdedb,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xf7be,
    0x9cd3,0x630c,0xffff,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffdf,0xffff,0xffff,0x6336,0xa503,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xf7a0,0xffe0,0xe783,0x42d7,0xfce0,0xfd80,0xf500,
    0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,
    0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,0xfd20,
    0xfd40,0xa52d,0x62f2,0xb880,0xa145,0xa165,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa165,0xa0e3,0xa8e3,0x9b4d,0x0fbe,0x07ff,0x07df,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x4e7d,0xa2aa,0x0420,0x0400,
    0x03e0,0x03e0,0x0400,0x0400,0x03e0,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x03e0,0x0400,
    0x0400,0x03e0,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x03e0,0x0400,0x0400,0x03e0,0x03e0,
    0x03e0,0x03e0,0x554a,0xe99d,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf83f,0xf81f,0xe91d,0x5dab,0x780f,0x8010,0x782f,0x8010,0x8010,0x8010,0x780f,
    0x8010,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x8010,0x780f,0x8010,0x8010,0x8010,
    0x780f,0x780f,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x8010,0x780f,0x780f,0x7810,0x880e,0x5c34,0xabaa,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf020,0xf800,0xf800,0x8dcf,0x00df,0x001f,0x003e,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x5adc,0x9cc9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0000,0x6b4d,0xd69a,
    0xe71c,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xc638,0x5aeb,0xbdf7,0xef5d,0xce79,
    0xd6ba,0xce59,0xf79e,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xdefb,0x5aeb,0xad75,0xef7d,0xce59,0xd69a,
    0xce79,0xe73c,0xbdd7,0x632c,0xce79,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xf7be,
    0x9cd3,0x630c,0xffff,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffdf,0xffff,0xffff,0x6336,0xa503,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xf7a0,0xffe0,0xe782,0x42b6,0xfce0,0xfd60,0xf4e0,
    0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,
    0xfd00,0xfd20,0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd00,0xfd20,0xfd20,0xfd00,0xfd00,0xfd00,0xfd20,
    0xfd40,0xa50d,0x62f2,0xb080,0xa125,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,0xa145,
    0xa145,0xa145,0xa145,0xa145,0xa165,0xa0e3,0xa8e3,0x9b2c,0x0fbe,0x07ff,0x07df,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07df,0x07ff,0x4e5d,0xa2aa,0x0400,0x03e0,
    0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,
    0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,
    0x03e0,0x03c0,0x552a,0xe99d,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf83f,0xf81f,0xe91d,0x5dab,0x780f,0x8010,0x782f,0x780f,0x780f,0x780f,0x780f,
    0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,
    0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x780f,0x800e,0x5c14,0xabaa,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf020,0xf800,0xf800,0x85ae,0x00bf,0x001f,0x003e,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x5adb,0x9cc9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6b4d,0xce79,
    0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xd69a,0x6b6d,0xad75,0xdedb,0xd69a,
    0xd69a,0xce59,0xef7d,0xad75,0x5aeb,0xdefb,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x7bef,0xc618,0xe71c,0xc638,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce79,0xce59,0xce79,0xce79,0xce59,
    0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce79,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,
    0xce59,0xce79,0xce59,0xce59,0xef7d,0x8430,0x738e,0xef5d,0xd69a,0xce59,0xce79,0xce79,0xce79,0xce59,0xce79,0xce59,
    0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce79,0xce59,0xce79,0xce79,0xce59,
    0xce59,0xce79,0xce79,0xce59,0xce79,0xce59,0xce79,0xce79,0xc638,0xdedb,0xdedb,0x5aeb,0xad55,0xef5d,0xc638,0xce79,
    0xce79,0xd69a,0xa534,0x73ae,0xce59,0xdefb,0xc638,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce79,0xce59,
    0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce79,0xce59,0xce79,0xce59,0xce79,0xce59,0xce79,0xc638,0xf79e,
    0x94b2,0x630c,0xffff,0xffdf,0xf79e,0xffdf,0xffdf,0xf7be,0xf7be,0xf7be,0xffdf,0xffdf,0xf7be,0xf7be,0xf7be,0xffdf,
    0xf7be,0xf7be,0xf7be,0xffdf,0xffdf,0xf7be,0xf7be,0xffdf,0xffdf,0xf7be,0xf7be,0xf7be,0xffdf,0xf7be,0xf7be,0xf7be,
    0xffdf,0xffdf,0xffdf,0xf79e,0xffdf,0xffff,0x6336,0x9ce3,0xffe0,0xf7a0,0xf7a0,0xf7a0,0xf7a0,0xffc0,0xffc0,0xf7a0,
    0xf7a0,0xf7a0,0xffc0,0xf7a0,0xf7a0,0xf7a0,0xffc0,0xffc0,0xf7a0,0xf7a0,0xffc0,0xffc0,0xf7a0,0xf7a0,0xf7a0,0xffc0,
    0xf7a0,0xf7a0,0xf7a0,0xffc0,0xffc0,0xf7a0,0xf7a0,0xffc0,0xffc0,0xf781,0xffe0,0xe743,0x42b7,0xf4e0,0xfd60,0xf4e1,
    0xfd00,0xfd00,0xf500,0xf500,0xf500,0xfd00,0xf500,0xf500,0xf500,0xfd00,0xfd00,0xf500,0xf500,0xfd00,0xfd00,0xf500,
    0xf500,0xf500,0xfd00,0xf500,0xf500,0xf500,0xfd00,0xfd00,0xf500,0xf500,0xf500,0xfd00,0xf500,0xf500,0xf500,0xfd00,
    0xfd20,0x9d0d,0x5af2,0xb0a1,0xa165,0x9986,0xa165,0xa165,0xa165,0xa165,0xa165,0xa165,0xa165,0xa165,0xa165,0xa165,
    0xa165,0xa165,0xa165,0xa165,0xa165,0xa165,0xa165,0xa165,0xa165,0xa165,0xa165,0xa165,0xa165,0xa165,0xa165,0xa165,
    0xa165,0xa165,0xa165,0xa165,0x9986,0xa104,0xa904,0x9b4d,0x179e,0x07ff,0x0f9e,0x07df,0x07be,0x07be,0x07be,0x07df,
    0x07df,0x07be,0x07be,0x07df,0x07df,0x07be,0x07be,0x07be,0x07df,0x07be,0x07be,0x07be,0x07df,0x07df,0x07be,0x07be,
    0x07be,0x07df,0x07be,0x07be,0x07be,0x07df,0x07df,0x07be,0x07be,0x07be,0x0fbe,0x07ff,0x4e3c,0xa2aa,0x0400,0x03e0,
    0x0be1,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,
    0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x03e0,0x0be1,
    0x03e0,0x03c0,0x552a,0xe19c,0xf81f,0xf05e,0xf03e,0xf03e,0xf03e,0xf83f,0xf83f,0xf03e,0xf03e,0xf03e,0xf83f,0xf03e,
    0xf03e,0xf03e,0xf83f,0xf83f,0xf03e,0xf03e,0xf03e,0xf83f,0xf03e,0xf03e,0xf03e,0xf83f,0xf83f,0xf03e,0xf03e,0xf83f,
    0xf83f,0xf03e,0xf03e,0xf03e,0xf83f,0xf05e,0xf81f,0xe13c,0x5dab,0x780f,0x8010,0x784f,0x782f,0x782f,0x782f,0x782f,
    0x782f,0x782f,0x782f,0x782f,0x782f,0x782f,0x782f,0x782f,0x782f,0x782f,0x782f,0x782f,0x782f,0x782f,0x782f,0x782f,
    0x782f,0x782f,0x782f,0x782f,0x782f,0x782f,0x782f,0x782f,0x782f,0x782f,0x784f,0x782f,0x800e,0x5c34,0xabaa,0xf800,
    0xf820,0xf020,0xf020,0xf020,0xf820,0xf020,0xf020,0xf020,0xf820,0xf820,0xf020,0xf020,0xf020,0xf820,0xf020,0xf020,
    0xf020,0xf820,0xf820,0xf020,0xf020,0xf820,0xf820,0xf020,0xf020,0xf020,0xf820,0xf020,0xf020,0xf020,0xf820,0xf820,
    0xf041,0xf800,0xf820,0x85ce,0x00ff,0x001f,0x085e,0x003f,0x003f,0x003e,0x003e,0x003f,0x003f,0x003e,0x003e,0x003e,
    0x003f,0x003e,0x003e,0x003e,0x003f,0x003f,0x003e,0x003e,0x003f,0x003f,0x003e,0x003e,0x003e,0x003f,0x003e,0x003e,
    0x003e,0x003f,0x003f,0x003e,0x003e,0x003e,0x003e,0x001f,0x5afb,0x9cc9,0x0000,0x0020,0x0841,0x0020,0x0020,0x0020,
    0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,
    0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,0x0841,0x0000,0x0000,0x6b4d,0xce79,
    0xdefb,0xce59,0xce79,0xce59,0xce79,0xce59,0xce79,0xce59,0xce79,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,
    0xce59,0xce79,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xd6ba,0xce79,0x8430,0x9cd3,0xc638,0xd6ba,
    0xce79,0xc638,0xef5d,0xad55,0x5aeb,0xdedb,0xdedb,0xc638,0xce79,0xce79,0xce59,0xce79,0xce59,0xce79,0xce79,0xce59,
    0xce59,0xce79,0xce79,0xce59,0xce79,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,
    0xce59,0xce79,0xce59,0xce79,0xce79,0xce79,0xce59,0xd69a,0xef5d,0x738e,0x8430,0xef7d,0xce59,0xce59,0xce79,0xce59,
    0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce79,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,
    0xce59,0xce79,0xce79,0xce59,0xce79,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xc638,0xdefb,0xce59,0x7bef,
    0x8410,0xce79,0xf79e,0xd6ba,0xdefb,0xdefb,0xdedb,0xdedb,0xdefb,0xdefb,0xdedb,0xdedb,0xdedb,0xdefb,0xdefb,0xdedb,
    0xdedb,0xdefb,0xdefb,0xdedb,0xdedb,0xdefb,0xdefb,0xdedb,0xdedb,0xdedb,0xdefb,0xdefb,0xdedb,0xdedb,0xdefb,0xdefb,
    0xdedb,0xdedb,0xdedb,0xdedb,0xffff,0x8c51,0x73ae,0xffdf,0xe71c,0xdedb,0xdedb,0xdefb,0xdefb,0xdedb,0xdedb,0xdedb,
    0xdefb,0xdefb,0xdedb,0xdedb,0xdefb,0xdefb,0xdedb,0xdedb,0xdefb,0xdefb,0xdedb,0xdedb,0xdedb,0xdefb,0xdefb,0xdedb,
    0xdedb,0xdefb,0xdefb,0xdedb,0xdedb,0xdedb,0xdefb,0xdedb,0xd6ba,0xef5d,0xe73c,0x630c,0xb596,0xffdf,0xd6ba,0xdefb,
    0xe73c,0xce59,0x9cd3,0x9cf3,0xdedb,0xe73c,0xd6ba,0xdefb,0xdefb,0xdedb,0xdedb,0xdefb,0xdefb,0xdedb,0xdedb,0xdedb,
    0xdefb,0xdefb,0xdedb,0xdedb,0xdefb,0xdefb,0xdedb,0xdedb,0xdedb,0xdefb,0xdedb,0xdedb,0xdedb,0xdefb,0xd6ba,0xffff,
    0x9cf3,0x630c,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x6337,0xa522,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xefc1,0x42d7,0xfce0,0xfda0,0xfd20,
    0xfd40,0xfd40,0xfd20,0xfd20,0xfd40,0xfd40,0xfd40,0xfd20,0xfd20,0xfd40,0xfd40,0xfd20,0xfd20,0xfd40,0xfd40,0xfd20,
    0xfd20,0xfd40,0xfd40,0xfd40,0xfd20,0xfd20,0xfd40,0xfd40,0xfd20,0xfd20,0xfd40,0xfd40,0xfd20,0xfd40,0xfd20,0xfd40,
    0xfd60,0xa52c,0x62d2,0xb840,0xa8e4,0xa104,0xa104,0xa904,0xa904,0xa904,0xa104,0xa104,0xa904,0xa904,0xa104,0xa104,
    0xa904,0xa904,0xa104,0xa904,0xa104,0xa904,0xa904,0xa104,0xa104,0xa904,0xa904,0xa104,0xa104,0xa904,0xa904,0xa104,
    0xa904,0xa104,0xa904,0xa904,0xa124,0xa8a2,0xb0a2,0x9b2c,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x46be,0xa2a9,0x0420,0x0400,
    0x03e0,0x03e0,0x0400,0x0400,0x03e0,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x03e0,0x0400,
    0x0400,0x03e0,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x03e0,0x0400,0x0400,0x03e0,0x03e0,
    0x03e0,0x03e0,0x4d49,0xf15e,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf0de,0x5dab,0x780f,0x8010,0x780f,0x8010,0x8010,0x8010,0x780f,
    0x8010,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x8010,0x780f,0x8010,0x8010,0x8010,
    0x780f,0x780f,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x8010,0x780f,0x780f,0x8010,0x880e,0x5415,0xb389,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf800,0xf800,0xf800,0x8dce,0x007f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x52bd,0x9cc8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x632c,0xd6ba,
    0xef5d,0xd6ba,0xdefb,0xdedb,0xdedb,0xdedb,0xdefb,0xdedb,0xdedb,0xdedb,0xdefb,0xdefb,0xdedb,0xdedb,0xdefb,0xdefb,
    0xdedb,0xdedb,0xdedb,0xdefb,0xdefb,0xdedb,0xdedb,0xdefb,0xdefb,0xdedb,0xe71c,0xdefb,0xad75,0x9492,0xc618,0xef5d,
    0xdefb,0xd6ba,0xffdf,0xb596,0x630c,0xe73c,0xef5d,0xd6ba,0xdedb,0xdefb,0xdedb,0xdedb,0xdedb,0xdefb,0xdefb,0xdedb,
    0xdedb,0xdefb,0xdefb,0xdedb,0xdedb,0xdedb,0xdefb,0xdefb,0xdedb,0xdedb,0xdefb,0xdefb,0xdedb,0xdedb,0xdefb,0xdefb,
    0xdedb,0xdedb,0xdedb,0xdefb,0xdefb,0xdedb,0xdedb,0xe71c,0xffdf,0x73ae,0x8c51,0xffff,0xdedb,0xdedb,0xdedb,0xdedb,
    0xdefb,0xdefb,0xdedb,0xdedb,0xdefb,0xdefb,0xdedb,0xdedb,0xdedb,0xdefb,0xdefb,0xdedb,0xdedb,0xdefb,0xdefb,0xdedb,
    0xdedb,0xdefb,0xdefb,0xdedb,0xdedb,0xdedb,0xdefb,0xdefb,0xdedb,0xdedb,0xdefb,0xdefb,0xd6ba,0xef7d,0xd6ba,0x8410,
    0x8410,0xd69a,0xffdf,0xdefb,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,
    0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,
    0xe73c,0xe73c,0xe73c,0xe73c,0xffff,0x94b2,0x8410,0xffff,0xef5d,0xe71c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,
    0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,
    0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xdefb,0xf7be,0xef5d,0x6b4d,0xbdd7,0xffff,0xdefb,0xe71c,
    0xf79e,0xc618,0x94b2,0xbdd7,0xe73c,0xef5d,0xe71c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,
    0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xdefb,0xffff,
    0xa534,0x6b6d,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x73b7,0xad62,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,
    0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xffe0,0xf7e0,0x5315,0xfd00,0xfda0,0xfd40,
    0xfd60,0xfd60,0xfd40,0xfd40,0xfd60,0xfd60,0xfd60,0xfd40,0xfd40,0xfd60,0xfd60,0xfd40,0xfd40,0xfd60,0xfd60,0xfd40,
    0xfd40,0xfd60,0xfd60,0xfd60,0xfd40,0xfd40,0xfd60,0xfd60,0xfd40,0xfd40,0xfd60,0xfd60,0xfd40,0xfd40,0xfd40,0xfd60,
    0xfd80,0xad2b,0x6ab0,0xb820,0xa8a2,0xa8c3,0xa8c3,0xa8c3,0xa8c3,0xa8c3,0xa8c3,0xa8c3,0xa8c3,0xa8c3,0xa8c3,0xa8c3,
    0xa8c3,0xa8c3,0xa8c3,0xa8c3,0xa8c3,0xa8c3,0xa8c3,0xa8c3,0xa8c3,0xa8c3,0xa8c3,0xa8c3,0xa8c3,0xa8c3,0xa8c3,0xa8c3,
    0xa8c3,0xa8c3,0xa8c3,0xa8c3,0xa8e3,0xa861,0xb082,0x9b4d,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,
    0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x07ff,0x3ede,0x92c9,0x0400,0x0400,
    0x03e0,0x03e0,0x0400,0x0400,0x03e0,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x03e0,0x0400,
    0x0400,0x03e0,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x0400,0x0400,0x0400,0x03e0,0x03e0,0x0400,0x0400,0x03e0,0x0400,
    0x03e0,0x03e0,0x4d29,0xf13e,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,
    0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf81f,0xf8bf,0x654c,0x780f,0x8010,0x780f,0x8010,0x8010,0x8010,0x780f,
    0x8010,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x8010,0x780f,0x8010,0x8010,0x8010,
    0x780f,0x780f,0x8010,0x8010,0x780f,0x780f,0x8010,0x8010,0x8010,0x780f,0x780f,0x8010,0x880e,0x5bb4,0xbb48,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
    0xf800,0xf800,0xf800,0x8d4f,0x005f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,
    0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x4a7d,0x8c48,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x632c,0xdedb,
    0xf79e,0xe71c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,
    0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe71c,0xef5d,0xef5d,0xce79,0x8c51,0xb5b6,0xffdf,
    0xe71c,0xdefb,0xffff,0xbdd7,0x6b4d,0xef5d,0xf7be,0xdefb,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,
    0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,
    0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe71c,0xef5d,0xffff,0x8410,0x94b2,0xffff,0xe73c,0xe73c,0xe73c,0xe73c,
    0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,
    0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xe73c,0xdefb,0xf7be,0xdedb,0x8410,
    0x8410,0x6b6d,0x630c,0x5aeb,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,
    0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,
    0x630c,0x630c,0x630c,0x630c,0x6b4d,0x6b4d,0x6b6d,0x6b6d,0x630c,0x5aeb,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,
    0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,
    0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x5aeb,0x630c,0x6b6d,0x6b6d,0x6b6d,0x632c,0x630c,0x630c,
    0x632c,0x6b6d,0x738e,0x632c,0x632c,0x630c,0x5aeb,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,
    0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x5aeb,0x632c,
    0x6b4d,0x7bcf,0xad55,0xa534,0xa514,0xa534,0xa534,0xa534,0xa514,0xa514,0xa534,0xa534,0xa514,0xa514,0xa534,0xa534,
    0xa534,0xa514,0xa534,0xa534,0xa534,0xa514,0xa514,0xa534,0xa534,0xa514,0xa514,0xa534,0xa534,0xa534,0xa514,0xa514,
    0xa534,0xa534,0xa514,0xa514,0xa534,0xad54,0x7bf1,0x8c51,0xad54,0xa515,0xa515,0xa515,0xa515,0xa535,0xa535,0xa515,
    0xa515,0xa535,0xa535,0xa535,0xa515,0xa535,0xa535,0xa535,0xa515,0xa515,0xa535,0xa535,0xa535,0xa515,0xa535,0xa535,
    0xa535,0xa515,0xa515,0xa535,0xa535,0xa515,0xa515,0xa535,0xa535,0xa515,0xa534,0x9cf3,0x73b3,0x83ef,0x7bf0,0x7bf0,
    0x7bf0,0x7bf0,0x7bf0,0x7bf0,0x7bf0,0x7bf0,0x7bf0,0x7bf0,0x7bf0,0x7bf0,0x7bf0,0x7bf0,0x7bf0,0x7bf0,0x7bf0,0x7bf0,
    0x7bf0,0x7bf0,0x7bf0,0x7bf0,0x7bf0,0x7bf0,0x7bf0,0x7bf0,0x7bf0,0x7bf0,0x7bf0,0x7bf0,0x7bf0,0x7bf0,0x7bf0,0x7bf0,
    0x83ef,0x7c10,0x73f1,0x83ef,0x7c10,0x7c10,0x7c10,0x7c30,0x7c10,0x7c30,0x7c10,0x7c10,0x7c30,0x7c30,0x7c10,0x7c10,
    0x7c30,0x7c10,0x7c30,0x7c10,0x7c30,0x7c10,0x7c30,0x7c10,0x7c10,0x7c30,0x7c30,0x7c10,0x7c10,0x7c30,0x7c10,0x7c30,
    0x7c10,0x7c30,0x7c10,0x7c10,0x7c10,0x7c10,0x83ef,0x83cf,0x73cf,0x736d,0x7b6d,0x736d,0x736d,0x736d,0x736d,0x736d,
    0x736d,0x736d,0x736d,0x736d,0x736d,0x736d,0x736d,0x736d,0x736d,0x736d,0x736d,0x736d,0x736d,0x736d,0x736d,0x736d,
    0x736d,0x736d,0x736d,0x736d,0x736d,0x736d,0x736d,0x736d,0x736d,0x736d,0x736d,0x6b8e,0x7baf,0x8b8f,0x6bae,0x738e,
    0x738e,0x738e,0x738e,0x738e,0x738e,0x738e,0x738e,0x738e,0x738e,0x738e,0x738e,0x738e,0x738e,0x738e,0x738e,0x738e,
    0x738e,0x738e,0x738e,0x738e,0x738e,0x738e,0x738e,0x738e,0x738e,0x738e,0x738e,0x738e,0x738e,0x738e,0x738e,0x738e,
    0x738e,0x738e,0x7c2f,0x738e,0x630c,0x634c,0x634c,0x5b4b,0x5b4b,0x634c,0x634c,0x634c,0x5b4b,0x634c,0x634c,0x634c,
    0x5b4b,0x5b4b,0x634c,0x634c,0x5b4b,0x5b4b,0x634c,0x634c,0x634c,0x5b4b,0x634c,0x634c,0x634c,0x5b4b,0x5b4b,0x634c,
    0x634c,0x5b4b,0x5b4b,0x634c,0x634c,0x5b4b,0x630c,0x736e,0x6c4d,0x6b2d,0x632c,0x634c,0x634c,0x634c,0x634c,0x634c,
    0x634c,0x634c,0x634c,0x634c,0x634c,0x634c,0x634c,0x634c,0x634c,0x634c,0x634c,0x634c,0x634c,0x634c,0x634c,0x634c,
    0x634c,0x634c,0x634c,0x634c,0x634c,0x634c,0x634c,0x634c,0x634c,0x634c,0x634c,0x634c,0x6b0c,0x6c0f,0x6bce,0x5aab,
    0x52eb,0x52eb,0x52cb,0x52eb,0x52eb,0x52eb,0x52cb,0x52cb,0x52eb,0x52eb,0x52cb,0x52cb,0x52eb,0x52eb,0x52eb,0x52cb,
    0x52eb,0x52eb,0x52eb,0x52cb,0x52cb,0x52eb,0x52eb,0x52cb,0x52cb,0x52eb,0x52eb,0x52eb,0x52cb,0x52cb,0x52eb,0x52eb,
    0x52eb,0x52cb,0x62eb,0x744e,0x632d,0x5aca,0x5aea,0x5aea,0x5aea,0x5aca,0x5aca,0x5aea,0x5aea,0x5aca,0x5aca,0x5aea,
    0x5aea,0x5aea,0x5aca,0x5aea,0x5aea,0x5aea,0x5aca,0x5aca,0x5aea,0x5aea,0x5aea,0x5aca,0x5aea,0x5aea,0x5aea,0x5aca,
    0x5aca,0x5aea,0x5aea,0x5aca,0x5aca,0x5aea,0x5aea,0x5acb,0x738e,0x840e,0x52ab,0x5aeb,0x5acb,0x5acb,0x5aeb,0x5aeb,
    0x5acb,0x5acb,0x5aeb,0x5aeb,0x5aeb,0x5acb,0x5acb,0x5aeb,0x5aeb,0x5acb,0x5acb,0x5aeb,0x5aeb,0x5aeb,0x5acb,0x5aeb,
    0x5aeb,0x5aeb,0x5acb,0x5acb,0x5aeb,0x5aeb,0x5acb,0x5acb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5aeb,0x5acb,0x73ae,0x738e,
    0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,
    0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x5aeb,0x630c,0x630c,0x6b4d,0x6b6d,0x6b6d,0x6b4d,
    0x630c,0x630c,0x632c,0x6b6d,0x6b6d,0x6b6d,0x630c,0x5aeb,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,
    0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,
    0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x5aeb,0x630c,0x6b6d,0x6b6d,0x6b4d,0x6b4d,0x630c,0x630c,0x630c,0x630c,
    0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,
    0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x630c,0x5aeb,0x630c,0x6b6d,0x8410,
    0x7bef,0xa514,0xb596,0xa514,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,
    0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,
    0xa534,0xa534,0xa534,0xa534,0xbdd7,0x8410,0x73ae,0xb5b6,0xad55,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,
    0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,
    0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xad55,0xa514,0xad75,0xad75,0x6b6d,0x94b2,0xb5b6,0xa534,0xa534,
    0xb5b6,0x8410,0x738e,0xbdd7,0xad75,0xa514,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,
    0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xad75,
    0xad55,0x6b6d,0x0000,0x0841,0x0861,0x0841,0x0841,0x0841,0x0841,0x0841,0x0841,0x0841,0x0841,0x0841,0x0841,0x0841,
    0x0841,0x0841,0x0841,0x0841,0x0841,0x0841,0x0841,0x0841,0x0841,0x0841,0x0841,0x0841,0x0841,0x0841,0x0841,0x0841,
    0x0841,0x0841,0x0841,0x0861,0x0841,0x0000,0x8430,0x52ae,0x0005,0x0847,0x0847,0x0847,0x0847,0x0847,0x0847,0x0847,
    0x0847,0x0847,0x0847,0x0847,0x0847,0x0847,0x0847,0x0847,0x0847,0x0847,0x0847,0x0847,0x0847,0x0847,0x0847,0x0847,
    0x0847,0x0847,0x0847,0x0847,0x0847,0x0847,0x0847,0x0847,0x0847,0x0867,0x0026,0x18c8,0x8c92,0x73f3,0x6392,0x63b2,
    0x63d3,0x63d3,0x63b2,0x63b2,0x63d3,0x63d3,0x63d3,0x63b2,0x63b2,0x63d3,0x63d3,0x63b2,0x63b2,0x63d3,0x63d3,0x63d3,
    0x63b2,0x63d3,0x63d3,0x63d3,0x63b2,0x63b2,0x63d3,0x63d3,0x63b2,0x63b2,0x63d3,0x63d3,0x63d3,0x63b2,0x63d3,0x63d3,
    0x63d2,0x73d0,0x7c10,0x7492,0x7c92,0x7471,0x7471,0x7c92,0x7c71,0x7c92,0x7471,0x7471,0x7c92,0x7c92,0x7471,0x7471,
    0x7c92,0x7c71,0x7c92,0x7471,0x7c92,0x7c71,0x7c92,0x7471,0x7471,0x7c92,0x7c92,0x7471,0x7471,0x7c92,0x7c71,0x7c92,
    0x7471,0x7c92,0x7c71,0x7c92,0x7471,0x7492,0x7471,0x73cf,0xa410,0xbc30,0xb3ef,0xb410,0xb410,0xb410,0xb410,0xb410,
    0xb410,0xb410,0xb410,0xb410,0xb410,0xb410,0xb410,0xb410,0xb410,0xb410,0xb410,0xb410,0xb410,0xb410,0xb410,0xb410,
    0xb410,0xb410,0xb410,0xb410,0xb410,0xb410,0xb410,0xb410,0xb410,0xb410,0xb410,0xbc51,0x93cf,0x7bd0,0xbd17,0xb4f6,
    0xb4d6,0xb4d6,0xb4f6,0xb4f6,0xb4d6,0xb4d6,0xb4f6,0xb4d6,0xb4d6,0xb4d6,0xb4d6,0xb4d6,0xb4f6,0xb4d6,0xb4d6,0xb4f6,
    0xb4f6,0xb4d6,0xb4d6,0xb4f6,0xb4d6,0xb4d6,0xb4d6,0xb4d6,0xb4d6,0xb4f6,0xb4d6,0xb4d6,0xb4f6,0xb4f6,0xb4d6,0xb4d6,
    0xb4f6,0xbd17,0x736e,0x8d31,0xaf15,0x9e73,0x9e93,0x9e93,0x9e93,0x9e93,0x9e93,0x9e93,0x9e93,0x9e93,0x9e93,0x9e93,
    0x9e93,0x9e93,0x9e93,0x9e93,0x9e93,0x9e93,0x9e93,0x9e93,0x9e93,0x9e93,0x9e93,0x9e93,0x9e93,0x9e93,0x9e93,0x9e93,
    0x9e93,0x9e93,0x9e93,0x9e93,0x9e93,0x9e73,0xb716,0x95b2,0x6b6d,0xbe77,0xc6f8,0xb656,0xbe97,0xbe97,0xbe97,0xb696,
    0xbe97,0xbe97,0xbe97,0xb696,0xb696,0xbe97,0xbe97,0xb696,0xb696,0xbe97,0xbe97,0xbe97,0xb696,0xbe97,0xbe97,0xbe97,
    0xb696,0xb696,0xbe97,0xbe97,0xb696,0xb696,0xbe97,0xbe97,0xbe97,0xb696,0xb676,0xbe97,0xcf39,0x7bce,0x84d3,0xd7ff,
    0xc7be,0xc79e,0xc79e,0xc79e,0xc7be,0xc79e,0xc79e,0xc79e,0xc7be,0xc7be,0xc79e,0xc79e,0xc79e,0xc7be,0xc79e,0xc79e,
    0xc79e,0xc7be,0xc7be,0xc79e,0xc79e,0xc7be,0xc7be,0xc79e,0xc79e,0xc79e,0xc7be,0xc79e,0xc79e,0xc79e,0xc7be,0xc7be,
    0xbf7d,0xc7be,0xbf5d,0x5b0c,0xdeb6,0xffb8,0xef77,0xf7b8,0xf7b8,0xf798,0xf798,0xf7b8,0xf7b8,0xf798,0xf798,0xf798,
    0xf7b8,0xf798,0xf798,0xf798,0xf7b8,0xf7b8,0xf798,0xf798,0xf7b8,0xf7b8,0xf798,0xf798,0xf798,0xf7b8,0xf798,0xf798,
    0xf798,0xf7b8,0xf7b8,0xf798,0xf798,0xf798,0xf798,0xfff9,0xa531,0x7bcf,0xffff,0xf7be,0xef7d,0xf79e,0xf7be,0xf7be,
    0xf79e,0xf79e,0xf79e,0xf7be,0xf79e,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf79e,
    0xf7be,0xf79e,0xf79e,0xf79e,0xf7be,0xf7be,0xf79e,0xf79e,0xf79e,0xf7be,0xf79e,0xef7d,0xf7be,0xffff,0x73ae,0x8430,
    0xbdf7,0xa514,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,
    0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xad55,0xbdd7,0x7bcf,0x8410,0xad75,
    0xad55,0xa534,0xb5b6,0x94b2,0x6b6d,0xad75,0xad75,0xa514,0xad55,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,
    0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,
    0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xad55,0xb5b6,0x73ae,0x8410,0xbdd7,0xa534,0xa534,0xa534,0xa534,
    0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,
    0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa514,0xb596,0xa534,0x7bef,
    0x7bef,0xdefb,0xffff,0xef5d,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xef7d,0xffff,0x94b2,0x7bcf,0xffff,0xf7be,0xef7d,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xef5d,0xffff,0xf7be,0x632c,0xbdf7,0xffff,0xef5d,0xf79e,
    0xffff,0x9cf3,0x8430,0xffff,0xf7be,0xef5d,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xef7d,0xffff,
    0xe73c,0x630c,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9492,0x4a68,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9cf3,0x8c50,0x83cd,0x840e,
    0x8c0e,0x8c0e,0x83ee,0x83ee,0x8c0e,0x8c0e,0x8c0e,0x83ee,0x83ee,0x8c0e,0x8c0e,0x83ee,0x83ee,0x8c0e,0x8c0e,0x8c0e,
    0x83ee,0x8c0e,0x8c0e,0x8c0e,0x83ee,0x83ee,0x8c0e,0x8c0e,0x83ee,0x83ee,0x8c0e,0x8c0e,0x8c0e,0x83ee,0x8c0e,0x8c0e,
    0x8c0e,0x83ef,0x7bcf,0x83cf,0x83cf,0x7bae,0x7bae,0x83cf,0x83cf,0x83cf,0x7bae,0x7bae,0x83cf,0x83cf,0x7bae,0x7bae,
    0x83cf,0x83cf,0x83cf,0x7bae,0x83cf,0x83cf,0x83cf,0x7bae,0x7bae,0x83cf,0x83cf,0x7bae,0x7bae,0x83cf,0x83cf,0x83cf,
    0x7bae,0x83cf,0x83cf,0x83cf,0x7bae,0x83cf,0x83cf,0x738e,0xa596,0xb659,0xa5d7,0xadf7,0xadf7,0xadf7,0xadf7,0xadf7,
    0xadf7,0xadf7,0xadf7,0xadf7,0xadf7,0xadf7,0xadf7,0xadf7,0xadf7,0xadf7,0xadf7,0xadf7,0xadf7,0xadf7,0xadf7,0xadf7,
    0xadf7,0xadf7,0xadf7,0xadf7,0xadf7,0xadf7,0xadf7,0xadf7,0xadf7,0xadf7,0xa5d7,0xbe79,0x8cd3,0x738e,0xb5f6,0xadd5,
    0xa594,0xad95,0xadb5,0xadb5,0xad95,0xad95,0xadb5,0xadb5,0xad95,0xad95,0xad95,0xadb5,0xadb5,0xad95,0xad95,0xadb5,
    0xadb5,0xad95,0xad95,0xadb5,0xadb5,0xad95,0xad95,0xad95,0xadb5,0xadb5,0xad95,0xad95,0xadb5,0xadb5,0xad95,0xa594,
    0xadd5,0xb5f6,0x634c,0xbd77,0xffff,0xeefd,0xf71e,0xf71e,0xf71e,0xf71e,0xf71e,0xf71e,0xf71e,0xf71e,0xf71e,0xf71e,
    0xf71e,0xf71e,0xf71e,0xf71e,0xf71e,0xf71e,0xf71e,0xf71e,0xf71e,0xf71e,0xf71e,0xf71e,0xf71e,0xf71e,0xf71e,0xf71e,
    0xf71e,0xf71e,0xf71e,0xf71e,0xf71e,0xeedd,0xffff,0xcdf9,0x5aeb,0xef1d,0xffbf,0xe6dc,0xef1d,0xef1d,0xef1d,0xef1d,
    0xef1d,0xef1d,0xef1d,0xef1d,0xef1d,0xef1d,0xef1d,0xef1d,0xef1d,0xef1d,0xef1d,0xef1d,0xef1d,0xef1d,0xef1d,0xef1d,
    0xef1d,0xef1d,0xef1d,0xef1d,0xef1d,0xef1d,0xef1d,0xef1d,0xef1d,0xef1d,0xeefd,0xef1d,0xffff,0x736e,0xa4f3,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0x4a49,0xffdf,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xad77,0x6b6d,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x632c,0xad55,
    0xffff,0xef5d,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xef7d,0xf7be,0xffff,0x94b2,0x9cf3,0xef7d,
    0xf7be,0xef5d,0xffff,0xbdf7,0x632c,0xf7be,0xffff,0xef5d,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xef7d,0xf7be,0xffff,0x7bcf,0x94b2,0xffff,0xef7d,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,
    0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xf79e,0xef5d,0xffff,0xe73c,0x7bef,
    0x8410,0xc618,0xe71c,0xc638,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xef7d,0x8430,0x738e,0xe73c,0xce79,0xc638,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xc638,0xdedb,0xdedb,0x5aeb,0xad55,0xef5d,0xc638,0xd69a,
    0xbdf7,0x8c71,0x94b2,0xdefb,0xd69a,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xc638,0xdedb,
    0xce59,0x6b4d,0x0000,0x0000,0x0841,0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,
    0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,
    0x0020,0x0020,0x0020,0x0841,0x0020,0x0000,0x9cd3,0x5aeb,0x0000,0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,
    0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,
    0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,0x0841,0x0000,0x0861,0xa514,0x8431,0x7bcf,0x7bf0,
    0x7c10,0x7c10,0x7bef,0x7bef,0x7c10,0x7c10,0x7c10,0x7bef,0x7bef,0x7c10,0x7c10,0x7bef,0x7bef,0x7c10,0x7c10,0x7c10,
    0x7bef,0x7c10,0x7c10,0x7c10,0x7bef,0x7bef,0x7c10,0x7c10,0x7bef,0x7bef,0x7c10,0x7c10,0x7c10,0x7bef,0x7c10,0x7c10,
    0x7c10,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,
    0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,
    0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x7bef,0x73ae,0x9cf3,0xb575,0xa514,0xad34,0xa534,0xa514,0xa514,0xa534,
    0xa534,0xa514,0xa514,0xa534,0xa534,0xa514,0xa534,0xa514,0xa534,0xa534,0xa514,0xa514,0xa534,0xa534,0xa514,0xa514,
    0xa534,0xa534,0xa514,0xa534,0xa514,0xa534,0xa534,0xa514,0xa514,0xad34,0xa514,0xb596,0x8c51,0x738e,0xb596,0xad55,
    0xa514,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,
    0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa534,0xa514,
    0xad55,0xb596,0x632c,0xa514,0xe75c,0xc658,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,0xce79,0xce79,
    0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,
    0xce79,0xce59,0xce59,0xce59,0xce79,0xc638,0xe75c,0xb596,0x5aeb,0xd69a,0xdefb,0xc638,0xce79,0xce79,0xce59,0xce59,
    0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,0xce79,0xce79,
    0xce59,0xce59,0xce79,0xce79,0xce59,0xce59,0xce59,0xce79,0xce59,0xce79,0xce59,0xce79,0xef7d,0x6b4d,0x9492,0xffff,
    0xffdf,0xf7be,0xf7be,0xf7be,0xffdf,0xf7be,0xf7be,0xf7be,0xffdf,0xffdf,0xf7be,0xf7be,0xf7be,0xffdf,0xf7be,0xf7be,
    0xf7be,0xffdf,0xffdf,0xf7be,0xf7be,0xffdf,0xffdf,0xf7be,0xf7be,0xf7be,0xffdf,0xf7be,0xf7be,0xf7be,0xffdf,0xffdf,
    0xf79e,0xffff,0xffdf,0x4228,0xe71c,0xffff,0xf79e,0xffdf,0xffdf,0xf7be,0xf7be,0xffdf,0xffdf,0xf7be,0xf7be,0xf7be,
    0xffdf,0xf7be,0xf7be,0xf7be,0xffdf,0xffdf,0xf7be,0xf7be,0xffdf,0xffdf,0xf7be,0xf7be,0xf7be,0xffdf,0xf7be,0xf7be,
    0xf7be,0xffdf,0xffdf,0xf7be,0xf7be,0xf7be,0xf7be,0xffff,0x9cf3,0x630c,0xffff,0xffdf,0xf79e,0xf7be,0xffdf,0xffdf,
    0xf7be,0xf7be,0xf7be,0xffdf,0xf7be,0xf7be,0xf7be,0xffdf,0xffdf,0xf7be,0xf7be,0xffdf,0xffdf,0xf7be,0xf7be,0xf7be,
    0xffdf,0xf7be,0xf7be,0xf7be,0xffdf,0xffdf,0xf7be,0xf7be,0xf7be,0xffdf,0xf7be,0xf79e,0xffdf,0xffff,0x5aeb,0x94b2,
    0xef7d,0xc638,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xc638,0xce79,0xd6ba,0xa534,0x8c71,0xad75,
    0xd6ba,0xc638,0xe73c,0xad55,0x5aeb,0xdedb,0xdedb,0xc638,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xc638,0xce79,0xe73c,0x738e,0x8430,0xef7d,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,
    0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xce59,0xc638,0xdefb,0xce59,0x8410,
    0x8410,0xce59,0xef5d,0xce79,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,
    0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xdedb,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,
    0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xef7d,0xce79,0xdefb,
    0xad75,0x9492,0xb596,0xdefb,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe71c,
    0xd69a,0x6b4d,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9cd3,0x5acb,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0841,0xa514,0x8c51,0x7bcf,0x7bef,
    0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,
    0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,
    0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,
    0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,
    0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x7bef,0x73ae,0xa514,0xb5b6,0xa534,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xa534,0xbdd7,0x8c71,0x738e,0xb5b6,0xad75,
    0xa534,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xa534,
    0xad75,0xb5b6,0x632c,0xa534,0xf79e,0xce79,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,
    0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xef7d,0xb5b6,0x5aeb,0xdedb,0xe73c,0xce59,0xd6ba,0xd6ba,0xd69a,0xd69a,
    0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,
    0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xf7be,0x6b6d,0x94b2,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffdf,0xffff,0xffff,0x4228,0xe73c,0xffff,0xffdf,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xa514,0x632c,0xffff,0xffff,0xffdf,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffdf,0xffff,0xffff,0x630c,0x9cd3,
    0xf7be,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xdedb,0xc618,0x9492,0x9cf3,
    0xe73c,0xd69a,0xef7d,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,
    0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,
    0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xdedb,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,
    0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd6ba,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x8410,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x630c,0xad75,0xef7d,0xce79,0xe71c,
    0x9492,0x9492,0xce59,0xdedb,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,
    0xce79,0x6b4d,0x0000,0x0000,0x0020,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9cd3,0x5acb,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0841,0xa514,0x8c51,0x7bcf,0x7bef,
    0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,
    0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,
    0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,
    0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,
    0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x7bef,0x73ae,0xa514,0xb596,0xa534,0xad55,0xa534,0xad55,0xad55,0xa534,
    0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,
    0xa534,0xa534,0xad55,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xad55,0xa534,0xb5b6,0x8c71,0x738e,0xb596,0xad55,
    0xa534,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,
    0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xa534,
    0xad55,0xb596,0x632c,0xa534,0xef7d,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x6b6d,0x94b2,0xffff,
    0xffff,0xffdf,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xf7be,0xffff,0xffff,0x4228,0xe73c,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xa514,0x632c,0xffff,0xffff,0xf7be,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xf7be,0xffff,0xffff,0x630c,0x9cd3,
    0xf7be,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xd69a,0xdedb,0x8c71,0x8410,
    0xef5d,0xd69a,0xef7d,0xad75,0x630c,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x8410,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xdefb,0x5aeb,0xad75,0xef7d,0xd69a,0xe73c,
    0x7bcf,0x8c71,0xe71c,0xd69a,0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,
    0xce79,0x6b4d,0x0000,0x0000,0x0020,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9cd3,0x5acb,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0841,0x9cf3,0x8430,0x7bcf,0x7bef,
    0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,
    0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,
    0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,
    0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,
    0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x738e,0xa514,0xb596,0xa514,0xad55,0xad55,0xa534,0xa534,0xad55,
    0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,
    0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xa534,0xb5b6,0x8c71,0x738e,0xb596,0xad55,
    0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,
    0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,
    0xad55,0xb596,0x632c,0xa534,0xef7d,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x6b4d,0x9492,0xffff,
    0xffff,0xffdf,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xf7be,0xffff,0xffff,0x4228,0xe73c,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xa514,0x632c,0xffff,0xffff,0xf7be,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xf7be,0xffff,0xffff,0x630c,0x9cd3,
    0xf7be,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xef5d,0x9492,0x738e,
    0xe73c,0xce79,0xef7d,0xad75,0x5aeb,0xdefb,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x5aeb,0xad75,0xef7d,0xd69a,0xe71c,
    0x738e,0x94b2,0xef7d,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,
    0xce79,0x6b4d,0x0000,0x0000,0x0020,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9cd3,0x5acb,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0841,0x9cf3,0x8430,0x7bcf,0x7bef,
    0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,
    0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,
    0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,
    0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,
    0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x738e,0xa514,0xb596,0xa514,0xad55,0xad55,0xa534,0xa534,0xad55,
    0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,
    0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xa534,0xb5b6,0x8c71,0x738e,0xb596,0xad55,
    0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,
    0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,
    0xad55,0xb596,0x632c,0xa534,0xef7d,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x6b4d,0x9492,0xffff,
    0xffff,0xffdf,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xf7be,0xffff,0xffff,0x4228,0xe73c,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xa514,0x630c,0xffff,0xffff,0xf7be,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xf7be,0xffff,0xffff,0x630c,0x9cd3,
    0xf7be,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xef7d,0xa514,0x7bcf,
    0xd69a,0xce79,0xf79e,0xad75,0x5aeb,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf79e,0xce79,0xce79,
    0x7bef,0xa534,0xef7d,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe71c,
    0xd69a,0x6b4d,0x0000,0x0000,0x0020,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9cd3,0x5acb,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0841,0xa514,0x8c51,0x7bcf,0x7bef,
    0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,
    0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,
    0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,
    0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,
    0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x7bef,0x73ae,0xa514,0xb596,0xa534,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xa534,0xbdd7,0x8c71,0x738e,0xb5b6,0xad75,
    0xa534,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xa534,
    0xad75,0xb5b6,0x632c,0xa534,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf7be,0x6b6d,0x94b2,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xf7be,0xffff,0xffff,0x4228,0xe73c,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xa514,0x632c,0xffff,0xffff,0xffdf,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xf7be,0xffff,0xffff,0x630c,0x9cd3,
    0xf7be,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xe73c,0xb596,0x8c51,
    0xbdd7,0xce79,0xf7be,0xad75,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xad75,0xf7be,0xce79,0xb5b6,
    0x8430,0xb596,0xe73c,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe71c,
    0xd69a,0x6b4d,0x0000,0x0000,0x0020,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9cd3,0x5acb,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0841,0xa514,0x8c51,0x7bcf,0x7bef,
    0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,
    0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,
    0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,
    0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,
    0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x7bef,0x73ae,0xa514,0xb596,0xa534,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xa534,0xbdd7,0x8c71,0x738e,0xb5b6,0xad75,
    0xa534,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xa534,
    0xad75,0xb5b6,0x632c,0xa534,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf7be,0x6b6d,0x94b2,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xf7be,0xffff,0xffff,0x4228,0xe73c,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xa514,0x632c,0xffff,0xffff,0xffdf,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xf7be,0xffff,0xffff,0x630c,0x9cd3,
    0xf7be,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xe71c,0xbdd7,0x9492,
    0xa534,0xce79,0xffdf,0xad55,0x630c,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x5aeb,0xad55,0xf7be,0xce79,0xa514,
    0x94b2,0xbdf7,0xdefb,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,
    0xce79,0x6b4d,0x0000,0x0000,0x0020,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9cd3,0x5acb,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0841,0x9cf3,0x8430,0x7bcf,0x7bef,
    0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,
    0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,
    0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,
    0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,
    0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x738e,0xa514,0xb596,0xa514,0xad55,0xad55,0xa534,0xa534,0xad55,
    0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,
    0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xa534,0xb5b6,0x8c71,0x738e,0xb596,0xad55,
    0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,
    0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,
    0xad55,0xb596,0x632c,0xa534,0xef7d,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x6b4d,0x9492,0xffff,
    0xffff,0xffdf,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xf7be,0xffff,0xffff,0x4228,0xe73c,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xa514,0x630c,0xffff,0xffff,0xf7be,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xf7be,0xffff,0xffff,0x630c,0x9cd3,
    0xf7be,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xdedb,0xce59,0x9cf3,
    0x9492,0xce59,0xffdf,0xad55,0x5aeb,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xdefb,0x5aeb,0xa534,0xffdf,0xce59,0x9492,
    0x9cf3,0xce59,0xdedb,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,
    0xce79,0x6b4d,0x0000,0x0000,0x0020,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9cd3,0x5acb,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0841,0x9cf3,0x8430,0x7bcf,0x7bef,
    0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,
    0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,
    0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,
    0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,
    0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x738e,0xa514,0xb596,0xa514,0xad55,0xad55,0xa534,0xa534,0xad55,
    0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,
    0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xa534,0xb5b6,0x8c71,0x738e,0xb596,0xad55,
    0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,
    0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,
    0xad55,0xb596,0x632c,0xa534,0xef7d,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x6b4d,0x9492,0xffff,
    0xffff,0xffdf,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xf7be,0xffff,0xffff,0x4228,0xe73c,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xa514,0x632c,0xffff,0xffff,0xf7be,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xf7be,0xffff,0xffff,0x630c,0x9cd3,
    0xf7be,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xad55,
    0x7bef,0xce59,0xffff,0xa534,0x5aeb,0xdefb,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x8410,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x630c,0xa534,0xffff,0xce79,0x7bcf,
    0xa534,0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,
    0xce79,0x6b4d,0x0000,0x0000,0x0020,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9cd3,0x5acb,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0841,0xa514,0x8c51,0x7bcf,0x7bef,
    0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,
    0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,
    0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,
    0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,
    0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x7bef,0x73ae,0xa514,0xb596,0xa514,0xad55,0xad55,0xa534,0xa534,0xad55,
    0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,
    0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xa534,0xb5b6,0x8c71,0x738e,0xb596,0xad55,
    0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,
    0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,
    0xad55,0xb596,0x632c,0xa534,0xef7d,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x6b6d,0x9492,0xffff,
    0xffff,0xffdf,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xf7be,0xffff,0xffff,0x4228,0xe73c,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xa514,0x632c,0xffff,0xffff,0xf7be,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xf7be,0xffff,0xffff,0x630c,0x9cd3,
    0xf7be,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xb596,
    0x6b4d,0xce59,0xffff,0xa534,0x5aeb,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x8410,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x630c,0xa534,0xffff,0xce59,0x632c,
    0xb5b6,0xe73c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe71c,
    0xd69a,0x6b4d,0x0000,0x0000,0x0020,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9cd3,0x5acb,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0841,0xa514,0x8c51,0x7bcf,0x7bef,
    0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,
    0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,
    0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,
    0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,
    0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x7bef,0x73ae,0xa514,0xb596,0xa534,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xa534,0xbdd7,0x8c71,0x738e,0xb5b6,0xad75,
    0xa534,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xa534,
    0xad75,0xb5b6,0x632c,0xa534,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf7be,0x6b6d,0x94b2,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xf7be,0xffff,0xffff,0x4228,0xe73c,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xa514,0x632c,0xffff,0xffff,0xffdf,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xf7be,0xffff,0xffff,0x630c,0x9cd3,
    0xf7be,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xef5d,0xbdf7,
    0x5aeb,0xc618,0xffff,0xad55,0x5aeb,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x5aeb,0xa534,0xffff,0xc618,0x630c,
    0xc618,0xef5d,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe71c,
    0xd69a,0x6b4d,0x0000,0x0000,0x0020,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9cd3,0x5acb,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0841,0xa514,0x8c51,0x7bcf,0x7bef,
    0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,
    0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,
    0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,
    0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,
    0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x7bef,0x73ae,0xa514,0xb596,0xa534,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xa534,0xbdd7,0x8c71,0x738e,0xb5b6,0xad75,
    0xa534,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xa534,
    0xad75,0xb5b6,0x632c,0xa534,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf7be,0x6b6d,0x94b2,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xf7be,0xffff,0xffff,0x4228,0xe73c,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xa514,0x632c,0xffff,0xffff,0xffdf,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xf7be,0xffff,0xffff,0x630c,0x9cd3,
    0xf7be,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xc638,
    0x6b6d,0xb5b6,0xffdf,0xad75,0x5aeb,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x5aeb,0xad75,0xf7be,0xb596,0x6b6d,
    0xc618,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,
    0xce79,0x6b4d,0x0000,0x0000,0x0020,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9cd3,0x5acb,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0841,0x9cf3,0x8430,0x7bcf,0x7bef,
    0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,
    0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,
    0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,
    0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,
    0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x738e,0xa514,0xb596,0xa514,0xad55,0xad55,0xa534,0xa534,0xad55,
    0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,
    0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xa534,0xb5b6,0x8c71,0x738e,0xb596,0xad55,
    0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,
    0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,
    0xad55,0xb596,0x632c,0xa534,0xef7d,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x6b4d,0x9492,0xffff,
    0xffff,0xffdf,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xf7be,0xffff,0xffff,0x4228,0xe73c,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xa514,0x630c,0xffff,0xffff,0xf7be,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xf7be,0xffff,0xffff,0x630c,0x9cd3,
    0xf7be,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xc638,
    0x8410,0xa514,0xef7d,0xb596,0x5aeb,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x5aeb,0xb596,0xef7d,0xa514,0x8430,
    0xc638,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,
    0xce79,0x6b4d,0x0000,0x0000,0x0020,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9cd3,0x5acb,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0841,0x9cf3,0x8430,0x7bcf,0x7bef,
    0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,
    0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,
    0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,
    0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,
    0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x738e,0xa514,0xb596,0xa514,0xad55,0xad55,0xa534,0xa534,0xad55,
    0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,
    0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xa534,0xb5b6,0x8c71,0x738e,0xb596,0xad55,
    0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,
    0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,
    0xad55,0xb596,0x632c,0xa534,0xef7d,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x6b4d,0x9492,0xffff,
    0xffff,0xffdf,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xf7be,0xffff,0xffff,0x4228,0xe73c,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xa514,0x630c,0xffff,0xffff,0xf7be,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xf7be,0xffff,0xffff,0x630c,0x9cd3,
    0xf7be,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xce59,
    0x94b2,0x94b2,0xe73c,0xb5b6,0x5acb,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x5aeb,0xbdd7,0xe73c,0x94b2,0x9cd3,
    0xce79,0xdefb,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe71c,
    0xd69a,0x6b4d,0x0000,0x0000,0x0020,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9cd3,0x5acb,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0841,0xa514,0x8c51,0x7bcf,0x7bef,
    0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,
    0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,
    0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,
    0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,
    0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x7bef,0x73ae,0xa514,0xb596,0xa534,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xa534,0xbdd7,0x8c71,0x738e,0xb5b6,0xad75,
    0xa534,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xa534,
    0xad75,0xb5b6,0x632c,0xa534,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf7be,0x6b6d,0x94b2,0xffff,
    0xffff,0xffdf,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xf7be,0xffff,0xffff,0x4228,0xe73c,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xa514,0x632c,0xffff,0xffff,0xf7be,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xf7be,0xffff,0xffff,0x630c,0x9cd3,
    0xf7be,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdedb,0xd69a,
    0xad55,0x8c51,0xdefb,0xbdf7,0x5aeb,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x5acb,0xbdf7,0xdefb,0x8430,0xad55,
    0xd69a,0xdedb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe71c,
    0xd69a,0x6b4d,0x0000,0x0000,0x0020,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9cd3,0x5acb,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0841,0xa514,0x8c51,0x7bcf,0x7bef,
    0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,
    0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,
    0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,
    0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,
    0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x7bef,0x73ae,0xa514,0xb596,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,
    0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xad55,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,
    0xad55,0xad55,0xa534,0xad55,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xa534,0xbdd7,0x8c71,0x738e,0xb596,0xad75,
    0xa534,0xad55,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xad55,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,
    0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xad55,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xad55,0xa534,
    0xad75,0xb5b6,0x632c,0xa534,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf7be,0x6b6d,0x94b2,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xf7be,0xffff,0xffff,0x4228,0xe73c,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xa514,0x632c,0xffff,0xffff,0xffdf,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xf7be,0xffff,0xffff,0x630c,0x9cd3,
    0xf7be,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xd6ba,
    0xbdd7,0x73ae,0xd6ba,0xc618,0x5acb,0xdefb,0xe71c,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x8410,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x5acb,0xc618,0xd69a,0x73ae,0xbdf7,
    0xd6ba,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,
    0xce79,0x6b4d,0x0000,0x0000,0x0020,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9cd3,0x5acb,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0841,0xa514,0x8c51,0x7bcf,0x7bef,
    0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,
    0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,
    0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,
    0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,
    0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x7bef,0x73ae,0xa514,0xb596,0xa534,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xa534,0xbdd7,0x8c71,0x738e,0xb5b6,0xad75,
    0xa534,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xa534,
    0xad75,0xb5b6,0x632c,0xa534,0xef7d,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x6b6d,0x94b2,0xffff,
    0xffff,0xffdf,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xf7be,0xffff,0xffff,0x4228,0xe73c,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xa514,0x632c,0xffff,0xffff,0xf7be,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xf7be,0xffff,0xffff,0x630c,0x9cd3,
    0xf7be,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xdedb,
    0xce79,0x6b4d,0xce79,0xce59,0x5acb,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x8410,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe71c,0xdefb,0x5acb,0xc638,0xce79,0x6b4d,0xce79,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,
    0xce79,0x6b4d,0x0000,0x0000,0x0020,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9cd3,0x5acb,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0841,0x9cf3,0x8430,0x7bcf,0x7bef,
    0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,
    0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,
    0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,
    0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,
    0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x738e,0xa514,0xb596,0xa514,0xad55,0xad55,0xa534,0xa534,0xad55,
    0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,
    0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xa534,0xb5b6,0x8c71,0x738e,0xb596,0xad55,
    0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,
    0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,
    0xad55,0xb596,0x632c,0xa534,0xef7d,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x6b4d,0x9492,0xffff,
    0xffff,0xffdf,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xf7be,0xffff,0xffff,0x4228,0xe73c,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xa514,0x630c,0xffff,0xffff,0xf7be,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xf7be,0xffff,0xffff,0x630c,0x9cd3,
    0xf7be,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,
    0xdefb,0x5aeb,0xc618,0xce79,0x5acb,0xdefb,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x5acb,0xce79,0xc638,0x5aeb,0xdedb,
    0xdedb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,
    0xce79,0x6b4d,0x0000,0x0000,0x0020,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9cd3,0x5acb,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0841,0x9cf3,0x8430,0x7bcf,0x7bef,
    0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,
    0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,
    0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,
    0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,
    0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x738e,0xa514,0xb596,0xa514,0xad55,0xad55,0xa534,0xa534,0xad55,
    0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,
    0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xa534,0xb5b6,0x8c71,0x738e,0xb596,0xad55,
    0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,
    0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,
    0xad55,0xb596,0x632c,0xa534,0xef7d,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x6b4d,0x9492,0xffff,
    0xffff,0xffdf,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xf7be,0xffff,0xffff,0x4228,0xe73c,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xa514,0x630c,0xffff,0xffff,0xf7be,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xf7be,0xffff,0xffff,0x630c,0x9cd3,
    0xf7be,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,
    0xe71c,0x630c,0xbdf7,0xc638,0x5acb,0xdefb,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,0xdefb,0x5acb,0xce59,0xbdf7,0x5aeb,0xe71c,
    0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe71c,
    0xd69a,0x6b4d,0x0000,0x0000,0x0020,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9cd3,0x5acb,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0841,0xa514,0x8c51,0x7bcf,0x7bef,
    0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,
    0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,
    0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,
    0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,
    0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x7bef,0x73ae,0xa514,0xb596,0xa534,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xa534,0xbdd7,0x8c71,0x738e,0xb5b6,0xad75,
    0xa534,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xa534,
    0xad75,0xb5b6,0x632c,0xa534,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf7be,0x6b6d,0x94b2,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xf7be,0xffff,0xffff,0x4228,0xe73c,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xa514,0x632c,0xffff,0xffff,0xffdf,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xf7be,0xffff,0xffff,0x630c,0x9cd3,
    0xf7be,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,
    0xe71c,0x73ae,0xbdf7,0xbdd7,0x5aeb,0xdefb,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xdefb,0x5aeb,0xbdf7,0xbdf7,0x6b6d,0xe71c,
    0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe71c,
    0xd69a,0x6b4d,0x0000,0x0000,0x0020,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9cd3,0x5acb,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0841,0xa514,0x8c51,0x7bcf,0x7bef,
    0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,
    0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,
    0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,
    0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,
    0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x7bef,0x73ae,0xa514,0xb596,0xa534,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xa534,0xbdd7,0x8c71,0x738e,0xb5b6,0xad75,
    0xa534,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xa534,
    0xad75,0xb5b6,0x632c,0xa534,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf7be,0x6b6d,0x94b2,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xf7be,0xffff,0xffff,0x4228,0xe73c,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xa514,0x632c,0xffff,0xffff,0xffdf,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xf7be,0xffff,0xffff,0x630c,0x9cd3,
    0xf7be,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdedb,
    0xe71c,0x8410,0xbdd7,0xad75,0x630c,0xdefb,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x8410,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x630c,0xad75,0xbdd7,0x7bef,0xdefb,
    0xdedb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,
    0xce79,0x6b4d,0x0000,0x0000,0x0020,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9cd3,0x5acb,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0841,0xa514,0x8c51,0x7bcf,0x7bef,
    0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,
    0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,
    0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,
    0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,
    0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x7bef,0x73ae,0xa514,0xb596,0xa514,0xad55,0xad55,0xa534,0xa534,0xad55,
    0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,
    0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xa534,0xb5b6,0x8c71,0x738e,0xb596,0xad55,
    0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,
    0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,
    0xad55,0xb596,0x632c,0xa534,0xef7d,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x6b4d,0x9492,0xffff,
    0xffff,0xffdf,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xf7be,0xffff,0xffff,0x4228,0xe73c,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xa514,0x630c,0xffff,0xffff,0xf7be,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xf7be,0xffff,0xffff,0x630c,0x9cd3,
    0xf7be,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,
    0xdefb,0x8c71,0xb5b6,0xa514,0x632c,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x8410,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x632c,0xa534,0xb5b6,0x8c71,0xdefb,
    0xdedb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,
    0xce79,0x6b4d,0x0000,0x0000,0x0020,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9cd3,0x5acb,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0841,0x9cf3,0x8430,0x7bcf,0x7bef,
    0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,
    0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,
    0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,
    0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,
    0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x7bef,0x738e,0xa514,0xb596,0xa514,0xad55,0xad55,0xa534,0xa534,0xad55,
    0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,
    0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xa534,0xb5b6,0x8c71,0x738e,0xb596,0xad55,
    0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,
    0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,
    0xad55,0xb596,0x632c,0xa534,0xef7d,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5acb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x6b4d,0x9492,0xffff,
    0xffff,0xffdf,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xf7be,0xffff,0xffff,0x4228,0xe73c,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xa514,0x632c,0xffff,0xffff,0xf7be,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xf7be,0xffff,0xffff,0x630c,0x9cd3,
    0xf7be,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,
    0xdedb,0x9cf3,0xb596,0x94b2,0x6b4d,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x7bef,
    0x8410,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x6b4d,0x9cd3,0xb596,0x9cd3,0xdedb,
    0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,
    0xce79,0x6b4d,0x0000,0x0000,0x0020,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9cd3,0x5acb,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0841,0xa514,0x8c51,0x7bcf,0x7bef,
    0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,
    0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,
    0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,
    0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,
    0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x7bef,0x73ae,0xa514,0xb596,0xa514,0xad55,0xad55,0xa534,0xa534,0xad55,
    0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,
    0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xa534,0xb5b6,0x8c71,0x738e,0xb596,0xad55,
    0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,
    0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,0xad55,0xad55,0xa534,0xa534,
    0xad55,0xb596,0x632c,0xa534,0xef7d,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe71c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd69a,0xf79e,0x6b4d,0x9492,0xffff,
    0xffff,0xffdf,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xf7be,0xffff,0xffff,0x4228,0xe73c,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xa514,0x630c,0xffff,0xffff,0xf7be,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xf7be,0xffff,0xffff,0x630c,0x9cd3,
    0xf7be,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,
    0xdedb,0xad55,0xad75,0x8c51,0x6b6d,0xdefb,0xdefb,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x738e,0x8c51,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xe73c,0xce79,0x8410,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xdefb,0x6b6d,0x8c71,0xad75,0xa534,0xdedb,
    0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe71c,
    0xd69a,0x6b4d,0x0000,0x0000,0x0020,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9cd3,0x5acb,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0841,0xa514,0x8c51,0x7bcf,0x7bef,
    0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,
    0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,
    0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,
    0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,
    0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x7bef,0x73ae,0xa514,0xb596,0xa534,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xa534,0xbdd7,0x8c71,0x738e,0xb5b6,0xad75,
    0xa534,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xa534,
    0xad75,0xb5b6,0x632c,0xa534,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf7be,0x6b6d,0x94b2,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xf7be,0xffff,0xffff,0x4228,0xe73c,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xa514,0x632c,0xffff,0xffff,0xffdf,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xf7be,0xffff,0xffff,0x630c,0x9cd3,
    0xf7be,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,
    0xdedb,0xbdd7,0xad75,0x7bef,0x738e,0xdefb,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x8410,0xc638,0xef5d,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xf7be,0x8c51,0x73ae,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xdefb,0xdefb,0x738e,0x8410,0xad75,0xb5b6,0xdedb,
    0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe71c,
    0xd69a,0x6b4d,0x0000,0x0000,0x0020,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9cd3,0x5acb,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0000,0x0841,0xa514,0x8c51,0x7bcf,0x7bef,
    0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,
    0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,
    0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,
    0x8410,0x8410,0x8410,0x7bef,0x8410,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x7bef,0x7bef,0x8410,0x8410,0x8410,
    0x7bef,0x8410,0x8410,0x8410,0x7bef,0x8410,0x7bef,0x73ae,0xa514,0xb596,0xa534,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xa534,0xbdd7,0x8c71,0x738e,0xb5b6,0xad75,
    0xa534,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,
    0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xad55,0xa534,
    0xad75,0xb5b6,0x632c,0xa534,0xf79e,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce59,0xef7d,0xb5b6,0x5aeb,0xd6ba,0xe73c,0xce59,0xd6ba,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xf7be,0x6b6d,0x94b2,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xf7be,0xffff,0xffff,0x4228,0xe73c,0xffff,0xf7be,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xa514,0x632c,0xffff,0xffff,0xffdf,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
    0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xf7be,0xffff,0xffff,0x630c,0x9cd3,
    0xf7be,0xce79,0xd6ba,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd6ba,0xce59,0xad55,0x738e,0x73ae,0xdefb,0xdefb,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xd6ba,0xef7d,0x73ae,0x8c51,0xf7be,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd6ba,0xce79,0xe73c,0xd69a,0x8410,
    0x7bef,0xc638,0xe73c,0xce59,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xce79,0xf79e,0x8c51,0x738e,0xef7d,0xd6ba,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce59,0xdefb,0xdefb,0x738e,0x73ae,0xad55,0xc638,0xd6ba,
    0xd69a,0xce79,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,
    0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xd69a,0xce79,0xe71c,
    0xce79,0x6b4d,0x0000,0x0000,0x0020,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9cd3,0x5acb,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0