/**
 * \file  main_arm.c
 *
 * \brief Simple example to illustrate buffer passing between CPUs (ARM side)
 */

/* Copyright (c) 2011, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. */
#include "uart.h"
#include "hw_uart.h"
#include "interrupt.h"
#include "soc_OMAPL138.h"
#include "hw_syscfg0_OMAPL138.h"
#include "timer.h"

#include "ipc_buffer_io.h"


/* Globals */
int    	volatile evtRcvd;
UInt32 	volatile myPayload;
int 	volatile *dspStartInitFlag = (int *)0x80000020;

/* Declarations */
void AppInit(void);
void UARTPrintd(char *, int);
void UARTPrintx(char *, int);
void iAssert (int);
void wait_event(void);

/* Event Call back function */
void cbFxnEvent(UInt16 procId, UInt16 lineId,
                UInt32 eventId, UArg arg, UInt32 payload)
{
    myPayload = payload; /* Transfer payload */
    evtRcvd = 1;         /* Flag event to background app */
}
void main (void)
{
    evtRcvd = 0;
    *dspStartInitFlag = 0;

    /* Set up the UART1 peripheral */
    UARTStdioInit();

    while (1)
    	UARTPuts("ARM subsystem up\n", -1);

    // Initialize
/*    AppInit();
    UARTPuts("ARM subsystem ready\n", -1);

    // Wait for event and process it
    wait_event();
    UARTPuts((char *) myPayload, -1);
    myPayload = (UInt32) "Hello from ARM\n";
    iAssert (Notify_sendEvent(IPC_DSP0,IPC_DSP0_INTLINE, EVENTID, myPayload, TRUE));

    *dspStartInitFlag = 0;

    WAIT_HERE;*/
}

/* Initialize everything */
void AppInit(void)
{
    int i;
    /* Data structure allocation and init */
    /* IPC data structure */
    char *p = (char *) &ipcPvMemArm;
    struct IPC_cfg ipcCfg = {
                    IPC_ARM_HOST,            /* local processor Id */
                    IPC_DSP0,                /* remote processor Id */
                    IPC_DSP0_INTLINE,        /* ID of interrupt line to remote CPU */
                    IPC_INTERRUPT_METHOD,    /* Method to receive from remote processor */
                    NUM_MAX_EVENT,           /* maximum number of events to be created */
                    &ipcPvMemArm,            /* local side private IPC memory */
                    &ipcPvMemDsp             /* remote side private IPC memory */
            };

    for (i=0; i<32; i++) *p++ = 0;

    /* Init MMU and caches */

    /* Init interrupt structure */
    IntAINTCInit();
    /* Init I/O */

    UARTStdioInit();
//    IntChannelSet(SYS_INT_UARTINT1, AINTC_UART2_CHNL); /* set UART  AINTC channel */

    //  release the DSP to initialize
    *dspStartInitFlag = 1;

    /* Init IPC */
    IPC_init(&ipcCfg);
    IPC_intRegister(AINTC_IPC_CHNL);                   /* set IPC AINTC channel */
    iAssert (Notify_registerEvent(IPC_DSP0, IPC_DSP0_INTLINE, EVENTID, cbFxnEvent, 0xc0de));

    /*  Enabling the system interrupt for HOST (ARM) CPU and sync IPC */
    IntMasterIRQEnable();
    IntGlobalEnable();
    IntIRQEnable();
    iAssert (Notify_start());
}

/* Trap for errors */
void iAssert (int status)
{
    if (status != Notify_S_SUCCESS)
    {
        UARTPrintd("Notify failed ", status);
        WAIT_HERE;
    }
}

/* Hex formatted printf to serial console */
void UARTPrintd(char *buf, int val)
{
    UARTPuts(buf, -1);
    UARTPutNum(val);
    UARTPuts("\n", -1);
}

/* Decimal formatted printf to serial console */
void UARTPrintx(char *buf, int val)
{
    UARTPuts(buf, -1);
    UARTPutHexNum(val);
    UARTPuts("\n", -1);
}

void wait_event(void)
{
    int i = 0;
    while (!evtRcvd)
        i++;
    evtRcvd = 0;
}
