/**
 * \file  images.c
 *
 * \brief Arrays containing graphics images used by the application.
 */

/* Copyright (c) 2007-2010 Texas Instruments Incorporated.  All rights reserved.
 *
 * Software License Agreement
 * 
 * Texas Instruments (TI) is supplying this software for use solely and
 * exclusively on TI's microcontroller products. The software is owned by
 * TI and/or its suppliers, and is protected under applicable copyright
 * laws. You may not combine this software with "viral" open-source
 * software in order to form a larger program.
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND WITH ALL FAULTS.
 * NO WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT
 * NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. TI SHALL NOT, UNDER ANY
 * CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
 * DAMAGES, FOR ANY REASON WHATSOEVER.
 * 
 * This is part of revision 6288 of the EK-LM3S2965 Firmware Package. */

#include "images.h"

//*****************************************************************************
//
// A bitmap for the Texas Instruments logo.  This logo is 120x42.
//
//*****************************************************************************
const unsigned char g_pucTILogo_bu[2520] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xcb, 0xbc, 0x30, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0xff, 0x40, 0x06,
    0xa1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0xff, 0x40, 0x1d,
    0xf1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0xff, 0x40, 0x03,
    0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0xff, 0xd6, 0x2b,
    0x52, 0xcb, 0xb9, 0x00, 0x00, 0x1c, 0xbb, 0xbb, 0xbc, 0x30, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0xff, 0xf4, 0x5f,
    0x46, 0xff, 0xfc, 0x00, 0x00, 0x33, 0x14, 0xf7, 0x12, 0x30, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0xfe, 0xb2, 0x8f,
    0x26, 0xdf, 0xfc, 0x00, 0x00, 0x00, 0x01, 0xf4, 0x02, 0x78, 0x78, 0x51,
    0x78, 0x20, 0x38, 0x10, 0x07, 0x60, 0x00, 0x29, 0x97, 0x20, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0xf7, 0x00, 0xcf,
    0x10, 0x4f, 0xfd, 0x10, 0x00, 0x00, 0x01, 0xf4, 0x01, 0xf6, 0x12, 0x51,
    0x4f, 0x40, 0x94, 0x00, 0x2f, 0xf1, 0x01, 0xe2, 0x15, 0x70, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x05, 0x87, 0x77, 0x7c, 0xff, 0xf4, 0x01, 0xfc,
    0x00, 0x7f, 0xff, 0x50, 0x00, 0x00, 0x01, 0xf4, 0x01, 0xf3, 0x00, 0x10,
    0x08, 0xd7, 0x70, 0x00, 0x84, 0xe7, 0x02, 0xf4, 0x10, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x32, 0xf8,
    0x28, 0xdf, 0xff, 0xe1, 0x00, 0x00, 0x01, 0xf4, 0x01, 0xfb, 0x8b, 0x30,
    0x01, 0xde, 0x10, 0x01, 0xa0, 0x8d, 0x00, 0x9f, 0xfc, 0x30, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xff, 0xff, 0xff, 0xff, 0x55, 0xf5,
    0x6f, 0xff, 0xff, 0xf1, 0x00, 0x00, 0x01, 0xf4, 0x01, 0xf5, 0x11, 0x10,
    0x02, 0xbe, 0x60, 0x05, 0xc5, 0x9f, 0x20, 0x01, 0x3a, 0xf1, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xff, 0xff, 0x38, 0xf3,
    0x9f, 0xff, 0xff, 0xf1, 0x00, 0x00, 0x01, 0xf4, 0x01, 0xf3, 0x00, 0x01,
    0x1a, 0x15, 0xf2, 0x09, 0x43, 0x3d, 0x82, 0x20, 0x01, 0xf2, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xdf, 0xff, 0xff, 0xfe, 0x2c, 0xf2,
    0xcf, 0xff, 0xff, 0xf1, 0x00, 0x00, 0x03, 0xf6, 0x02, 0xfa, 0x66, 0xa3,
    0x98, 0x01, 0xec, 0x6b, 0x00, 0x09, 0xf5, 0xc8, 0x5a, 0x90, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0xce, 0xfb, 0x01, 0x10,
    0x19, 0xff, 0xfe, 0x91, 0x00, 0x00, 0x01, 0x11, 0x01, 0x22, 0x22, 0x21,
    0x21, 0x01, 0x22, 0x22, 0x00, 0x02, 0x21, 0x12, 0x42, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0xf3, 0x03, 0xfa, 0x00, 0x00,
    0x0b, 0xfd, 0x51, 0x00, 0x00, 0x00, 0x02, 0x22, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x10, 0x00, 0x9f, 0x41, 0x11,
    0x2e, 0xb1, 0x00, 0x00, 0x00, 0x00, 0x04, 0xf7, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xff, 0xff,
    0xfa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xf4, 0x01, 0x10, 0x00, 0x11,
    0x00, 0x21, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x10, 0x01, 0x11, 0x00,
    0x11, 0x11, 0x11, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x01, 0x10, 0x00,
    0x11, 0x01, 0x11, 0x11, 0x00, 0x02, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0xff,
    0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xf4, 0x0a, 0xf3, 0x00, 0xc3,
    0x2b, 0x89, 0xa1, 0xa8, 0xdc, 0x8a, 0x2c, 0xd8, 0xac, 0x21, 0xda, 0x00,
    0x1d, 0x22, 0xfc, 0x00, 0x07, 0xf6, 0x0b, 0xe8, 0x7b, 0x23, 0xf8, 0x00,
    0x69, 0x3a, 0x9f, 0xaa, 0x61, 0xb9, 0x8c, 0x10, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff,
    0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xf4, 0x07, 0xfe, 0x20, 0xa1,
    0x98, 0x00, 0x23, 0x10, 0xb8, 0x01, 0x1c, 0x80, 0x0d, 0xb0, 0xc8, 0x00,
    0x0b, 0x11, 0xdf, 0x40, 0x1c, 0xf3, 0x0a, 0xb0, 0x00, 0x11, 0xef, 0x70,
    0x37, 0x20, 0x1f, 0x30, 0x2a, 0x80, 0x02, 0x20, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xff,
    0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xf4, 0x08, 0x5a, 0xd1, 0x91,
    0x6f, 0x95, 0x10, 0x00, 0xb8, 0x00, 0x0c, 0x80, 0x1e, 0x80, 0xc8, 0x00,
    0x0b, 0x11, 0x99, 0xb0, 0x67, 0xf4, 0x0a, 0xc2, 0x24, 0x02, 0x95, 0xf4,
    0x38, 0x00, 0x1f, 0x30, 0x06, 0xfa, 0x51, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff,
    0xd1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xf4, 0x08, 0x31, 0xdb, 0xb2,
    0x06, 0xcf, 0xf4, 0x00, 0xb8, 0x00, 0x0c, 0xd8, 0xe8, 0x00, 0xc7, 0x00,
    0x0b, 0x11, 0x82, 0xf3, 0x82, 0xf4, 0x0a, 0xe6, 0x78, 0x02, 0x90, 0x7f,
    0xa7, 0x00, 0x1f, 0x30, 0x00, 0x5b, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15,
    0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xf4, 0x08, 0x30, 0x2e, 0xf2,
    0x00, 0x01, 0xab, 0x00, 0xb8, 0x00, 0x0c, 0x80, 0x8d, 0x10, 0xc8, 0x00,
    0x0b, 0x11, 0x90, 0xbf, 0x41, 0xf3, 0x0a, 0xb0, 0x00, 0x02, 0x90, 0x09,
    0xf7, 0x00, 0x1f, 0x30, 0x01, 0x00, 0x09, 0xc0, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xf4, 0x08, 0x30, 0x03, 0xf1,
    0x74, 0x00, 0xa9, 0x00, 0xb9, 0x00, 0x0d, 0x80, 0x1f, 0xa0, 0x8d, 0x10,
    0x2c, 0x01, 0xa0, 0x4f, 0x11, 0xf4, 0x0a, 0xc1, 0x11, 0x32, 0xa0, 0x00,
    0xc8, 0x00, 0x1f, 0x30, 0x08, 0x50, 0x09, 0xa0, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xb6, 0x18, 0x60, 0x00, 0x41,
    0x39, 0x9a, 0x81, 0x01, 0xa9, 0x10, 0x1a, 0x80, 0x03, 0xc5, 0x17, 0xa9,
    0x92, 0x03, 0x91, 0x15, 0x03, 0xb5, 0x19, 0xa9, 0x9a, 0x33, 0xa1, 0x00,
    0x14, 0x00, 0x3b, 0x50, 0x03, 0x99, 0xa8, 0x10, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

//*****************************************************************************
//
// A bitmap for the Code Composer Studio logo.  This logo is 128x34.
//
//*****************************************************************************
#if defined(ccs)
const unsigned char g_pucCodeComposer[2176] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x01, 0x46, 0x56, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x55, 0x44, 0x44, 0x45, 0x52, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x55, 0x66, 0x53,
    0x33, 0x34, 0x66, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
    0x54, 0x33, 0x34, 0x66, 0x34, 0x65, 0x43, 0x45, 0x63, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x13, 0x47, 0x53, 0x23, 0x32, 0x3a, 0xec, 0x52, 0x33, 0x32,
    0x27, 0x63, 0x00, 0x00, 0x00, 0x01, 0x8f, 0xfc, 0x40, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x02, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xef,
    0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x53, 0x33, 0x67, 0x52, 0x39, 0xed,
    0xcc, 0xda, 0x51, 0x24, 0x65, 0x34, 0x54, 0x10, 0x00, 0x0c, 0xfe, 0xef,
    0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0x70, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x7f, 0xfe, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x23, 0x33,
    0x22, 0x77, 0xec, 0xbc, 0xcc, 0xcc, 0xd5, 0x64, 0x23, 0x33, 0x33, 0x42,
    0x00, 0x4f, 0xfb, 0x9d, 0xdb, 0x11, 0x7a, 0x85, 0x00, 0x28, 0xa7, 0xff,
    0x91, 0x6a, 0xa6, 0x10, 0x00, 0x01, 0xff, 0xd9, 0xcd, 0xc3, 0x06, 0xaa,
    0x61, 0x06, 0x62, 0x8a, 0x24, 0xa8, 0x12, 0x65, 0x4a, 0x81, 0x00, 0x6a,
    0xa6, 0x10, 0x48, 0xa8, 0x40, 0x03, 0x8a, 0x83, 0x02, 0x65, 0x68, 0x20,
    0x01, 0x53, 0x22, 0x21, 0x24, 0x54, 0x69, 0xcb, 0xbb, 0xb9, 0x75, 0x55,
    0x42, 0x23, 0x21, 0x24, 0x00, 0x6f, 0xf9, 0x21, 0x64, 0x2d, 0xfd, 0xff,
    0x80, 0xdf, 0xef, 0xff, 0x9a, 0xfe, 0xef, 0xc1, 0x00, 0x03, 0xff, 0xb4,
    0x05, 0x43, 0x8f, 0xee, 0xfc, 0x1f, 0xfe, 0xff, 0xff, 0xff, 0xb4, 0xfe,
    0xee, 0xfb, 0x18, 0xfe, 0xef, 0xc2, 0xff, 0xaf, 0xe3, 0x3f, 0xfd, 0xff,
    0x53, 0xfe, 0xfe, 0x61, 0x00, 0x64, 0x42, 0x14, 0x53, 0x22, 0x23, 0x7b,
    0xb9, 0x75, 0x22, 0x23, 0x55, 0x31, 0x12, 0x43, 0x00, 0x6f, 0xf9, 0x00,
    0x00, 0x6f, 0xe9, 0xaf, 0xf6, 0xff, 0xaa, 0xff, 0xbf, 0xfc, 0xaf, 0xf8,
    0x00, 0x03, 0xff, 0xb2, 0x00, 0x02, 0xff, 0xa8, 0xff, 0x8f, 0xfd, 0xbf,
    0xfa, 0xdf, 0xe7, 0xff, 0x9a, 0xff, 0x7f, 0xfa, 0x8f, 0xf8, 0xff, 0xd8,
    0xb7, 0x9f, 0xeb, 0xdf, 0xe5, 0xff, 0xa9, 0x80, 0x00, 0x54, 0x43, 0x43,
    0x12, 0x22, 0x21, 0x16, 0x99, 0x31, 0x22, 0x22, 0x11, 0x52, 0x33, 0x42,
    0x00, 0x5f, 0xfa, 0x2d, 0x83, 0x6f, 0xe8, 0x3f, 0xfa, 0xff, 0x94, 0xff,
    0xbf, 0xfe, 0xcc, 0xeb, 0x20, 0x02, 0xff, 0xc2, 0xc8, 0x53, 0xff, 0x91,
    0xff, 0xbf, 0xfb, 0x6f, 0xf9, 0x7f, 0xe8, 0xff, 0x94, 0xff, 0xaf, 0xf9,
    0x1f, 0xfb, 0x5e, 0xff, 0xf4, 0xaf, 0xed, 0xbd, 0xd8, 0xff, 0x92, 0x00,
    0x00, 0x54, 0x43, 0x45, 0x31, 0x11, 0x13, 0x54, 0x23, 0x65, 0x21, 0x11,
    0x11, 0x52, 0x33, 0x42, 0x00, 0x1e, 0xfe, 0x9f, 0xf7, 0x5f, 0xf9, 0x8f,
    0xea, 0xff, 0xd8, 0xff, 0xae, 0xfd, 0x9d, 0xb7, 0x20, 0x00, 0xbf, 0xe8,
    0xff, 0x94, 0xef, 0xd6, 0xff, 0xaf, 0xfb, 0x5f, 0xf9, 0x6f, 0xe8, 0xff,
    0xd8, 0xfe, 0xae, 0xfd, 0x6f, 0xfc, 0x8a, 0x7e, 0xfd, 0x7f, 0xe9, 0xcd,
    0x97, 0xff, 0x90, 0x00, 0x00, 0x57, 0x53, 0x45, 0x33, 0x21, 0x45, 0x21,
    0x11, 0x13, 0x63, 0x11, 0x22, 0x52, 0x24, 0x61, 0x00, 0x03, 0xff, 0xff,
    0xd9, 0x27, 0xff, 0xfe, 0xb7, 0x7f, 0xfa, 0xff, 0x95, 0xff, 0xff, 0xa5,
    0x10, 0x00, 0x1e, 0xff, 0xfe, 0x94, 0x4f, 0xff, 0xec, 0x8f, 0xfb, 0x5f,
    0xf9, 0x6f, 0xe8, 0xff, 0xff, 0xfc, 0x84, 0xff, 0xfe, 0xc9, 0xdf, 0xff,
    0xea, 0x5c, 0xff, 0xfd, 0x75, 0xff, 0x90, 0x00, 0x00, 0x35, 0x76, 0x45,
    0x33, 0x34, 0x40, 0x11, 0x11, 0x11, 0x06, 0x22, 0x23, 0x52, 0x66, 0x61,
    0x00, 0x00, 0x2a, 0xba, 0x94, 0x00, 0x5b, 0xb9, 0x82, 0x06, 0xb9, 0x59,
    0x90, 0x4a, 0xba, 0x94, 0x00, 0x00, 0x01, 0x8b, 0xa9, 0x60, 0x03, 0xab,
    0x98, 0x30, 0x99, 0x22, 0x99, 0x04, 0x98, 0xff, 0xaa, 0xa9, 0x30, 0x3a,
    0xb9, 0x83, 0x18, 0xbb, 0x97, 0x11, 0x8b, 0xb9, 0x71, 0x29, 0x90, 0x00,
    0x00, 0x34, 0x35, 0x76, 0x33, 0x34, 0x52, 0x10, 0x11, 0x01, 0x16, 0x22,
    0x23, 0x76, 0x42, 0x50, 0x00, 0x00, 0x00, 0x22, 0x10, 0x00, 0x01, 0x22,
    0x00, 0x00, 0x22, 0x00, 0x00, 0x01, 0x22, 0x10, 0x00, 0x00, 0x00, 0x02,
    0x21, 0x00, 0x00, 0x02, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff,
    0x91, 0x21, 0x00, 0x00, 0x22, 0x00, 0x00, 0x22, 0x20, 0x00, 0x02, 0x22,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x35, 0x43, 0x4d, 0x84, 0x34, 0x53, 0x32,
    0x10, 0x12, 0x26, 0x22, 0x6c, 0x52, 0x23, 0x60, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x29, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x44, 0x4d,
    0xdc, 0x65, 0x63, 0x33, 0x11, 0x12, 0x26, 0x3b, 0xdd, 0x42, 0x33, 0x50,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x27, 0x54, 0x4e, 0xcc, 0xde, 0x63, 0x33, 0x11, 0x21, 0x3e, 0xdc,
    0xbd, 0x52, 0x35, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x66, 0x3e, 0xdd, 0xcc, 0x86, 0x43,
    0x11, 0x14, 0x8e, 0xab, 0xcd, 0x43, 0x66, 0x40, 0x00, 0x06, 0xdf, 0xe8,
    0x10, 0x01, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xaa, 0x07, 0xa5,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x45, 0x6e,
    0xdd, 0xcd, 0x53, 0x66, 0x12, 0x64, 0x3e, 0xbc, 0xca, 0x65, 0x34, 0x30,
    0x00, 0x5f, 0xfe, 0xff, 0x91, 0x2e, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x03, 0xff, 0x77, 0xc9, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x16, 0x54, 0x38, 0xdd, 0xcd, 0x63, 0x24, 0x55, 0x21, 0x3e, 0xbc,
    0xb8, 0x42, 0x35, 0x30, 0x00, 0x6f, 0xfa, 0xad, 0xc4, 0x8f, 0xfd, 0x26,
    0x62, 0x26, 0x60, 0x28, 0xa7, 0xff, 0x95, 0x88, 0x31, 0x7a, 0x85, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x55, 0x36, 0x59, 0xdd, 0x63, 0x32,
    0x11, 0x12, 0x4d, 0xb8, 0x56, 0x33, 0x45, 0x20, 0x00, 0x2e, 0xff, 0xd8,
    0x53, 0xff, 0xff, 0x6f, 0xf6, 0x4f, 0xf4, 0xdf, 0xef, 0xff, 0x9a, 0xf8,
    0x3d, 0xfd, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x65, 0x46,
    0x43, 0x68, 0x63, 0x33, 0x11, 0x22, 0x3a, 0x63, 0x25, 0x33, 0x45, 0x10,
    0x00, 0x03, 0xde, 0xff, 0xc1, 0x3f, 0xf9, 0x9f, 0xfb, 0x5f, 0xfb, 0xff,
    0xaa, 0xff, 0x9a, 0xfd, 0x8f, 0xe9, 0xaf, 0xf4, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x36, 0x45, 0x54, 0x34, 0x75, 0x33, 0x21, 0x23, 0x75, 0x22,
    0x36, 0x35, 0x51, 0x00, 0x00, 0x56, 0x65, 0xcf, 0xf7, 0x3f, 0xf9, 0x0f,
    0xfb, 0x5f, 0xfb, 0xff, 0x94, 0xff, 0x9a, 0xfd, 0x8f, 0xe8, 0x3f, 0xf8,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x57, 0x54, 0x44, 0x64, 0x64,
    0x12, 0x44, 0x64, 0x23, 0x36, 0x53, 0x00, 0x00, 0x00, 0x7f, 0xf8, 0xcf,
    0xe9, 0x3f, 0xfb, 0x0f, 0xfe, 0xdf, 0xfa, 0xff, 0xd8, 0xff, 0x9a, 0xfd,
    0x6f, 0xf9, 0x8f, 0xe9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
    0x65, 0x44, 0x63, 0x35, 0x34, 0x31, 0x55, 0x23, 0x44, 0x10, 0x00, 0x00,
    0x00, 0x1d, 0xff, 0xfe, 0xb8, 0x1e, 0xff, 0x57, 0xff, 0xbf, 0xf9, 0x7f,
    0xfa, 0xff, 0x9a, 0xfd, 0x47, 0xff, 0xfe, 0xb7, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x16, 0x54, 0x64, 0x32, 0x32, 0x12, 0x54, 0x35,
    0x20, 0x00, 0x00, 0x00, 0x00, 0x01, 0x8b, 0xb9, 0x82, 0x01, 0xab, 0x92,
    0x7b, 0x95, 0x99, 0x06, 0xb9, 0x59, 0x90, 0x79, 0x40, 0x5b, 0xb9, 0x82,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x64, 0x44,
    0x12, 0x22, 0x56, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x22,
    0x00, 0x00, 0x12, 0x20, 0x02, 0x20, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00,
    0x00, 0x01, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x01, 0x55, 0x44, 0x22, 0x23, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x54, 0x22, 0x44, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15,
    0x34, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
};
#endif

//*****************************************************************************
//
// A bitmap for the CodeRed logo.  This logo is 128x32.
//
//*****************************************************************************
#if defined(codered)
const unsigned char g_pucCodeRedLogo[2048] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x99, 0x99, 0x99, 0x99, 0x99, 0x90, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0x00, 0x00, 0x00, 0x00, 0x90,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0x00,
    0x00, 0x00, 0x00, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x90, 0x00, 0x00, 0x00, 0x00, 0x90, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0x00, 0x00, 0x00, 0x00, 0x90,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0x00,
    0x06, 0x66, 0x66, 0x96, 0x66, 0x66, 0x66, 0x60, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x90, 0x00, 0x06, 0x66, 0x66, 0x96, 0x66, 0x66, 0x66, 0x60,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0x00, 0x06, 0x66, 0x66, 0x96,
    0x66, 0x66, 0x66, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0x00,
    0x06, 0x66, 0x66, 0x96, 0x66, 0x66, 0x66, 0x60, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x90, 0x00, 0x06, 0x66, 0x66, 0x96, 0x66, 0x66, 0x66, 0x60,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x99, 0x99, 0x99, 0x99, 0x99, 0x96,
    0x66, 0x66, 0x66, 0x60, 0x00, 0x00, 0xff, 0xff, 0xf0, 0x00, 0x00, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0, 0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0xf0, 0x00, 0x0f, 0xff,
    0x00, 0x00, 0x00, 0x00, 0xff, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x06, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x60, 0x00, 0x0f, 0xff, 0xff,
    0xf0, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xf0,
    0x00, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xff, 0x0f, 0xff,
    0xf0, 0x0f, 0xff, 0xff, 0xff, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x06, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x60,
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x0f,
    0xff, 0xff, 0xff, 0xf0, 0x00, 0xff, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00,
    0x00, 0xff, 0xff, 0xff, 0xf0, 0x0f, 0xf0, 0x00, 0xff, 0xf0, 0x00, 0xff,
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x60, 0x00, 0xff, 0xf0, 0x00, 0x00, 0xff, 0xff, 0x00,
    0xff, 0xff, 0x00, 0xff, 0xf0, 0x0f, 0xff, 0xf0, 0x0f, 0xff, 0x00, 0x0f,
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xf0, 0x00,
    0xff, 0xf0, 0x0f, 0xff, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x06, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x60, 0x00, 0xff, 0x00, 0x00,
    0x00, 0xff, 0xf0, 0x00, 0x0f, 0xff, 0x00, 0xff, 0x00, 0x00, 0xff, 0xf0,
    0x0f, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,
    0x00, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0f, 0xf0, 0x00, 0x0f, 0xff, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x96, 0x66, 0x60,
    0x00, 0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x0f, 0xff, 0x00, 0xff,
    0x00, 0x00, 0xff, 0xf0, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xf0,
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0x00, 0x06, 0x66, 0x66, 0x66,
    0x66, 0x96, 0x66, 0x60, 0x00, 0xff, 0xff, 0x00, 0x00, 0x0f, 0xff, 0x00,
    0xff, 0xf0, 0x00, 0xff, 0xf0, 0x0f, 0xff, 0xf0, 0x0f, 0xff, 0x00, 0x00,
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00,
    0x0f, 0xf0, 0x0f, 0xff, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0x00,
    0x06, 0x66, 0x66, 0x66, 0x66, 0x96, 0x66, 0x60, 0x00, 0x0f, 0xff, 0xff,
    0xf0, 0x0f, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xf0,
    0x00, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,
    0x00, 0x0f, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x90, 0x00, 0x06, 0x66, 0x66, 0x66, 0x66, 0x96, 0x66, 0x60,
    0x00, 0x00, 0xff, 0xff, 0xf0, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
    0xff, 0xf0, 0xff, 0xf0, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xf0, 0x00, 0x00, 0x0f,
    0xff, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0x00, 0x06, 0x66, 0x66, 0x66,
    0x66, 0x96, 0x66, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x90, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
#endif

//*****************************************************************************
//
// A bitmap for the IAR logo.  This logo is 102x61.
//
//*****************************************************************************
#if defined(ewarm)
const unsigned char g_pucIarLogo[3111] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x79, 0xa9, 0x96, 0x30, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0xbb, 0xba, 0xaa,
    0xab, 0xbb, 0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xff,
    0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3d, 0xff, 0xff, 0xc0, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xca, 0x86, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xba,
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xbb, 0x93, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x05, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xff,
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xef, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x05, 0xba, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xab, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x05, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0f, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xef,
    0xff, 0xff, 0xc5, 0x55, 0x55, 0x79, 0xef, 0xff, 0xff, 0xf5, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x34, 0xba, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
    0xab, 0x03, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xff, 0xfe, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xef, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0x09, 0xff, 0xff,
    0xff, 0x50, 0x00, 0x00, 0x00, 0x0b, 0x44, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0x05, 0xb0, 0x00, 0x00, 0x00, 0x05, 0xff, 0xff,
    0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbf, 0xf0, 0x2f, 0xff, 0xff, 0xfa,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xef, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00,
    0x00, 0x9f, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0xab, 0x40, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xb8, 0x00, 0x00, 0x00,
    0x05, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xa0, 0x0b,
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xef, 0xff, 0xff, 0x90,
    0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xf7, 0x00, 0x00, 0x08, 0xbb,
    0x30, 0x65, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x05, 0xbb,
    0x70, 0x00, 0x00, 0x05, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x05,
    0xff, 0x50, 0x05, 0xff, 0xff, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0xef,
    0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0xff, 0xfb, 0x00,
    0x00, 0x5b, 0xab, 0x35, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xbb, 0x04, 0xba, 0xb0, 0x00, 0x00, 0x05, 0xff, 0xff, 0xfe, 0x00, 0x00,
    0x00, 0x00, 0x09, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x90, 0x00, 0x00,
    0x00, 0x00, 0xef, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff,
    0xff, 0xfc, 0x00, 0x00, 0xaa, 0xab, 0x34, 0xba, 0xaa, 0xaa, 0xaa, 0xaa,
    0xaa, 0xaa, 0xaa, 0xab, 0x04, 0xba, 0xa8, 0x00, 0x00, 0x05, 0xff, 0xff,
    0xfe, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xfb, 0x00, 0x00, 0xcf, 0xff, 0xff,
    0xe0, 0x00, 0x00, 0x00, 0x00, 0xef, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00,
    0x00, 0x04, 0xff, 0xff, 0xfd, 0x00, 0x05, 0xba, 0xab, 0x34, 0xba, 0xaa,
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xab, 0x04, 0xba, 0xab, 0x00, 0x00,
    0x05, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf6, 0x00, 0x00,
    0x7f, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xef, 0xff, 0xff, 0x90,
    0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xff, 0xfc, 0x00, 0x08, 0xaa, 0xab,
    0x34, 0xba, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xab, 0x04, 0xba,
    0xab, 0x70, 0x00, 0x05, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x7f,
    0xf0, 0x00, 0x00, 0x2f, 0xff, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00, 0xef,
    0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xff, 0xfa, 0x00,
    0x0b, 0xaa, 0xab, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x05, 0xba, 0xaa, 0xa0, 0x00, 0x05, 0xff, 0xff, 0xfe, 0x00, 0x00,
    0x00, 0x00, 0xcf, 0xc0, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xfc, 0x00, 0x00,
    0x00, 0x00, 0xef, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xff,
    0xff, 0xf5, 0x00, 0x4b, 0xaa, 0xab, 0x30, 0x76, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x67, 0x05, 0xba, 0xaa, 0xb0, 0x00, 0x05, 0xff, 0xff,
    0xfe, 0x00, 0x00, 0x00, 0x00, 0xff, 0x80, 0x00, 0x00, 0x09, 0xff, 0xff,
    0xff, 0x00, 0x00, 0x00, 0x00, 0xef, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00,
    0x00, 0x0f, 0xff, 0xff, 0xc0, 0x00, 0x7b, 0xaa, 0xab, 0x35, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0x04, 0xba, 0xaa, 0xb3, 0x00,
    0x05, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x05, 0xff, 0x20, 0x00, 0x00,
    0x05, 0xff, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00, 0xef, 0xff, 0xff, 0x90,
    0x00, 0x00, 0x00, 0x00, 0xaf, 0xff, 0xff, 0x00, 0x00, 0x9a, 0xaa, 0xab,
    0x34, 0xba, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xab, 0x04, 0xba,
    0xaa, 0xb5, 0x00, 0x05, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x0b, 0xfe,
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xa0, 0x00, 0x00, 0x00, 0xef,
    0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0x09, 0xff, 0xff, 0xe0, 0x00, 0x00,
    0xaa, 0xaa, 0xab, 0x33, 0xa9, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99,
    0x9a, 0x04, 0xba, 0xaa, 0xb6, 0x00, 0x05, 0xff, 0xff, 0xfe, 0x00, 0x00,
    0x00, 0x0f, 0xfa, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xff, 0xff, 0xe0, 0x00,
    0x00, 0x00, 0xef, 0xff, 0xff, 0x90, 0x00, 0x55, 0x7a, 0xef, 0xff, 0xd7,
    0x00, 0x00, 0x00, 0x9a, 0xaa, 0xab, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x05, 0xba, 0xaa, 0xb6, 0x00, 0x05, 0xff, 0xff,
    0xfe, 0x00, 0x00, 0x00, 0x4f, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xff,
    0xff, 0xf4, 0x00, 0x00, 0x00, 0xef, 0xff, 0xff, 0x90, 0x00, 0xcf, 0xff,
    0xff, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x9a, 0xaa, 0xab, 0x50, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x06, 0xba, 0xaa, 0xb5, 0x00,
    0x05, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x8f, 0xf0, 0x00, 0x00, 0x00,
    0x00, 0x0f, 0xff, 0xff, 0xf7, 0x00, 0x00, 0x00, 0xef, 0xff, 0xff, 0x90,
    0x00, 0x4f, 0xff, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x6b, 0xaa, 0xab,
    0x70, 0xab, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xb8, 0x08, 0xaa,
    0xaa, 0xb0, 0x00, 0x05, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00, 0xcf, 0xd0,
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xfd, 0x00, 0x00, 0x00, 0xef,
    0xff, 0xff, 0x90, 0x00, 0x0b, 0xff, 0xff, 0xff, 0x50, 0x00, 0x00, 0x00,
    0x0b, 0xaa, 0xaa, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x0b, 0xaa, 0xaa, 0xb0, 0x00, 0x05, 0xff, 0xff, 0xfe, 0x00, 0x00,
    0x00, 0xff, 0xfb, 0xaa, 0xaa, 0xaa, 0xaa, 0xcf, 0xff, 0xff, 0xff, 0x00,
    0x00, 0x00, 0xef, 0xff, 0xff, 0x90, 0x00, 0x04, 0xff, 0xff, 0xff, 0xd0,
    0x00, 0x00, 0x00, 0x0a, 0xaa, 0xaa, 0xb4, 0x05, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x30, 0x6b, 0xaa, 0xaa, 0x90, 0x00, 0x05, 0xff, 0xff,
    0xfe, 0x00, 0x00, 0x06, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x60, 0x00, 0x00, 0xef, 0xff, 0xff, 0x90, 0x00, 0x00, 0xbf,
    0xff, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x07, 0xba, 0xaa, 0xaa, 0x05, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0x00, 0xba, 0xaa, 0xab, 0x50, 0x00,
    0x05, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x0b, 0xff, 0xcc, 0xcc, 0xcc, 0xcc,
    0xcc, 0xcd, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0xef, 0xff, 0xff, 0x90,
    0x00, 0x00, 0x4f, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xba, 0xaa,
    0xab, 0x70, 0x05, 0x55, 0x55, 0x55, 0x55, 0x55, 0x50, 0x09, 0xaa, 0xaa,
    0xab, 0x00, 0x00, 0x05, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x0f, 0xf8, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xbf, 0xff, 0xff, 0xe0, 0x00, 0x00, 0xef,
    0xff, 0xff, 0x90, 0x00, 0x00, 0x0b, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00,
    0x00, 0x8a, 0xaa, 0xaa, 0xb7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x8b, 0xaa, 0xaa, 0xb7, 0x00, 0x00, 0x05, 0xff, 0xff, 0xfe, 0x00, 0x00,
    0x5f, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xff, 0xff, 0xf5,
    0x00, 0x00, 0xef, 0xff, 0xff, 0x90, 0x00, 0x00, 0x02, 0xff, 0xff, 0xff,
    0xf0, 0x00, 0x00, 0x00, 0x0b, 0xaa, 0xaa, 0xab, 0x80, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x0a, 0xba, 0xaa, 0xaa, 0xa0, 0x00, 0x00, 0x05, 0xff, 0xff,
    0xfe, 0x00, 0x00, 0xaf, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f,
    0xff, 0xff, 0xf9, 0x00, 0x00, 0xef, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00,
    0xaf, 0xff, 0xff, 0xfa, 0x00, 0x00, 0x00, 0x06, 0xba, 0xaa, 0xaa, 0xab,
    0x60, 0x00, 0x00, 0x00, 0x07, 0xba, 0xaa, 0xaa, 0xab, 0x50, 0x00, 0x00,
    0x05, 0xff, 0xff, 0xfe, 0x00, 0x00, 0xef, 0xa0, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x0c, 0xff, 0xff, 0xfd, 0x00, 0x00, 0xef, 0xff, 0xff, 0x90,
    0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0x50, 0x00, 0x00, 0x00, 0x8b,
    0xaa, 0xaa, 0xaa, 0xbb, 0x98, 0x77, 0x8a, 0xbb, 0xaa, 0xaa, 0xaa, 0xb6,
    0x00, 0x00, 0x00, 0x05, 0xff, 0xff, 0xfe, 0x00, 0x03, 0xff, 0x50, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0xff, 0xff, 0x00, 0x00, 0xef,
    0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0x09, 0xff, 0xff, 0xff, 0xe0, 0x00,
    0x00, 0x00, 0x08, 0xba, 0xaa, 0xaa, 0xaa, 0xaa, 0xbb, 0xaa, 0xaa, 0xaa,
    0xaa, 0xab, 0x70, 0x00, 0x00, 0x00, 0x05, 0xff, 0xff, 0xfe, 0x00, 0x08,
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xff, 0xff,
    0x60, 0x00, 0xef, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,
    0xff, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x7b, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
    0xaa, 0xaa, 0xaa, 0xaa, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xff,
    0xfe, 0x00, 0x0c, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xff, 0xff, 0xff, 0xb0, 0x00, 0xef, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00,
    0x00, 0x9f, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x05, 0xbb, 0xaa,
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xba, 0x40, 0x00, 0x00, 0x00, 0x00,
    0x05, 0xff, 0xff, 0xfe, 0x00, 0x0f, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0xbf, 0xff, 0xff, 0xf0, 0x00, 0xef, 0xff, 0xff, 0x90,
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00,
    0x00, 0x07, 0xbb, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xba, 0x60, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x05, 0xff, 0xff, 0xfe, 0x00, 0x6f, 0xf3, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xff, 0xff, 0xf2, 0x00, 0xef,
    0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xff, 0xf2,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x8a, 0xbb, 0xbb, 0xbb, 0xa8, 0x40,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x76, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x05, 0x96, 0x55, 0x50, 0x00, 0x66, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x03, 0x00, 0x06, 0x96, 0x55, 0x50, 0x00, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x50, 0x00, 0x55, 0x55, 0x55, 0x55, 0x55, 0x50, 0x00, 0xb9,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc5, 0x00, 0x00, 0x00, 0x87,
    0x65, 0x50, 0x00, 0x00, 0x00, 0xc8, 0x00, 0x00, 0x07, 0x00, 0x7f, 0xa0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0x00, 0xd7, 0x00, 0x00, 0x07, 0x00,
    0x00, 0x00, 0x7f, 0xa0, 0x00, 0x00, 0x06, 0xf6, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x06, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xfc, 0x00,
    0x00, 0x7d, 0x00, 0x00, 0x05, 0x60, 0x00, 0x0c, 0xa0, 0x00, 0x00, 0x00,
    0x20, 0x0a, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x02, 0x90, 0x0e, 0x90, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0x80, 0x00, 0x00, 0x07, 0xf4, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0f, 0xfc, 0x00, 0x06, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xdf, 0x20, 0x00, 0x00, 0x00, 0x0a, 0x00,
    0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0x80, 0x00, 0x00,
    0x07, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x8b, 0xf0, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x96, 0xfc, 0x00, 0x0f, 0x80, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xbf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xe0, 0x00, 0x00,
    0x00, 0x90, 0x00, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f,
    0x80, 0x00, 0x00, 0x07, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x55,
    0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 0xfd, 0x00, 0x4f, 0x50, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xcf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06,
    0xfa, 0x00, 0x00, 0x07, 0x50, 0x00, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x5f, 0x80, 0x00, 0x00, 0x07, 0xf4, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x08, 0x60, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x07, 0x50, 0xfd, 0x00,
    0x6f, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0x50, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x9f, 0x70, 0x00, 0x28, 0x00, 0x00, 0xcf, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0x80, 0x00, 0x00, 0x07, 0xf4, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x08, 0x60, 0x8f, 0x50, 0x00, 0x00, 0x00, 0x0b,
    0x00, 0xfd, 0x00, 0x3f, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xd0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xf5, 0x00, 0x90, 0x00, 0x00,
    0x6f, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0x80, 0x00, 0x00,
    0x07, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x60, 0x0f, 0xa0, 0x00,
    0x00, 0x00, 0x58, 0x00, 0xfd, 0x00, 0x0d, 0xf5, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x08, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x09,
    0x00, 0x00, 0x00, 0x0a, 0xfb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f,
    0x80, 0x00, 0x00, 0x07, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x60,
    0x0d, 0xf0, 0x00, 0x00, 0x00, 0xa0, 0x00, 0xfd, 0x00, 0x00, 0xff, 0x70,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfb, 0x30, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x5f, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xfa, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x5f, 0x80, 0x00, 0x00, 0x07, 0xf5, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x08, 0x60, 0x06, 0xf8, 0x00, 0x00, 0x00, 0x90, 0x00, 0xfd, 0x00,
    0x00, 0x0d, 0xfe, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xfd, 0x50,
    0x00, 0x00, 0x00, 0x00, 0x0e, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbf,
    0xfc, 0x20, 0x00, 0x00, 0x00, 0x5f, 0x80, 0x00, 0x00, 0x07, 0xfb, 0x99,
    0x99, 0x99, 0x99, 0x60, 0x08, 0x60, 0x00, 0xff, 0x00, 0x00, 0x09, 0x40,
    0x00, 0xfd, 0x00, 0x00, 0x00, 0x7f, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x8f, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xc0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x9f, 0xf7, 0x00, 0x00, 0x00, 0x5f, 0x80, 0x00, 0x00,
    0x07, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x60, 0x00, 0xaf, 0x50,
    0x00, 0x0b, 0x00, 0x00, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x5d, 0xfe, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xef, 0x70, 0x00, 0x00, 0x00, 0x0e, 0xc0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0x60, 0x00, 0x00, 0x5f,
    0x80, 0x00, 0x00, 0x07, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x60,
    0x00, 0x4f, 0xb0, 0x00, 0x66, 0x00, 0x00, 0xfd, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x9f, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,
    0x00, 0x0e, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xe0,
    0x00, 0x00, 0x5f, 0x80, 0x00, 0x00, 0x07, 0xf5, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x08, 0x60, 0x00, 0x0d, 0xf0, 0x00, 0xa0, 0x00, 0x00, 0xfd, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x0a, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09,
    0xf5, 0x00, 0x00, 0x00, 0x0e, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x0a, 0xf3, 0x00, 0x00, 0x5f, 0x80, 0x00, 0x00, 0x07, 0xf4, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x08, 0x60, 0x00, 0x07, 0xf8, 0x00, 0x80, 0x00,
    0x00, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x06, 0xf5, 0x00, 0x00, 0x00, 0x0e, 0xc0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x08, 0xf5, 0x00, 0x00, 0x5f, 0x80, 0x00, 0x00,
    0x07, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x60, 0x00, 0x00, 0xfe,
    0x08, 0x00, 0x00, 0x00, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xf5, 0x00, 0x00, 0x00, 0x0e, 0xc0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xf2, 0x00, 0x00, 0x5f,
    0x80, 0x00, 0x00, 0x07, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x60,
    0x00, 0x00, 0xaf, 0x89, 0x00, 0x00, 0x00, 0xfd, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xfb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0xf0, 0x00, 0x00,
    0x00, 0x0e, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xe0,
    0x00, 0x00, 0x5f, 0x80, 0x00, 0x00, 0x07, 0xf4, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x08, 0x60, 0x00, 0x00, 0x3f, 0xf5, 0x00, 0x00, 0x00, 0xfd, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x03, 0xf5, 0x00, 0x70, 0x00, 0x00, 0x00, 0x2f,
    0x50, 0x00, 0x00, 0x00, 0x0e, 0xc0, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
    0x00, 0x5f, 0x40, 0x00, 0x00, 0x5f, 0x80, 0x00, 0x00, 0x07, 0xf4, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x08, 0x60, 0x00, 0x00, 0x0e, 0xf0, 0x00, 0x00,
    0x00, 0xfd, 0x00, 0x25, 0x00, 0x00, 0x00, 0x0c, 0xb0, 0x00, 0x08, 0x00,
    0x00, 0x03, 0xe6, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xd0, 0x00, 0x00, 0x00,
    0x09, 0x00, 0x00, 0x05, 0xe5, 0x00, 0x00, 0x00, 0x5f, 0x80, 0x00, 0x00,
    0x06, 0xf8, 0x24, 0x44, 0x44, 0x44, 0x50, 0x08, 0x60, 0x00, 0x00, 0x07,
    0x80, 0x00, 0x00, 0x00, 0xfd, 0x00, 0x06, 0x60, 0x00, 0x00, 0xab, 0x00,
    0x00, 0x00, 0x67, 0x66, 0x89, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x40,
    0x00, 0x00, 0x00, 0x00, 0x77, 0x67, 0x98, 0x00, 0x00, 0x00, 0x00, 0x05,
    0x00, 0x00, 0x00, 0x00, 0x55, 0x55, 0x55, 0x55, 0x55, 0x60, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0x00, 0x00, 0x47, 0x76,
    0x79, 0x50, 0x00
};
#endif

//*****************************************************************************
//
// A bitmap for the CodeSourcery logo.  This logo is 128x34.
//
//*****************************************************************************
#if defined(sourcerygxx)
const unsigned char g_pucCodeSourceryLogo[2176] =
{
    0x00, 0x00, 0x00, 0x00, 0x01, 0x36, 0x7a, 0x98, 0x63, 0x11, 0x10, 0x00,
    0x00, 0x01, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x5a, 0xca, 0x85, 0x45,
    0x66, 0x66, 0x54, 0x32, 0x11, 0x59, 0x98, 0x30, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a,
    0xca, 0x75, 0x55, 0x77, 0x77, 0x77, 0x77, 0x76, 0x58, 0x96, 0x45, 0x60,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x10, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x17, 0xdc, 0x86, 0x43, 0x22, 0x67, 0x77, 0x77, 0x77, 0x77,
    0xa7, 0x20, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x47, 0x50, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38,
    0xa6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x8d, 0xc6, 0x52, 0x10, 0x03, 0x67,
    0x77, 0x77, 0x77, 0x8b, 0x71, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x39, 0xcd, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x03, 0xad, 0xe8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xdd, 0x55,
    0x21, 0x45, 0x67, 0x77, 0x77, 0x77, 0x78, 0xc5, 0x10, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x04, 0xbe, 0xeb, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x29, 0xee, 0x71, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x6d, 0xd6, 0x62, 0x46, 0x77, 0x77, 0x77, 0x77, 0x77, 0x9b, 0x50,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0xed, 0x81, 0x00, 0x01,
    0x22, 0x10, 0x00, 0x11, 0x11, 0x00, 0x00, 0x11, 0x11, 0x11, 0x4d, 0xea,
    0x10, 0x00, 0x00, 0x22, 0x10, 0x00, 0x12, 0x10, 0x11, 0x10, 0x01, 0x22,
    0x21, 0x00, 0x00, 0x00, 0x11, 0x01, 0x11, 0x11, 0x10, 0x12, 0x22, 0x10,
    0x01, 0x10, 0x00, 0x22, 0x03, 0xbe, 0x86, 0x45, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x7a, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x8e,
    0xd7, 0x10, 0x00, 0x16, 0xbb, 0x83, 0x00, 0x49, 0x98, 0x51, 0x01, 0x69,
    0x99, 0x98, 0x6e, 0xe5, 0x00, 0x00, 0x15, 0xac, 0x94, 0x00, 0x7b, 0x60,
    0x59, 0x70, 0x28, 0xbc, 0xb8, 0x10, 0x00, 0x14, 0x98, 0x35, 0x99, 0x99,
    0x62, 0x7a, 0xcb, 0x93, 0x05, 0x94, 0x03, 0xa9, 0x18, 0xeb, 0x65, 0x57,
    0x77, 0x77, 0x77, 0x77, 0x68, 0xba, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x03, 0xde, 0xa2, 0x00, 0x00, 0x6d, 0xcb, 0xea, 0x20, 0x6e,
    0xdc, 0xd6, 0x11, 0xbe, 0xcb, 0xa7, 0x5e, 0xe5, 0x00, 0x00, 0x5c, 0xcb,
    0xeb, 0x30, 0x9d, 0x80, 0x7e, 0xb1, 0x3e, 0xda, 0xde, 0x70, 0x02, 0x7d,
    0xd8, 0x3a, 0xec, 0xaa, 0x63, 0xbe, 0xab, 0xe9, 0x17, 0xe9, 0x18, 0xd9,
    0x2c, 0xe8, 0x65, 0x77, 0x77, 0x77, 0x77, 0x76, 0x8c, 0x92, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xee, 0x60, 0x00, 0x03, 0xbe,
    0x54, 0xcd, 0x50, 0x6e, 0xa7, 0xdc, 0x21, 0x9e, 0x83, 0x21, 0x4d, 0xe8,
    0x10, 0x02, 0x9e, 0x73, 0xbd, 0x70, 0x8d, 0x80, 0x6d, 0xb1, 0x3e, 0xb4,
    0x8e, 0xb0, 0x17, 0xdd, 0x62, 0x2a, 0xe6, 0x22, 0x12, 0xbe, 0x45, 0xdc,
    0x32, 0xdc, 0x6a, 0xe3, 0x6e, 0xc7, 0x67, 0x77, 0x77, 0x77, 0x77, 0x69,
    0xda, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xed,
    0x40, 0x00, 0x05, 0xce, 0x21, 0x9e, 0x71, 0x6e, 0xa3, 0xbe, 0x41, 0x9e,
    0x60, 0x00, 0x2b, 0xec, 0x20, 0x04, 0xce, 0x31, 0x7e, 0x92, 0x8d, 0x80,
    0x5d, 0xb1, 0x3e, 0xa2, 0x6d, 0xb1, 0x4c, 0xe6, 0x10, 0x2a, 0xe6, 0x00,
    0x02, 0xbe, 0x33, 0xcd, 0x30, 0xad, 0xbc, 0xa1, 0xae, 0xa6, 0x77, 0x77,
    0x77, 0x77, 0x76, 0xad, 0x79, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x1b, 0xeb, 0x30, 0x00, 0x06, 0xeb, 0x11, 0x7e, 0x92, 0x9e,
    0xa2, 0xae, 0x81, 0x9e, 0x71, 0x11, 0x17, 0xee, 0x70, 0x04, 0xce, 0x20,
    0x6e, 0xa2, 0x9d, 0x80, 0x5d, 0xb1, 0x3e, 0xa2, 0x5d, 0xb1, 0x8e, 0xa1,
    0x00, 0x2a, 0xe8, 0x11, 0x12, 0xbe, 0x33, 0xcc, 0x30, 0x6e, 0xee, 0x60,
    0xce, 0x95, 0x77, 0x77, 0x77, 0x77, 0x6c, 0xd7, 0x27, 0x20, 0x02, 0x34,
    0x66, 0x52, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xea, 0x20, 0x00, 0x07, 0xeb,
    0x11, 0x7e, 0xa2, 0x9e, 0xa1, 0x9e, 0x81, 0x9e, 0xed, 0xe6, 0x04, 0xce,
    0xc1, 0x05, 0xdd, 0x20, 0x4e, 0xb3, 0x8d, 0x80, 0x5d, 0xd1, 0x3e, 0xa3,
    0x7d, 0xa2, 0xae, 0x70, 0x00, 0x19, 0xee, 0xdd, 0x62, 0xbe, 0x34, 0xcb,
    0x20, 0x2d, 0xec, 0x30, 0xed, 0x86, 0x77, 0x77, 0x77, 0x77, 0x6c, 0xd8,
    0x54, 0x34, 0x46, 0x99, 0xab, 0xcb, 0x30, 0x00, 0x00, 0x00, 0x1e, 0xe9,
    0x20, 0x00, 0x07, 0xeb, 0x11, 0x7e, 0xa2, 0x9e, 0xa0, 0x8e, 0xa1, 0x9e,
    0xb8, 0x82, 0x01, 0x9e, 0xe5, 0x06, 0xec, 0x20, 0x3e, 0xc3, 0x8d, 0x80,
    0x5d, 0xe1, 0x3e, 0xc7, 0xbd, 0x43, 0xce, 0x40, 0x00, 0x09, 0xea, 0x77,
    0x32, 0xbe, 0x89, 0xd7, 0x10, 0x1a, 0xea, 0x20, 0xed, 0x86, 0x77, 0x77,
    0x77, 0x77, 0x77, 0xcd, 0xba, 0x77, 0x77, 0x66, 0x67, 0x9d, 0x61, 0x00,
    0x00, 0x00, 0x1e, 0xe9, 0x20, 0x00, 0x07, 0xeb, 0x11, 0x7e, 0xa2, 0x9e,
    0xa0, 0x8e, 0xb1, 0x9e, 0x81, 0x00, 0x00, 0x5d, 0xea, 0x06, 0xec, 0x20,
    0x3e, 0xc3, 0x8d, 0x80, 0x4c, 0xe1, 0x3e, 0xdd, 0xed, 0x34, 0xcd, 0x30,
    0x00, 0x09, 0xe7, 0x00, 0x02, 0xbe, 0xdd, 0xd6, 0x00, 0x18, 0xe8, 0x10,
    0xed, 0x86, 0x77, 0x77, 0x77, 0x77, 0x76, 0x77, 0x78, 0x76, 0x77, 0x77,
    0x77, 0x7b, 0x71, 0x00, 0x00, 0x00, 0x1e, 0xea, 0x20, 0x00, 0x07, 0xeb,
    0x11, 0x7e, 0xa2, 0x9e, 0xa0, 0x8e, 0xb1, 0x9e, 0x81, 0x00, 0x00, 0x2b,
    0xed, 0x35, 0xec, 0x20, 0x3e, 0xc3, 0x8d, 0x80, 0x4c, 0xd1, 0x3e, 0xb5,
    0xad, 0x84, 0xcc, 0x30, 0x00, 0x09, 0xe7, 0x00, 0x02, 0xbe, 0x67, 0xe9,
    0x20, 0x17, 0xe8, 0x10, 0xed, 0x86, 0x77, 0x77, 0x77, 0x77, 0x77, 0x76,
    0x67, 0x77, 0x77, 0x77, 0x77, 0x7b, 0x71, 0x00, 0x00, 0x00, 0x1c, 0xeb,
    0x30, 0x00, 0x07, 0xeb, 0x11, 0x7e, 0xa2, 0x9e, 0xa1, 0x9e, 0xa1, 0x9e,
    0x81, 0x00, 0x00, 0x08, 0xed, 0x74, 0xde, 0x20, 0x5e, 0xb3, 0x8d, 0x80,
    0x5d, 0xb1, 0x3e, 0xa2, 0x6d, 0xb4, 0xcd, 0x30, 0x00, 0x09, 0xe7, 0x00,
    0x02, 0xbe, 0x33, 0xcc, 0x30, 0x17, 0xe8, 0x10, 0xde, 0x95, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x8d, 0x50, 0x00,
    0x00, 0x00, 0x19, 0xee, 0x50, 0x00, 0x05, 0xdd, 0x11, 0x7e, 0x91, 0x9e,
    0xa2, 0xae, 0x81, 0x9e, 0x81, 0x00, 0x00, 0x04, 0xde, 0x94, 0xce, 0x30,
    0x6e, 0xa2, 0x9d, 0x80, 0x5d, 0xb1, 0x3e, 0xa2, 0x3d, 0xc6, 0xce, 0x40,
    0x00, 0x19, 0xe7, 0x00, 0x02, 0xbe, 0x32, 0xae, 0x40, 0x18, 0xe8, 0x10,
    0xae, 0xa6, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0xac, 0x30, 0x00, 0x00, 0x00, 0x05, 0xee, 0xa2, 0x00, 0x04, 0xce,
    0x21, 0xae, 0x71, 0x9e, 0xa2, 0xae, 0x61, 0x9e, 0x70, 0x00, 0x00, 0x03,
    0xce, 0xa3, 0xbe, 0x41, 0x8e, 0x81, 0x9e, 0x90, 0x6d, 0xa1, 0x3e, 0xa2,
    0x2d, 0xc6, 0xae, 0x81, 0x00, 0x2a, 0xe7, 0x00, 0x02, 0xbe, 0x32, 0xae,
    0x60, 0x19, 0xe8, 0x10, 0x6e, 0xb6, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x79, 0xc7, 0x10, 0x00, 0x00, 0x00, 0x02, 0xae,
    0xd8, 0x34, 0x33, 0xbe, 0x54, 0xcc, 0x40, 0x7e, 0xa4, 0xcd, 0x31, 0xae,
    0x60, 0x00, 0x00, 0x06, 0xde, 0x92, 0x9e, 0x72, 0xcd, 0x60, 0x8e, 0xb2,
    0x9e, 0x70, 0x3e, 0xa2, 0x1d, 0xd6, 0x7d, 0xc4, 0x11, 0x2a, 0xe7, 0x00,
    0x02, 0xbe, 0x31, 0x9e, 0x71, 0x19, 0xe8, 0x10, 0x3d, 0xd7, 0x67, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0xac, 0x72, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x5c, 0xee, 0xbc, 0x92, 0x9e, 0xbb, 0xd8, 0x10, 0x6e,
    0xcb, 0xea, 0x12, 0xbe, 0xb8, 0x88, 0x21, 0x5c, 0xed, 0x40, 0x7d, 0xca,
    0xe9, 0x20, 0x5e, 0xda, 0xcd, 0x40, 0x3e, 0xb3, 0x0d, 0xd6, 0x3b, 0xec,
    0x98, 0x5b, 0xeb, 0x88, 0x74, 0xbe, 0x41, 0x8e, 0x91, 0x19, 0xe7, 0x00,
    0x19, 0xe9, 0x67, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x7a,
    0xd6, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0xbe, 0xed, 0x70, 0x3b,
    0xed, 0x82, 0x00, 0x6e, 0xed, 0x93, 0x02, 0xde, 0xee, 0xed, 0x59, 0xde,
    0xe7, 0x10, 0x2b, 0xee, 0x92, 0x00, 0x1b, 0xee, 0xe8, 0x10, 0x3e, 0xc4,
    0x0d, 0xd6, 0x04, 0xbe, 0xea, 0x5b, 0xee, 0xee, 0xb5, 0xbe, 0x61, 0x8e,
    0x81, 0x19, 0xe6, 0x00, 0x04, 0xdd, 0x66, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0xbd, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x14, 0x43, 0x10, 0x02, 0x43, 0x10, 0x00, 0x14, 0x31, 0x10, 0x00, 0x12,
    0x44, 0x43, 0x3c, 0xdb, 0x51, 0x00, 0x01, 0x43, 0x10, 0x00, 0x01, 0x34,
    0x31, 0x00, 0x01, 0x10, 0x03, 0x31, 0x00, 0x13, 0x41, 0x01, 0x34, 0x44,
    0x21, 0x11, 0x10, 0x23, 0x10, 0x02, 0x42, 0x00, 0x01, 0x7d, 0xb5, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x7b, 0xc6, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x31, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x29, 0xd8, 0x57, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0xbb, 0x40,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x9d, 0x85, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x8b, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x29, 0xd8,
    0x56, 0x77, 0x77, 0x77, 0x78, 0xcb, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x01, 0x7c, 0xa6, 0x67, 0x77, 0x77, 0x8c, 0xb2, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x9c, 0x75, 0x67, 0x79,
    0xcb, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x02, 0x68, 0x64, 0x7c, 0xa3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xab, 0x57, 0x40, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xc7,
    0x66, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x03, 0xc8, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x79, 0x30, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00
};
#endif

//*****************************************************************************
//
// A bitmap for the Keil logo.  This logo is 128x40.
//
//*****************************************************************************
#if defined(rvmdk) || defined(__ARMCC_VERSION)
const unsigned char g_pucKeilLogo[2560] =
{
    0xa1, 0x00, 0x7b, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xb0, 0x00, 0x00, 0xab, 0xbb,
    0xbb, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x03, 0xbb, 0xbb, 0xbb, 0xb5, 0x00,
    0x1b, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xb6, 0x00, 0x00,
    0x4b, 0xbb, 0xbb, 0xbb, 0x30, 0x00, 0x07, 0xbb, 0xbb, 0xbb, 0xb0, 0x00,
    0x6b, 0x93, 0x71, 0x1a, 0xb9, 0x20, 0x07, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xb0,
    0x00, 0x00, 0xab, 0xbb, 0xbb, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x3b, 0xbb,
    0xbb, 0xbb, 0x50, 0x00, 0x1b, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xbb, 0xb6, 0x00, 0x00, 0x4b, 0xbb, 0xbb, 0xbb, 0x30, 0x00, 0x07, 0xbb,
    0xbb, 0xbb, 0xb0, 0x00, 0x09, 0x13, 0xa5, 0x6b, 0xbb, 0x82, 0x00, 0x7b,
    0xbb, 0x76, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x9b, 0xb0, 0x00, 0x00, 0xab, 0xbb, 0xbb, 0xb8, 0x00, 0x00,
    0x00, 0x03, 0xab, 0xbb, 0xbb, 0xb5, 0x00, 0x00, 0x1b, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xb6, 0x00, 0x00, 0x4b, 0xbb, 0xbb, 0xbb,
    0x30, 0x00, 0x07, 0xbb, 0xbb, 0xbb, 0xb0, 0x00, 0x09, 0x13, 0x76, 0x39,
    0xbb, 0xb8, 0x20, 0x17, 0xbb, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6b, 0xb0, 0x00, 0x00, 0xab, 0xbb,
    0xbb, 0xb8, 0x00, 0x00, 0x00, 0x3a, 0xbb, 0xbb, 0xbb, 0x50, 0x00, 0x00,
    0x1b, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xb6, 0x00, 0x00,
    0x4b, 0xbb, 0xbb, 0xbb, 0x30, 0x00, 0x07, 0xbb, 0xbb, 0xbb, 0xb0, 0x00,
    0x09, 0x13, 0x72, 0x19, 0xbb, 0xbb, 0x91, 0x01, 0x7b, 0xb7, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6b, 0xb0,
    0x00, 0x00, 0xab, 0xbb, 0xbb, 0xb8, 0x00, 0x00, 0x03, 0xab, 0xbb, 0xbb,
    0xb5, 0x00, 0x00, 0x00, 0x1b, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xbb, 0xb6, 0x00, 0x00, 0x4b, 0xbb, 0xbb, 0xbb, 0x30, 0x00, 0x07, 0xbb,
    0xbb, 0xbb, 0xb0, 0x00, 0x02, 0x01, 0x20, 0x02, 0xbb, 0xbb, 0xb9, 0x00,
    0x18, 0xbb, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x6b, 0xb0, 0x00, 0x00, 0xab, 0xbb, 0xbb, 0xb8, 0x00, 0x00,
    0x2a, 0xbb, 0xbb, 0xbb, 0x50, 0x00, 0x00, 0x00, 0x1b, 0xbb, 0xbb, 0xbb,
    0x61, 0x11, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00, 0x4b, 0xbb, 0xbb, 0xbb,
    0x30, 0x00, 0x07, 0xbb, 0xbb, 0xbb, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xbb, 0x66, 0xbb, 0x91, 0x00, 0x7b, 0xb7, 0x10, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6b, 0xb0, 0x00, 0x00, 0xab, 0xbb,
    0xbb, 0xb8, 0x00, 0x02, 0xbb, 0xbb, 0xbb, 0xb5, 0x00, 0x00, 0x00, 0x00,
    0x1b, 0xbb, 0xbb, 0xbb, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x4b, 0xbb, 0xbb, 0xbb, 0x30, 0x00, 0x07, 0xbb, 0xbb, 0xbb, 0xb0, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xbb, 0x60, 0x6b, 0xb8, 0x20, 0x08, 0xbb, 0x71,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6b, 0xb0,
    0x00, 0x00, 0xab, 0xbb, 0xbb, 0xb8, 0x00, 0x3a, 0xbb, 0xbb, 0xbb, 0x50,
    0x00, 0x00, 0x00, 0x00, 0x1b, 0xbb, 0xbb, 0xbb, 0x60, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x4b, 0xbb, 0xbb, 0xbb, 0x30, 0x00, 0x07, 0xbb,
    0xbb, 0xbb, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbb, 0x60, 0x06, 0xbb,
    0x82, 0x01, 0x7b, 0xb7, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x6b, 0xb0, 0x00, 0x00, 0xab, 0xbb, 0xbb, 0xb8, 0x03, 0xab,
    0xbb, 0xbb, 0xb5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0xbb, 0xbb, 0xbb,
    0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4b, 0xbb, 0xbb, 0xbb,
    0x30, 0x00, 0x07, 0xbb, 0xbb, 0xbb, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xbb, 0x60, 0x00, 0x6b, 0xb8, 0x10, 0x17, 0xbb, 0x70, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6b, 0xb0, 0x00, 0x00, 0xab, 0xbb,
    0xbb, 0xb8, 0x3a, 0xbb, 0xbb, 0xbb, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x1b, 0xbb, 0xbb, 0xbb, 0x97, 0x77, 0x77, 0x77, 0x77, 0x50, 0x00, 0x00,
    0x4b, 0xbb, 0xbb, 0xbb, 0x30, 0x00, 0x07, 0xbb, 0xbb, 0xbb, 0xb0, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xbb, 0x60, 0x00, 0x16, 0xbb, 0x90, 0x01, 0x8b,
    0xb7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6b, 0xb0,
    0x00, 0x00, 0xab, 0xbb, 0xbb, 0xba, 0xab, 0xbb, 0xbb, 0xb5, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x1b, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xbb, 0x80, 0x00, 0x00, 0x4b, 0xbb, 0xbb, 0xbb, 0x30, 0x00, 0x07, 0xbb,
    0xbb, 0xbb, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbb, 0x60, 0x00, 0x00,
    0x6b, 0xb9, 0x10, 0x08, 0xbb, 0x71, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x6b, 0xb0, 0x00, 0x00, 0xab, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xbb, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0x80, 0x00, 0x00, 0x4b, 0xbb, 0xbb, 0xbb,
    0x30, 0x00, 0x07, 0xbb, 0xbb, 0xbb, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xbb, 0x60, 0x00, 0x00, 0x06, 0xbb, 0x91, 0x00, 0x8b, 0xb7, 0x10, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6b, 0xb0, 0x00, 0x00, 0xab, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xb6, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x1b, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0x80, 0x00, 0x00,
    0x4b, 0xbb, 0xbb, 0xbb, 0x30, 0x00, 0x07, 0xbb, 0xbb, 0xbb, 0xb0, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xbb, 0x60, 0x00, 0x00, 0x00, 0x6b, 0xb8, 0x20,
    0x08, 0xbb, 0x71, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6b, 0xb0,
    0x00, 0x00, 0xab, 0xbb, 0xbb, 0xba, 0x9b, 0xbb, 0xbb, 0xbb, 0x60, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x1b, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xbb, 0x80, 0x00, 0x00, 0x4b, 0xbb, 0xbb, 0xbb, 0x30, 0x00, 0x07, 0xbb,
    0xbb, 0xbb, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbb, 0x60, 0x00, 0x00,
    0x00, 0x06, 0xbb, 0x82, 0x01, 0x7b, 0xb7, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x6b, 0xb0, 0x00, 0x00, 0xab, 0xbb, 0xbb, 0xb8, 0x29, 0xbb,
    0xbb, 0xbb, 0xb5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0xbb, 0xbb, 0xbb,
    0x85, 0x55, 0x55, 0x55, 0x55, 0x40, 0x00, 0x00, 0x4b, 0xbb, 0xbb, 0xbb,
    0x30, 0x00, 0x07, 0xbb, 0xbb, 0xbb, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xbb, 0x60, 0x00, 0x00, 0x00, 0x01, 0x6b, 0xb9, 0x10, 0x17, 0xbb, 0x70,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6b, 0xb0, 0x00, 0x00, 0xab, 0xbb,
    0xbb, 0xb8, 0x02, 0x9b, 0xbb, 0xbb, 0xbb, 0x60, 0x00, 0x00, 0x00, 0x00,
    0x1b, 0xbb, 0xbb, 0xbb, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x4b, 0xbb, 0xbb, 0xbb, 0x30, 0x00, 0x07, 0xbb, 0xbb, 0xbb, 0xb0, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xbb, 0x60, 0x00, 0x00, 0x00, 0x00, 0x16, 0xbb,
    0x90, 0x01, 0x8b, 0xb7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6b, 0xb0,
    0x00, 0x00, 0xab, 0xbb, 0xbb, 0xb8, 0x00, 0x1a, 0xbb, 0xbb, 0xbb, 0xb5,
    0x00, 0x00, 0x00, 0x00, 0x1b, 0xbb, 0xbb, 0xbb, 0x60, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x4b, 0xbb, 0xbb, 0xbb, 0x30, 0x00, 0x07, 0xbb,
    0xbb, 0xbb, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbb, 0x60, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x6b, 0xb9, 0x10, 0x08, 0xbb, 0x71, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x6b, 0xb0, 0x00, 0x00, 0xab, 0xbb, 0xbb, 0xb8, 0x00, 0x01,
    0xab, 0xbb, 0xbb, 0xbb, 0x50, 0x00, 0x00, 0x00, 0x1b, 0xbb, 0xbb, 0xbb,
    0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4b, 0xbb, 0xbb, 0xbb,
    0x30, 0x00, 0x07, 0xbb, 0xbb, 0xbb, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xbb, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xbb, 0x70, 0x00, 0xbb,
    0xb5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6b, 0xb0, 0x00, 0x00, 0xab, 0xbb,
    0xbb, 0xb8, 0x00, 0x00, 0x29, 0xbb, 0xbb, 0xbb, 0xb5, 0x00, 0x00, 0x00,
    0x1b, 0xbb, 0xbb, 0xbb, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x4b, 0xbb, 0xbb, 0xbb, 0x30, 0x00, 0x07, 0xbb, 0xbb, 0xbb, 0xb3, 0x33,
    0x33, 0x33, 0x33, 0x33, 0xbb, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a,
    0xba, 0x40, 0x04, 0xbb, 0x93, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6b, 0xb0,
    0x00, 0x00, 0xab, 0xbb, 0xbb, 0xb8, 0x00, 0x00, 0x02, 0x9b, 0xbb, 0xbb,
    0xbb, 0x50, 0x00, 0x00, 0x1b, 0xbb, 0xbb, 0xbb, 0x85, 0x55, 0x55, 0x55,
    0x55, 0x53, 0x00, 0x00, 0x4b, 0xbb, 0xbb, 0xbb, 0x30, 0x00, 0x07, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0x60, 0x00, 0x00,
    0x00, 0x00, 0x03, 0x9b, 0xb4, 0x00, 0x4a, 0xb9, 0x30, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x6b, 0xb0, 0x00, 0x00, 0xab, 0xbb, 0xbb, 0xb8, 0x00, 0x00,
    0x00, 0x29, 0xbb, 0xbb, 0xbb, 0xb5, 0x00, 0x00, 0x1b, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xb6, 0x00, 0x00, 0x4b, 0xbb, 0xbb, 0xbb,
    0x30, 0x00, 0x07, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xbb, 0x60, 0x00, 0x00, 0x00, 0x00, 0x29, 0xbb, 0x40, 0x04, 0xab, 0xa2,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6b, 0xb0, 0x00, 0x00, 0xab, 0xbb,
    0xbb, 0xb8, 0x00, 0x00, 0x00, 0x02, 0xab, 0xbb, 0xbb, 0xbb, 0x50, 0x00,
    0x1b, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xb6, 0x00, 0x00,
    0x4b, 0xbb, 0xbb, 0xbb, 0x30, 0x00, 0x07, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0x60, 0x00, 0x00, 0x00, 0x02, 0xab, 0xb4,
    0x00, 0x4a, 0xbb, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6b, 0xb0,
    0x00, 0x00, 0xab, 0xbb, 0xbb, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x1b, 0xbb,
    0xbb, 0xbb, 0xb5, 0x00, 0x1b, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xbb, 0xb6, 0x00, 0x00, 0x4b, 0xbb, 0xbb, 0xbb, 0x30, 0x00, 0x07, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0x60, 0x00, 0x00,
    0x00, 0x2b, 0xba, 0x40, 0x04, 0xbb, 0xa2, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x6b, 0xb0, 0x00, 0x00, 0xab, 0xbb, 0xbb, 0xb8, 0x00, 0x00,
    0x00, 0x00, 0x01, 0xab, 0xbb, 0xbb, 0xbb, 0x50, 0x1b, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xb6, 0x00, 0x00, 0x4b, 0xbb, 0xbb, 0xbb,
    0x30, 0x00, 0x07, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xbb, 0x60, 0x00, 0x00, 0x02, 0xab, 0xa4, 0x00, 0x4b, 0xb9, 0x30, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6b, 0xb0, 0x00, 0x00, 0x78, 0x88,
    0x88, 0x85, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x88, 0x88, 0x88, 0x82,
    0x18, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x84, 0x00, 0x00,
    0x38, 0x88, 0x88, 0x88, 0x20, 0x00, 0x05, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0xbb, 0x60, 0x00, 0x00, 0x39, 0xba, 0x40, 0x04,
    0xbb, 0x93, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6b, 0xb0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbb, 0x60, 0x00, 0x03,
    0x9b, 0xb4, 0x00, 0x4a, 0xba, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x6b, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xbb, 0x60, 0x00, 0x2a, 0xbb, 0x40, 0x04, 0xab, 0xb2, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6b, 0xb0, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xbb, 0x60, 0x01, 0xab, 0xb4, 0x00, 0x3b, 0xbb,
    0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6b, 0xb0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x6d, 0xec, 0x20, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbb, 0x60, 0x2a, 0xba,
    0x40, 0x04, 0xbb, 0xa2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x6b, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16,
    0x84, 0x34, 0xa3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xbb, 0x62, 0x9b, 0xa4, 0x00, 0x3b, 0xb9, 0x30, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6b, 0xb0, 0x00, 0x00, 0x00, 0x13,
    0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x20, 0x01, 0x56, 0x52, 0x01,
    0x51, 0x00, 0x15, 0x36, 0x5a, 0xb7, 0x35, 0x00, 0x00, 0x26, 0x66, 0x10,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xbb, 0x99, 0xbb, 0x40, 0x04, 0xab, 0xa3, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6b, 0xb0,
    0x00, 0x00, 0x00, 0x5b, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x80,
    0x01, 0xd8, 0x97, 0x12, 0xd8, 0x10, 0x6f, 0x66, 0x49, 0x96, 0x25, 0x00,
    0x04, 0x98, 0x88, 0x71, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbb, 0xbb, 0xb4, 0x00,
    0x4a, 0xba, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x6b, 0xb0, 0x00, 0x00, 0x01, 0x8c, 0x71, 0x04, 0x89, 0x81,
    0x00, 0x00, 0x5c, 0xa3, 0x01, 0xc1, 0x48, 0x22, 0xda, 0x74, 0x9e, 0x56,
    0x58, 0x86, 0x35, 0x00, 0x0a, 0x51, 0x00, 0x40, 0x06, 0xaa, 0x21, 0x56,
    0x94, 0x4a, 0x41, 0x9b, 0x93, 0x29, 0xa4, 0x16, 0x8a, 0x72, 0x52, 0x27,
    0xbb, 0xbb, 0x40, 0x03, 0xab, 0xb2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6b, 0xb0, 0x00, 0x00, 0x03, 0x95,
    0x92, 0x07, 0xb5, 0xb3, 0x00, 0x00, 0xa5, 0x67, 0x01, 0xc1, 0x59, 0x22,
    0xc4, 0xbc, 0x5c, 0x56, 0x82, 0x16, 0xb3, 0x00, 0x2b, 0x00, 0x00, 0x00,
    0x58, 0x45, 0xb2, 0x8b, 0x5c, 0x87, 0x83, 0xd5, 0x69, 0x23, 0x5b, 0x29,
    0xa5, 0xc3, 0x75, 0x56, 0xbb, 0xb4, 0x00, 0x3b, 0xbb, 0x31, 0x11, 0x11,
    0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x7b, 0xb0,
    0x00, 0x00, 0x07, 0x82, 0xa7, 0x17, 0x91, 0xa4, 0x00, 0x04, 0xa2, 0x5a,
    0x21, 0xde, 0xc4, 0x02, 0xc1, 0x45, 0x1c, 0x40, 0x6d, 0xea, 0x10, 0x00,
    0x3b, 0x00, 0x00, 0x01, 0x75, 0x00, 0xa4, 0x75, 0x0c, 0x34, 0x84, 0xd2,
    0x28, 0x53, 0xdd, 0x29, 0x71, 0xc3, 0x59, 0xb3, 0xba, 0x50, 0x03, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xb0, 0x00, 0x00, 0x2b, 0xcc, 0xcd, 0x27, 0x91, 0xa6,
    0x00, 0x07, 0xcc, 0xcc, 0x62, 0xc2, 0x79, 0x12, 0xc1, 0x00, 0x0c, 0x40,
    0x00, 0x00, 0x00, 0x00, 0x1b, 0x50, 0x00, 0x21, 0x76, 0x01, 0xb4, 0x75,
    0x0b, 0x34, 0x84, 0xd2, 0x28, 0x7a, 0x4c, 0x29, 0x61, 0xc4, 0x2a, 0xb1,
    0xa5, 0x00, 0x3b, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xb0, 0x00, 0x00, 0x68, 0x00,
    0x09, 0x77, 0x91, 0xa6, 0x00, 0x39, 0x20, 0x05, 0x94, 0xc1, 0x28, 0x73,
    0xc1, 0x00, 0x0c, 0x40, 0x00, 0x00, 0x00, 0x00, 0x04, 0x97, 0x66, 0x71,
    0x48, 0x78, 0x92, 0x75, 0x0b, 0x34, 0x84, 0xd8, 0x88, 0x5a, 0x7d, 0x49,
    0x61, 0xc4, 0x18, 0x50, 0x40, 0x00, 0x45, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x50,
    0x00, 0x00, 0x43, 0x00, 0x02, 0x53, 0x40, 0x53, 0x00, 0x24, 0x10, 0x01,
    0x42, 0x50, 0x02, 0x52, 0x50, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x37, 0x77, 0x20, 0x04, 0x77, 0x10, 0x32, 0x05, 0x12, 0x33, 0xd8,
    0x62, 0x16, 0x66, 0x44, 0x30, 0x52, 0x38, 0x30, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x02, 0xd2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x67, 0x10,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xd2, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x02, 0x84, 0x00
};
#endif

//*****************************************************************************
//
// A bitmap for the "Press Button To Play" image.  This image is 128x16.
//
//*****************************************************************************
const unsigned char g_pucPlay[1024] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xff, 0xfe, 0x91, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2b, 0xff, 0xea, 0x10,
    0x00, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x02, 0xe0, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x03, 0xff, 0xfe, 0x91, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x02, 0xca, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xe8, 0x10, 0x28, 0x10, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x03, 0xf0, 0x00, 0x00, 0x00, 0x03, 0xf0, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf0, 0x02, 0xca, 0x3f, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x00,
    0x4f, 0x3f, 0x8e, 0xf0, 0x19, 0xff, 0xb1, 0x00, 0x5e, 0xfe, 0x70, 0x5e,
    0xfe, 0x70, 0x00, 0x02, 0xf0, 0x00, 0x00, 0x00, 0x01, 0x9f, 0xfb, 0x10,
    0x3f, 0x00, 0x19, 0xff, 0xb1, 0x00, 0x1b, 0xff, 0x8f, 0xff, 0xf0, 0x00,
    0x00, 0x03, 0xf0, 0x00, 0x1b, 0xff, 0x90, 0x00, 0x00, 0x03, 0xf0, 0x00,
    0x4f, 0x3f, 0x00, 0x2e, 0xfd, 0x40, 0x7c, 0x00, 0x0a, 0x90, 0x00, 0x00,
    0x00, 0x00, 0xf0, 0x00, 0x4e, 0x3f, 0x71, 0x00, 0xab, 0x11, 0xba, 0x01,
    0xf4, 0x04, 0x81, 0xf4, 0x04, 0x80, 0x00, 0x00, 0xfa, 0x41, 0x00, 0x00,
    0x0a, 0xb1, 0x1b, 0xa0, 0x3f, 0x00, 0xab, 0x11, 0xba, 0x00, 0xba, 0x12,
    0x93, 0xf0, 0x00, 0x00, 0x00, 0x03, 0xf0, 0x00, 0xba, 0x12, 0xc8, 0x00,
    0x00, 0x03, 0xf0, 0x00, 0x4e, 0x3f, 0x00, 0x00, 0x06, 0xd0, 0x2f, 0x20,
    0x1f, 0x30, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x03, 0xd8, 0x3f, 0x00, 0x01,
    0xf2, 0x00, 0x4e, 0x01, 0xf4, 0x00, 0x01, 0xf4, 0x00, 0x00, 0x00, 0x00,
    0x3c, 0xff, 0xe9, 0x10, 0x1f, 0x20, 0x04, 0xe0, 0x3f, 0x01, 0xf2, 0x00,
    0x4e, 0x01, 0xf2, 0x00, 0x03, 0xf0, 0x00, 0x00, 0x00, 0x03, 0xf0, 0x01,
    0xf2, 0x00, 0x4e, 0x00, 0x00, 0x03, 0xf0, 0x03, 0xd8, 0x3f, 0x00, 0x3b,
    0xef, 0xf0, 0x0b, 0x80, 0x6d, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xfe,
    0x80, 0x3f, 0x00, 0x02, 0xff, 0xff, 0xff, 0x00, 0x6d, 0xfb, 0x30, 0x6d,
    0xfb, 0x30, 0x00, 0x00, 0x00, 0x03, 0x6d, 0xc0, 0x2f, 0xff, 0xff, 0xf0,
    0x3f, 0x02, 0xff, 0xff, 0xff, 0x02, 0xf0, 0x00, 0x03, 0xf0, 0x00, 0x00,
    0x00, 0x03, 0xf0, 0x02, 0xf0, 0x00, 0x3f, 0x00, 0x00, 0x03, 0xff, 0xfe,
    0x80, 0x3f, 0x00, 0xe9, 0x23, 0xf0, 0x05, 0xe0, 0xc7, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xf0, 0x00, 0x00, 0x3f, 0x00, 0x01, 0xf2, 0x00, 0x00, 0x00,
    0x00, 0x17, 0xe0, 0x00, 0x17, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf0,
    0x1f, 0x20, 0x00, 0x00, 0x3f, 0x01, 0xf2, 0x00, 0x00, 0x01, 0xf2, 0x00,
    0x02, 0xf0, 0x00, 0x00, 0x00, 0x03, 0xf0, 0x01, 0xf2, 0x00, 0x5e, 0x00,
    0x00, 0x03, 0xf0, 0x00, 0x00, 0x3f, 0x02, 0xf0, 0x03, 0xf0, 0x00, 0xf5,
    0xf1, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x00, 0x00, 0x3f, 0x00, 0x00,
    0xad, 0x30, 0x3b, 0x02, 0x92, 0x07, 0xe2, 0x92, 0x07, 0xe0, 0x00, 0x02,
    0xb4, 0x10, 0x2b, 0xa0, 0x0a, 0xd3, 0x03, 0xb0, 0x3f, 0x00, 0xad, 0x30,
    0x3b, 0x00, 0xba, 0x12, 0x91, 0xf3, 0x00, 0x00, 0x00, 0x03, 0xf0, 0x00,
    0xba, 0x12, 0xc8, 0x00, 0x00, 0x03, 0xf0, 0x00, 0x00, 0x3f, 0x01, 0xf4,
    0x1a, 0xf0, 0x00, 0x9f, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x00,
    0x00, 0x3f, 0x00, 0x00, 0x19, 0xef, 0xea, 0x01, 0xbf, 0xfd, 0x31, 0xbf,
    0xfd, 0x30, 0x00, 0x01, 0x9d, 0xff, 0xe8, 0x00, 0x01, 0x9e, 0xfe, 0xa0,
    0x3f, 0x00, 0x19, 0xef, 0xea, 0x00, 0x1b, 0xff, 0x80, 0x9f, 0xf0, 0x00,
    0x00, 0x03, 0xf0, 0x00, 0x1b, 0xff, 0x90, 0x00, 0x00, 0x03, 0xf0, 0x00,
    0x00, 0x3f, 0x00, 0x6f, 0xfa, 0xf0, 0x00, 0x3f, 0x40, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xf2, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00
};

//*****************************************************************************
//
// A bitmap for the "Game Over" image.  This image is 74x13.
//
//*****************************************************************************
const unsigned char g_pucGameOver[481] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x2a, 0xef, 0xfc, 0x60, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x5c, 0xff, 0xb3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x03, 0xf8, 0x10, 0x15, 0xc0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x05, 0xf6, 0x11, 0x7f, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x80, 0x00, 0x00, 0x00, 0x02, 0xef,
    0xd4, 0x03, 0xf9, 0xff, 0x6a, 0xff, 0x50, 0x01, 0x9f, 0xfb, 0x10, 0x00,
    0x00, 0x0d, 0x70, 0x00, 0x09, 0xa0, 0x7c, 0x00, 0x09, 0x90, 0x19, 0xff,
    0xb1, 0x03, 0xf8, 0xef, 0x00, 0x00, 0x1f, 0x20, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x6d, 0x03, 0xf7, 0x17, 0xf7, 0x07, 0xd0, 0x0a, 0xb1, 0x1b, 0xa0,
    0x00, 0x00, 0x1f, 0x10, 0x00, 0x04, 0xe0, 0x2f, 0x20, 0x0f, 0x30, 0xab,
    0x11, 0xba, 0x03, 0xf7, 0x10, 0x00, 0x00, 0x2f, 0x00, 0x08, 0xff, 0xf0,
    0x03, 0xbe, 0xff, 0x03, 0xf0, 0x03, 0xf0, 0x03, 0xf0, 0x1f, 0x20, 0x04,
    0xe0, 0x00, 0x00, 0x2f, 0x00, 0x00, 0x03, 0xf0, 0x0b, 0x70, 0x5d, 0x01,
    0xf2, 0x00, 0x4e, 0x03, 0xf0, 0x00, 0x00, 0x00, 0x1f, 0x20, 0x00, 0x03,
    0xf0, 0x0e, 0x92, 0x3f, 0x03, 0xf0, 0x03, 0xf0, 0x03, 0xf0, 0x2f, 0xff,
    0xff, 0xf0, 0x00, 0x00, 0x1f, 0x10, 0x00, 0x04, 0xe0, 0x05, 0xd0, 0xb7,
    0x02, 0xff, 0xff, 0xff, 0x03, 0xf0, 0x00, 0x00, 0x00, 0x0c, 0x80, 0x00,
    0x03, 0xf0, 0x2f, 0x00, 0x3f, 0x03, 0xf0, 0x03, 0xf0, 0x03, 0xf0, 0x1f,
    0x20, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x70, 0x00, 0x09, 0xa0, 0x00, 0xf4,
    0xf1, 0x01, 0xf2, 0x00, 0x00, 0x03, 0xf0, 0x00, 0x00, 0x00, 0x03, 0xf8,
    0x20, 0x17, 0xf0, 0x1f, 0x41, 0xaf, 0x03, 0xf0, 0x03, 0xf0, 0x03, 0xf0,
    0x0a, 0xd3, 0x03, 0xb0, 0x00, 0x00, 0x05, 0xf6, 0x11, 0x7f, 0x20, 0x00,
    0x9e, 0xb0, 0x00, 0xad, 0x30, 0x3b, 0x03, 0xf0, 0x00, 0x00, 0x00, 0x00,
    0x3a, 0xef, 0xfb, 0x60, 0x06, 0xff, 0xaf, 0x03, 0xf0, 0x03, 0xf0, 0x03,
    0xf0, 0x01, 0x9e, 0xfe, 0xa0, 0x00, 0x00, 0x00, 0x5c, 0xff, 0xb3, 0x00,
    0x00, 0x3f, 0x50, 0x00, 0x19, 0xef, 0xea, 0x03, 0xf0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00
};

//*****************************************************************************
//
// A bitmap for the "Score:" image.  This image is 44x13.
//
//*****************************************************************************
const unsigned char g_pucScore[286] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xbf, 0xfe,
    0xa1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x81, 0x02, 0x81, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0x00, 0x00, 0x00, 0x00, 0x1b, 0xff,
    0x80, 0x1b, 0xff, 0x90, 0x03, 0xf8, 0xef, 0x01, 0x9f, 0xfb, 0x10, 0x03,
    0xf0, 0x00, 0x00, 0x0f, 0xa4, 0x10, 0x00, 0x00, 0xba, 0x12, 0x90, 0xba,
    0x12, 0xc8, 0x03, 0xf7, 0x10, 0x0a, 0xb1, 0x1b, 0xa0, 0x02, 0xd0, 0x00,
    0x00, 0x03, 0xcf, 0xfe, 0x91, 0x01, 0xf2, 0x00, 0x01, 0xf2, 0x00, 0x4e,
    0x03, 0xf0, 0x00, 0x1f, 0x20, 0x04, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x36, 0xdc, 0x02, 0xf0, 0x00, 0x02, 0xf0, 0x00, 0x3f, 0x03, 0xf0,
    0x00, 0x2f, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x3f, 0x01, 0xf2, 0x00, 0x01, 0xf2, 0x00, 0x5e, 0x03, 0xf0, 0x00, 0x1f,
    0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2b, 0x41, 0x02, 0xba, 0x00,
    0xba, 0x12, 0x90, 0xba, 0x12, 0xc8, 0x03, 0xf0, 0x00, 0x0a, 0xd3, 0x03,
    0xb0, 0x02, 0xd0, 0x00, 0x00, 0x19, 0xdf, 0xfe, 0x80, 0x00, 0x1b, 0xff,
    0x80, 0x1b, 0xff, 0x90, 0x03, 0xf0, 0x00, 0x01, 0x9e, 0xfe, 0xa0, 0x03,
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

//*****************************************************************************
//
// A bitmap for the "." image.  This image is 4x13.
//
//*****************************************************************************
const unsigned char g_pucDot[26] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2d, 0x00, 0x3f, 0x00, 0x00, 0x00,
    0x00, 0x00
};

//*****************************************************************************
//
// Bitmaps for the decimal digits, used for displaying the score.  Each image
// is 8x13.
//
//*****************************************************************************
const unsigned char g_ppucDigits[10][52] =
{
    //
    // Zero.
    //
    {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xbf, 0xf9, 0x00,
        0x0a, 0xa1, 0x2d, 0x70, 0x0f, 0x20, 0x06, 0xc0, 0x2f, 0x00, 0x03, 0xf0,
        0x2f, 0x00, 0x03, 0xf0, 0x2f, 0x00, 0x03, 0xf0, 0x0f, 0x20, 0x06, 0xc0,
        0x0a, 0xa1, 0x2d, 0x70, 0x01, 0xbf, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00
    },

    //
    // One.
    //
    {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0x00, 0x00,
        0x0f, 0xff, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00,
        0x00, 0x3f, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00,
        0x00, 0x3f, 0x00, 0x00, 0x0f, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00
    },

    //
    // Two.
    //
    {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xc2, 0x00,
        0x48, 0x11, 0x9c, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x6d, 0x00,
        0x00, 0x02, 0xe4, 0x00, 0x00, 0x1d, 0x70, 0x00, 0x02, 0xd7, 0x00, 0x00,
        0x7f, 0x60, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00
    },

    //
    // Three.
    //
    {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0xff, 0xd4, 0x00,
        0x00, 0x00, 0x6f, 0x00, 0x00, 0x02, 0xaa, 0x00, 0x00, 0xff, 0x90, 0x00,
        0x00, 0x02, 0xc9, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x4e, 0x00,
        0xd5, 0x02, 0xc8, 0x00, 0xae, 0xfe, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00
    },

    //
    // Four.
    //
    {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9f, 0x00,
        0x00, 0x08, 0xdf, 0x00, 0x00, 0x6c, 0x3f, 0x00, 0x05, 0xd1, 0x3f, 0x00,
        0x3d, 0x10, 0x3f, 0x00, 0x5f, 0xff, 0xff, 0xd0, 0x00, 0x00, 0x3f, 0x00,
        0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00
    },

    //
    // Five.
    //
    {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0x00,
        0x3f, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xb1, 0x00,
        0x01, 0x01, 0xbb, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x4e, 0x00,
        0x26, 0x11, 0xc9, 0x00, 0x1c, 0xff, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00
    },

    //
    // Six.
    //
    {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0xfd, 0x00,
        0x04, 0xe5, 0x00, 0x00, 0x0c, 0x50, 0x00, 0x00, 0x1f, 0xbf, 0xfb, 0x10,
        0x2f, 0x40, 0x1b, 0xa0, 0x2f, 0x00, 0x03, 0xf0, 0x0f, 0x30, 0x04, 0xe0,
        0x0a, 0xc1, 0x1b, 0x90, 0x01, 0xaf, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00
    },

    //
    // Seven.
    //
    {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00,
        0x00, 0x00, 0x4e, 0x00, 0x00, 0x00, 0xd6, 0x00, 0x00, 0x05, 0xe0, 0x00,
        0x00, 0x0e, 0x60, 0x00, 0x00, 0x6d, 0x00, 0x00, 0x00, 0xe5, 0x00, 0x00,
        0x07, 0xd0, 0x00, 0x00, 0x1f, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00
    },

    //
    // Eight.
    //
    {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xcf, 0xfb, 0x20,
        0x1f, 0x61, 0x19, 0xd0, 0x2f, 0x10, 0x03, 0xf0, 0x09, 0xe8, 0x39, 0x80,
        0x03, 0xba, 0xdf, 0x30, 0x0f, 0x40, 0x08, 0xd0, 0x2f, 0x00, 0x03, 0xf0,
        0x0e, 0x91, 0x1a, 0xb0, 0x03, 0xcf, 0xfa, 0x10, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00
    },

    //
    // Nine.
    {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xbf, 0xf8, 0x00,
        0x0c, 0x91, 0x2d, 0x70, 0x1f, 0x10, 0x05, 0xd0, 0x2f, 0x10, 0x03, 0xf0,
        0x0e, 0x81, 0x16, 0xf0, 0x03, 0xcf, 0xeb, 0xd0, 0x00, 0x00, 0x08, 0x90,
        0x00, 0x01, 0x6e, 0x20, 0x02, 0xff, 0xb2, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00
    }
};

//*****************************************************************************
//
// An array of sprites used in the game.
//
//*****************************************************************************
const unsigned char g_ppucSprites[56][72] =
{
    //
    // 0: Blank background.
    //
    // ............
    // ............
    // ............
    // ............
    // ............
    // ............
    // ............
    // ............
    // ............
    // ............
    // ............
    // ............
    //
    {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    },

    //
    // 1: Wall with connection to wall above.
    //
    // 55.FFFFF.AAA
    // 55.FFFFF.AAA
    // 55.FFFFF.AAA
    // 55.FFFFF.AAA
    // 55.FFFFF.AAA
    // 55.FFFFF.AAA
    // 55.FFFFF.AAA
    // 55.FFFFF.AAA
    // 55.......AAA
    // 55.AAAAAA.AA
    // 5.AAAAAAAA.A
    // .AAAAAAAAAA.
    //
    {
        0x55, 0x0f, 0xff, 0xff, 0x0a, 0xaa,
        0x55, 0x0f, 0xff, 0xff, 0x0a, 0xaa,
        0x55, 0x0f, 0xff, 0xff, 0x0a, 0xaa,
        0x55, 0x0f, 0xff, 0xff, 0x0a, 0xaa,
        0x55, 0x0f, 0xff, 0xff, 0x0a, 0xaa,
        0x55, 0x0f, 0xff, 0xff, 0x0a, 0xaa,
        0x55, 0x0f, 0xff, 0xff, 0x0a, 0xaa,
        0x55, 0x0f, 0xff, 0xff, 0x0a, 0xaa,
        0x55, 0x00, 0x00, 0x00, 0x0a, 0xaa,
        0x55, 0x0a, 0xaa, 0xaa, 0xa0, 0xaa,
        0x50, 0xaa, 0xaa, 0xaa, 0xaa, 0x0a,
        0x0a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa0
    },

    //
    // 2: Wall with connection to wall below.
    //
    // .5555555555.
    // 5.55555555.A
    // 55........AA
    // 55.FFFFF.AAA
    // 55.FFFFF.AAA
    // 55.FFFFF.AAA
    // 55.FFFFF.AAA
    // 55.FFFFF.AAA
    // 55.FFFFF.AAA
    // 55.FFFFF.AAA
    // 55.FFFFF.AAA
    // 55.FFFFF.AAA
    //
    {
        0x05, 0x55, 0x55, 0x55, 0x55, 0x50,
        0x50, 0x55, 0x55, 0x55, 0x55, 0x0a,
        0x55, 0x00, 0x00, 0x00, 0x00, 0xaa,
        0x55, 0x0f, 0xff, 0xff, 0x0a, 0xaa,
        0x55, 0x0f, 0xff, 0xff, 0x0a, 0xaa,
        0x55, 0x0f, 0xff, 0xff, 0x0a, 0xaa,
        0x55, 0x0f, 0xff, 0xff, 0x0a, 0xaa,
        0x55, 0x0f, 0xff, 0xff, 0x0a, 0xaa,
        0x55, 0x0f, 0xff, 0xff, 0x0a, 0xaa,
        0x55, 0x0f, 0xff, 0xff, 0x0a, 0xaa,
        0x55, 0x0f, 0xff, 0xff, 0x0a, 0xaa,
        0x55, 0x0f, 0xff, 0xff, 0x0a, 0xaa
    },

    //
    // 3: Wall with connection to walls above and below.
    //
    // 55.FFFFF.AAA
    // 55.FFFFF.AAA
    // 55.FFFFF.AAA
    // 55.FFFFF.AAA
    // 55.FFFFF.AAA
    // 55.FFFFF.AAA
    // 55.FFFFF.AAA
    // 55.FFFFF.AAA
    // 55.FFFFF.AAA
    // 55.FFFFF.AAA
    // 55.FFFFF.AAA
    // 55.FFFFF.AAA
    //
    {
        0x55, 0x0f, 0xff, 0xff, 0x0a, 0xaa,
        0x55, 0x0f, 0xff, 0xff, 0x0a, 0xaa,
        0x55, 0x0f, 0xff, 0xff, 0x0a, 0xaa,
        0x55, 0x0f, 0xff, 0xff, 0x0a, 0xaa,
        0x55, 0x0f, 0xff, 0xff, 0x0a, 0xaa,
        0x55, 0x0f, 0xff, 0xff, 0x0a, 0xaa,
        0x55, 0x0f, 0xff, 0xff, 0x0a, 0xaa,
        0x55, 0x0f, 0xff, 0xff, 0x0a, 0xaa,
        0x55, 0x0f, 0xff, 0xff, 0x0a, 0xaa,
        0x55, 0x0f, 0xff, 0xff, 0x0a, 0xaa,
        0x55, 0x0f, 0xff, 0xff, 0x0a, 0xaa,
        0x55, 0x0f, 0xff, 0xff, 0x0a, 0xaa
    },

    //
    // 4: Wall with connection to wall to the right.
    //
    // .55555555555
    // 5.5555555555
    // 55..........
    // 55.FFFFFFFFF
    // 55.FFFFFFFFF
    // 55.FFFFFFFFF
    // 55.FFFFFFFFF
    // 55.FFFFFFFFF
    // 55..........
    // 55.AAAAAAAAA
    // 5.AAAAAAAAAA
    // .AAAAAAAAAAA
    //
    {
        0x05, 0x55, 0x55, 0x55, 0x55, 0x55,
        0x50, 0x55, 0x55, 0x55, 0x55, 0x55,
        0x55, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x55, 0x0f, 0xff, 0xff, 0xff, 0xff,
        0x55, 0x0f, 0xff, 0xff, 0xff, 0xff,
        0x55, 0x0f, 0xff, 0xff, 0xff, 0xff,
        0x55, 0x0f, 0xff, 0xff, 0xff, 0xff,
        0x55, 0x0f, 0xff, 0xff, 0xff, 0xff,
        0x55, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x55, 0x0a, 0xaa, 0xaa, 0xaa, 0xaa,
        0x50, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
        0x0a, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa
    },

    //
    // 5: Wall with connections to wall above and to the right.
    //
    // 55.FFFFF.AA.
    // 55.FFFFF.A.5
    // 55.FFFFF....
    // 55.FFFFFFFFF
    // 55.FFFFFFFFF
    // 55.FFFFFFFFF
    // 55.FFFFFFFFF
    // 55.FFFFFFFFF
    // 55..........
    // 55.AAAAAAAAA
    // 5.AAAAAAAAAA
    // .AAAAAAAAAAA
    //
    {
        0x55, 0x0f, 0xff, 0xff, 0x0a, 0xa0,
        0x55, 0x0f, 0xff, 0xff, 0x0a, 0x05,
        0x55, 0x0f, 0xff, 0xff, 0x00, 0x00,
        0x55, 0x0f, 0xff, 0xff, 0xff, 0xff,
        0x55, 0x0f, 0xff, 0xff, 0xff, 0xff,
        0x55, 0x0f, 0xff, 0xff, 0xff, 0xff,
        0x55, 0x0f, 0xff, 0xff, 0xff, 0xff,
        0x55, 0x0f, 0xff, 0xff, 0xff, 0xff,
        0x55, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x55, 0x0a, 0xaa, 0xaa, 0xaa, 0xaa,
        0x50, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
        0x0a, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa
    },

    //
    // 6: Wall with connections to wall below and to the right.
    //
    // .55555555555
    // 5.5555555555
    // 55..........
    // 55.FFFFFFFFF
    // 55.FFFFFFFFF
    // 55.FFFFFFFFF
    // 55.FFFFFFFFF
    // 55.FFFFFFFFF
    // 55.FFFFF....
    // 55.FFFFF..AA
    // 55.FFFFF.A.A
    // 55.FFFFF.AA.
    //
    {
        0x05, 0x55, 0x55, 0x55, 0x55, 0x55,
        0x50, 0x55, 0x55, 0x55, 0x55, 0x55,
        0x55, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x55, 0x0f, 0xff, 0xff, 0xff, 0xff,
        0x55, 0x0f, 0xff, 0xff, 0xff, 0xff,
        0x55, 0x0f, 0xff, 0xff, 0xff, 0xff,
        0x55, 0x0f, 0xff, 0xff, 0xff, 0xff,
        0x55, 0x0f, 0xff, 0xff, 0xff, 0xff,
        0x55, 0x0f, 0xff, 0xff, 0x00, 0x00,
        0x55, 0x0f, 0xff, 0xff, 0x00, 0xaa,
        0x55, 0x0f, 0xff, 0xff, 0x0a, 0x0a,
        0x55, 0x0f, 0xff, 0xff, 0x0a, 0xa0
    },

    //
    // 7: Wall with connections to wall above, below, and to the right.
    //
    // 55.FFFFF.AA.
    // 55.FFFFF.A.5
    // 55.FFFFF....
    // 55.FFFFFFFFF
    // 55.FFFFFFFFF
    // 55.FFFFFFFFF
    // 55.FFFFFFFFF
    // 55.FFFFFFFFF
    // 55.FFFFF....
    // 55.FFFFF..AA
    // 55.FFFFF.A.A
    // 55.FFFFF.AA.
    //
    {
        0x55, 0x0f, 0xff, 0xff, 0x0a, 0xa0,
        0x55, 0x0f, 0xff, 0xff, 0x0a, 0x05,
        0x55, 0x0f, 0xff, 0xff, 0x00, 0x00,
        0x55, 0x0f, 0xff, 0xff, 0xff, 0xff,
        0x55, 0x0f, 0xff, 0xff, 0xff, 0xff,
        0x55, 0x0f, 0xff, 0xff, 0xff, 0xff,
        0x55, 0x0f, 0xff, 0xff, 0xff, 0xff,
        0x55, 0x0f, 0xff, 0xff, 0xff, 0xff,
        0x55, 0x0f, 0xff, 0xff, 0x00, 0x00,
        0x55, 0x0f, 0xff, 0xff, 0x00, 0xaa,
        0x55, 0x0f, 0xff, 0xff, 0x0a, 0x0a,
        0x55, 0x0f, 0xff, 0xff, 0x0a, 0xa0
    },

    //
    // 8: Wall with connection to wall to the left.
    //
    // 55555555555.
    // 5555555555.A
    // ..........AA
    // FFFFFFFF.AAA
    // FFFFFFFF.AAA
    // FFFFFFFF.AAA
    // FFFFFFFF.AAA
    // FFFFFFFF.AAA
    // .........AAA
    // AAAAAAAAA.AA
    // AAAAAAAAAA.A
    // AAAAAAAAAAA.
    //
    {
        0x55, 0x55, 0x55, 0x55, 0x55, 0x50,
        0x55, 0x55, 0x55, 0x55, 0x55, 0x0a,
        0x00, 0x00, 0x00, 0x00, 0x00, 0xaa,
        0xff, 0xff, 0xff, 0xff, 0x0a, 0xaa,
        0xff, 0xff, 0xff, 0xff, 0x0a, 0xaa,
        0xff, 0xff, 0xff, 0xff, 0x0a, 0xaa,
        0xff, 0xff, 0xff, 0xff, 0x0a, 0xaa,
        0xff, 0xff, 0xff, 0xff, 0x0a, 0xaa,
        0x00, 0x00, 0x00, 0x00, 0x0a, 0xaa,
        0xaa, 0xaa, 0xaa, 0xaa, 0xa0, 0xaa,
        0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x0a,
        0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xa0
    },

    //
    // 9: Wall with connections to wall above and to the left.
    //
    // .5.FFFFF.AAA
    // 5..FFFFF.AAA
    // ...FFFFF.AAA
    // FFFFFFFF.AAA
    // FFFFFFFF.AAA
    // FFFFFFFF.AAA
    // FFFFFFFF.AAA
    // FFFFFFFF.AAA
    // .........AAA
    // AAAAAAAAA.AA
    // AAAAAAAAAA.A
    // AAAAAAAAAAA.
    //
    {
        0x05, 0x0f, 0xff, 0xff, 0x0a, 0xaa,
        0x50, 0x0f, 0xff, 0xff, 0x0a, 0xaa,
        0x00, 0x0f, 0xff, 0xff, 0x0a, 0xaa,
        0xff, 0xff, 0xff, 0xff, 0x0a, 0xaa,
        0xff, 0xff, 0xff, 0xff, 0x0a, 0xaa,
        0xff, 0xff, 0xff, 0xff, 0x0a, 0xaa,
        0xff, 0xff, 0xff, 0xff, 0x0a, 0xaa,
        0xff, 0xff, 0xff, 0xff, 0x0a, 0xaa,
        0x00, 0x00, 0x00, 0x00, 0x0a, 0xaa,
        0xaa, 0xaa, 0xaa, 0xaa, 0xa0, 0xaa,
        0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x0a,
        0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xa0
    },

    //
    // 10: Wall with connections to wall below and to the left.
    //
    // 55555555555.
    // 5555555555.A
    // ..........AA
    // FFFFFFFF.AAA
    // FFFFFFFF.AAA
    // FFFFFFFF.AAA
    // FFFFFFFF.AAA
    // FFFFFFFF.AAA
    // ...FFFFF.AAA
    // AA.FFFFF.AAA
    // A..FFFFF.AAA
    // .5.FFFFF.AAA
    //
    {
        0x55, 0x55, 0x55, 0x55, 0x55, 0x50,
        0x55, 0x55, 0x55, 0x55, 0x55, 0x0a,
        0x00, 0x00, 0x00, 0x00, 0x00, 0xaa,
        0xff, 0xff, 0xff, 0xff, 0x0a, 0xaa,
        0xff, 0xff, 0xff, 0xff, 0x0a, 0xaa,
        0xff, 0xff, 0xff, 0xff, 0x0a, 0xaa,
        0xff, 0xff, 0xff, 0xff, 0x0a, 0xaa,
        0xff, 0xff, 0xff, 0xff, 0x0a, 0xaa,
        0x00, 0x0f, 0xff, 0xff, 0x0a, 0xaa,
        0xaa, 0x0f, 0xff, 0xff, 0x0a, 0xaa,
        0xa0, 0x0f, 0xff, 0xff, 0x0a, 0xaa,
        0x05, 0x0f, 0xff, 0xff, 0x0a, 0xaa
    },

    //
    // 11: Wall with connections to wall above, below, and to the left.
    //
    // .5.FFFFF.AAA
    // 5..FFFFF.AAA
    // ...FFFFF.AAA
    // FFFFFFFF.AAA
    // FFFFFFFF.AAA
    // FFFFFFFF.AAA
    // FFFFFFFF.AAA
    // FFFFFFFF.AAA
    // ...FFFFF.AAA
    // AA.FFFFF.AAA
    // A..FFFFF.AAA
    // .5.FFFFF.AAA
    //
    {
        0x05, 0x0f, 0xff, 0xff, 0x0a, 0xaa,
        0x50, 0x0f, 0xff, 0xff, 0x0a, 0xaa,
        0x00, 0x0f, 0xff, 0xff, 0x0a, 0xaa,
        0xff, 0xff, 0xff, 0xff, 0x0a, 0xaa,
        0xff, 0xff, 0xff, 0xff, 0x0a, 0xaa,
        0xff, 0xff, 0xff, 0xff, 0x0a, 0xaa,
        0xff, 0xff, 0xff, 0xff, 0x0a, 0xaa,
        0xff, 0xff, 0xff, 0xff, 0x0a, 0xaa,
        0x00, 0x0f, 0xff, 0xff, 0x0a, 0xaa,
        0xaa, 0x0f, 0xff, 0xff, 0x0a, 0xaa,
        0xa0, 0x0f, 0xff, 0xff, 0x0a, 0xaa,
        0x05, 0x0f, 0xff, 0xff, 0x0a, 0xaa
    },

    //
    // 12: Wall with connections to wall to the left and right.
    //
    // 555555555555
    // 555555555555
    // ............
    // FFFFFFFFFFFF
    // FFFFFFFFFFFF
    // FFFFFFFFFFFF
    // FFFFFFFFFFFF
    // FFFFFFFFFFFF
    // ............
    // AAAAAAAAAAAA
    // AAAAAAAAAAAA
    // AAAAAAAAAAAA
    //
    {
        0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
        0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
        0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
        0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa
    },

    //
    // 13: Wall with connections to wall above, to the left, and to the right.
    //
    // .5.FFFFF.AA.
    // 5..FFFFF.A.5
    // ...FFFFF....
    // FFFFFFFFFFFF
    // FFFFFFFFFFFF
    // FFFFFFFFFFFF
    // FFFFFFFFFFFF
    // FFFFFFFFFFFF
    // ............
    // AAAAAAAAAAAA
    // AAAAAAAAAAAA
    // AAAAAAAAAAAA
    //
    {
        0x05, 0x0f, 0xff, 0xff, 0x0a, 0xa0,
        0x50, 0x0f, 0xff, 0xff, 0x0a, 0x05,
        0x00, 0x0f, 0xff, 0xff, 0x00, 0x00,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
        0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
        0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa
    },

    //
    // 14: Wall with connections to wall below, to the left, and to the right.
    //
    // 555555555555
    // 555555555555
    // ............
    // FFFFFFFFFFFF
    // FFFFFFFFFFFF
    // FFFFFFFFFFFF
    // FFFFFFFFFFFF
    // FFFFFFFFFFFF
    // ...FFFFF....
    // AA.FFFFF..AA
    // A..FFFFF.A.A
    // .5.FFFFF.AA.
    //
    {
        0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
        0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0x00, 0x0f, 0xff, 0xff, 0x00, 0x00,
        0xaa, 0x0f, 0xff, 0xff, 0x00, 0xaa,
        0xa0, 0x0f, 0xff, 0xff, 0x0a, 0x0a,
        0x05, 0x0f, 0xff, 0xff, 0x0a, 0xa0
    },

    //
    // 15: Wall with connections to wall above, below, to the left, and to the
    // right.
    //
    // .5.FFFFF.AA.
    // 5..FFFFF.A.5
    // ...FFFFF....
    // FFFFFFFFFFFF
    // FFFFFFFFFFFF
    // FFFFFFFFFFFF
    // FFFFFFFFFFFF
    // FFFFFFFFFFFF
    // ...FFFFF....
    // AA.FFFFF..AA
    // A..FFFFF.A.A
    // .5.FFFFF.AA.
    //
    {
        0x05, 0x0f, 0xff, 0xff, 0x0a, 0xa0,
        0x50, 0x0f, 0xff, 0xff, 0x0a, 0x05,
        0x00, 0x0f, 0xff, 0xff, 0x00, 0x00,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0x00, 0x0f, 0xff, 0xff, 0x00, 0x00,
        0xaa, 0x0f, 0xff, 0xff, 0x00, 0xaa,
        0xa0, 0x0f, 0xff, 0xff, 0x0a, 0x0a,
        0x05, 0x0f, 0xff, 0xff, 0x0a, 0xa0
    },

    //
    // 16: Player facing forward.
    //
    // ....4444....
    // ...4AAAA4...
    // ..4AAAAAA4..
    // ..4AFAAFA4..
    // ..4A.AA.A4..
    // .4AAAAAAAA4.
    // 4AAAAAAAAAA4
    // 4AAAAAAAAAA4
    // 4AAAAAAAAAA4
    // 4AAAAAAAAAA4
    // .4AAAAAAAA4.
    // ..44444444..
    //
    {
        0x00, 0x00, 0x44, 0x44, 0x00, 0x00,
        0x00, 0x04, 0xaa, 0xaa, 0x40, 0x00,
        0x00, 0x4a, 0xaa, 0xaa, 0xa4, 0x00,
        0x00, 0x4a, 0xfa, 0xaf, 0xa4, 0x00,
        0x00, 0x4a, 0x0a, 0xa0, 0xa4, 0x00,
        0x04, 0xaa, 0xaa, 0xaa, 0xaa, 0x40,
        0x4a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa4,
        0x4a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa4,
        0x4a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa4,
        0x4a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa4,
        0x04, 0xaa, 0xaa, 0xaa, 0xaa, 0x40,
        0x00, 0x44, 0x44, 0x44, 0x44, 0x00
    },

    //
    // 17: Player facing forward, looking left.
    //
    // ....4444....
    // ...4AAAA4...
    // ..4AAAAAA4..
    // ..4FAAFAA4..
    // ..4.AA.AA4..
    // .4AAAAAAAA4.
    // 4AAAAAAAAAA4
    // 4AAAAAAAAAA4
    // 4AAAAAAAAAA4
    // 4AAAAAAAAAA4
    // .4AAAAAAAA4.
    // ..44444444..
    //
    {
        0x00, 0x00, 0x44, 0x44, 0x00, 0x00,
        0x00, 0x04, 0xaa, 0xaa, 0x40, 0x00,
        0x00, 0x4a, 0xaa, 0xaa, 0xa4, 0x00,
        0x00, 0x4f, 0xaa, 0xfa, 0xa4, 0x00,
        0x00, 0x40, 0xaa, 0x0a, 0xa4, 0x00,
        0x04, 0xaa, 0xaa, 0xaa, 0xaa, 0x40,
        0x4a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa4,
        0x4a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa4,
        0x4a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa4,
        0x4a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa4,
        0x04, 0xaa, 0xaa, 0xaa, 0xaa, 0x40,
        0x00, 0x44, 0x44, 0x44, 0x44, 0x00
    },

    //
    // 18: Player facing forward, looking right.
    //
    // ....4444....
    // ...4AAAA4...
    // ..4AAAAAA4..
    // ..4AAFAAF4..
    // ..4AA.AA.4..
    // .4AAAAAAAA4.
    // 4AAAAAAAAAA4
    // 4AAAAAAAAAA4
    // 4AAAAAAAAAA4
    // 4AAAAAAAAAA4
    // .4AAAAAAAA4.
    // ..44444444..
    //
    {
        0x00, 0x00, 0x44, 0x44, 0x00, 0x00,
        0x00, 0x04, 0xaa, 0xaa, 0x40, 0x00,
        0x00, 0x4a, 0xaa, 0xaa, 0xa4, 0x00,
        0x00, 0x4a, 0xaf, 0xaa, 0xf4, 0x00,
        0x00, 0x4a, 0xa0, 0xaa, 0x04, 0x00,
        0x04, 0xaa, 0xaa, 0xaa, 0xaa, 0x40,
        0x4a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa4,
        0x4a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa4,
        0x4a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa4,
        0x4a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa4,
        0x04, 0xaa, 0xaa, 0xaa, 0xaa, 0x40,
        0x00, 0x44, 0x44, 0x44, 0x44, 0x00
    },

    //
    // 19: Player facing forward, eyes closed.
    //
    // ....4444....
    // ...4AAAA4...
    // ..4AAAAAA4..
    // ..4AAAAAA4..
    // ..4AAAAAA4..
    // .4AAAAAAAA4.
    // 4AAAAAAAAAA4
    // 4AAAAAAAAAA4
    // 4AAAAAAAAAA4
    // 4AAAAAAAAAA4
    // .4AAAAAAAA4.
    // ..44444444..
    //
    {
        0x00, 0x00, 0x44, 0x44, 0x00, 0x00,
        0x00, 0x04, 0xaa, 0xaa, 0x40, 0x00,
        0x00, 0x4a, 0xaa, 0xaa, 0xa4, 0x00,
        0x00, 0x4a, 0xaa, 0xaa, 0xa4, 0x00,
        0x00, 0x4a, 0xaa, 0xaa, 0xa4, 0x00,
        0x04, 0xaa, 0xaa, 0xaa, 0xaa, 0x40,
        0x4a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa4,
        0x4a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa4,
        0x4a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa4,
        0x4a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa4,
        0x04, 0xaa, 0xaa, 0xaa, 0xaa, 0x40,
        0x00, 0x44, 0x44, 0x44, 0x44, 0x00
    },

    //
    // 20: Player facing forward, stepping left.
    //
    // ....4444....
    // ...4AAAA4...
    // ..4AAAAAA4..
    // ..4AFAAFA4..
    // ..4A0AA0A4..
    // .4AAAAAAAA4.
    // 4AAAAAAAAAA4
    // 4AAAAAAAAAA4
    // 4AAAAAAAAAA4
    // 4AAAAAAAAAA4
    // 4AAAAAAAA44.
    // .44444444...
    //
    {
        0x00, 0x00, 0x44, 0x44, 0x00, 0x00,
        0x00, 0x04, 0xaa, 0xaa, 0x40, 0x00,
        0x00, 0x4a, 0xaa, 0xaa, 0xa4, 0x00,
        0x00, 0x4a, 0xfa, 0xaf, 0xa4, 0x00,
        0x00, 0x4a, 0x0a, 0xa0, 0xa4, 0x00,
        0x04, 0xaa, 0xaa, 0xaa, 0xaa, 0x40,
        0x4a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa4,
        0x4a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa4,
        0x4a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa4,
        0x4a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa4,
        0x4a, 0xaa, 0xaa, 0xaa, 0xa4, 0x40,
        0x04, 0x44, 0x44, 0x44, 0x40, 0x00
    },

    //
    // 21: Player facing forward, stepping right.
    //
    // ....4444....
    // ...4AAAA4...
    // ..4AAAAAA4..
    // ..4AFAAFA4..
    // ..4A0AA0A4..
    // .4AAAAAAAA4.
    // 4AAAAAAAAAA4
    // 4AAAAAAAAAA4
    // 4AAAAAAAAAA4
    // 4AAAAAAAAAA4
    // .44AAAAAAAA4
    // ...44444444.
    //
    {
        0x00, 0x00, 0x44, 0x44, 0x00, 0x00,
        0x00, 0x04, 0xaa, 0xaa, 0x40, 0x00,
        0x00, 0x4a, 0xaa, 0xaa, 0xa4, 0x00,
        0x00, 0x4a, 0xfa, 0xaf, 0xa4, 0x00,
        0x00, 0x4a, 0x0a, 0xa0, 0xa4, 0x00,
        0x04, 0xaa, 0xaa, 0xaa, 0xaa, 0x40,
        0x4a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa4,
        0x4a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa4,
        0x4a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa4,
        0x4a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa4,
        0x04, 0x4a, 0xaa, 0xaa, 0xaa, 0xa4,
        0x00, 0x04, 0x44, 0x44, 0x44, 0x40
    },

    //
    // 22: Player facing away.
    //
    // ....4444....
    // ...498894...
    // ..4A9889A4..
    // ..4A9889A4..
    // ..4A9889A4..
    // .4AA9889AA4.
    // 4AAA9889AAA4
    // 4AAA9889AAA4
    // 4AAA9889AAA4
    // 4AAA9889AAA4
    // .4AA9889AA4.
    // ..44444444..
    //
    {
        0x00, 0x00, 0x44, 0x44, 0x00, 0x00,
        0x00, 0x04, 0x98, 0x89, 0x40, 0x00,
        0x00, 0x4a, 0x98, 0x89, 0xa4, 0x00,
        0x00, 0x4a, 0x98, 0x89, 0xa4, 0x00,
        0x00, 0x4a, 0x98, 0x89, 0xa4, 0x00,
        0x04, 0xaa, 0x98, 0x89, 0xaa, 0x40,
        0x4a, 0xaa, 0x98, 0x89, 0xaa, 0xa4,
        0x4a, 0xaa, 0x98, 0x89, 0xaa, 0xa4,
        0x4a, 0xaa, 0x98, 0x89, 0xaa, 0xa4,
        0x4a, 0xaa, 0x98, 0x89, 0xaa, 0xa4,
        0x04, 0xaa, 0x98, 0x89, 0xaa, 0x40,
        0x00, 0x44, 0x44, 0x44, 0x44, 0x00
    },

    //
    // 23: Player facing away, shrugging.
    //
    // ....4444....
    // ...498894...
    // ..4A9889A4..
    // ..4A9889A4..
    // .4AA9889AA4.
    // 4AAA9889AAA4
    // 4AAA9889AAA4
    // 4AAA9889AAA4
    // 4AAA9889AAA4
    // 4AAA9889AAA4
    // .4AA9889AA4.
    // ..44444444..
    //
    {
        0x00, 0x00, 0x44, 0x44, 0x00, 0x00,
        0x00, 0x04, 0x98, 0x89, 0x40, 0x00,
        0x00, 0x4a, 0x98, 0x89, 0xa4, 0x00,
        0x00, 0x4a, 0x98, 0x89, 0xa4, 0x00,
        0x04, 0xaa, 0x98, 0x89, 0xaa, 0x40,
        0x4a, 0xaa, 0x98, 0x89, 0xaa, 0xa4,
        0x4a, 0xaa, 0x98, 0x89, 0xaa, 0xa4,
        0x4a, 0xaa, 0x98, 0x89, 0xaa, 0xa4,
        0x4a, 0xaa, 0x98, 0x89, 0xaa, 0xa4,
        0x4a, 0xaa, 0x98, 0x89, 0xaa, 0xa4,
        0x04, 0xaa, 0x98, 0x89, 0xaa, 0x40,
        0x00, 0x44, 0x44, 0x44, 0x44, 0x00
    },

    //
    // 24: Player facing away, stepping left.
    //
    // ....4444....
    // ...498894...
    // ..4A9889A4..
    // ..4A9889A4..
    // ..4A9889A4..
    // .4AA9889AA4.
    // 4AAA9889AAA4
    // 4AAA9889AAA4
    // 4AAA9889AAA4
    // 4AA9889AAAA4
    // 4AA9889AA44.
    // .44444444...
    //
    {
        0x00, 0x00, 0x44, 0x44, 0x00, 0x00,
        0x00, 0x04, 0x98, 0x89, 0x40, 0x00,
        0x00, 0x4a, 0x98, 0x89, 0xa4, 0x00,
        0x00, 0x4a, 0x98, 0x89, 0xa4, 0x00,
        0x00, 0x4a, 0x98, 0x89, 0xa4, 0x00,
        0x04, 0xaa, 0x98, 0x89, 0xaa, 0x40,
        0x4a, 0xaa, 0x98, 0x89, 0xaa, 0xa4,
        0x4a, 0xaa, 0x98, 0x89, 0xaa, 0xa4,
        0x4a, 0xaa, 0x98, 0x89, 0xaa, 0xa4,
        0x4a, 0xa9, 0x88, 0x9a, 0xaa, 0xa4,
        0x4a, 0xa9, 0x88, 0x9a, 0xa4, 0x40,
        0x04, 0x44, 0x44, 0x44, 0x40, 0x00
    },

    //
    // 25: Player facing away, stepping right.
    //
    // ....4444....
    // ...498894...
    // ..4A9889A4..
    // ..4A9889A4..
    // ..4A9889A4..
    // .4AA9889AA4.
    // 4AAA9889AAA4
    // 4AAA9889AAA4
    // 4AAA9889AAA4
    // 4AAAA9889AA4
    // .44AA9889AA4.
    // ...44444444.
    //
    {
        0x00, 0x00, 0x44, 0x44, 0x00, 0x00,
        0x00, 0x04, 0x98, 0x89, 0x40, 0x00,
        0x00, 0x4a, 0x98, 0x89, 0xa4, 0x00,
        0x00, 0x4a, 0x98, 0x89, 0xa4, 0x00,
        0x00, 0x4a, 0x98, 0x89, 0xa4, 0x00,
        0x04, 0xaa, 0x98, 0x89, 0xaa, 0x40,
        0x4a, 0xaa, 0x98, 0x89, 0xaa, 0xa4,
        0x4a, 0xaa, 0x98, 0x89, 0xaa, 0xa4,
        0x4a, 0xaa, 0x98, 0x89, 0xaa, 0xa4,
        0x4a, 0xaa, 0xa9, 0x88, 0x9a, 0xa4,
        0x04, 0x4a, 0xa9, 0x88, 0x9a, 0xa4,
        0x00, 0x04, 0x44, 0x44, 0x44, 0x40
    },

    //
    // 26: Player facing left.
    //
    // ....4444....
    // ...4AAA84...
    // ..4AAAA984..
    // ..4AFAA984..
    // ..4A.AA984..
    // .4AAAAAA984.
    // 4AAAAAAAA984
    // 4AAAAAAAA984
    // 4AAAAAAAA984
    // 4AAAAAAAA984
    // .4AAAAAAAA4.
    // ..44444444..
    //
    {
        0x00, 0x00, 0x44, 0x44, 0x00, 0x00,
        0x00, 0x04, 0xaa, 0xa8, 0x40, 0x00,
        0x00, 0x4a, 0xaa, 0xa9, 0x84, 0x00,
        0x00, 0x4a, 0xfa, 0xa9, 0x84, 0x00,
        0x00, 0x4a, 0x0a, 0xa9, 0x84, 0x00,
        0x04, 0xaa, 0xaa, 0xaa, 0x98, 0x40,
        0x4a, 0xaa, 0xaa, 0xaa, 0xa9, 0x84,
        0x4a, 0xaa, 0xaa, 0xaa, 0xa9, 0x84,
        0x4a, 0xaa, 0xaa, 0xaa, 0xa9, 0x84,
        0x4a, 0xaa, 0xaa, 0xaa, 0xa9, 0x84,
        0x04, 0xaa, 0xaa, 0xaa, 0xaa, 0x40,
        0x00, 0x44, 0x44, 0x44, 0x44, 0x00
    },

    //
    // 27: Player facing left, eyes closed.
    //
    // ....4444....
    // ...4AAA84...
    // ..4AAAA984..
    // ..4AAAA984..
    // ..4AAAA984..
    // .4AAAAAA984.
    // 4AAAAAAAA984
    // 4AAAAAAAA984
    // 4AAAAAAAA984
    // 4AAAAAAAA984
    // .4AAAAAAAA4.
    // ..44444444..
    //
    {
        0x00, 0x00, 0x44, 0x44, 0x00, 0x00,
        0x00, 0x04, 0xaa, 0xa8, 0x40, 0x00,
        0x00, 0x4a, 0xaa, 0xa9, 0x84, 0x00,
        0x00, 0x4a, 0xaa, 0xa9, 0x84, 0x00,
        0x00, 0x4a, 0xaa, 0xa9, 0x84, 0x00,
        0x04, 0xaa, 0xaa, 0xaa, 0x98, 0x40,
        0x4a, 0xaa, 0xaa, 0xaa, 0xa9, 0x84,
        0x4a, 0xaa, 0xaa, 0xaa, 0xa9, 0x84,
        0x4a, 0xaa, 0xaa, 0xaa, 0xa9, 0x84,
        0x4a, 0xaa, 0xaa, 0xaa, 0xa9, 0x84,
        0x04, 0xaa, 0xaa, 0xaa, 0xaa, 0x40,
        0x00, 0x44, 0x44, 0x44, 0x44, 0x00
    },

    //
    // 28: Player facing left, stepping.
    //
    // ....4444....
    // ...4AAA84...
    // ..4AAAA984..
    // ..4AFAA984..
    // ..4A.AA984..
    // .4AAAAAA984.
    // 4AAAAAAAA984
    // 4AAAAAAAA984
    // 4AAAAAAAA984
    // 4AAAAAAAA984
    // 4AAAAAAAA44.
    // .44444444...
    //
    {
        0x00, 0x00, 0x44, 0x44, 0x00, 0x00,
        0x00, 0x04, 0xaa, 0xa8, 0x40, 0x00,
        0x00, 0x4a, 0xaa, 0xa9, 0x84, 0x00,
        0x00, 0x4a, 0xfa, 0xa9, 0x84, 0x00,
        0x00, 0x4a, 0x0a, 0xa9, 0x84, 0x00,
        0x04, 0xaa, 0xaa, 0xaa, 0x98, 0x40,
        0x4a, 0xaa, 0xaa, 0xaa, 0xa9, 0x84,
        0x4a, 0xaa, 0xaa, 0xaa, 0xa9, 0x84,
        0x4a, 0xaa, 0xaa, 0xaa, 0xa9, 0x84,
        0x4a, 0xaa, 0xaa, 0xaa, 0xa9, 0x84,
        0x4a, 0xaa, 0xaa, 0xaa, 0xa4, 0x40,
        0x04, 0x44, 0x44, 0x44, 0x40, 0x00
    },

    //
    // 29: Player facing right.
    //
    // ....4444....
    // ...48AAA4...
    // ..489AAAA4..
    // ..489AAFA4..
    // ..489AA.A4..
    // .489AAAAAA4.
    // 489AAAAAAAA4
    // 489AAAAAAAA4
    // 489AAAAAAAA4
    // 489AAAAAAAA4
    // .4AAAAAAAA4.
    // ..44444444..
    //
    {
        0x00, 0x00, 0x44, 0x44, 0x00, 0x00,
        0x00, 0x04, 0x8a, 0xaa, 0x40, 0x00,
        0x00, 0x48, 0x9a, 0xaa, 0xa4, 0x00,
        0x00, 0x48, 0x9a, 0xaf, 0xa4, 0x00,
        0x00, 0x48, 0x9a, 0xa0, 0xa4, 0x00,
        0x04, 0x89, 0xaa, 0xaa, 0xaa, 0x40,
        0x48, 0x9a, 0xaa, 0xaa, 0xaa, 0xa4,
        0x48, 0x9a, 0xaa, 0xaa, 0xaa, 0xa4,
        0x48, 0x9a, 0xaa, 0xaa, 0xaa, 0xa4,
        0x48, 0x9a, 0xaa, 0xaa, 0xaa, 0xa4,
        0x04, 0xaa, 0xaa, 0xaa, 0xaa, 0x40,
        0x00, 0x44, 0x44, 0x44, 0x44, 0x00
    },

    //
    // 30: Player facing right, eyes closed.
    //
    // ....4444....
    // ...48AAA4...
    // ..489AAAA4..
    // ..489AAAA4..
    // ..489AAAA4..
    // .489AAAAAA4.
    // 489AAAAAAAA4
    // 489AAAAAAAA4
    // 489AAAAAAAA4
    // 489AAAAAAAA4
    // .4AAAAAAAA4.
    // ..44444444..
    //
    {
        0x00, 0x00, 0x44, 0x44, 0x00, 0x00,
        0x00, 0x04, 0x8a, 0xaa, 0x40, 0x00,
        0x00, 0x48, 0x9a, 0xaa, 0xa4, 0x00,
        0x00, 0x48, 0x9a, 0xaa, 0xa4, 0x00,
        0x00, 0x48, 0x9a, 0xaa, 0xa4, 0x00,
        0x04, 0x89, 0xaa, 0xaa, 0xaa, 0x40,
        0x48, 0x9a, 0xaa, 0xaa, 0xaa, 0xa4,
        0x48, 0x9a, 0xaa, 0xaa, 0xaa, 0xa4,
        0x48, 0x9a, 0xaa, 0xaa, 0xaa, 0xa4,
        0x48, 0x9a, 0xaa, 0xaa, 0xaa, 0xa4,
        0x04, 0xaa, 0xaa, 0xaa, 0xaa, 0x40,
        0x00, 0x44, 0x44, 0x44, 0x44, 0x00
    },

    //
    // 31: Player facing right, stepping.
    //
    // ....4444....
    // ...48AAA4...
    // ..489AAAA4..
    // ..489AAFA4..
    // ..489AA.A4..
    // .489AAAAAA4.
    // 489AAAAAAAA4
    // 489AAAAAAAA4
    // 489AAAAAAAA4
    // 489AAAAAAAA4
    // .44AAAAAAAA4
    // ...44444444.
    //
    {
        0x00, 0x00, 0x44, 0x44, 0x00, 0x00,
        0x00, 0x04, 0x8a, 0xaa, 0x40, 0x00,
        0x00, 0x48, 0x9a, 0xaa, 0xa4, 0x00,
        0x00, 0x48, 0x9a, 0xaf, 0xa4, 0x00,
        0x00, 0x48, 0x9a, 0xa0, 0xa4, 0x00,
        0x04, 0x89, 0xaa, 0xaa, 0xaa, 0x40,
        0x48, 0x9a, 0xaa, 0xaa, 0xaa, 0xa4,
        0x48, 0x9a, 0xaa, 0xaa, 0xaa, 0xa4,
        0x48, 0x9a, 0xaa, 0xaa, 0xaa, 0xa4,
        0x48, 0x9a, 0xaa, 0xaa, 0xaa, 0xa4,
        0x04, 0x4a, 0xaa, 0xaa, 0xaa, 0xa4,
        0x00, 0x04, 0x44, 0x44, 0x44, 0x40
    },

    //
    // 32: Explosion stage one.
    //
    // ............
    // ............
    // ............
    // ............
    // ............
    // ....68ea....
    // ....6ce6....
    // .....686....
    // ............
    // ............
    // ............
    // ............
    //
    {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x68, 0xea, 0x00, 0x00,
        0x00, 0x00, 0x6c, 0xe6, 0x00, 0x00,
        0x00, 0x00, 0x06, 0x86, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    },

    //
    // 33: Explosion stage two.
    //
    // ............
    // ............
    // ............
    // .....6.66...
    // ....aa6a6...
    // ...6cc8a6...
    // ...6caee....
    // ....6acc8...
    // ......666...
    // ............
    // ............
    // ............
    //
    {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x06, 0x06, 0x60, 0x00,
        0x00, 0x00, 0xaa, 0x6a, 0x60, 0x00,
        0x00, 0x06, 0xcc, 0x8a, 0x60, 0x00,
        0x00, 0x06, 0xca, 0xee, 0x00, 0x00,
        0x00, 0x00, 0x6a, 0xcc, 0x80, 0x00,
        0x00, 0x00, 0x00, 0x66, 0x60, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    },

    //
    // 34: Explosion stage three.
    //
    // ............
    // ............
    // ....66.363..
    // ...6886975..
    // ..688ceba6..
    // ..6bbe9d65..
    // ..69cceb6...
    // ..387bdd94..
    // ...3668766..
    // .....26632..
    // ............
    // ............
    //
    {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x66, 0x03, 0x63, 0x00,
        0x00, 0x06, 0x88, 0x69, 0x75, 0x00,
        0x00, 0x68, 0x8c, 0xeb, 0xa6, 0x00,
        0x00, 0x6b, 0xbe, 0x9d, 0x65, 0x00,
        0x00, 0x69, 0xcc, 0xeb, 0x60, 0x00,
        0x00, 0x38, 0x7b, 0xdd, 0x94, 0x00,
        0x00, 0x03, 0x66, 0x87, 0x66, 0x00,
        0x00, 0x00, 0x02, 0x66, 0x32, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    },

    //
    // 35: Explosion stage four.
    //
    // ............
    // ...266.1661.
    // ..377667762.
    // .28ab99ba76.
    // .67bccaca76.
    // .6bcceaea62.
    // .67cbde9b2..
    // .598acedb81.
    // ..4676aa973.
    // ...22577663.
    // .....16641..
    // ............
    //
    {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x02, 0x66, 0x01, 0x66, 0x10,
        0x00, 0x37, 0x76, 0x67, 0x76, 0x20,
        0x02, 0x8a, 0xb9, 0x9b, 0xa7, 0x60,
        0x06, 0x7b, 0xcc, 0xac, 0xa7, 0x60,
        0x06, 0xbc, 0xce, 0xae, 0xa6, 0x20,
        0x06, 0x7c, 0xbd, 0xe9, 0xb2, 0x00,
        0x05, 0x98, 0xac, 0xed, 0xb8, 0x10,
        0x00, 0x46, 0x76, 0xaa, 0x97, 0x30,
        0x00, 0x02, 0x25, 0x77, 0x66, 0x30,
        0x00, 0x00, 0x01, 0x66, 0x41, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    },

    //
    // 36: Explosion stage five.
    //
    // ...66..666.
    // ..666666666.
    // .8aaa86ca866
    // 66a8eaeaca66
    // 66cece8ea666
    // 6ce8eeaee66.
    // 66ccaee8e6..
    // 6a88ceeeca6.
    // .666a6ccc88.
    // ..6666886666
    // .....666666.
    // ......666...
    //
    {
        0x00, 0x06, 0x66, 0x00, 0x66, 0x60,
        0x00, 0x66, 0x66, 0x66, 0x66, 0x60,
        0x08, 0xaa, 0xa8, 0x6c, 0xa8, 0x66,
        0x66, 0xa8, 0xea, 0xea, 0xca, 0x66,
        0x66, 0xce, 0xce, 0x8e, 0xa6, 0x66,
        0x6c, 0xe8, 0xee, 0xae, 0xe6, 0x60,
        0x66, 0xcc, 0xae, 0xe8, 0xe6, 0x00,
        0x6a, 0x88, 0xce, 0xee, 0xca, 0x60,
        0x06, 0x66, 0xa6, 0xcc, 0xc8, 0x80,
        0x00, 0x66, 0x66, 0x88, 0x66, 0x66,
        0x00, 0x00, 0x06, 0x66, 0x66, 0x60,
        0x00, 0x00, 0x00, 0x66, 0x60, 0x00
    },

    //
    // 37: Player death stage one.
    //
    // ............
    // ...444444...
    // ..4AAAAAA4..
    // ..4AFAAFA4..
    // ..4A.AA.A4..
    // .4AAAAAAAA4.
    // 4AAAAAAAAAA4
    // 4AAAAAAAAAA4
    // 4AAAAAAAAAA4
    // 4AAAAAAAAAA4
    // .4AAAAAAAA4.
    // ..44444444..
    //
    {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x04, 0x44, 0x44, 0x40, 0x00,
        0x00, 0x4a, 0xaa, 0xaa, 0xa4, 0x00,
        0x00, 0x4a, 0xfa, 0xaf, 0xa4, 0x00,
        0x00, 0x4a, 0x0a, 0xa0, 0xa4, 0x00,
        0x04, 0xaa, 0xaa, 0xaa, 0xaa, 0x40,
        0x4a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa4,
        0x4a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa4,
        0x4a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa4,
        0x4a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa4,
        0x04, 0xaa, 0xaa, 0xaa, 0xaa, 0x40,
        0x00, 0x44, 0x44, 0x44, 0x44, 0x00
    },

    //
    // 38: Player death stage two.
    //
    // ............
    // ............
    // ..44444444..
    // ..4AFAAFA4..
    // ..4A.AA.A4..
    // .4AAAAAAAA4.
    // 4AAAAAAAAAA4
    // 4AAAAAAAAAA4
    // 4AAAAAAAAAA4
    // 4AAAAAAAAAA4
    // .4AAAAAAAA4.
    // ..44444444..
    //
    {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x44, 0x44, 0x44, 0x44, 0x00,
        0x00, 0x4a, 0xfa, 0xaf, 0xa4, 0x00,
        0x00, 0x4a, 0x0a, 0xa0, 0xa4, 0x00,
        0x04, 0xaa, 0xaa, 0xaa, 0xaa, 0x40,
        0x4a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa4,
        0x4a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa4,
        0x4a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa4,
        0x4a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa4,
        0x04, 0xaa, 0xaa, 0xaa, 0xaa, 0x40,
        0x00, 0x44, 0x44, 0x44, 0x44, 0x00
    },

    //
    // 39: Player death stage three.
    //
    // ............
    // ............
    // ............
    // ..44444444..
    // ..4A.AA.A4..
    // .4AAAAAAAA4.
    // 4AAAAAAAAAA4
    // 4AAAAAAAAAA4
    // 4AAAAAAAAAA4
    // 4AAAAAAAAAA4
    // .4AAAAAAAA4.
    // ..44444444..
    //
    {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x44, 0x44, 0x44, 0x44, 0x00,
        0x00, 0x4a, 0x0a, 0xa0, 0xa4, 0x00,
        0x04, 0xaa, 0xaa, 0xaa, 0xaa, 0x40,
        0x4a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa4,
        0x4a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa4,
        0x4a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa4,
        0x4a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa4,
        0x04, 0xaa, 0xaa, 0xaa, 0xaa, 0x40,
        0x00, 0x44, 0x44, 0x44, 0x44, 0x00
    },

    //
    // 40: Player death stage four.
    //
    // ............
    // ............
    // ............
    // ............
    // ..44444444..
    // .4AAAAAAAA4.
    // 4AAAAAAAAAA4
    // 4AAAAAAAAAA4
    // 4AAAAAAAAAA4
    // 4AAAAAAAAAA4
    // .4AAAAAAAA4.
    // ..44444444..
    //
    {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x44, 0x44, 0x44, 0x44, 0x00,
        0x04, 0xaa, 0xaa, 0xaa, 0xaa, 0x40,
        0x4a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa4,
        0x4a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa4,
        0x4a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa4,
        0x4a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa4,
        0x04, 0xaa, 0xaa, 0xaa, 0xaa, 0x40,
        0x00, 0x44, 0x44, 0x44, 0x44, 0x00
    },

    //
    // 41: Player death stage five.
    //
    // ............
    // ............
    // ............
    // ............
    // ............
    // .4444444444.
    // 4AAAAAAAAAA4
    // 4AAAAAAAAAA4
    // 4AAAAAAAAAA4
    // 4AAAAAAAAAA4
    // .4444444444.
    // ............
    //
    {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x04, 0x44, 0x44, 0x44, 0x44, 0x40,
        0x4a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa4,
        0x4a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa4,
        0x4a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa4,
        0x4a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa4,
        0x04, 0x44, 0x44, 0x44, 0x44, 0x40,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    },

    //
    // 42: Player death stage six.
    //
    // ............
    // ............
    // ............
    // ............
    // ............
    // ..44444444..
    // .4AAAAAAAA4.
    // .4AAAAAAAA4.
    // .4AAAAAAAA4.
    // .4AAAAAAAA4.
    // ..44444444..
    // ............
    //
    {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x44, 0x44, 0x44, 0x44, 0x00,
        0x04, 0xaa, 0xaa, 0xaa, 0xaa, 0x40,
        0x04, 0xaa, 0xaa, 0xaa, 0xaa, 0x40,
        0x04, 0xaa, 0xaa, 0xaa, 0xaa, 0x40,
        0x04, 0xaa, 0xaa, 0xaa, 0xaa, 0x40,
        0x00, 0x44, 0x44, 0x44, 0x44, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    },

    //
    // 43: Player death stage seven.
    //
    // ............
    // ............
    // ............
    // ............
    // ............
    // ...444444...
    // ..4AAAAAA4..
    // ..4AAAAAA4..
    // ..4AAAAAA4..
    // ..4AAAAAA4..
    // ...444444...
    // ............
    //
    {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x04, 0x44, 0x44, 0x40, 0x00,
        0x00, 0x4a, 0xaa, 0xaa, 0xa4, 0x00,
        0x00, 0x4a, 0xaa, 0xaa, 0xa4, 0x00,
        0x00, 0x4a, 0xaa, 0xaa, 0xa4, 0x00,
        0x00, 0x4a, 0xaa, 0xaa, 0xa4, 0x00,
        0x00, 0x04, 0x44, 0x44, 0x40, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    },

    //
    // 44: Player death stage eight.
    //
    // ............
    // ............
    // ............
    // ............
    // ............
    // ............
    // ....4444....
    // ...4AAAA4...
    // ...4AAAA4...
    // ....4444....
    // ............
    // ............
    //
    {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x44, 0x44, 0x00, 0x00,
        0x00, 0x04, 0xaa, 0xaa, 0x40, 0x00,
        0x00, 0x04, 0xaa, 0xaa, 0x40, 0x00,
        0x00, 0x00, 0x44, 0x44, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    },

    //
    // 45: Player death stage nine.
    //
    // ............
    // ............
    // ............
    // ............
    // ............
    // ............
    // .....44.....
    // ....4AA4....
    // ....4AA4....
    // .....44.....
    // ............
    // ............
    //
    {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x04, 0x40, 0x00, 0x00,
        0x00, 0x00, 0x4a, 0xa4, 0x00, 0x00,
        0x00, 0x00, 0x4a, 0xa4, 0x00, 0x00,
        0x00, 0x00, 0x04, 0x40, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    },

    //
    // 46: Player death stage ten.
    //
    // ............
    // ............
    // ............
    // ............
    // ............
    // ............
    // ............
    // .....44.....
    // .....44.....
    // ............
    // ............
    // ............
    //
    {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x04, 0x40, 0x00, 0x00,
        0x00, 0x00, 0x04, 0x40, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    },

    //
    // 47: Player death stage eleven.
    //
    // ............
    // ............
    // ............
    // ............
    // ............
    // ............
    // ............
    // .....AA.....
    // .....AA.....
    // ............
    // ............
    // ............
    //
    {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x0a, 0xa0, 0x00, 0x00,
        0x00, 0x00, 0x0a, 0xa0, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    },

    //
    // 48: Player death stage twelve.
    //
    // ............
    // ............
    // ............
    // ............
    // ............
    // ............
    // ....A..A....
    // .....AA.....
    // .....AA.....
    // ....A..A....
    // ............
    // ............
    //
    {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0xa0, 0x0a, 0x00, 0x00,
        0x00, 0x00, 0x0a, 0xa0, 0x00, 0x00,
        0x00, 0x00, 0x0a, 0xa0, 0x00, 0x00,
        0x00, 0x00, 0xa0, 0x0a, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    },

    //
    // 49: Player death stage thirteen.
    //
    // ............
    // ............
    // ............
    // ............
    // ............
    // ...A..A.A...
    // ....A.AA....
    // ...AAAA.....
    // .....AAAA...
    // ....AA.A....
    // ...A.A..A...
    // ............
    //
    {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x0a, 0x00, 0xa0, 0xa0, 0x00,
        0x00, 0x00, 0xa0, 0xaa, 0x00, 0x00,
        0x00, 0x0a, 0xaa, 0xa0, 0x00, 0x00,
        0x00, 0x00, 0x0a, 0xaa, 0xa0, 0x00,
        0x00, 0x00, 0xaa, 0x0a, 0x00, 0x00,
        0x00, 0x0a, 0x0a, 0x00, 0xa0, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    },

    //
    // 50: Player death stage fourteen.
    //
    // ............
    // ............
    // ............
    // ............
    // ..A...A..A..
    // ...A..A.A...
    // ....A.AA....
    // ..AAAAA.....
    // .....AAAAA..
    // ....AA.A....
    // ...A.A..A...
    // ..A..A...A..
    //
    {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0xa0, 0x00, 0xa0, 0x0a, 0x00,
        0x00, 0x0a, 0x00, 0xa0, 0xa0, 0x00,
        0x00, 0x00, 0xa0, 0xaa, 0x00, 0x00,
        0x00, 0xaa, 0xaa, 0xa0, 0x00, 0x00,
        0x00, 0x00, 0x0a, 0xaa, 0xaa, 0x00,
        0x00, 0x00, 0xaa, 0x0a, 0x00, 0x00,
        0x00, 0x0a, 0x0a, 0x00, 0xa0, 0x00,
        0x00, 0xa0, 0x0a, 0x00, 0x0a, 0x00
    },

    //
    // 51: Player death stage fifteen.
    //
    // ............
    // ............
    // ............
    // ............
    // ..A...A..A..
    // ...A..A.A...
    // ............
    // ..AA........
    // ........AA..
    // ............
    // ...A.A..A...
    // ..A..A...A..
    //
    {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0xa0, 0x00, 0xa0, 0x0a, 0x00,
        0x00, 0x0a, 0x00, 0xa0, 0xa0, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0xaa, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0xaa, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x0a, 0x0a, 0x00, 0xa0, 0x00,
        0x00, 0xa0, 0x0a, 0x00, 0x0a, 0x00
    },

    //
    // 52: Monster step one.
    //
    // .......1....
    // ......1A....
    // .2....BC....
    // .9D937FC....
    // ..DFFFFD....
    // ..2FFFFFFA61.
    // ...BFFFFFFE7.
    // ..7FFFFF72..
    // .3FFBDFC....
    // .85102FC....
    // ......5C....
    // .......5....
    //
    {
        0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x1a, 0x00, 0x00,
        0x02, 0x00, 0x00, 0xbc, 0x00, 0x00,
        0x09, 0xd9, 0x37, 0xfc, 0x00, 0x00,
        0x00, 0xdf, 0xff, 0xfd, 0x00, 0x00,
        0x00, 0x2f, 0xff, 0xff, 0xfa, 0x61,
        0x00, 0x0b, 0xff, 0xff, 0xff, 0xe7,
        0x00, 0x7f, 0xff, 0xff, 0x72, 0x00,
        0x03, 0xff, 0xbd, 0xfc, 0x00, 0x00,
        0x08, 0x51, 0x02, 0xfc, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x5c, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x05, 0x00, 0x00
    },

    //
    // 53: Monster step two.
    //
    // .....41.....
    // .....A6.....
    // .....FA.....
    // ....5FF.....
    // 5CCCEFFDCCA1
    // .5FFFFFFFB1.
    // ..2DFFFF7...
    // ...AFFFF3...
    // ...FFBFF9...
    // ..5F7.2DD...
    // ..83....92..
    // ............
    //
    {
        0x00, 0x00, 0x04, 0x10, 0x00, 0x00,
        0x00, 0x00, 0x0a, 0x60, 0x00, 0x00,
        0x00, 0x00, 0x0f, 0xa0, 0x00, 0x00,
        0x00, 0x00, 0x5f, 0xf0, 0x00, 0x00,
        0x5c, 0xcc, 0xef, 0xfd, 0xcc, 0xa1,
        0x05, 0xff, 0xff, 0xff, 0xfb, 0x10,
        0x00, 0x2d, 0xff, 0xff, 0x70, 0x00,
        0x00, 0x0a, 0xff, 0xff, 0x30, 0x00,
        0x00, 0x0f, 0xfb, 0xff, 0x90, 0x00,
        0x00, 0x5f, 0x70, 0x2d, 0xd0, 0x00,
        0x00, 0x83, 0x00, 0x00, 0x92, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    },

    //
    // 54: Monster step three.
    //
    // ...1........
    // ...47.......
    // ...4F3....2.
    // ...4FE26AE2.
    // ...4FFFFF5..
    // 27CFFFFF9...
    // 6BFFFFFF3...
    // ..18FFFFE1..
    // ...4FF9DFB..
    // ...4F9..274.
    // ...4D.......
    // ...32.......
    //
    {
        0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x04, 0x70, 0x00, 0x00, 0x00,
        0x00, 0x04, 0xf3, 0x00, 0x00, 0x20,
        0x00, 0x04, 0xfe, 0x26, 0xae, 0x20,
        0x00, 0x04, 0xff, 0xff, 0xf5, 0x00,
        0x27, 0xcf, 0xff, 0xff, 0x90, 0x00,
        0x6b, 0xff, 0xff, 0xff, 0x30, 0x00,
        0x00, 0x18, 0xff, 0xff, 0xe1, 0x00,
        0x00, 0x04, 0xff, 0x9d, 0xfb, 0x00,
        0x00, 0x04, 0xf9, 0x00, 0x27, 0x40,
        0x00, 0x04, 0xd0, 0x00, 0x00, 0x00,
        0x00, 0x03, 0x20, 0x00, 0x00, 0x00
    },

    //
    // 55: Monster step four.
    //
    // ............
    // ..4.....22..
    // ..7B1..5E...
    // ..2FE39FA...
    // ...EFFFF5...
    // ...AFFFF1...
    // ..9FFFFFE3..
    // 2DFFFFFFFF7.
    // 3444AFE44441
    // ....4F9.....
    // .....F3.....
    // .....8......
    //
    {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x40, 0x00, 0x00, 0x22, 0x00,
        0x00, 0x7b, 0x10, 0x05, 0xe0, 0x00,
        0x00, 0x2f, 0xe3, 0x9f, 0xa0, 0x00,
        0x00, 0x0e, 0xff, 0xff, 0x50, 0x00,
        0x00, 0x0a, 0xff, 0xff, 0x10, 0x00,
        0x00, 0x9f, 0xff, 0xff, 0xe3, 0x00,
        0x2d, 0xff, 0xff, 0xff, 0xff, 0x70,
        0x34, 0x44, 0xaf, 0xe4, 0x44, 0x41,
        0x00, 0x00, 0x4f, 0x90, 0x00, 0x00,
        0x00, 0x00, 0x0f, 0x30, 0x00, 0x00,
        0x00, 0x00, 0x08, 0x00, 0x00, 0x00
    }
};

//*****************************************************************************
//
// The animation sequence for the player when facing down and standing in
// place.
//
//*****************************************************************************
const unsigned char g_pucPlayerStandingDown[14] =
{
    0, 16,
    150, 17,
    170, 16,
    180, 18,
    200, 16,
    210, 19,
    220, 0
};

//*****************************************************************************
//
// The animation sequence for the player when facing down and walking.
//
//*****************************************************************************
const unsigned char g_pucPlayerWalkingDown[10] =
{
    0, 16,
    5, 20,
    10, 16,
    15, 21,
    20, 0
};

//*****************************************************************************
//
// The animation sequence for the player when facing up and standing in place.
//
//*****************************************************************************
const unsigned char g_pucPlayerStandingUp[6] =
{
    0, 22,
    150, 23,
    170, 0
};

//*****************************************************************************
//
// The animation sequence for the player when facing up and walking.
//
//*****************************************************************************
const unsigned char g_pucPlayerWalkingUp[10] =
{
    0, 22,
    5, 24,
    10, 22,
    15, 25,
    20, 0
};

//*****************************************************************************
//
// The animation sequence for the player when facing left and standing in
// place.
//
//*****************************************************************************
const unsigned char g_pucPlayerStandingLeft[6] =
{
    0, 26,
    150, 27,
    160, 0
};

//*****************************************************************************
//
// The animation sequence for the player when facing left and walking.
//
//*****************************************************************************
const unsigned char g_pucPlayerWalkingLeft[6] =
{
    0, 26,
    5, 28,
    10, 0
};

//*****************************************************************************
//
// The animation sequence for the player when facing right and standing in
// place.
//
//*****************************************************************************
const unsigned char g_pucPlayerStandingRight[6] =
{
    0, 29,
    150, 30,
    160, 0
};

//*****************************************************************************
//
// The animation sequence for the player when facing right and walking.
//
//*****************************************************************************
const unsigned char g_pucPlayerWalkingRight[6] =
{
    0, 29,
    5, 31,
    10, 0
};

//*****************************************************************************
//
// The animation sequence for the player when dying.
//
//*****************************************************************************
const unsigned char g_pucPlayerDying[] =
{
    0, 37,
    1, 38,
    2, 39,
    3, 40,
    4, 41,
    5, 42,
    6, 43,
    7, 44,
    8, 45,
    9, 46,
    10, 47,
    11, 48,
    12, 49,
    13, 50,
    14, 51,
    15, 0,
    255, 0
};

//*****************************************************************************
//
// The animation sequence for the monsters.
//
//*****************************************************************************
const unsigned char g_pucMonster[10] =
{
    0, 52,
    2, 53,
    4, 54,
    6, 55,
    8, 0
};

//*****************************************************************************
//
// The animation sequence for explosions.
//
//*****************************************************************************
const unsigned char g_pucExplosion[12] =
{
    0, 32,
    2, 33,
    4, 34,
    6, 35,
    8, 36,
    10, 0
};
