/**
 * \file  hw_pllss_C6A811x.h
 *
 * \brief Hardware definitions for PLLSS on C6A811x
 */

/*
* Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/
*/
/*
*  Redistribution and use in source and binary forms, with or without
*  modification, are permitted provided that the following conditions
*  are met:
*
*    Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the
*    documentation and/or other materials provided with the
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/



#ifndef _HW_PLLSS_C6A811x_H_
#define _HW_PLLSS_C6A811x_H_

#ifdef __cplusplus
extern "C" {
#endif

/*************************************************************************\
 * Register Definition Macros
\*************************************************************************/

#define PLLSS_CONTROL_REVISION      (0x0000)
#define PLLSS_CONTROL_HWINFO        (0x0004)
#define PLLSS_CONTROL_SYSCONFIG     (0x0010)
#define PLLSS_PLLSS_MMR_LOCK        (0x0040)
#define PLLSS_MPUPLL_PWRCTRL        (0x0048)
#define PLLSS_MPUPLL_CLKCTRL        (0x004C)
#define PLLSS_MPUPLL_TENABLE        (0x0050)
#define PLLSS_MPUPLL_TENABLEDIV     (0x0054)
#define PLLSS_MPUPLL_M2NDIV         (0x0058)
#define PLLSS_MPUPLL_MN2DIV         (0x005C)
#define PLLSS_MPUPLL_FRACDIV        (0x0060)
#define PLLSS_MPUPLL_BWCTRL         (0x0064)
#define PLLSS_MPUPLL_FRACCTRL       (0x0068)
#define PLLSS_MPUPLL_STATUS         (0x006C)
#define PLLSS_MPUPLL_M3DIV          (0x0070)
#define PLLSS_MPUPLL_RAMPCTRL       (0x0074)
#define PLLSS_DSPPLL_PWRCTRL        (0x0080)
#define PLLSS_DSPPLL_CLKCTRL        (0x0084)
#define PLLSS_DSPPLL_TENABLE        (0x0088)
#define PLLSS_DSPPLL_TENABLEDIV     (0x008C)
#define PLLSS_DSPPLL_M2NDIV         (0x0090)
#define PLLSS_DSPPLL_MN2DIV         (0x0094)
#define PLLSS_DSPPLL_FRACDIV        (0x0098)
#define PLLSS_DSPPLL_BWCTRL         (0x009C)
#define PLLSS_DSPPLL_FRACCTRL       (0x00A0)
#define PLLSS_DSPPLL_STATUS         (0x00A4)
#define PLLSS_SGXPLL_PWRCTRL        (0x00B0)
#define PLLSS_SGXPLL_CLKCTRL        (0x00B4)
#define PLLSS_SGXPLL_TENABLE        (0x00B8)
#define PLLSS_SGXPLL_TENABLEDIV     (0x00BC)
#define PLLSS_SGXPLL_M2NDIV         (0x00C0)
#define PLLSS_SGXPLL_MN2DIV         (0x00C4)
#define PLLSS_SGXPLL_FRACDIV        (0x00C8)
#define PLLSS_SGXPLL_BWCTRL         (0x00CC)
#define PLLSS_SGXPLL_FRACCTRL       (0x00D0)
#define PLLSS_SGXPLL_STATUS         (0x00D4)
#define PLLSS_ISSPLL_PWRCTRL        (0x0140)
#define PLLSS_ISSPLL_CLKCTRL        (0x0144)
#define PLLSS_ISSPLL_TENABLE        (0x0148)
#define PLLSS_ISSPLL_TENABLEDIV     (0x014C)
#define PLLSS_ISSPLL_M2NDIV         (0x0150)
#define PLLSS_ISSPLL_MN2DIV         (0x0154)
#define PLLSS_ISSPLL_FRACDIV        (0x0158)
#define PLLSS_ISSPLL_BWCTRL         (0x015C)
#define PLLSS_ISSPLL_FRACCTRL       (0x0160)
#define PLLSS_ISSPLL_STATUS         (0x0164)
#define PLLSS_VIDEO0PLL_PWRCTRL     (0x01A0)
#define PLLSS_VIDEO0PLL_CLKCTRL     (0x01A4)
#define PLLSS_VIDEO0PLL_TENABLE     (0x01A8)
#define PLLSS_VIDEO0PLL_TENABLEDIV  (0x01AC)
#define PLLSS_VIDEO0PLL_M2NDIV      (0x01B0)
#define PLLSS_VIDEO0PLL_MN2DIV      (0x01B4)
#define PLLSS_VIDEO0PLL_FRACDIV     (0x01B8)
#define PLLSS_VIDEO0PLL_BWCTRL      (0x01BC)
#define PLLSS_VIDEO0PLL_FRACCTRL    (0x01C0)
#define PLLSS_VIDEO0PLL_STATUS      (0x01C4)
#define PLLSS_VIDEO1PLL_PWRCTRL     (0x01D0)
#define PLLSS_VIDEO1PLL_CLKCTRL     (0x01D4)
#define PLLSS_VIDEO1PLL_TENABLE     (0x01D8)
#define PLLSS_VIDEO1PLL_TENABLEDIV  (0x01DC)
#define PLLSS_VIDEO1PLL_M2NDIV      (0x01E0)
#define PLLSS_VIDEO1PLL_MN2DIV      (0x01E4)
#define PLLSS_VIDEO1PLL_FRACDIV     (0x01E8)
#define PLLSS_VIDEO1PLL_BWCTRL      (0x01EC)
#define PLLSS_VIDEO1PLL_FRACCTRL    (0x01F0)
#define PLLSS_VIDEO1PLL_STATUS      (0x01F4)
#define PLLSS_HDMIPLL_PWRCTRL       (0x0200)
#define PLLSS_HDMIPLL_CLKCTRL       (0x0204)
#define PLLSS_HDMIPLL_TENABLE       (0x0208)
#define PLLSS_HDMIPLL_TENABLEDIV    (0x020C)
#define PLLSS_HDMIPLL_M2NDIV        (0x0210)
#define PLLSS_HDMIPLL_MN2DIV        (0x0214)
#define PLLSS_HDMIPLL_FRACDIV       (0x0218)
#define PLLSS_HDMIPLL_BWCTRL        (0x021C)
#define PLLSS_HDMIPLL_FRACCTRL      (0x0220)
#define PLLSS_HDMIPLL_STATUS        (0x0224)
#define PLLSS_AUDIOPLL_PWRCTRL      (0x0230)
#define PLLSS_AUDIOPLL_CLKCTRL      (0x0234)
#define PLLSS_AUDIOPLL_TENABLE      (0x0238)
#define PLLSS_AUDIOPLL_TENABLEDIV   (0x023C)
#define PLLSS_AUDIOPLL_M2NDIV       (0x0240)
#define PLLSS_AUDIOPLL_MN2DIV       (0x0244)
#define PLLSS_AUDIOPLL_FRACDIV      (0x0248)
#define PLLSS_AUDIOPLL_BWCTRL       (0x024C)
#define PLLSS_AUDIOPLL_FRACCTRL     (0x0250)
#define PLLSS_AUDIOPLL_STATUS       (0x0254)
#define PLLSS_USBPLL_PWRCTRL        (0x0260)
#define PLLSS_USBPLL_CLKCTRL        (0x0264)
#define PLLSS_USBPLL_TENABLE        (0x0268)
#define PLLSS_USBPLL_TENABLEDIV     (0x026C)
#define PLLSS_USBPLL_M2NDIV         (0x0270)
#define PLLSS_USBPLL_MN2DIV         (0x0274)
#define PLLSS_USBPLL_FRACDIV        (0x0278)
#define PLLSS_USBPLL_BWCTRL         (0x027C)
#define PLLSS_USBPLL_FRACCTRL       (0x0280)
#define PLLSS_USBPLL_STATUS         (0x0284)
#define PLLSS_DDRPLL_PWRCTRL        (0x0290)
#define PLLSS_DDRPLL_CLKCTRL        (0x0294)
#define PLLSS_DDRPLL_TENABLE        (0x0298)
#define PLLSS_DDRPLL_TENABLEDIV     (0x029C)
#define PLLSS_DDRPLL_M2NDIV         (0x02A0)
#define PLLSS_DDRPLL_MN2DIV         (0x02A4)
#define PLLSS_DDRPLL_FRACDIV        (0x02A8)
#define PLLSS_DDRPLL_BWCTRL         (0x02AC)
#define PLLSS_DDRPLL_FRACCTRL       (0x02B0)
#define PLLSS_DDRPLL_STATUS         (0x02B4)
#define PLLSS_OSC_SRC               (0x02C0)
#define PLLSS_ARM_CLKSRC            (0x02C4)
#define PLLSS_VIDEO_PLL_CLKSRC      (0x02C8)
#define PLLSS_MLB_ATL_CLKSRC        (0x02CC)
#define PLLSS_McASP345_AUX_CLKSRC   (0x02D0)
#define PLLSS_McASP_AHCLK_CLKSRC    (0x02D4)
#define PLLSS_McBSP_UART_CLKSRC     (0x02D8)
#define PLLSS_DMTIMER_CLKSRC        (0x02E0)
#define PLLSS_CLKOUT_MUX            (0x02E4)
#define PLLSS_RMII_REFCLK_SRC       (0x02E8)
#define PLLSS_SECSS_CLK_SRC         (0x02EC)
#define PLLSS_SYSCLK_18_SRC         (0x02F0)
#define PLLSS_WDT0_SRC              (0x02F4)
#define PLLSS_DSS_CLKSRC            (0x02FC)
#define PLLSS_TIMER_CLK_CHANGE      (0x0320)
#define PLLSS_DEEPSLEEP_CTRL        (0x0324)
#define PLLSS_DEEPSLEEP_STATUS      (0x0328)

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/** @brief PLLSS_CONTROL_REVISION register fields */

#define PLLSS_CONTROL_REVISION_IP_REV_SCHEME        (0xC0000000u)
#define PLLSS_CONTROL_REVISION_IP_REV_SCHEME_SHIFT  (0x1Eu)

#define PLLSS_CONTROL_REVISION_IP_REV_FUNC          (0x0FFF0000u)
#define PLLSS_CONTROL_REVISION_IP_REV_FUNC_SHIFT    (0x10u)

#define PLLSS_CONTROL_REVISION_IP_REV_RTL           (0x0000F800u)
#define PLLSS_CONTROL_REVISION_IP_REV_RTL_SHIFT     (0xBu)

#define PLLSS_CONTROL_REVISION_IP_REV_MAJOR         (0x00000700u)
#define PLLSS_CONTROL_REVISION_IP_REV_MAJOR_SHIFT   (0x8u)

#define PLLSS_CONTROL_REVISION_IP_REV_CUSTOM        (0x000000C0u)
#define PLLSS_CONTROL_REVISION_IP_REV_CUSTOM_SHIFT  (0x6u)

#define PLLSS_CONTROL_REVISION_IP_REV_MINOR         (0x0000003Fu)
#define PLLSS_CONTROL_REVISION_IP_REV_MINOR_SHIFT   (0x0u)

/** @brief PLLSS_CONTROL_HWINFO register fields */

#define PLLSS_CONTROL_HWINFO_IP_HWINFO              (0x7FFFFFFFu)
#define PLLSS_CONTROL_HWINFO_IP_HWINFO_SHIFT        (0x0u)

/** @brief PLLSS_CONTROL_SYSCONFIG register fields */

#define PLLSS_CONTROL_SYSCONFIG_STANDBY             (0x00000030u)
#define PLLSS_CONTROL_SYSCONFIG_STANDBY_SHIFT       (0x4u)

#define PLLSS_CONTROL_SYSCONFIG_IDLEMODE            (0x0000000Cu)
#define PLLSS_CONTROL_SYSCONFIG_IDLEMODE_SHIFT      (0x2u)

#define PLLSS_CONTROL_SYSCONFIG_FREEEMU             (0x00000002u)
#define PLLSS_CONTROL_SYSCONFIG_FREEEMU_SHIFT       (0x1u)

/** @brief PLLSS_MMR_LOCK register fields */

#define PLLSS_MMR_LOCK_LOCK                         (0x1F125B64u)
#define PLLSS_MMR_LOCK_UNLOCK                       (0x1EDA4C3Du)

/** @brief PLLSS_MPUPLL_PWRCTRL register fields */

#define PLLSS_MPUPLL_PWRCTRL_OFFMODE                (0x00000001u)
#define PLLSS_MPUPLL_PWRCTRL_OFFMODE_SHIFT          (0x0u)

/** @brief PLLSS_MPUPLL_CLKCTRL register fields */

#define PLLSS_MPUPLL_CLKCTRL_CYCLESLIPEN            (0x80000000u)
#define PLLSS_MPUPLL_CLKCTRL_CYCLESLIPEN_SHIFT      (0x1Fu)

#define PLLSS_MPUPLL_CLKCTRL_ENSSC                  (0x40000000u)
#define PLLSS_MPUPLL_CLKCTRL_ENSSC_SHIFT            (0x1Eu)

#define PLLSS_MPUPLL_CLKCTRL_NWELLTRIM              (0x1F000000u)
#define PLLSS_MPUPLL_CLKCTRL_NWELLTRIM_SHIFT        (0x18u)

#define PLLSS_MPUPLL_CLKCTRL_IDLE                   (0x00800000u)
#define PLLSS_MPUPLL_CLKCTRL_IDLE_SHIFT             (0x17u)

#define PLLSS_MPUPLL_CLKCTRL_STBYRET                (0x00200000u)
#define PLLSS_MPUPLL_CLKCTRL_STBYRET_SHIFT          (0x15u)

#define PLLSS_MPUPLL_CLKCTRL_CLKOUTEN               (0x00100000u)
#define PLLSS_MPUPLL_CLKCTRL_CLKOUTEN_SHIFT         (0x14u)

#define PLLSS_MPUPLL_CLKCTRL_ULOWCLKEN              (0x00040000u)
#define PLLSS_MPUPLL_CLKCTRL_ULOWCLKEN_SHIFT        (0x12u)

#define PLLSS_MPUPLL_CLKCTRL_CLKDCOLDOPWDNZ         (0x00020000u)
#define PLLSS_MPUPLL_CLKCTRL_CLKDCOLDOPWDNZ_SHIFT   (0x11u)

#define PLLSS_MPUPLL_CLKCTRL_M2PWDNZ                (0x00010000u)
#define PLLSS_MPUPLL_CLKCTRL_M2PWDNZ_SHIFT          (0x10u)

#define PLLSS_MPUPLL_CLKCTRL_M3PWDNZ                (0x00008000u)
#define PLLSS_MPUPLL_CLKCTRL_M3PWDNZ_SHIFT          (0xFu)

#define PLLSS_MPUPLL_CLKCTRL_STOPMODE               (0x00004000u)
#define PLLSS_MPUPLL_CLKCTRL_STOPMODE_SHIFT         (0xEu)

#define PLLSS_MPUPLL_CLKCTRL_LOWCURRSTDBY           (0x00002000u)
#define PLLSS_MPUPLL_CLKCTRL_LOWCURRSTDBY_SHIFT     (0xDu)

#define PLLSS_MPUPLL_CLKCTRL_LPMODE                 (0x00001000u)
#define PLLSS_MPUPLL_CLKCTRL_LPMODE_SHIFT           (0xCu)

#define PLLSS_MPUPLL_CLKCTRL_DRIFTGUARDEN           (0x00000800u)
#define PLLSS_MPUPLL_CLKCTRL_DRIFTGUARDEN_SHIFT     (0xBu)

#define PLLSS_MPUPLL_CLKCTRL_REGM4XEN               (0x00000400u)
#define PLLSS_MPUPLL_CLKCTRL_REGM4XEN_SHIFT         (0xAu)

#define PLLSS_MPUPLL_CLKCTRL_RELAXED_LOCK           (0x00000100u)
#define PLLSS_MPUPLL_CLKCTRL_RELAXED_LOCK_SHIFT     (0x8u)

#define PLLSS_MPUPLL_CLKCTRL_TINITZ                 (0x00000001u)
#define PLLSS_MPUPLL_CLKCTRL_TINITZ_SHIFT           (0x0u)

/** @brief PLLSS_MPUPLL_TENABLE register fields */

#define PLLSS_MPUPLL_TENABLE_TENABLE                (0x00000001u)
#define PLLSS_MPUPLL_TENABLE_TENABLE_SHIFT          (0x0u)

/** @brief PLLSS_MPUPLL_TENABLEDIV register fields */

#define PLLSS_MPUPLL_TENABLEDIV_TENABLEDIV          (0x00000001u)
#define PLLSS_MPUPLL_TENABLEDIV_TENABLEDIV_SHIFT    (0x0u)

/** @brief PLLSS_MPUPLL_M2NDIV register fields */

#define PLLSS_MPUPLL_M2NDIV_M2                      (0x001F0000u)
#define PLLSS_MPUPLL_M2NDIV_M2_SHIFT                (0x10u)

#define PLLSS_MPUPLL_M2NDIV_N                       (0x0000007Fu)
#define PLLSS_MPUPLL_M2NDIV_N_SHIFT                 (0x0u)

/** @brief PLLSS_MPUPLL_MN2DIV register fields */

#define PLLSS_MPUPLL_MN2DIV_N2                      (0x000F0000u)
#define PLLSS_MPUPLL_MN2DIV_N2_SHIFT                (0x10u)

#define PLLSS_MPUPLL_MN2DIV_M                       (0x00000FFFu)
#define PLLSS_MPUPLL_MN2DIV_M_SHIFT                 (0x0u)

/** @brief PLLSS_MPUPLL_FRACDIV register fields */

#define PLLSS_MPUPLL_FRACDIV_FRACTIONALM            (0x0003FFFFu)
#define PLLSS_MPUPLL_FRACDIV_FRACTIONALM_SHIFT      (0x0u)

/** @brief PLLSS_MPUPLL_BWCTRL register fields */

#define PLLSS_MPUPLL_BWCTRL_BWCONTROL               (0x00000006u)
#define PLLSS_MPUPLL_BWCTRL_BWCONTROL_SHIFT         (0x1u)

/** @brief PLLSS_MPUPLL_FRACCTRL register fields */

#define PLLSS_MPUPLL_FRACCTRL_DOWNSPREAD            (0x80000000u)
#define PLLSS_MPUPLL_FRACCTRL_DOWNSPREAD_SHIFT      (0x1Fu)

#define PLLSS_MPUPLL_FRACCTRL_ModFreqDividerExponent    (0x70000000u)
#define PLLSS_MPUPLL_FRACCTRL_ModFreqDividerExponent_SHIFT  (0x1Cu)

#define PLLSS_MPUPLL_FRACCTRL_ModFreqDividerMantissa    (0x0FE00000u)
#define PLLSS_MPUPLL_FRACCTRL_ModFreqDividerMantissa_SHIFT  (0x15u)

#define PLLSS_MPUPLL_FRACCTRL_DeltaMStepInteger     (0x000C0000u)
#define PLLSS_MPUPLL_FRACCTRL_DeltaMStepInteger_SHIFT   (0x12u)

#define PLLSS_MPUPLL_FRACCTRL_DeltaMStepFraction    (0x0003FFFFu)
#define PLLSS_MPUPLL_FRACCTRL_DeltaMStepFraction_SHIFT  (0x0u)

/** @brief PLLSS_MPUPLL_STATUS register fields */

#define PLLSS_MPUPLL_STATUS_SSACK                   (0x40000000u)
#define PLLSS_MPUPLL_STATUS_SSACK_SHIFT             (0x1Eu)

#define PLLSS_MPUPLL_STATUS_LDOPWDN                 (0x20000000u)
#define PLLSS_MPUPLL_STATUS_LDOPWDN_SHIFT           (0x1Du)

#define PLLSS_MPUPLL_STATUS_RECAL_BSTATUS3          (0x10000000u)
#define PLLSS_MPUPLL_STATUS_RECAL_BSTATUS3_SHIFT    (0x1Cu)

#define PLLSS_MPUPLL_STATUS_RECAL_OPPIN             (0x08000000u)
#define PLLSS_MPUPLL_STATUS_RECAL_OPPIN_SHIFT       (0x1Bu)

#define PLLSS_MPUPLL_STATUS_PHASELOCK               (0x00000400u)
#define PLLSS_MPUPLL_STATUS_PHASELOCK_SHIFT         (0xAu)

#define PLLSS_MPUPLL_STATUS_FREQLOCK                (0x00000200u)
#define PLLSS_MPUPLL_STATUS_FREQLOCK_SHIFT          (0x9u)

#define PLLSS_MPUPLL_STATUS_BYPASSACK               (0x00000100u)
#define PLLSS_MPUPLL_STATUS_BYPASSACK_SHIFT         (0x8u)

#define PLLSS_MPUPLL_STATUS_STBYRETACK              (0x00000080u)
#define PLLSS_MPUPLL_STATUS_STBYRETACK_SHIFT        (0x7u)

#define PLLSS_MPUPLL_STATUS_LOSSREF                 (0x00000040u)
#define PLLSS_MPUPLL_STATUS_LOSSREF_SHIFT           (0x6u)

#define PLLSS_MPUPLL_STATUS_CLKOUTENACK             (0x00000020u)
#define PLLSS_MPUPLL_STATUS_CLKOUTENACK_SHIFT       (0x5u)

#define PLLSS_MPUPLL_STATUS_LOCK2                   (0x00000010u)
#define PLLSS_MPUPLL_STATUS_LOCK2_SHIFT             (0x4u)

#define PLLSS_MPUPLL_STATUS_M2CHANGEACK             (0x00000008u)
#define PLLSS_MPUPLL_STATUS_M2CHANGEACK_SHIFT       (0x3u)

#define PLLSS_MPUPLL_STATUS_LIMP                    (0x00000004u)
#define PLLSS_MPUPLL_STATUS_LIMP_SHIFT              (0x2u)

#define PLLSS_MPUPLL_STATUS_HIGHJITTER              (0x00000002u)
#define PLLSS_MPUPLL_STATUS_HIGHJITTER_SHIFT        (0x1u)

#define PLLSS_MPUPLL_STATUS_BYPASS                  (0x00000001u)
#define PLLSS_MPUPLL_STATUS_BYPASS_SHIFT            (0x0u)

/** @brief PLLSS_MPUPLL_M3DIV register fields */

#define PLLSS_MPUPLL_M3DIV_M3                       (0x0000001Fu)
#define PLLSS_MPUPLL_M3DIV_M3_SHIFT                 (0x0u)

/** @brief PLLSS_MPUPLL_RAMPCTRL register fields */

#define PLLSS_MPUPLL_RAMPCTRL_CLKRAMPLEVEL          (0x00180000u)
#define PLLSS_MPUPLL_RAMPCTRL_CLKRAMPLEVEL_SHIFT    (0x13u)

#define PLLSS_MPUPLL_RAMPCTRL_CLKRAMPRATE           (0x00070000u)
#define PLLSS_MPUPLL_RAMPCTRL_CLKRAMPRATE_SHIFT     (0x10u)

#define PLLSS_MPUPLL_RAMPCTRL_RELOCK_RAMP_EN        (0x00000001u)
#define PLLSS_MPUPLL_RAMPCTRL_RELOCK_RAMP_EN_SHIFT  (0x0u)

/** @brief PLLSS_PLL_PWRCTRL register fields */

#define PLLSS_PLL_PWRCTRL_PONIN                     (0x00000020u)
#define PLLSS_PLL_PWRCTRL_PONIN_SHIFT               (0x5u)

#define PLLSS_PLL_PWRCTRL_PGOODIN                   (0x00000010u)
#define PLLSS_PLL_PWRCTRL_PGOODIN_SHIFT             (0x4u)

#define PLLSS_PLL_PWRCTRL_RET                       (0x00000008u)
#define PLLSS_PLL_PWRCTRL_RET_SHIFT                 (0x3u)

#define PLLSS_PLL_PWRCTRL_ISORET                    (0x00000004u)
#define PLLSS_PLL_PWRCTRL_ISORET_SHIFT              (0x2u)

#define PLLSS_PLL_PWRCTRL_ISOSCAN                   (0x00000002u)
#define PLLSS_PLL_PWRCTRL_ISOSCAN_SHIFT             (0x1u)

#define PLLSS_PLL_PWRCTRL_OFFMODE                   (0x00000001u)
#define PLLSS_PLL_PWRCTRL_OFFMODE_SHIFT             (0x0u)

/** @brief PLLSS_PLL_CLKCTRL register fields */

#define PLLSS_PLL_CLKCTRL_CYCLESLIPEN               (0x80000000u)
#define PLLSS_PLL_CLKCTRL_CYCLESLIPEN_SHIFT         (0x1Fu)

#define PLLSS_PLL_CLKCTRL_ENSSC                     (0x40000000u)
#define PLLSS_PLL_CLKCTRL_ENSSC_SHIFT               (0x1Eu)

#define PLLSS_PLL_CLKCTRL_NWELLTRIM                 (0x1F000000u)
#define PLLSS_PLL_CLKCTRL_NWELLTRIM_SHIFT           (0x18u)

#define PLLSS_PLL_CLKCTRL_IDLE                      (0x00800000u)
#define PLLSS_PLL_CLKCTRL_IDLE_SHIFT                (0x17u)

#define PLLSS_PLL_CLKCTRL_BYPASSACKZ                (0x00400000u)
#define PLLSS_PLL_CLKCTRL_BYPASSACKZ_SHIFT          (0x16u)

#define PLLSS_PLL_CLKCTRL_STBYRET                   (0x00200000u)
#define PLLSS_PLL_CLKCTRL_STBYRET_SHIFT             (0x15u)

#define PLLSS_PLL_CLKCTRL_CLKOUTEN                  (0x00100000u)
#define PLLSS_PLL_CLKCTRL_CLKOUTEN_SHIFT            (0x14u)

#define PLLSS_PLL_CLKCTRL_ULOWCLKEN                 (0x00040000u)
#define PLLSS_PLL_CLKCTRL_ULOWCLKEN_SHIFT           (0x12u)

#define PLLSS_PLL_CLKCTRL_CLKDCOLDOPWDNZ            (0x00020000u)
#define PLLSS_PLL_CLKCTRL_CLKDCOLDOPWDNZ_SHIFT      (0x11u)

#define PLLSS_PLL_CLKCTRL_M2PWDNZ                   (0x00010000u)
#define PLLSS_PLL_CLKCTRL_M2PWDNZ_SHIFT             (0x10u)

#define PLLSS_PLL_CLKCTRL_SELFREQDCO                (0x00001C00u)
#define PLLSS_PLL_CLKCTRL_SELFREQDCO_SHIFT          (0xAu)

#define PLLSS_PLL_CLKCTRL_RELAXED_LOCK              (0x00000100u)
#define PLLSS_PLL_CLKCTRL_RELAXED_LOCK_SHIFT        (0x8u)

#define PLLSS_PLL_CLKCTRL_TINITZ                    (0x00000001u)
#define PLLSS_PLL_CLKCTRL_TINITZ_SHIFT              (0x0u)

/** @brief PLLSS_PLL_TENABLE register fields */

#define PLLSS_PLL_TENABLE_TENABLE                   (0x00000001u)
#define PLLSS_PLL_TENABLE_TENABLE_SHIFT             (0x0u)

/** @brief PLLSS_PLL_TENABLEDIV register fields */

#define PLLSS_PLL_TENABLEDIV_TENABLEDIV             (0x00000001u)
#define PLLSS_PLL_TENABLEDIV_TENABLEDIV_SHIFT       (0x0u)

/** @brief PLLSS_PLL_M2NDIV register fields */

#define PLLSS_PLL_M2NDIV_M2                         (0x007F0000u)
#define PLLSS_PLL_M2NDIV_M2_SHIFT                   (0x10u)

#define PLLSS_PLL_M2NDIV_N                          (0x000000FFu)
#define PLLSS_PLL_M2NDIV_N_SHIFT                    (0x0u)

/** @brief PLLSS_PLL_MN2DIV register fields */

#define PLLSS_PLL_MN2DIV_N2                         (0x000F0000u)
#define PLLSS_PLL_MN2DIV_N2_SHIFT                   (0x10u)

#define PLLSS_PLL_MN2DIV_M                          (0x00000FFFu)
#define PLLSS_PLL_MN2DIV_M_SHIFT                    (0x0u)

/** @brief PLLSS_PLL_FRACDIV register fields */

#define PLLSS_PLL_FRACDIV_REGSD                     (0xFF000000u)
#define PLLSS_PLL_FRACDIV_REGSD_SHIFT               (0x18u)

#define PLLSS_PLL_FRACDIV_FRACTIONALM               (0x0003FFFFu)
#define PLLSS_PLL_FRACDIV_FRACTIONALM_SHIFT         (0x0u)

/** @brief PLLSS_PLL_BWCTRL register fields */

#define PLLSS_PLL_BWCTRL_BWCONTROL                  (0x00000006u)
#define PLLSS_PLL_BWCTRL_BWCONTROL_SHIFT            (0x1u)

#define PLLSS_PLL_BWCTRL_BW_INCR_DECRZ              (0x00000001u)
#define PLLSS_PLL_BWCTRL_BW_INCR_DECRZ_SHIFT        (0x0u)

/** @brief PLLSS_PLL_FRACCTRL register fields */

#define PLLSS_PLL_FRACCTRL_DOWNSPREAD               (0x80000000u)
#define PLLSS_PLL_FRACCTRL_DOWNSPREAD_SHIFT         (0x1Fu)

#define PLLSS_PLL_FRACCTRL_MFDEXP                   (0x70000000u)
#define PLLSS_PLL_FRACCTRL_MFDEXP_SHIFT             (0x1Cu)

#define PLLSS_PLL_FRACCTRL_MFDMAN                   (0x0FE00000u)
#define PLLSS_PLL_FRACCTRL_MFDMAN_SHIFT             (0x15u)

#define PLLSS_PLL_FRACCTRL_DMSINT                   (0x001C0000u)
#define PLLSS_PLL_FRACCTRL_DMSINT_SHIFT             (0x12u)

#define PLLSS_PLL_FRACCTRL_DMSFRAC                  (0x0003FFFFu)
#define PLLSS_PLL_FRACCTRL_DMSFRAC_SHIFT            (0x0u)

/** @brief PLLSS_PLL_STATUS register fields */

#define PLLSS_PLL_STATUS_PONOUT                     (0x80000000u)
#define PLLSS_PLL_STATUS_PONOUT_SHIFT               (0x1Fu)

#define PLLSS_PLL_STATUS_PGOODOUT                   (0x40000000u)
#define PLLSS_PLL_STATUS_PGOODOUT_SHIFT             (0x1Eu)

#define PLLSS_PLL_STATUS_LDOPWDN                    (0x20000000u)
#define PLLSS_PLL_STATUS_LDOPWDN_SHIFT              (0x1Du)

#define PLLSS_PLL_STATUS_RECALBSTATUS3              (0x10000000u)
#define PLLSS_PLL_STATUS_RECALBSTATUS3_SHIFT        (0x1Cu)

#define PLLSS_PLL_STATUS_RECALOPPIN                 (0x08000000u)
#define PLLSS_PLL_STATUS_RECALOPPIN_SHIFT           (0x1Bu)

#define PLLSS_PLL_STATUS_PHASELOCK                  (0x00000400u)
#define PLLSS_PLL_STATUS_PHASELOCK_SHIFT            (0xAu)

#define PLLSS_PLL_STATUS_FREQLOCK                   (0x00000200u)
#define PLLSS_PLL_STATUS_FREQLOCK_SHIFT             (0x9u)

#define PLLSS_PLL_STATUS_BYPASSACK                  (0x00000100u)
#define PLLSS_PLL_STATUS_BYPASSACK_SHIFT            (0x8u)

#define PLLSS_PLL_STATUS_STBYRETACK                 (0x00000080u)
#define PLLSS_PLL_STATUS_STBYRETACK_SHIFT           (0x7u)

#define PLLSS_PLL_STATUS_LOSSREF                    (0x00000040u)
#define PLLSS_PLL_STATUS_LOSSREF_SHIFT              (0x6u)

#define PLLSS_PLL_STATUS_CLKOUTACK                  (0x00000020u)
#define PLLSS_PLL_STATUS_CLKOUTACK_SHIFT            (0x5u)

#define PLLSS_PLL_STATUS_LOCK2                      (0x00000010u)
#define PLLSS_PLL_STATUS_LOCK2_SHIFT                (0x4u)

#define PLLSS_PLL_STATUS_M2CHANGEACK                (0x00000008u)
#define PLLSS_PLL_STATUS_M2CHANGEACK_SHIFT          (0x3u)

#define PLLSS_PLL_STATUS_SSCACK                     (0x00000004u)
#define PLLSS_PLL_STATUS_SSCACK_SHIFT               (0x2u)

#define PLLSS_PLL_STATUS_HIGHJITTER                 (0x00000002u)
#define PLLSS_PLL_STATUS_HIGHJITTER_SHIFT           (0x1u)

#define PLLSS_PLL_STATUS_BYPASS                     (0x00000001u)
#define PLLSS_PLL_STATUS_BYPASS_SHIFT               (0x0u)

/** @brief PLLSS_OSC_SRC register fields */

#define PLLSS_OSC_SRC_GEM_PLL_SOURCE                (0x80000000u)
#define PLLSS_OSC_SRC_GEM_PLL_SOURCE_SHIFT          (0x1Fu)

#define PLLSS_OSC_SRC_SGX_PLL_SOURCE                (0x40000000u)
#define PLLSS_OSC_SRC_SGX_PLL_SOURCE_SHIFT          (0x1Eu)

#define PLLSS_OSC_SRC_ISS_PLL_SOURCE                (0x10000000u)
#define PLLSS_OSC_SRC_ISS_PLL_SOURCE_SHIFT          (0x1Cu)

#define PLLSS_OSC_SRC_USB_PLL_SOURCE                (0x04000000u)
#define PLLSS_OSC_SRC_USB_PLL_SOURCE_SHIFT          (0x1Au)

#define PLLSS_OSC_SRC_DDR_PLL_SOURCE                (0x02000000u)
#define PLLSS_OSC_SRC_DDR_PLL_SOURCE_SHIFT          (0x19u)

#define PLLSS_OSC_SRC_AUDIO_PLL_SOURCE              (0x01000000u)
#define PLLSS_OSC_SRC_AUDIO_PLL_SOURCE_SHIFT        (0x18u)

#define PLLSS_OSC_SRC_HDMI_PLL_SOURCE               (0x00040000u)
#define PLLSS_OSC_SRC_HDMI_PLL_SOURCE_SHIFT         (0x12u)

#define PLLSS_OSC_SRC_VIDEO1_PLL_SOURCE             (0x00020000u)
#define PLLSS_OSC_SRC_VIDEO1_PLL_SOURCE_SHIFT       (0x11u)

#define PLLSS_OSC_SRC_VIDEO0_PLL_SOURCE             (0x00010000u)
#define PLLSS_OSC_SRC_VIDEO0_PLL_SOURCE_SHIFT       (0x10u)

/** @brief PLLSS_ARM_CLKSRC register fields */

#define PLLSS_ARM_CLKSRC_ARM_SOURCE                 (0x00000001u)
#define PLLSS_ARM_CLKSRC_ARM_SOURCE_SHIFT           (0x0u)

/** @brief PLLSS_VIDEO_PLL_CLKSRC register fields */

#define PLLSS_VIDEO_PLL_CLKSRC_HD_VENC_G_CLK_SOURCE (0x01000000u)
#define PLLSS_VIDEO_PLL_CLKSRC_HD_VENC_G_CLK_SOURCE_SHIFT   (0x18u)

#define PLLSS_VIDEO_PLL_CLKSRC_TPPSSSTSO_MUX_SOURCE (0x000C0000u)
#define PLLSS_VIDEO_PLL_CLKSRC_TPPSSSTSO_MUX_SOURCE_SHIFT   (0x12u)

#define PLLSS_VIDEO_PLL_CLKSRC_VIDEO_PLL_OUT_MUX_SOURCE (0x00000300u)
#define PLLSS_VIDEO_PLL_CLKSRC_VIDEO_PLL_OUT_MUX_SOURCE_SHIFT   (0x8u)

/** @brief PLLSS_MLB_ATL_CLKSRC register fields */

#define PLLSS_MLB_ATL_CLKSRC_ATL_SOURCE             (0x00030000u)
#define PLLSS_MLB_ATL_CLKSRC_ATL_SOURCE_SHIFT       (0x10u)

#define PLLSS_MLB_ATL_CLKSRC_MLB_SOURCE             (0x00000001u)
#define PLLSS_MLB_ATL_CLKSRC_MLB_SOURCE_SHIFT       (0x0u)

/** @brief PLLSS_McASP345_AUX_CLKSRC register fields */

#define PLLSS_McASP345_AUX_CLKSRC_McASP5_AUX_SOURCE (0x00070000u)
#define PLLSS_McASP345_AUX_CLKSRC_McASP5_AUX_SOURCE_SHIFT   (0x10u)

#define PLLSS_McASP345_AUX_CLKSRC_McASP4_AUX_SOURCE (0x00000700u)
#define PLLSS_McASP345_AUX_CLKSRC_McASP4_AUX_SOURCE_SHIFT   (0x8u)

#define PLLSS_McASP345_AUX_CLKSRC_McASP3_AUX_SOURCE (0x00000007u)
#define PLLSS_McASP345_AUX_CLKSRC_McASP3_AUX_SOURCE_SHIFT   (0x0u)

/** @brief PLLSS_McASP_AHCLK_CLKSRC register fields */

#define PLLSS_McASP_AHCLK_CLKSRC_McASP5_AHCLKX_SOURCE   (0x0E000000u)
#define PLLSS_McASP_AHCLK_CLKSRC_McASP5_AHCLKX_SOURCE_SHIFT (0x19u)

#define PLLSS_McASP_AHCLK_CLKSRC_McASP4_AHCLKX_SOURCE   (0x01C00000u)
#define PLLSS_McASP_AHCLK_CLKSRC_McASP4_AHCLKX_SOURCE_SHIFT (0x16u)

#define PLLSS_McASP_AHCLK_CLKSRC_McASP3_AHCLKX_SOURCE   (0x00380000u)
#define PLLSS_McASP_AHCLK_CLKSRC_McASP3_AHCLKX_SOURCE_SHIFT (0x13u)

#define PLLSS_McASP_AHCLK_CLKSRC_McASP2_AHCLKX_SOURCE   (0x00070000u)
#define PLLSS_McASP_AHCLK_CLKSRC_McASP2_AHCLKX_SOURCE_SHIFT (0x10u)

#define PLLSS_McASP_AHCLK_CLKSRC_McASP1_AHCLKR_SOURCE   (0x00000E00u)
#define PLLSS_McASP_AHCLK_CLKSRC_McASP1_AHCLKR_SOURCE_SHIFT (0x9u)

#define PLLSS_McASP_AHCLK_CLKSRC_McASP1_AHCLKX_SOURCE   (0x000001C0u)
#define PLLSS_McASP_AHCLK_CLKSRC_McASP1_AHCLKX_SOURCE_SHIFT (0x6u)

#define PLLSS_McASP_AHCLK_CLKSRC_McASP0_AHCLKR_SOURCE   (0x00000038u)
#define PLLSS_McASP_AHCLK_CLKSRC_McASP0_AHCLKR_SOURCE_SHIFT (0x3u)

#define PLLSS_McASP_AHCLK_CLKSRC_McASP0_AHCLKX_SOURCE   (0x00000007u)
#define PLLSS_McASP_AHCLK_CLKSRC_McASP0_AHCLKX_SOURCE_SHIFT (0x0u)

/** @brief PLLSS_McBSP_UART_CLKSRC register fields */

#define PLLSS_McBSP_UART_CLKSRC_UART5_CLK_SOURCE    (0x00000180u)
#define PLLSS_McBSP_UART_CLKSRC_UART5_CLK_SOURCE_SHIFT  (0x7u)

#define PLLSS_McBSP_UART_CLKSRC_UART4_CLK_SOURCE    (0x00000060u)
#define PLLSS_McBSP_UART_CLKSRC_UART4_CLK_SOURCE_SHIFT  (0x5u)

#define PLLSS_McBSP_UART_CLKSRC_UART3_CLK_SOURCE    (0x00000018u)
#define PLLSS_McBSP_UART_CLKSRC_UART3_CLK_SOURCE_SHIFT  (0x3u)

#define PLLSS_McBSP_UART_CLKSRC_McBSP_CLKS_SOURCE   (0x00000007u)
#define PLLSS_McBSP_UART_CLKSRC_McBSP_CLKS_SOURCE_SHIFT (0x0u)

/** @brief PLLSS_DMTIMER_CLKSRC register fields */

#define PLLSS_DMTIMER_CLKSRC_DMTIMER7_SOURCE        (0xF0000000u)
#define PLLSS_DMTIMER_CLKSRC_DMTIMER7_SOURCE_SHIFT  (0x1Cu)

#define PLLSS_DMTIMER_CLKSRC_DMTIMER6_SOURCE        (0x0F000000u)
#define PLLSS_DMTIMER_CLKSRC_DMTIMER6_SOURCE_SHIFT  (0x18u)

#define PLLSS_DMTIMER_CLKSRC_DMTIMER5_SOURCE        (0x00F00000u)
#define PLLSS_DMTIMER_CLKSRC_DMTIMER5_SOURCE_SHIFT  (0x14u)

#define PLLSS_DMTIMER_CLKSRC_DMTIMER4_SOURCE        (0x000F0000u)
#define PLLSS_DMTIMER_CLKSRC_DMTIMER4_SOURCE_SHIFT  (0x10u)

#define PLLSS_DMTIMER_CLKSRC_DMTIMER3_SOURCE        (0x0000F000u)
#define PLLSS_DMTIMER_CLKSRC_DMTIMER3_SOURCE_SHIFT  (0xCu)

#define PLLSS_DMTIMER_CLKSRC_DMTIMER2_SOURCE        (0x00000F00u)
#define PLLSS_DMTIMER_CLKSRC_DMTIMER2_SOURCE_SHIFT  (0x8u)

#define PLLSS_DMTIMER_CLKSRC_DMTIMER1_SOURCE        (0x000000F0u)
#define PLLSS_DMTIMER_CLKSRC_DMTIMER1_SOURCE_SHIFT  (0x4u)

#define PLLSS_DMTIMER_CLKSRC_DMTIMER8_SOURCE        (0x0000000Fu)
#define PLLSS_DMTIMER_CLKSRC_DMTIMER8_SOURCE_SHIFT  (0x0u)

/** @brief PLLSS_CLKOUT_MUX register fields */

#define PLLSS_CLKOUT_MUX_CLKOUT1_MUX                (0x000F0000u)
#define PLLSS_CLKOUT_MUX_CLKOUT1_MUX_SHIFT          (0x10u)

#define PLLSS_CLKOUT_MUX_CLKOUT0_MUX                (0x0000000Fu)
#define PLLSS_CLKOUT_MUX_CLKOUT0_MUX_SHIFT          (0x0u)

/** @brief PLLSS_RMII_REFCLK_SRC register fields */

#define PLLSS_RMII_REFCLK_SRC_GMAC_50_CLK_MUX_SEL   (0x00020000u)
#define PLLSS_RMII_REFCLK_SRC_GMAC_50_CLK_MUX_SEL_SHIFT (0x11u)

#define PLLSS_RMII_REFCLK_SRC_GMAC_125_CLK_MUX_SEL  (0x00010000u)
#define PLLSS_RMII_REFCLK_SRC_GMAC_125_CLK_MUX_SEL_SHIFT    (0x10u)

#define PLLSS_RMII_REFCLK_SRC_CPTS_RFT_CLK          (0x0000000Eu)
#define PLLSS_RMII_REFCLK_SRC_CPTS_RFT_CLK_SHIFT    (0x1u)

#define PLLSS_RMII_REFCLK_SRC_REFCLK_SOURCE         (0x00000001u)
#define PLLSS_RMII_REFCLK_SRC_REFCLK_SOURCE_SHIFT   (0x0u)

/** @brief PLLSS_SECSS_CLK_SRC register fields */

#define PLLSS_SECSS_CLK_SRC_SECSSCLK_SOURCE         (0x00000001u)
#define PLLSS_SECSS_CLK_SRC_SECSSCLK_SOURCE_SHIFT   (0x0u)

/** @brief PLLSS_SYSCLK18_CLKSRC register fields */

#define PLLSS_SYSCLK18_CLKSRC_SYSCLK18_SOURCE       (0x00000001u)
#define PLLSS_SYSCLK18_CLKSRC_SYSCLK18_SOURCE_SHIFT (0x0u)

/** @brief PLLSS_WDT0_CLKSRC register fields */

#define PLLSS_WDT0_CLKSRC_WDT0_SOURCE               (0x00000001u)
#define PLLSS_WDT0_CLKSRC_WDT0_SOURCE_SHIFT         (0x0u)

/** @brief PLLSS_EMIF_CLK_GATE register fields */

#define PLLSS_EMIF_CLK_GATE_DDR0_CKE_STATUS         (0x00000004u)
#define PLLSS_EMIF_CLK_GATE_DDR0_CKE_STATUS_SHIFT   (0x2u)

#define PLLSS_EMIF_CLK_GATE_DDRPHY0_CLK_GATE        (0x00000001u)
#define PLLSS_EMIF_CLK_GATE_DDRPHY0_CLK_GATE_SHIFT  (0x0u)

/** @brief PLLSS_DMTIMER_CLK_CHANGE register fields */

#define PLLSS_DMTIMER_CLK_CHANGE_DMTIMER7_IDLESTATUS    (0x00008000u)
#define PLLSS_DMTIMER_CLK_CHANGE_DMTIMER7_IDLESTATUS_SHIFT  (0xFu)

#define PLLSS_DMTIMER_CLK_CHANGE_DMTIMER6_IDLESTATUS    (0x00004000u)
#define PLLSS_DMTIMER_CLK_CHANGE_DMTIMER6_IDLESTATUS_SHIFT  (0xEu)

#define PLLSS_DMTIMER_CLK_CHANGE_DMTIMER5_IDLESTATUS    (0x00002000u)
#define PLLSS_DMTIMER_CLK_CHANGE_DMTIMER5_IDLESTATUS_SHIFT  (0xDu)

#define PLLSS_DMTIMER_CLK_CHANGE_DMTIMER4_IDLESTATUS    (0x00001000u)
#define PLLSS_DMTIMER_CLK_CHANGE_DMTIMER4_IDLESTATUS_SHIFT  (0xCu)

#define PLLSS_DMTIMER_CLK_CHANGE_DMTIMER3_IDLESTATUS    (0x00000800u)
#define PLLSS_DMTIMER_CLK_CHANGE_DMTIMER3_IDLESTATUS_SHIFT  (0xBu)

#define PLLSS_DMTIMER_CLK_CHANGE_DMTIMER2_IDLESTATUS    (0x00000400u)
#define PLLSS_DMTIMER_CLK_CHANGE_DMTIMER2_IDLESTATUS_SHIFT  (0xAu)

#define PLLSS_DMTIMER_CLK_CHANGE_DMTIMER1_IDLESTATUS    (0x00000200u)
#define PLLSS_DMTIMER_CLK_CHANGE_DMTIMER1_IDLESTATUS_SHIFT  (0x9u)

#define PLLSS_DMTIMER_CLK_CHANGE_DMTIMER8_IDLESTATUS    (0x00000100u)
#define PLLSS_DMTIMER_CLK_CHANGE_DMTIMER8_IDLESTATUS_SHIFT  (0x8u)

#define PLLSS_DMTIMER_CLK_CHANGE_DMTIMER7_IDLEREQ   (0x00000080u)
#define PLLSS_DMTIMER_CLK_CHANGE_DMTIMER7_IDLEREQ_SHIFT (0x7u)

#define PLLSS_DMTIMER_CLK_CHANGE_DMTIMER6_IDLEREQ   (0x00000040u)
#define PLLSS_DMTIMER_CLK_CHANGE_DMTIMER6_IDLEREQ_SHIFT (0x6u)

#define PLLSS_DMTIMER_CLK_CHANGE_DMTIMER5_IDLEREQ   (0x00000020u)
#define PLLSS_DMTIMER_CLK_CHANGE_DMTIMER5_IDLEREQ_SHIFT (0x5u)

#define PLLSS_DMTIMER_CLK_CHANGE_DMTIMER4_IDLEREQ   (0x00000010u)
#define PLLSS_DMTIMER_CLK_CHANGE_DMTIMER4_IDLEREQ_SHIFT (0x4u)

#define PLLSS_DMTIMER_CLK_CHANGE_DMTIMER3_IDLEREQ   (0x00000008u)
#define PLLSS_DMTIMER_CLK_CHANGE_DMTIMER3_IDLEREQ_SHIFT (0x3u)

#define PLLSS_DMTIMER_CLK_CHANGE_DMTIMER2_IDLEREQ   (0x00000004u)
#define PLLSS_DMTIMER_CLK_CHANGE_DMTIMER2_IDLEREQ_SHIFT (0x2u)

#define PLLSS_DMTIMER_CLK_CHANGE_DMTIMER1_IDLEREQ   (0x00000002u)
#define PLLSS_DMTIMER_CLK_CHANGE_DMTIMER1_IDLEREQ_SHIFT (0x1u)

#define PLLSS_DMTIMER_CLK_CHANGE_DMTIMER8_IDLEREQ   (0x00000001u)
#define PLLSS_DMTIMER_CLK_CHANGE_DMTIMER8_IDLEREQ_SHIFT (0x0u)

/** @brief PLLSS_DEEPSLEEP_CTRL register fields */

#define PLLSS_DEEPSLEEP_CTRL_DSENABLE               (0x00020000u)
#define PLLSS_DEEPSLEEP_CTRL_DSENABLE_SHIFT         (0x11u)

#define PLLSS_DEEPSLEEP_CTRL_DSPOLARITY             (0x00010000u)
#define PLLSS_DEEPSLEEP_CTRL_DSPOLARITY_SHIFT       (0x10u)

#define PLLSS_DEEPSLEEP_CTRL_DSCOUNT                (0x0000FFFFu)
#define PLLSS_DEEPSLEEP_CTRL_DSCOUNT_SHIFT          (0x0u)

/** @brief PLLSS_DEEPSLEEP_STATUS register fields */

#define PLLSS_DEEPSLEEP_STATUS_DSCOMPLETE           (0x00000001u)
#define PLLSS_DEEPSLEEP_STATUS_DSCOMPLETE_SHIFT     (0x0u)

#ifdef __cplusplus
}
#endif

#endif
