/**
 * @file 		ADS5560.h
 * @author		James Thesing <james.thesing@criticallink.com>
 * @version		1.0
 *
 * @section LICENSE
 *
 *
 *    o  0
 *    | /       Copyright (c) 2005-2011
 *  (CL)---o   Critical Link, LLC
 *    \
 *     O
 *
 *
 * @section DESCRIPTION
 *
 * This class handles exercising the ADS5560 on the DSP. Input data is
 * acquired through an analog source, and capture data is sent back
 * to the ARM.
 */

#ifndef ADS5560_H_
#define ADS5560_H_

#include "ADS5560.h"
#include "core/DspUpp.h"

#include <stdint.h>
#include <std.h>
#include <tsk.h>
#include <clk.h>
#include <vector>



class ADS5560{
public:

	/**
	 * Get a pointer to the singleton ADS5560 object.
	 *
	 * @return A pointer to the singleton object.
	 */

	static ADS5560* getInstance();

	/**
	 * Gets data from the upp interface
	 * @param SAMPLE_SIZE amount of samples to collect
	 */
	void getData( int SAMPLE_SIZE );



private:

	/**
	 * Private Constructor - forces getInstance() use
	 */
	ADS5560();

	/**
	 * Destructor
	 */
	~ADS5560();

	/**
	 * Initialize DSP link
	 */
	void init();


	static ADS5560* mpUppSignal; //!< Pointer to the singleton.
	bool filled; //!<ensures table is filled only once
	const MityDSP::tcDspUpp::teUppChan meXmitChan; //!< Constant for
			//!< transmit channel.
	static const uint32_t uppFreq = 50000000; //!<freq of upp
	MityDSP::tcDspUpp* mpDspUpp; //!< Pointer to uPP driver singleton.
	MBX_Handle mhXmitMbx; //!< Handle to transmit mailbox.
	const MityDSP::tcDspUpp::teUppChan meRecvChan; //!< Constant for
			//!< receive channel.
	MBX_Handle mhRecvMbx; //!< Handle to receive mailbox.

};

#endif /*ADS5560_H_*/
