module pcie_rp_ed_top (
    // FPGA peripherals ports
//  	output wire [3:0]  fpga_led_pio,                     
   // HPS memory controller ports
//	output wire [14:0] hps_memory_mem_a,                           
//	output wire [2:0]  hps_memory_mem_ba,                          
//	output wire        hps_memory_mem_ck,                          
//	output wire        hps_memory_mem_ck_n,                        
//	output wire        hps_memory_mem_cke,                         
//	output wire        hps_memory_mem_cs_n,                        
//	output wire        hps_memory_mem_ras_n,                       
//	output wire        hps_memory_mem_cas_n,                       
//	output wire        hps_memory_mem_we_n,                        
//	output wire        hps_memory_mem_reset_n,                     
//	inout  wire [39:0] hps_memory_mem_dq,                          
//	inout  wire [4:0]  hps_memory_mem_dqs,                         
//	inout  wire [4:0]  hps_memory_mem_dqs_n,                       
//	output wire        hps_memory_mem_odt,                         
//	output wire [4:0]  hps_memory_mem_dm,                          
//	input  wire        hps_memory_oct_rzqin,                       
	output wire [14:0 ] HPS_DDR_A,
	output wire [2:0] HPS_DDR_BAS,
	output wire HPS_DDR_CK_P,
	output wire HPS_DDR_CK_N,
	output wire HPS_DDR_CKE,
	output wire HPS_DDR_CS0_N,
	output wire HPS_DDR_RAS_N,
	output wire HPS_DDR_CAS_N,
	output wire HPS_DDR_WE_N,
	output wire HPS_DDR_RESET_N,
	inout wire [39:0] HPS_DDR_D,
	inout wire [4:0] HPS_DDR_DQS_P,
	inout wire [4:0] HPS_DDR_DQS_N,
	output wire [4:0] HPS_DDR_DQM,
	input wire HPS_RZQ0,
	output wire HPS_ODT,
    // HPS peripherals
/*
	output wire        hps_emac1_TX_CLK,   
	output wire        hps_emac1_TXD0,     
	output wire        hps_emac1_TXD1,     
	output wire        hps_emac1_TXD2,     
	output wire        hps_emac1_TXD3,     
	input  wire        hps_emac1_RXD0,     
	inout  wire        hps_emac1_MDIO,     
	output wire        hps_emac1_MDC,      
	input  wire        hps_emac1_RX_CTL,   
	output wire        hps_emac1_TX_CTL,   
	input  wire        hps_emac1_RX_CLK,   
	input  wire        hps_emac1_RXD1,     
	input  wire        hps_emac1_RXD2,     
	input  wire        hps_emac1_RXD3,     
	inout wire RGMII1_RESETn, 
	inout  wire        hps_qspi_IO0,       
	inout  wire        hps_qspi_IO1,       
	inout  wire        hps_qspi_IO2,       
	inout  wire        hps_qspi_IO3,       
	output wire        hps_qspi_SS0,       
	output wire        hps_qspi_CLK,       
	inout  wire        hps_sdio_CMD,       
	inout  wire        hps_sdio_D0,        
	inout  wire        hps_sdio_D1,        
	output wire        hps_sdio_CLK,       
	inout  wire        hps_sdio_D2,        
	inout  wire        hps_sdio_D3,        
	inout  wire        hps_usb1_D0,        
	inout  wire        hps_usb1_D1,        
	inout  wire        hps_usb1_D2,        
	inout  wire        hps_usb1_D3,        
	inout  wire        hps_usb1_D4,        
	inout  wire        hps_usb1_D5,        
	inout  wire        hps_usb1_D6,        
	inout  wire        hps_usb1_D7,        
	input  wire        hps_usb1_CLK,       
	output wire        hps_usb1_STP,       
	input  wire        hps_usb1_DIR,       
	input  wire        hps_usb1_NXT,       
	output wire        hps_spim0_CLK,      
	output wire        hps_spim0_MOSI,     
	input  wire        hps_spim0_MISO,     
	output wire        hps_spim0_SS0,      
	input  wire        hps_uart0_RX,       
	output wire        hps_uart0_TX,       
	inout  wire        hps_i2c0_SDA,       
	inout  wire        hps_i2c0_SCL,       
	input  wire        hps_can0_RX,        
	output wire        hps_can0_TX,        
	output wire        hps_trace_CLK,      
	output wire        hps_trace_D0,       
	output wire        hps_trace_D1,       
	output wire        hps_trace_D2,       
	output wire        hps_trace_D3,       
	output wire        hps_trace_D4,       
	output wire        hps_trace_D5,       
	output wire        hps_trace_D6,       
	output wire        hps_trace_D7,       
	inout  wire        hps_gpio_GPIO09,    
	inout  wire        hps_gpio_GPIO35,    
	inout  wire        hps_gpio_GPIO41,    
	inout  wire        hps_gpio_GPIO42,    
	inout  wire        hps_gpio_GPIO43,    
	inout  wire        hps_gpio_GPIO44,    
*/
	// RGMII1                                                       
	output wire RGMII1_TX_CLK,
	output wire RGMII1_TXD0,
	output wire RGMII1_TXD1,
	output wire RGMII1_TXD2,
	output wire RGMII1_TXD3,
	input wire RGMII1_RXD0,
	inout wire RGMII1_MDIO,
	output wire RGMII1_MDC,
	input wire RGMII1_RX_CTL,
	output wire RGMII1_TX_CTL,
	input wire RGMII1_RX_CLK,
	input wire RGMII1_RXD1,
	input wire RGMII1_RXD2,
	input wire RGMII1_RXD3,
	inout wire RGMII1_RESETn,
	// QSPI                                                         
	inout wire QSPI_DQ0,
	inout wire QSPI_DQ1,
	inout wire QSPI_DQ2,
	inout wire QSPI_DQ3,
	output wire QSPI_SS0,
	output wire QSPI_SS1,
	output wire QSPI_CLK,
	// SDMMC                                                        
	inout wire SDMMC_CMD,
	inout wire SDMMC_D0,
	inout wire SDMMC_D1,
	output wire SDMMC_CLK,
	inout wire SDMMC_D2,
	inout wire SDMMC_D3,
	// USB1                                                         
	inout wire USB1_ULPI_D0,
	inout wire USB1_ULPI_D1,
	inout wire USB1_ULPI_D2,
	inout wire USB1_ULPI_D3,
	inout wire USB1_ULPI_D4,
	inout wire USB1_ULPI_D5,
	inout wire USB1_ULPI_D6,
	inout wire USB1_ULPI_D7,
	input wire USB1_ULPI_CLK,
	output wire USB1_ULPI_STP,
	input wire USB1_ULPI_DIR,
	input wire USB1_ULPI_NXT,
	inout wire USB1_ULPI_CS,
	inout wire USB1_ULPI_RESET_N,
	// UART0                                                        
	input wire B7A_UART0_RX,
	output wire B7A_UART0_TX,
	// I2C0                                                         
	inout wire B7A_I2C0_SDA,
	inout wire B7A_I2C0_SCL,
	// CAN0                                                         
	input wire B7A_CAN0_RX,
	output wire B7A_CAN0_TX,
	// CAN1                                                         
	input wire B7A_CAN1_RX,
	output wire B7A_CAN1_TX,
	// I2C1                                                         
	inout wire I2C1_SCL,
	inout wire I2C1_SDA,
	// LEDs                                                         
	inout wire LED1,
	inout wire LED2,
	inout wire LED3,
	// Switches                                                     
	inout wire SW1,
	inout wire SW2,
	inout wire SW3,

    // PCIe signals
    input  wire        pcie_refclk_clk,                          
    inout wire        pcie_npor_pin_perst,                      
    input  wire        pcie_hip_rx_in0,                   
    input  wire        pcie_hip_rx_in1,                   
    input  wire        pcie_hip_rx_in2,                   
    input  wire        pcie_hip_rx_in3,                   
    output wire        pcie_hip_tx_out0,                  
    output wire        pcie_hip_tx_out1,                  
    output wire        pcie_hip_tx_out2,                  
    output wire        pcie_hip_tx_out3
//    output wire        pcie_perstn_out,
    // FPGA clock and reset
//	input  wire        fpga_clk_50,
//   input  wire        fpga_rst_n	
);

// internal wires and registers declaration
  wire       fpga_led_internal;
  wire       hps_fpga_reset_n;
  wire       pcie_npor_npor;
  wire [4:0] pipe_sim_ltssmstate;
  wire       sync_pcie_por;
  wire       sync_pcie_por_n;
  wire       coreclk_fan_clk;
  wire       coreclk_fan_reset_n;
  wire       pcie_reconfig_clk_locked_fixedclk_locked;
  wire [2:0] hps_reset_req;
  wire       hps_cold_reset;
  wire       hps_warm_reset;
  wire       hps_debug_reset;
  wire pcie_reset; 

  reg         L0_led;        // link status ltssm=0xf
  reg         alive_led;     // heart beat 
  reg  [1:0]  linkwidth_led; // link width, 1=x1, 2=x4, skipped x2 and ignored x8
  reg  [25:0] alive_cnt;
 

// connection of internal logics
//  assign pcie_perstn_out = ~fpga_led_internal;
  assign pcie_npor_pin_perst = pcie_reset ? ~pcie_reset : 1'bz;
//  assign fpga_led_pio = {L0_led, alive_led, linkwidth_led[1], ~fpga_led_internal};
  assign pcie_npor_npor = hps_fpga_reset_n & pcie_npor_pin_perst; // & fpga_rst_n;
//  assign sync_pcie_por_n = ~sync_pcie_por;
  
	  
  // logic for LED display derivation
//  always @(posedge coreclk_fan_clk or negedge coreclk_fan_reset_n) begin // pcie_refclk_clk to be modified with coreclk_out from PCIe IP later
//    if (!coreclk_fan_reset_n) begin
//      L0_led        <= 1'b0;      
//      alive_led     <= 1'b0;   
//      linkwidth_led <= 2'h0;
//      alive_cnt     <= 26'd0;
//      end
//    else begin
//      L0_led        <= ~(pipe_sim_ltssmstate[3:0] == 4'hf);
//      alive_led     <= alive_cnt[25];   
//      linkwidth_led <= {alive_cnt[24],alive_cnt[21]}; // tentatively assign linkwidth_led as flashing display as PCIe HIP has yet exposed the tl_cfg_sts signal
//      alive_cnt     <= alive_cnt + 1;   
//      end
//    end
  
// SoC sub-system module
pcie_rp_ed_5csxfc6 soc_inst (
  .memory_mem_a                                           (HPS_DDR_A), //hps_memory_mem_a),                               
  .memory_mem_ba                                          (HPS_DDR_BAS), //hps_memory_mem_ba),                         
  .memory_mem_ck                                          (HPS_DDR_CK_P), //hps_memory_mem_ck),                         
  .memory_mem_ck_n                                        (HPS_DDR_CK_N), //hps_memory_mem_ck_n),                       
  .memory_mem_cke                                         (HPS_DDR_CKE), //hps_memory_mem_cke),                        
  .memory_mem_cs_n                                        (HPS_DDR_CS0_N), //hps_memory_mem_cs_n),                       
  .memory_mem_ras_n                                       (HPS_DDR_RAS_N), //hps_memory_mem_ras_n),                      
  .memory_mem_cas_n                                       (HPS_DDR_CAS_N), //hps_memory_mem_cas_n),                      
  .memory_mem_we_n                                        (HPS_DDR_WE_N), //hps_memory_mem_we_n),                       
  .memory_mem_reset_n                                     (HPS_DDR_RESET_N), //hps_memory_mem_reset_n),                    
  .memory_mem_dq                                          (HPS_DDR_D), //hps_memory_mem_dq),                         
  .memory_mem_dqs                                         (HPS_DDR_DQS_P), //hps_memory_mem_dqs),                        
  .memory_mem_dqs_n                                       (HPS_DDR_DQS_N), //hps_memory_mem_dqs_n),                      
  .memory_mem_odt                                         (HPS_ODT), //hps_memory_mem_odt),                        
  .memory_mem_dm                                          (HPS_DDR_DQM), //hps_memory_mem_dm),                         
  .memory_oct_rzqin                                       (HPS_RZQ0), //hps_memory_oct_rzqin),                      
  .pio_led_external_connection_in_port                    (fpga_led_internal),
  .pio_led_external_connection_out_port                   (fpga_led_internal),                   
/*
  .hps_0_hps_io_hps_io_emac1_inst_TX_CLK                  (hps_emac1_TX_CLK), 
  .hps_0_hps_io_hps_io_emac1_inst_TXD0                    (hps_emac1_TXD0),   
  .hps_0_hps_io_hps_io_emac1_inst_TXD1                    (hps_emac1_TXD1),   
  .hps_0_hps_io_hps_io_emac1_inst_TXD2                    (hps_emac1_TXD2),   
  .hps_0_hps_io_hps_io_emac1_inst_TXD3                    (hps_emac1_TXD3),   
  .hps_0_hps_io_hps_io_emac1_inst_RXD0                    (hps_emac1_RXD0),   
  .hps_0_hps_io_hps_io_emac1_inst_MDIO                    (hps_emac1_MDIO),   
  .hps_0_hps_io_hps_io_emac1_inst_MDC                     (hps_emac1_MDC),    
  .hps_0_hps_io_hps_io_emac1_inst_RX_CTL                  (hps_emac1_RX_CTL), 
  .hps_0_hps_io_hps_io_emac1_inst_TX_CTL                  (hps_emac1_TX_CTL), 
  .hps_0_hps_io_hps_io_emac1_inst_RX_CLK                  (hps_emac1_RX_CLK), 
  .hps_0_hps_io_hps_io_emac1_inst_RXD1                    (hps_emac1_RXD1),   
  .hps_0_hps_io_hps_io_emac1_inst_RXD2                    (hps_emac1_RXD2),   
  .hps_0_hps_io_hps_io_emac1_inst_RXD3                    (hps_emac1_RXD3),   
  .hps_0_hps_io_hps_io_qspi_inst_IO0                      (hps_qspi_IO0),     
  .hps_0_hps_io_hps_io_qspi_inst_IO1                      (hps_qspi_IO1),     
  .hps_0_hps_io_hps_io_qspi_inst_IO2                      (hps_qspi_IO2),     
  .hps_0_hps_io_hps_io_qspi_inst_IO3                      (hps_qspi_IO3),     
  .hps_0_hps_io_hps_io_qspi_inst_SS0                      (hps_qspi_SS0),     
  .hps_0_hps_io_hps_io_qspi_inst_CLK                      (hps_qspi_CLK),     
  .hps_0_hps_io_hps_io_sdio_inst_CMD                      (hps_sdio_CMD),     
  .hps_0_hps_io_hps_io_sdio_inst_D0                       (hps_sdio_D0),      
  .hps_0_hps_io_hps_io_sdio_inst_D1                       (hps_sdio_D1),      
  .hps_0_hps_io_hps_io_sdio_inst_CLK                      (hps_sdio_CLK),     
  .hps_0_hps_io_hps_io_sdio_inst_D2                       (hps_sdio_D2),      
  .hps_0_hps_io_hps_io_sdio_inst_D3                       (hps_sdio_D3),      
  .hps_0_hps_io_hps_io_usb1_inst_D0                       (hps_usb1_D0),      
  .hps_0_hps_io_hps_io_usb1_inst_D1                       (hps_usb1_D1),      
  .hps_0_hps_io_hps_io_usb1_inst_D2                       (hps_usb1_D2),      
  .hps_0_hps_io_hps_io_usb1_inst_D3                       (hps_usb1_D3),      
  .hps_0_hps_io_hps_io_usb1_inst_D4                       (hps_usb1_D4),      
  .hps_0_hps_io_hps_io_usb1_inst_D5                       (hps_usb1_D5),      
  .hps_0_hps_io_hps_io_usb1_inst_D6                       (hps_usb1_D6),      
  .hps_0_hps_io_hps_io_usb1_inst_D7                       (hps_usb1_D7),      
  .hps_0_hps_io_hps_io_usb1_inst_CLK                      (hps_usb1_CLK),     
  .hps_0_hps_io_hps_io_usb1_inst_STP                      (hps_usb1_STP),     
  .hps_0_hps_io_hps_io_usb1_inst_DIR                      (hps_usb1_DIR),     
  .hps_0_hps_io_hps_io_usb1_inst_NXT                      (hps_usb1_NXT),     
  .hps_0_hps_io_hps_io_spim0_inst_CLK                     (hps_spim0_CLK),    
  .hps_0_hps_io_hps_io_spim0_inst_MOSI                    (hps_spim0_MOSI),   
  .hps_0_hps_io_hps_io_spim0_inst_MISO                    (hps_spim0_MISO),   
  .hps_0_hps_io_hps_io_spim0_inst_SS0                     (hps_spim0_SS0),    
  .hps_0_hps_io_hps_io_uart0_inst_RX                      (hps_uart0_RX),     
  .hps_0_hps_io_hps_io_uart0_inst_TX                      (hps_uart0_TX),     
  .hps_0_hps_io_hps_io_i2c0_inst_SDA                      (hps_i2c0_SDA),     
  .hps_0_hps_io_hps_io_i2c0_inst_SCL                      (hps_i2c0_SCL),     
  .hps_0_hps_io_hps_io_can0_inst_RX                       (hps_can0_RX),      
  .hps_0_hps_io_hps_io_can0_inst_TX                       (hps_can0_TX),      
  .hps_0_hps_io_hps_io_trace_inst_CLK                     (hps_trace_CLK),    
  .hps_0_hps_io_hps_io_trace_inst_D0                      (hps_trace_D0),     
  .hps_0_hps_io_hps_io_trace_inst_D1                      (hps_trace_D1),     
  .hps_0_hps_io_hps_io_trace_inst_D2                      (hps_trace_D2),     
  .hps_0_hps_io_hps_io_trace_inst_D3                      (hps_trace_D3),     
  .hps_0_hps_io_hps_io_trace_inst_D4                      (hps_trace_D4),     
  .hps_0_hps_io_hps_io_trace_inst_D5                      (hps_trace_D5),     
  .hps_0_hps_io_hps_io_trace_inst_D6                      (hps_trace_D6),     
  .hps_0_hps_io_hps_io_trace_inst_D7                      (hps_trace_D7),     
  .hps_0_hps_io_hps_io_gpio_inst_GPIO09                   (hps_gpio_GPIO09),  
  .hps_0_hps_io_hps_io_gpio_inst_GPIO35                   (hps_gpio_GPIO35),  
  .hps_0_hps_io_hps_io_gpio_inst_GPIO41                   (hps_gpio_GPIO41),  
  .hps_0_hps_io_hps_io_gpio_inst_GPIO42                   (hps_gpio_GPIO42),  
  .hps_0_hps_io_hps_io_gpio_inst_GPIO43                   (hps_gpio_GPIO43),  
  .hps_0_hps_io_hps_io_gpio_inst_GPIO44                   (hps_gpio_GPIO44),
*/
	.hps_0_hps_io_hps_io_emac1_inst_TX_CLK                  (RGMII1_TX_CLK),
        .hps_0_hps_io_hps_io_emac1_inst_TXD0                    (RGMII1_TXD0),
        .hps_0_hps_io_hps_io_emac1_inst_TXD1                    (RGMII1_TXD1),
        .hps_0_hps_io_hps_io_emac1_inst_TXD2                    (RGMII1_TXD2),
        .hps_0_hps_io_hps_io_emac1_inst_TXD3                    (RGMII1_TXD3),
        .hps_0_hps_io_hps_io_emac1_inst_RXD0                    (RGMII1_RXD0),
        .hps_0_hps_io_hps_io_emac1_inst_MDIO                    (RGMII1_MDIO),
        .hps_0_hps_io_hps_io_emac1_inst_MDC                     (RGMII1_MDC),
        .hps_0_hps_io_hps_io_emac1_inst_RX_CTL                  (RGMII1_RX_CTL),
        .hps_0_hps_io_hps_io_emac1_inst_TX_CTL                  (RGMII1_TX_CTL),
        .hps_0_hps_io_hps_io_emac1_inst_RX_CLK                  (RGMII1_RX_CLK),
        .hps_0_hps_io_hps_io_emac1_inst_RXD1                    (RGMII1_RXD1),
        .hps_0_hps_io_hps_io_emac1_inst_RXD2                    (RGMII1_RXD2),
        .hps_0_hps_io_hps_io_emac1_inst_RXD3                    (RGMII1_RXD3),
        .hps_0_hps_io_hps_io_qspi_inst_SS1                      (QSPI_SS1),
        .hps_0_hps_io_hps_io_qspi_inst_IO0                      (QSPI_DQ0),
        .hps_0_hps_io_hps_io_qspi_inst_IO1                      (QSPI_DQ1),
        .hps_0_hps_io_hps_io_qspi_inst_IO2                      (QSPI_DQ2),
        .hps_0_hps_io_hps_io_qspi_inst_IO3                      (QSPI_DQ3),
        .hps_0_hps_io_hps_io_qspi_inst_SS0                      (QSPI_SS0),
        .hps_0_hps_io_hps_io_qspi_inst_CLK                      (QSPI_CLK),
        .hps_0_hps_io_hps_io_sdio_inst_CMD                      (SDMMC_CMD),
        .hps_0_hps_io_hps_io_sdio_inst_D0                       (SDMMC_D0),
        .hps_0_hps_io_hps_io_sdio_inst_D1                       (SDMMC_D1),
        .hps_0_hps_io_hps_io_sdio_inst_CLK                      (SDMMC_CLK),
        .hps_0_hps_io_hps_io_sdio_inst_D2                       (SDMMC_D2),
        .hps_0_hps_io_hps_io_sdio_inst_D3                       (SDMMC_D3),
        .hps_0_hps_io_hps_io_usb1_inst_D0                       (USB1_ULPI_D0),
        .hps_0_hps_io_hps_io_usb1_inst_D1                       (USB1_ULPI_D1),
        .hps_0_hps_io_hps_io_usb1_inst_D2                       (USB1_ULPI_D2),
        .hps_0_hps_io_hps_io_usb1_inst_D3                       (USB1_ULPI_D3),
        .hps_0_hps_io_hps_io_usb1_inst_D4                       (USB1_ULPI_D4),
        .hps_0_hps_io_hps_io_usb1_inst_D5                       (USB1_ULPI_D5),
        .hps_0_hps_io_hps_io_usb1_inst_D6                       (USB1_ULPI_D6),
        .hps_0_hps_io_hps_io_usb1_inst_D7                       (USB1_ULPI_D7),
        .hps_0_hps_io_hps_io_usb1_inst_CLK                      (USB1_ULPI_CLK),
        .hps_0_hps_io_hps_io_usb1_inst_STP                      (USB1_ULPI_STP),
        .hps_0_hps_io_hps_io_usb1_inst_DIR                      (USB1_ULPI_DIR),
        .hps_0_hps_io_hps_io_usb1_inst_NXT                      (USB1_ULPI_NXT),
        .hps_0_hps_io_hps_io_uart0_inst_RX                      (B7A_UART0_RX),
        .hps_0_hps_io_hps_io_uart0_inst_TX                      (B7A_UART0_TX),
        .hps_0_hps_io_hps_io_i2c0_inst_SDA                      (B7A_I2C0_SDA),
        .hps_0_hps_io_hps_io_i2c0_inst_SCL                      (B7A_I2C0_SCL),
        .hps_0_hps_io_hps_io_i2c1_inst_SDA                      (I2C1_SCL),
        .hps_0_hps_io_hps_io_i2c1_inst_SCL                      (I2C1_SDA),
        .hps_0_hps_io_hps_io_can0_inst_RX                       (B7A_CAN0_RX),
        .hps_0_hps_io_hps_io_can0_inst_TX                       (B7A_CAN0_TX),
	.hps_0_hps_io_hps_io_can1_inst_RX                       (B7A_CAN1_RX),
        .hps_0_hps_io_hps_io_can1_inst_TX                       (B7A_CAN1_TX),
        .hps_0_hps_io_hps_io_gpio_inst_GPIO00                   (USB1_ULPI_CS),
        .hps_0_hps_io_hps_io_gpio_inst_GPIO09                   (USB1_ULPI_RESET_N),
        .hps_0_hps_io_hps_io_gpio_inst_GPIO28                   (LED3),
        .hps_0_hps_io_hps_io_gpio_inst_GPIO37                   (SW1),
        .hps_0_hps_io_hps_io_gpio_inst_GPIO40                   (SW2),
        .hps_0_hps_io_hps_io_gpio_inst_GPIO41                   (SW3),
        .hps_0_hps_io_hps_io_gpio_inst_GPIO48                   (RGMII1_RESETn),
        .hps_0_hps_io_hps_io_gpio_inst_GPIO49                   (LED2),
        .hps_0_hps_io_hps_io_gpio_inst_GPIO50                   (LED1),

  .pcie_cv_hip_avmm_0_refclk_clk                          (pcie_refclk_clk),
  .pcie_cv_hip_avmm_0_npor_npor                           (pcie_npor_npor),
  .pcie_cv_hip_avmm_0_npor_pin_perst                      (pcie_npor_pin_perst),
  .pcie_cv_hip_avmm_0_reconfig_clk_locked_fixedclk_locked (pcie_reconfig_clk_locked_fixedclk_locked),
  .pcie_cv_hip_avmm_0_hip_serial_rx_in0                   (pcie_hip_rx_in0),
  .pcie_cv_hip_avmm_0_hip_serial_rx_in1                   (pcie_hip_rx_in1),
  .pcie_cv_hip_avmm_0_hip_serial_rx_in2                   (pcie_hip_rx_in2),
  .pcie_cv_hip_avmm_0_hip_serial_rx_in3                   (pcie_hip_rx_in3),
  .pcie_cv_hip_avmm_0_hip_serial_tx_out0                  (pcie_hip_tx_out0),
  .pcie_cv_hip_avmm_0_hip_serial_tx_out1                  (pcie_hip_tx_out1),
  .pcie_cv_hip_avmm_0_hip_serial_tx_out2                  (pcie_hip_tx_out2),
  .pcie_cv_hip_avmm_0_hip_serial_tx_out3                  (pcie_hip_tx_out3),
  .pcie_cv_hip_avmm_0_hip_pipe_sim_pipe_pclk_in           (1'b0),
  .pcie_cv_hip_avmm_0_hip_pipe_sim_ltssmstate             (pipe_sim_ltssmstate),
  .pcie_cv_hip_avmm_0_hip_pipe_phystatus0                 (1'b0),
  .pcie_cv_hip_avmm_0_hip_pipe_phystatus1                 (1'b0),
  .pcie_cv_hip_avmm_0_hip_pipe_phystatus2                 (1'b0),
  .pcie_cv_hip_avmm_0_hip_pipe_phystatus3                 (1'b0),
  .pcie_cv_hip_avmm_0_hip_pipe_rxdata0                    (8'h0),
  .pcie_cv_hip_avmm_0_hip_pipe_rxdata1                    (8'h0),
  .pcie_cv_hip_avmm_0_hip_pipe_rxdata2                    (8'h0),
  .pcie_cv_hip_avmm_0_hip_pipe_rxdata3                    (8'h0),
  .pcie_cv_hip_avmm_0_hip_pipe_rxdatak0                   (8'h0),
  .pcie_cv_hip_avmm_0_hip_pipe_rxdatak1                   (8'h0),
  .pcie_cv_hip_avmm_0_hip_pipe_rxdatak2                   (8'h0),
  .pcie_cv_hip_avmm_0_hip_pipe_rxdatak3                   (8'h0),
  .pcie_cv_hip_avmm_0_hip_pipe_rxelecidle0                (1'b0),
  .pcie_cv_hip_avmm_0_hip_pipe_rxelecidle1                (1'b0),
  .pcie_cv_hip_avmm_0_hip_pipe_rxelecidle2                (1'b0),
  .pcie_cv_hip_avmm_0_hip_pipe_rxelecidle3                (1'b0),
  .pcie_cv_hip_avmm_0_hip_pipe_rxstatus0                  (3'h0),
  .pcie_cv_hip_avmm_0_hip_pipe_rxstatus1                  (3'h0),
  .pcie_cv_hip_avmm_0_hip_pipe_rxstatus2                  (3'h0),  
  .pcie_cv_hip_avmm_0_hip_pipe_rxstatus3                  (3'h0),  
  .pcie_cv_hip_avmm_0_hip_pipe_rxvalid0                   (1'b0),  
  .pcie_cv_hip_avmm_0_hip_pipe_rxvalid1                   (1'b0),  
  .pcie_cv_hip_avmm_0_hip_pipe_rxvalid2                   (1'b0),  
  .pcie_cv_hip_avmm_0_hip_pipe_rxvalid3                   (1'b0),  
  .alt_xcvr_reconfig_0_reconfig_mgmt_address              (7'h0),  
  .alt_xcvr_reconfig_0_reconfig_mgmt_read                 (1'b0),  
  .alt_xcvr_reconfig_0_reconfig_mgmt_write                (1'b0),  
  .alt_xcvr_reconfig_0_reconfig_mgmt_writedata            (32'h0),  
 
  .coreclk_fan_clk_clk                                    (coreclk_fan_clk),
  .coreclk_fan_reset_reset_n                              (coreclk_fan_reset_n),
//  .clk_clk                                                (fpga_clk_50),
  .hps_0_h2f_reset_reset_n                                (hps_fpga_reset_n),
//  .reset_reset_n                                          (hps_fpga_reset_n),
//  .hps_0_f2h_cold_reset_req_reset_n                       (~hps_cold_reset),
//  .hps_0_f2h_warm_reset_req_reset_n                       (~hps_warm_reset),
//  .hps_0_f2h_debug_reset_req_reset_n                      (~hps_debug_reset)
  .reset_1_reset_n					  (hps_fpga_reset_n),
  .pio_pcie_reset_export 				(pcie_reset)
);  

// Source/Probe megawizard instance
//hps_reset hps_reset_inst (
//  .source_clk (fpga_clk_50),
//  .source     (hps_reset_req)
//);

//altera_edge_detector pulse_cold_reset (
//  .clk       (fpga_clk_50),
//  .rst_n     (hps_fpga_reset_n),
//  .signal_in (hps_reset_req[0]),
//  .pulse_out (hps_cold_reset)
//);
//  defparam pulse_cold_reset.PULSE_EXT = 6;
//  defparam pulse_cold_reset.EDGE_TYPE = 1;
//  defparam pulse_cold_reset.IGNORE_RST_WHILE_BUSY = 1;

//altera_edge_detector pulse_warm_reset (
//  .clk       (fpga_clk_50),
//  .rst_n     (hps_fpga_reset_n),
//  .signal_in (hps_reset_req[1]),
//  .pulse_out (hps_warm_reset)
//);
//  defparam pulse_warm_reset.PULSE_EXT = 2;
//  defparam pulse_warm_reset.EDGE_TYPE = 1;
//  defparam pulse_warm_reset.IGNORE_RST_WHILE_BUSY = 1;
  
//altera_edge_detector pulse_debug_reset (
//  .clk       (fpga_clk_50),
//  .rst_n     (hps_fpga_reset_n),
//  .signal_in (hps_reset_req[2]),
//  .pulse_out (hps_debug_reset)
//);
//  defparam pulse_debug_reset.PULSE_EXT = 32;
//  defparam pulse_debug_reset.EDGE_TYPE = 1;
//  defparam pulse_debug_reset.IGNORE_RST_WHILE_BUSY = 1;


endmodule
