/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGTextPathElement.h"

#include "JSSVGAnimatedEnumeration.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedString.h"
#include "SVGTextPathElement.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGTextPathElement);

/* Hash table */

static const HashTableValue JSSVGTextPathElementTableValues[6] =
{
    { "startOffset", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementStartOffset), (intptr_t)0 },
    { "method", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementMethod), (intptr_t)0 },
    { "spacing", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementSpacing), (intptr_t)0 },
    { "href", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementHref), (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementConstructor), (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGTextPathElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 15, JSSVGTextPathElementTableValues, 0 };
#else
    { 16, 15, JSSVGTextPathElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSSVGTextPathElementConstructorTableValues[7] =
{
    { "TEXTPATH_METHODTYPE_UNKNOWN", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementTEXTPATH_METHODTYPE_UNKNOWN), (intptr_t)0 },
    { "TEXTPATH_METHODTYPE_ALIGN", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementTEXTPATH_METHODTYPE_ALIGN), (intptr_t)0 },
    { "TEXTPATH_METHODTYPE_STRETCH", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementTEXTPATH_METHODTYPE_STRETCH), (intptr_t)0 },
    { "TEXTPATH_SPACINGTYPE_UNKNOWN", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementTEXTPATH_SPACINGTYPE_UNKNOWN), (intptr_t)0 },
    { "TEXTPATH_SPACINGTYPE_AUTO", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementTEXTPATH_SPACINGTYPE_AUTO), (intptr_t)0 },
    { "TEXTPATH_SPACINGTYPE_EXACT", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementTEXTPATH_SPACINGTYPE_EXACT), (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGTextPathElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 31, JSSVGTextPathElementConstructorTableValues, 0 };
#else
    { 18, 15, JSSVGTextPathElementConstructorTableValues, 0 };
#endif

class JSSVGTextPathElementConstructor : public DOMConstructorObject {
public:
    JSSVGTextPathElementConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSSVGTextPathElementConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSSVGTextPathElementPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSSVGTextPathElementConstructor::s_info = { "SVGTextPathElementConstructor", 0, &JSSVGTextPathElementConstructorTable, 0 };

bool JSSVGTextPathElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGTextPathElementConstructor, DOMObject>(exec, &JSSVGTextPathElementConstructorTable, this, propertyName, slot);
}

bool JSSVGTextPathElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGTextPathElementConstructor, DOMObject>(exec, &JSSVGTextPathElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGTextPathElementPrototypeTableValues[7] =
{
    { "TEXTPATH_METHODTYPE_UNKNOWN", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementTEXTPATH_METHODTYPE_UNKNOWN), (intptr_t)0 },
    { "TEXTPATH_METHODTYPE_ALIGN", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementTEXTPATH_METHODTYPE_ALIGN), (intptr_t)0 },
    { "TEXTPATH_METHODTYPE_STRETCH", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementTEXTPATH_METHODTYPE_STRETCH), (intptr_t)0 },
    { "TEXTPATH_SPACINGTYPE_UNKNOWN", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementTEXTPATH_SPACINGTYPE_UNKNOWN), (intptr_t)0 },
    { "TEXTPATH_SPACINGTYPE_AUTO", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementTEXTPATH_SPACINGTYPE_AUTO), (intptr_t)0 },
    { "TEXTPATH_SPACINGTYPE_EXACT", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPathElementTEXTPATH_SPACINGTYPE_EXACT), (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGTextPathElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 31, JSSVGTextPathElementPrototypeTableValues, 0 };
#else
    { 18, 15, JSSVGTextPathElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGTextPathElementPrototype::s_info = { "SVGTextPathElementPrototype", 0, &JSSVGTextPathElementPrototypeTable, 0 };

JSObject* JSSVGTextPathElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGTextPathElement>(exec, globalObject);
}

bool JSSVGTextPathElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGTextPathElementPrototype, JSObject>(exec, &JSSVGTextPathElementPrototypeTable, this, propertyName, slot);
}

bool JSSVGTextPathElementPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGTextPathElementPrototype, JSObject>(exec, &JSSVGTextPathElementPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSSVGTextPathElement::s_info = { "SVGTextPathElement", &JSSVGTextContentElement::s_info, &JSSVGTextPathElementTable, 0 };

JSSVGTextPathElement::JSSVGTextPathElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGTextPathElement> impl)
    : JSSVGTextContentElement(structure, globalObject, impl)
{
}

JSObject* JSSVGTextPathElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGTextPathElementPrototype(JSSVGTextPathElementPrototype::createStructure(JSSVGTextContentElementPrototype::self(exec, globalObject)));
}

bool JSSVGTextPathElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGTextPathElement, Base>(exec, &JSSVGTextPathElementTable, this, propertyName, slot);
}

bool JSSVGTextPathElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGTextPathElement, Base>(exec, &JSSVGTextPathElementTable, this, propertyName, descriptor);
}

JSValue jsSVGTextPathElementStartOffset(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGTextPathElement* castedThis = static_cast<JSSVGTextPathElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGTextPathElement* imp = static_cast<SVGTextPathElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->startOffsetAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGTextPathElementMethod(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGTextPathElement* castedThis = static_cast<JSSVGTextPathElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGTextPathElement* imp = static_cast<SVGTextPathElement*>(castedThis->impl());
    RefPtr<SVGAnimatedEnumeration> obj = imp->methodAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGTextPathElementSpacing(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGTextPathElement* castedThis = static_cast<JSSVGTextPathElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGTextPathElement* imp = static_cast<SVGTextPathElement*>(castedThis->impl());
    RefPtr<SVGAnimatedEnumeration> obj = imp->spacingAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGTextPathElementHref(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGTextPathElement* castedThis = static_cast<JSSVGTextPathElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGTextPathElement* imp = static_cast<SVGTextPathElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = imp->hrefAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGTextPathElementConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGTextPathElement* domObject = static_cast<JSSVGTextPathElement*>(asObject(slotBase));
    return JSSVGTextPathElement::getConstructor(exec, domObject->globalObject());
}
JSValue JSSVGTextPathElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGTextPathElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

// Constant getters

JSValue jsSVGTextPathElementTEXTPATH_METHODTYPE_UNKNOWN(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(0));
}

JSValue jsSVGTextPathElementTEXTPATH_METHODTYPE_ALIGN(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(1));
}

JSValue jsSVGTextPathElementTEXTPATH_METHODTYPE_STRETCH(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(2));
}

JSValue jsSVGTextPathElementTEXTPATH_SPACINGTYPE_UNKNOWN(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(0));
}

JSValue jsSVGTextPathElementTEXTPATH_SPACINGTYPE_AUTO(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(1));
}

JSValue jsSVGTextPathElementTEXTPATH_SPACINGTYPE_EXACT(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(2));
}


}

#endif // ENABLE(SVG)
