#ifndef TFP410_H
#define TFP410_H

#include "i2cdevice.h"
#include <stdio.h>

namespace MityDSP
{

/**
 * the TC74 is an I2C capable temperature sensor
 * with a 1°C resolution.
 * The factory default address for this device
 * is 1001101b (0x95).
 */
class tcTC74 : public tcI2CDevice
{
public:
    tcTC74(int bus);
    virtual ~tcTC74(void);
    int   Initialize(void);
    /// Gets the temperature from the part
    int getTemperature() const;

    /// is the device in standby mode
    bool getStandby() const;
    /// set standby mode
    int setStandby(bool abStandby) const;

};

}

#endif
