#!/bin/sh

# Create a loopback file in /dev/shm. Format fat32 and give to g_mass_storage driver.

FILE=/dev/shm/20M
set -x

die()
{
    echo $@
    exit
}

rm -f $FILE

# Create 20M file with all zeros
dd if=/dev/zero of=$FILE bs=1M count=20 || die

# opkg install util-linux-sfdisk
# Create one large fat32 partition
sfdisk --force $FILE << EOF
unit: sectors
8,,c;
EOF

# Attach loopback file to /dev/loop0
[ ! -e /dev/loop0 ] && mknod /dev/loop0 b 7 0
losetup -o 4096 /dev/loop0 $FILE || die

# Format fat32
mkfs.vfat /dev/loop0 || die

# Mount fat32 partition
mkdir -p /mnt/loop
mount -t vfat /dev/loop0 /mnt/loop || die

# Add files to loop device
touch /mnt/loop/testfile || die

# Unmount and unAttach
umount /mnt/loop || die
losetup -d /dev/loop0 || die

# Load mass storage driver module
modprobe g_mass_storage file=$FILE stall=0 removable=1 || die

echo "Plugin usb cable"

