#!/bin/sh

for iface in usb0 eth0 eth0:avahi
do
    HWADDR=`/sbin/ifconfig $iface | awk -e '/HWaddr/{print $5}'`
    IPADDR=`/sbin/ifconfig $iface | awk -e '/Bcast/{print $2}' | sed -e 's/.*://'`
    BCAST=`/sbin/ifconfig $iface | awk -e '/Bcast/{print $3}' | sed -e 's/.*://'`
    NETMASK=`/sbin/ifconfig $iface | awk -e '/Bcast/{print $4}' | sed -e 's/.*://'`
    MODE=`grep $iface /etc/network/interfaces | grep iface | awk -e '{print $4}'`
    GATEWAY=`/sbin/ip route show | grep default | awk '{ print $3}'`

    # Put something in there for the auto ip interface because it's just empty from the above.
    if [ $iface == "eth0:avahi" ]
    then
        MODE=autoip
    fi

    if [ x$IPADDR == "x" ]
    then
        IPADDR=0.0.0.0
    fi 
    if [ x$NETMASK == "x" ]
    then
        NETMASK=255.255.0.0
    fi 
    if [ x$BCAST == "x" ]
    then
        BCAST=10.0.255.255
    fi
    if [ x$GATEWAY == "x" ]
    then
          GATEWAY=0.0.0.0
    fi
    # When we have AUTO IP only, we get $GATEWAY == "eth0"
    if [ $GATEWAY == "eth0" ]
    then
          GATEWAY=0.0.0.0
    fi
    echo "$iface $HWADDR $MODE $IPADDR $BCAST $NETMASK $GATEWAY"
done

